/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
/**************************************************************************
 *
 * SOURCE FILE NAME = TODATA.C
 *
 * DESCRIPTIVE NAME = Static/Initialization data for Tohiba CD-ROM Filter
 *
 *
 * VERSION = V2.0
 *
 * DATE
 *
 * DESCRIPTION
 *
 *
 * FUNCTIONS
 *
 * ENTRY POINTS:
 *
 * DEPENDENCIES:
 *
 * NOTES
 *
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
*/

#include "os2.h"
#include "misc.h"
#include "iorb.h"
#include "scsi.h"
#include "cdbscsi.h"
#include "dhcalls.h"
#include "todefs.h"
#include "fltdefs.h"

/*
**  GLOBAL DATA
**  -----------
**  1. Static data
**  2. Static init data discarded after init time
*/

PFN             Device_Help=0L;            /* far ptr to devhelp function    */
PVOID           pDataSeg=0L;               /* virt ptr of our data segment   */
ULONG           ppDataSeg=0L;              /* phys addr of our data segment  */
ULONG           plDataSeg=0L;              /* linear addr of our data seg    */
USHORT          FilterFlags=0;             /* Global driver flags            */
USHORT          NumCDROMDrives=0;          /* Number of CD-ROM drives        */
USHORT          FilterADDHandle = 0;
USHORT          InitComplete = 0;

struct Vendor   Vendor [] = { "TOSHIBA " ,
/*                            "IBM     "        */
                            };

USHORT  vendor_count = sizeof (Vendor) / sizeof (Vendor [0]);


IORB_CDB  default_iorb_cdb = {

   sizeof(IORB_ADAPTER_PASSTHRU),            /* IORB Length                */
   0,                                        /* Unit Identifier            */
   IOCC_ADAPTER_PASSTHRU,                    /* Command Code               */
   IOCM_EXECUTE_CDB,                         /* Command Modifier           */
   IORB_ASYNC_POST + IORB_REQ_STATUSBLOCK,   /* Request Control Flags      */
   0,                                        /* Status                     */
   0,                                        /* Error Code                 */
   0,                                        /* Cmd completion timeout (s) */
   sizeof(SCSI_STATUS_BLOCK),                /* Status block length        */
   0,                                        /* Status block               */
   0,                                        /* Reserved, MBZ              */
   0,                                        /* Pointer to next IORB       */
   0,                                        /* Notification Address       */
   0,                                        /* For use by DM              */
   0,                                        /* For use by ADD             */

   1,                                        /* Count of S/G list elements */
   0,                                        /* far ptr to S/G List        */
   0,                                        /* physical addr of S/G List  */
   0,                                        /* Length of CDB              */
   0,                                        /* Pointer to CDB             */
   0,                                        /* phys ptr to SCB            */
   0                                         /* Flags                      */
};


/*
** Configuration Data
*/
USHORT    UnitCBCount            =  0;
UNITCB    UnitCBTable[MAX_UNITS] = {0};

UCHAR     Filter_EndofData = 0;

