/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
/**************************************************************************
 *
 * SOURCE FILE NAME = TOCDB.H
 *
 * DESCRIPTIVE NAME = Vendor unique CDB definitions for Toshiba CD-ROM
 *                    drives.
 *
 *
 * VERSION = V2.0
 *
 * DATE
 *
 * DESCRIPTION
 *
 * FUNCTIONS
 *
 * ENTRY POINTS:
 *
 * DEPENDENCIES:
 *
 * NOTES
 *
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
*/

/*
** Toshiba Vendor Unique Command Codes
*/
#define TOSH_AUDIO_TRACK_SEARCH     0xC0
#define TOSH_PLAY_AUDIO             0xC1
#define TOSH_STILL                  0xC2
#define TOSH_SET_STOP_TIME          0xC3
#define TOSH_EJECT                  0xC4
#define TOSH_READ_Q_DATA            0xC6
#define TOSH_READ_DISK_INFO         0xC7
#define TOSH_READ_MODE              0xC8

/*
** TYPE field definitions for CDB control byte
*/
#define CONTROL_TYPE_LBA                0x00
#define CONTROL_TYPE_ATIME              0x40
#define CONTROL_TYPE_TNO                0x80
#define CONTROL_TYPE_PREVIOUS_ADDRESS   0xC0

/*
** Toshiba Vendor Unique Command Descriptor Blocks
*/
/************************************************
 * Audio Track Search        (0xC0)             *
 ************************************************/
struct TOSH_CDB_AudioTrackSearch  {

        UCHAR   OpCode;

        UCHAR   play        : 1;
        UCHAR   reserved_1  : 4;
        UCHAR   LUN         : 3;
        union
        AddressType search_address;
        UCHAR   reserved_2;
        UCHAR   reserved_3;
        UCHAR   reserved_4;
        UCHAR   control;
};


/************************************************
 * Play Audio (10)           (0xC1)             *
 ************************************************/
struct TOSH_CDB_PlayAudio {

        UCHAR   OpCode;

        UCHAR   play_mode   : 3;
        UCHAR   reserved_1  : 2;
        UCHAR   LUN         : 3;

        union
        AddressType completion_address;
        UCHAR   reserved_2;
        UCHAR   reserved_3;
        UCHAR   reserved_4;
        UCHAR   control;
};

/*
** play_mode definitions
*/
#define TOSH_PLAY_MUTE                  0
#define TOSH_PLAY_LEFT_CHANNEL          1
#define TOSH_PLAY_RIGHT_CHANNEL         2
#define TOSH_PLAY_STEREO                3
#define TOSH_PLAY_PREVIOUS_MODE         4

/************************************************
 * Still                     (0xC2)             *
 ************************************************/

struct TOSH_CDB_Still  {

        UCHAR   OpCode;

        UCHAR   reserved_1  : 5;
        UCHAR   LUN         : 3;

        UCHAR   reserved_2;
        UCHAR   reserved_3;
        UCHAR   reserved_4;
        UCHAR   reserved_5;
        UCHAR   reserved_6;
        UCHAR   reserved_7;
        UCHAR   reserved_8;

        UCHAR   control;
};


/************************************************
 * Set Stop Time             (0xC3)             *
 ************************************************/

struct TOSH_CDB_SetStopTime  {

        UCHAR   OpCode;

        UCHAR   time_min    : 5;
        UCHAR   LUN         : 3;

        UCHAR   time_secs;

        UCHAR   reserved_1;
        UCHAR   reserved_2;
        UCHAR   reserved_3;
        UCHAR   reserved_4;
        UCHAR   reserved_5;
        UCHAR   reserved_6;

        UCHAR   control;
};

/************************************************
 * Eject Disk                (0xC4)             *
 ************************************************/

struct TOSH_CDB_Eject  {

        UCHAR   OpCode;

        UCHAR   immed       : 1;
        UCHAR   reserved_1  : 4;
        UCHAR   LUN         : 3;

        UCHAR   reserved_2;
        UCHAR   reserved_3;
        UCHAR   reserved_4;
        UCHAR   reserved_5;
        UCHAR   reserved_6;
        UCHAR   reserved_7;
        UCHAR   reserved_8;

        UCHAR   control;
};


/************************************************
 * Read Q Data               (0xC6)             *
 ************************************************/

struct TOSH_CDB_ReadQData    {

        UCHAR   OpCode;

        UCHAR   alloc_length : 5;
        UCHAR   LUN          : 3;

        UCHAR   reserved_1;
        UCHAR   reserved_2;
        UCHAR   reserved_3;
        UCHAR   reserved_4;
        UCHAR   reserved_5;
        UCHAR   reserved_6;
        UCHAR   reserved_7;

        UCHAR   control;
};


struct TOSH_SubQ_Channel_Data
{
        UCHAR   playback_status;
        UCHAR   control;
        UCHAR   track_number;
        UCHAR   point;
        UCHAR   min;
        UCHAR   sec;
        UCHAR   frame;
        UCHAR   amin;
        UCHAR   asec;
        UCHAR   aframe;
};

/*
** Audio Status Codes
*/
#define TOSH_PLAY_IN_PROGRESS         0X00
#define TOSH_PLAY_STILL               0x01
#define TOSH_PLAY_PAUSED              0x02
#define TOSH_PLAY_COMPLETE            0x03



/************************************************
 * Read Disk Info            (0xC7)             *
 ************************************************/

struct TOSH_CDB_ReadDiskInfo {

        UCHAR   OpCode;

        UCHAR   type         : 2;
        UCHAR   reserved_1   : 3;
        UCHAR   LUN          : 3;

        UCHAR   track_number;

        UCHAR   reserved_2;
        UCHAR   reserved_3;
        UCHAR   reserved_4;
        UCHAR   reserved_5;
        UCHAR   reserved_6;
        UCHAR   reserved_7;

        UCHAR   control;
};

#define TOSH_MINMAX_INFO      0x00
#define TOSH_LEADOUT_INFO     0x01
#define TOSH_TRACK_INFO       0x02
#define TOSH_LASTSESSION_INFO 0x03


struct Min_Max {
        UCHAR   minimum;
        UCHAR   maximum;
        UCHAR   reserved_1;
        UCHAR   reserved_2;
};

struct LeadOut {
        UCHAR   amin;
        UCHAR   asec;
        UCHAR   aframe;
        UCHAR   reserved_1;
};

struct Track_Info {
        UCHAR   amin;
        UCHAR   asec;
        UCHAR   aframe;
        UCHAR   control;
};


struct LastSession {
        UCHAR   disk_id;
        UCHAR   amin;
        UCHAR   asec;
        UCHAR   aframe;
};

#define TOSH_AUDIO_TRACK        0x00
#define TOSH_DATA_TRACK         0x01

#define TOSH_DISK_CDDA_CDROM    0x00
#define TOSH_DISK_CDI           0x10
#define TOSH_DISK_XA            0x20



union TOSH_ReadDiskInfo_Data
{
        struct Min_Max       track_number;
        struct LeadOut       leadout;
        struct Track_Info    track;
        struct LastSession   last_session;
};


/************************************************
 * Read Mode                 (0xC8)             *
 ************************************************/

struct TOSH_CDB_ReadMode     {

        UCHAR   OpCode;

        UCHAR   reserved_1   : 5;
        UCHAR   LUN          : 3;

        UCHAR   reserved_2;
        UCHAR   reserved_3;
        UCHAR   reserved_4;
        UCHAR   reserved_5;
        UCHAR   reserved_6;
        UCHAR   reserved_7;
        UCHAR   reserved_8;

        UCHAR   control;
};


