/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
/*static char *SCCSID = "src/dev/dasd/os2cdrom/cdtrace.h, dscd, r206, 6a.585 93/03/20";*/
/**************************************************************************
 *
 * SOURCE FILE NAME = CDTRACE.H
 *
 * DESCRIPTIVE NAME = OS2CDROM.DMD - OS/2 CDROM Device Manager
 *
 *
 *
 *
 *
 * VERSION = V2.0
 *
 * DATE
 *
 * DESCRIPTION : Internal data structures for System
 *               tracing in the OS/2 CD ROM Manager.
 *
 *
*/

/*--------------------------------------------------------------------*/
/*   SYSTEM trace header file for OS2CDROM.DMD                        */
/*--------------------------------------------------------------------*/
#define TEST_RAS_TRACING(RMT,Maj)   \
         (*(RMT+(Maj>>3)) & (0x80>>(Maj&7)))

#define TEST_TRACING(RMT,Maj)   \
        (*RMT & 0x40) && (*(RMT+(Maj>>3)) & (0x80>>(Maj&7)))

#define TEST_MAJOR(RMT,Maj)   \
        (*(RMT+(Maj>>3)) & (0x80>>(Maj&7)))

#define TEST_DEKKO(RMT)   \
        (*RMT & 0x40)

/* Trace Event flags */
#define TRACE_STRAT1            0x0001
#define TRACE_STRAT2            0x0002
#define TRACE_IORB              0x0004
#define TRACE_ENTRY             0x0008
#define TRACE_ASYNCSTART        0x0010
#define TRACE_ASYNCDONE         0x0020
#define TRACE_EXIT              0x0040
#define TRACE_READ              0x0080
#define TRACE_WRITE             0x0100
#define TRACE_FORMAT            0x0200
#define TRACE_VERIFY            0x0400
#define TRACE_PREFETCH          0x0800
#define TRACE_IOCTL             0x1000
#define TRACE_RLE               0x2000
#define TRACE_OS2DASD           0x4000
#define TRACE_STRAT3            0x8000

/* Global TraceFlags */
#define TF_INTERNAL             0x0001
#define TF_PERFVIEW             0x0002
#define TF_RAS                  0x0004
#define TF_DEKKO                0x0008


/* RAS Trace Major/Minor Codes */
#define DEKKO_MAJOR_DISK        0x68

#define RAS_MAJOR_DISK          0x07
#define RAS_MINOR_STRAT1_RWV    0x08
#define RAS_MINOR_IOCTL_RWVF    0x09
#define RAS_MINOR_STRAT2_RLH    0x0A
#define RAS_MINOR_STRAT2_RLE    0x0B
#define RAS_MINOR_IORB          0x0C
#define RAS_MINOR_OS2DASD       0x0E
#define RAS_MINOR_STRAT3_RLH    0x1A
#define RAS_MINOR_STRAT3_RLE    0x1B
#define RAS_MINOR_IORB32        0x1C
#define RAS_MINOR_OS2CDROM_STRAT1 0x20

/* Trace Control Block */

typedef struct _TCB {

   PBYTE        pRequest;
   USHORT       Unit;
   UCHAR        Drive[2];
   UCHAR        CommandCode;
   UCHAR        CommandModifier;
   UCHAR        CmdString[3];
   UCHAR        Reserved_1;
   USHORT       RequestControl;
   UCHAR        Priority;
   UCHAR        Flags;
   USHORT       cSGList;
   ULONG        RBA;
   ULONG        BlockCount;
   USHORT       pRLH;
   USHORT       Reserved_2;

} TCB, FAR *PTCB;


typedef struct _TCBD {

   PBYTE        pRequest;
   USHORT       Status;
   USHORT       ErrorCode;
   ULONG        BlocksXferred;

} TCBD, FAR *PTCBD;


typedef struct _TRLHS {

   PBYTE        pRLH;
   USHORT       Count;
   USHORT       Unit;
   UCHAR        Drive[2];
   USHORT       Request_Control;

} TRLHS, FAR *PTRLHS;

typedef struct _TRLHD {

   PBYTE        pRLH;
   USHORT       DoneCount;
   USHORT       Status;

} TRLHD, FAR *PTRLHD;

