/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
/*static char *SCCSID = "%w% %e%";*/
#define SCCSID  "%w% %e%"

/**************************************************************************
 *
 * SOURCE FILE NAME = CDTRACE.C
 *
 * DESCRIPTIVE NAME = OS2CDROM.DMD - OS/2 CD-ROM Device Manager
 *
 *
 *
 * VERSION = V0.0
 *
 * DATE
 *
 * DESCRIPTION : System Tracing routines for OS/2 CD-ROM Mgr
 *
 *
 *
*/
#include "cdh.h"

VOID   TraceStrat1Pre (USHORT, PBYTE, NPUNITCB);
VOID   TraceStrat1Post (USHORT, PBYTE);
USHORT GetTraceType (USHORT, PBYTE);
USHORT GetCmdString (USHORT);
VOID   DekkoTrace (USHORT, USHORT, PBYTE);
USHORT IsTraceOn2(VOID);


/* @V111573 typedef struct InfoSefGDT FAR *PInfoSegGDT; */ /*Now defined in dmdefs.h*/

typedef struct _TRACEENTRY
{
   UCHAR  TraceData[32];

} TRACEENTRY, FAR *PTRACEENTRY;
/*------------------------------------------------------------------------
;
;** IsTraceOn - Checks to see if RAS/DEKKO/PERFVIEW/Internal trace is
;               enabled and sets the appropriate flag bits in the
;               global TraceFlags variable.
;
;   USHORT IsTraceOn ()
;
;   ENTRY: VOID
;
;   RETURN:   USHORT            TraceFlags
;
;   EFFECTS:
;
------------------------------------------------------------------------*/
USHORT IsTraceOn ()

{
   return ( IsTraceOn2() );
}


/*------------------------------------------------------------------------
;
;** IsTraceOn2 - Checks to see if RAS/DEKKO/PERFVIEW/Internal trace is
;
------------------------------------------------------------------------*/

USHORT IsTraceOn2()
{
   DISABLE;

   TraceFlags &= ~(TF_DEKKO);

   /* See if DEKKO tracing is required */

   if ( TEST_MAJOR(pSIS_perf_mec_table, DEKKO_MAJOR_DISK) )
      TraceFlags |= TF_DEKKO;

   ENABLE;

   return(TraceFlags);
}

/*------------------------------------------------------------------------
;
;** Trace - DEKKO/Internal Tracing Functions
;
;   Checks to see if System Tracing is enabled
;   and performs the requested tracing function.
;
;   USHORT Trace (USHORT TraceFlags, PBYTE pRequest, NPUNITCB pUnitCB)
;
;   ENTRY:    TraceEvent       - Trace Event Flags
;             pRequest         - Request to trace
;             pUnitCB           - Trace Point
;
;   RETURN:   VOID
;
;   EFFECTS:
;
------------------------------------------------------------------------*/
VOID Trace (TraceEvent, pRequest, pUnitCB)

USHORT  TraceEvent;
PBYTE   pRequest;
NPUNITCB pUnitCB;

{
   USHORT TraceType;

   if (TraceEvent & TRACE_STRAT1)
   {
      if ( TraceFlags & (TF_DEKKO) )
      {
         if ((TraceType = GetTraceType(TraceEvent, pRequest)) == 0)
            return;

         TraceEvent |= TraceType;

         if (TraceEvent & TRACE_ENTRY)
            TraceStrat1Pre(TraceEvent, pRequest, pUnitCB);
         else
            TraceStrat1Post(TraceEvent, pRequest);
      }
   }
}

/*------------------------------------------------------------------------
;
;** TraceStrat1Pre - Trace Strategy-1 Pre-Invocation Request
;
;   VOID TraceStrat1Request (USHORT TraceEvent, PBYTE pRequest, pUnitCB)
;
;   ENTRY:    TraceEvent       - Trace Flags
;             pRequest         - Request to trace
;             pUnitCB           - Pointer to UnitCB
;
;   RETURN:   VOID
;
;   EFFECTS:
;
------------------------------------------------------------------------*/
VOID TraceStrat1Pre (TraceEvent, pRequest, pUnitCB)

USHORT  TraceEvent;
PBYTE   pRequest;
NPUNITCB pUnitCB;

{
   UCHAR  TraceBuffer[sizeof(TCB)];
   PTCB   pTraceBuffer = (PTCB) TraceBuffer;
   USHORT MinorCode = 0;

   if (((PRPH)pRequest)->Flags & RPF_Internal)
      return;

   pTraceBuffer->pRequest = pRequest;
   pTraceBuffer->Unit = pUnitCB->PhysDriveNum;

   if ( ((PRPH)pRequest)->Unit <= 26)
      (USHORT) pTraceBuffer->Drive[0] = (USHORT) (((PRPH)pRequest)->Unit + 'A');
   else
      (USHORT) pTraceBuffer->Drive[0] = ' ';
   pTraceBuffer->Drive[1] = 0;

   pTraceBuffer->CommandCode = ((PRPH)pRequest)->Cmd;
   (USHORT) (pTraceBuffer->CmdString[0]) = GetCmdString(TraceEvent);
   pTraceBuffer->CmdString[2]=0;
   pTraceBuffer->RequestControl=0;
   pTraceBuffer->Priority = 3;
   pTraceBuffer->Flags=0;
   pTraceBuffer->cSGList = 1;
   pTraceBuffer->pRLH = 0;

   pTraceBuffer->RBA = ((PRP_RWV)pRequest)->rba;


   pTraceBuffer->BlockCount = (ULONG) ((PRP_RWV)pRequest)->NumSectors;

   MinorCode = RAS_MINOR_OS2CDROM_STRAT1;

   DekkoTrace(MinorCode, sizeof(TCB), (PBYTE) pTraceBuffer);

   return;
}
/*------------------------------------------------------------------------
;
;** TraceStrat1Post - Trace Strategy-1 Post-Invocation Request
;
;   VOID TraceStrat1Post (USHORT TraceEvent, PBYTE pRequest)
;
;   ENTRY:    TraceEvent       - Trace Flags
;             pRequest         - Request to trace
;
;   RETURN:   VOID
;
;   EFFECTS:
;
------------------------------------------------------------------------*/
VOID TraceStrat1Post (TraceEvent, pRequest)

USHORT TraceEvent;
PBYTE  pRequest;

{
   UCHAR  TraceBuffer[sizeof(TCBD)];
   PTCBD  pTraceBuffer = (PTCBD) TraceBuffer;
   USHORT MinorCode = 0;

   if (((PRPH)pRequest)->Flags & (RPF_TraceComplete | RPF_Internal))
      return;

   ((PRPH)pRequest)->Flags |= RPF_TraceComplete;

   pTraceBuffer->pRequest = pRequest;
   pTraceBuffer->Status = (USHORT) (((PRPH)pRequest)->Status >> 8);
   pTraceBuffer->ErrorCode = (USHORT) (((PRPH)pRequest)->Status & 0x00FF);
   pTraceBuffer->BlocksXferred = (ULONG) ((PRP_RWV)pRequest)->NumSectors;

   MinorCode = RAS_MINOR_OS2CDROM_STRAT1;

   MinorCode |= 0x0080;
   DekkoTrace(MinorCode, sizeof(TCBD), (PBYTE) pTraceBuffer);

}


/*------------------------------------------------------------------------
;
;** GetCmdString - Get command code string
;
;   USHORT GetCmdString (USHORT TraceEvent)
;
;   ENTRY:    TraceEvent      - TraceFlags
;
;   RETURN:   USHORT          - Two char ASCII command code
;
;   EFFECTS:
;
------------------------------------------------------------------------*/
USHORT GetCmdString (TraceEvent)

USHORT TraceEvent;

{
   USHORT Cmd;

   UCHAR  Char1 = ' ';
   UCHAR  Char2 = ' ';

   if (TraceEvent & TRACE_READ)
       Char1 = 'R';
   if (TraceEvent & TRACE_WRITE)
       Char1 = 'W';
   if (TraceEvent & TRACE_FORMAT)
       Char1 = 'F';

   if (TraceEvent & TRACE_VERIFY)
       Char2 = 'V';
   else if (TraceEvent & TRACE_PREFETCH)
       Char2 = 'P';

   Cmd = Char1 + Char2 * 256;

   return(Cmd);

}

/*------------------------------------------------------------------------
;
;** GetTraceType - Get Trace Type
;
;   USHORT GetTraceType (USHORT TraceEvent, pRequest)
;
;   ENTRY:    TraceEvent      - Trace Flags
;             pRequest        - Request
;
;   RETURN:   USHORT          - Trace Flags
;
;   EFFECTS:
;
------------------------------------------------------------------------*/
USHORT GetTraceType (TraceEvent, pRequest)

USHORT TraceEvent;
PBYTE  pRequest;

{
   USHORT Cmd=0, i=0;

/* if (TraceEvent & TRACE_STRAT1)
   {
      Cmd = (USHORT) ((PRPH)pRequest)->Cmd;
      if (Cmd == CMDGenIOCTL)
          Cmd = (USHORT) ((Cmd << 8) + ((PRP_GENIOCTL)pRequest)->Function);
   }
   else if (TraceEvent & TRACE_STRAT2)
      Cmd=(USHORT)((PB_REQ_LIST*256)+((PPB_Read_Write)pRequest)->RqHdr.Command_Code);
   else if (TraceEvent & TRACE_IORB)
      Cmd = ((((PIORB)pRequest)->CommandCode) << 8) +
             ((PIORB)pRequest)->CommandModifier;

   for (i = 0; i < sizeof(CmdTable)/sizeof(CMDTABLE); i++)
      if (CmdTable[i].Cmd == Cmd)
         return(CmdTable[i].CmdType);
*/

  return(0);
}





/*------------------------------------------------------------------------
;
;** DekkoTrace - Perform Dekko tracing
;
;   VOID DekkoTrace (USHORT MinorCode, USHORT TraceSize, PBYTE pTraceBuffer)
;
;   ENTRY:    MinorCode        - Minor Code
;             TraceSize        - Size of data to trace
;             pTraceBuffer     - Pointer to trace buffer
;
;   RETURN:   VOID
;
;   EFFECTS:
;
------------------------------------------------------------------------*/
VOID DekkoTrace (MinorCode, TraceSize, pTraceBuffer)

USHORT MinorCode;
USHORT TraceSize;
PBYTE  pTraceBuffer;

{
   volatile struct Dekko_Addr FAR *pDekko;
   USHORT i;
   PUSHORT pusTraceBuffer = (PUSHORT) pTraceBuffer;

   if ( TEST_MAJOR(pSIS_perf_mec_table, DEKKO_MAJOR_DISK) )
   {
      if ( TEST_DEKKO(pSIS_perf_mec_table) )
      {
         SELECTOROF(pDekko) = ((PInfoSegGDT)pSysInfoSeg)->SIS_MMIOBase;
         OFFSETOF(pDekko) = 0;

         pDekko->majmin_code = DEKKO_MAJOR_DISK * 256 + MinorCode;

         for (i = 0; i < TraceSize/2; i++)
         {
            pDekko->perf_data = (USHORT) *(pusTraceBuffer+i);
         }
      }
      else
         ;//DevHelp_PerfSysTrace(DEKKO_MAJOR_DISK, MinorCode, TraceSize, (PBYTE) pTraceBuffer);
   }
}

