/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
/**************************************************************************
 *
 * SOURCE FILE NAME = CDSONY.H
 *
 * DESCRIPTIVE NAME = Vendor unique command descriptor blocks for Sony
 *
 *
 * VERSION = V2.0
 *
 * DATE
 *
 * DESCRIPTION
 *
 *
 * FUNCTIONS
 *
 * ENTRY POINTS:
 *
 * DEPENDENCIES:
 *
 * NOTES
 *
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
*/

/*
**      CD-ROM device specific data structures
*/
#define SONY_READ_CDDA  0xD8
#define SONY_READ_CDXA  0xDB

/************************************************
 * Sony SCSI Read CD-DA         (0xD8)          *
 ************************************************/
struct Sony_CDB_Read_CDDA {
        UCHAR   OpCode;

        UCHAR   reserved_1  : 5;
        UCHAR   LUN         : 3;

        union
        ULONGB  LBA;
        union
        ULONGB  transfer_length;
        UCHAR   sub_code;
        UCHAR   control;
};

#define CDDA_SUBCODE_2352       0x00
#define CDDA_SUBCODE_2368       0x01
#define CDDA_SUBCODE_2448       0x02
#define CDDA_SUBCODE_96         0x03


/************************************************
 * Sony SCSI Read CD-XA         (0xDB)          *
 ************************************************/
struct Sony_CDB_Read_CDXA {
        UCHAR   OpCode;

        UCHAR   reserved_1  : 5;
        UCHAR   LUN         : 3;

        union
        ULONGB  LBA;
        UCHAR   format;
        union
        ULONGB  transfer_length;
        UCHAR   control;
};
#define CDXA_FORMAT_2048    0x00
#define CDXA_FORMAT_2352    0x0F
#define CDXA_FORMAT_2646    0x1F


