/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
/**************************************************************************
 *
 * SOURCE FILE NAME = CDPROTO.H
 *
 * DESCRIPTIVE NAME = C function prototypes for OS/2 CD-ROM Device Mgr
 *
 *
 * VERSION = V2.0
 *
 * DATE
 *
 * DESCRIPTION
 *
 *
 * FUNCTIONS
 *
 * ENTRY POINTS:
 *
 * DEPENDENCIES:
 *
 * NOTES
 *
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
*/

/*---------------------------------------*
 * Function declarations - Static Code   *
 *---------------------------------------*/
USHORT NEAR CD_DriveInit (PRPINITIN, NPUNITCB);
VOID   NEAR CD_Strat1 (PRPH);
VOID   NEAR CD_Strat1b (void);
USHORT NEAR CD_DriveInit (PRPINITIN, NPUNITCB);
USHORT NEAR CD_MediaCheck (PRP_MEDIACHECK, NPUNITCB);
USHORT NEAR CD_BuildBPB (PRP_BUILDBPB, NPUNITCB);
USHORT NEAR CD_Read (PRP_RWV, NPUNITCB);
USHORT NEAR CD_Write (PRP_RWV, NPUNITCB);
USHORT NEAR CD_WriteV (PRP_RWV, NPUNITCB);
USHORT NEAR RemovableMedia (PRPH, NPUNITCB);
USHORT NEAR DriveGenIOCTL (PRP_GENIOCTL, NPUNITCB);
USHORT NEAR f_CD_DriveGenIOCTL (PRP_GENIOCTL, NPUNITCB);
USHORT NEAR ResetMedia (PRPH, NPUNITCB);
USHORT NEAR GetLogDriveMap (PRPH, NPUNITCB);
USHORT NEAR SetLogDriveMap (PRPH, NPUNITCB);
USHORT NEAR PartFixedDisks (PRP_PARTFIXEDDISKS, NPUNITCB);
USHORT NEAR GetUnitMap (PRP_GETUNITMAP, NPUNITCB);
USHORT NEAR DiskIO (PBYTE, NPUNITCB);
USHORT NEAR DiskIO_Wait (PBYTE, NPUNITCB);
USHORT NEAR GetVolumeSize (NPUNITCB, ULONG FAR *);
USHORT NEAR ClearCheckCondition (NPUNITCB);
USHORT NEAR GetPlayStatus (NPUNITCB, BOOL FAR *);
USHORT NEAR Tosh_GetDensityCode(NPUNITCB, USHORT FAR *);
USHORT NEAR GetSectorMode(NPUNITCB, USHORT FAR *);
USHORT NEAR Get_UnitCB_Addr (UCHAR, NPUNITCB FAR *);
UCHAR  NEAR GetMediumType (NPUNITCB);   // 10/23/2000 MB
USHORT NEAR SetPacketInfo (NPUNITCB);
BOOL   NEAR isDVDMedia (UCHAR);    // AK 04/04/02
USHORT NEAR SetPacketFlags (NPUNITCB, USHORT, BOOL, BOOL);
USHORT NEAR MemCopy (ULONG, ULONG, USHORT);
BOOL   NEAR FindPacket (NPUNITCB, ULONG, PUSHORT);
USHORT NEAR FindLeastUsed (NPUNITCB, PUSHORT);
USHORT NEAR FlushBuffers (NPUNITCB);
USHORT NEAR SetAccessOrder (NPUNITCB, USHORT);
BOOL   NEAR Strncmp (UCHAR *, UCHAR *, USHORT);
USHORT NEAR Check_MultiSession_Mounted (NPUNITCB, ULONG);
VOID   NEAR SubmitRequestsToADD(NPUNITCB);
USHORT NEAR CmdErr (PRPH, NPUNITCB);
USHORT NEAR WriteErr (PRPH, NPUNITCB);
USHORT NEAR WriteVErr (PRPH, NPUNITCB);
USHORT NEAR StatusDevReady (PRPH, NPUNITCB);
USHORT NEAR StatusComplete (PRPH, NPUNITCB);
USHORT NEAR Submit_ModeSelect (NPUNITCB, USHORT, USHORT);
USHORT NEAR StatusError (PRPH, USHORT);
USHORT NEAR ChainModeSelectRead (NPUNITCB, ULONG, USHORT, ULONG,
                                                  USHORT, USHORT);
USHORT NEAR ChainModeSelectWrite (NPUNITCB, ULONG, USHORT, ULONG,
                                                   USHORT, USHORT, BOOL);
USHORT NEAR ReadSector (NPUNITCB, ULONG, USHORT, ULONG, USHORT);
USHORT NEAR WriteSector (NPUNITCB, ULONG, USHORT, ULONG, USHORT, BOOL);
USHORT NEAR CD_Read_2352 (NPUNITCB, ULONG, USHORT, ULONG, USHORT );  // 10/23/2000 MB
USHORT NEAR ATAPI_Read_2352 (NPUNITCB, ULONG, USHORT, ULONG);
USHORT NEAR CD_Write_2352(NPUNITCB, ULONG, USHORT, ULONG, BOOL);
USHORT NEAR Tosh_Read_2048 (NPUNITCB, ULONG, USHORT, ULONG);
USHORT NEAR Tosh_Read_2352 (NPUNITCB, ULONG, USHORT, ULONG);
USHORT NEAR Sony_Read_2048 (NPUNITCB, ULONG, USHORT, ULONG);
USHORT NEAR Sony_Read_2352 (NPUNITCB, ULONG, USHORT, ULONG);

USHORT ReadTOC_Leadout (NPUNITCB, NPIORB_CDB);

/*
** cdiorb.c prologs
*/
USHORT AllocIORB (NPUNITCB, NPIORB FAR *);
VOID   AllocIORB_Wait (NPUNITCB, NPIORB FAR *);
VOID   FreeIORB (NPUNITCB, NPIORB_CDB);
VOID   BuildIORB_DeviceControl (NPUNITCB, USHORT, NPIORB FAR *);
VOID   BuildIORB_PassthruCDB (NPUNITCB, ULONG, ULONG, NPIORB_CDB FAR *);
VOID   BuildCDB_TestUnitReady(NPUNITCB, NPIORB_CDB FAR *);
VOID   BuildCDB_RezeroUnit(NPUNITCB, NPIORB_CDB FAR *);
VOID   BuildCDB_RequestSense(NPUNITCB, NPIORB_CDB FAR *);
VOID   BuildCDB_Read_6(NPUNITCB, ULONG, USHORT, USHORT,
                                         ULONG, NPIORB_CDB FAR *);
VOID   BuildCDB_Read_10(NPUNITCB, ULONG, USHORT, USHORT,
                                         ULONG, NPIORB_CDB FAR *);
VOID   BuildCDB_Write_10(NPUNITCB, ULONG, USHORT, USHORT,
                                          ULONG, NPIORB_CDB FAR *);
VOID   BuildCDB_WriteV_10(NPUNITCB, ULONG, USHORT, USHORT,
                                           ULONG, NPIORB_CDB FAR *);
VOID   BuildCDB_Seek_6(NPUNITCB, ULONG, NPIORB_CDB FAR *);
VOID   BuildCDB_Seek_10(NPUNITCB, ULONG, NPIORB_CDB FAR *);
VOID   BuildCDB_Inquiry(NPUNITCB, NPIORB_CDB FAR *);
VOID   BuildCDB_ModeSelect(NPUNITCB, USHORT, USHORT, NPIORB_CDB FAR *);
VOID   BuildCDB_AudioControl(NPUNITCB pUnitCB, NPIORB_CDB FAR *pIORBOut, BOOL initCall); // 10/23/2000 MB
VOID   BuildCDB_PreventAllowRemoval(NPUNITCB, USHORT, NPIORB_CDB FAR *);
VOID   BuildCDB_ReadCapacity(NPUNITCB, NPIORB_CDB FAR *);
VOID   BuildCDB_ReadSubChannel(NPUNITCB, USHORT, NPIORB_CDB FAR *);
VOID   BuildCDB_ReadTOC (NPUNITCB, UCHAR, USHORT, NPIORB_CDB FAR *); // 10/23/2000 MB
VOID   BuildCDB_ReadHeader (NPUNITCB, ULONG, NPIORB_CDB FAR *);
VOID   BuildCDB_PauseResume (NPUNITCB, UCHAR, NPIORB_CDB FAR *);  // 10/23/2000 MB
VOID   BuildCDB_StartStopUnit (NPUNITCB, USHORT, NPIORB_CDB FAR *);
VOID   BuildCDB_PlayAudio_MSF (NPUNITCB, union AddressType,
                                         union AddressType, NPIORB_CDB FAR *);
VOID   BuildCDB_SCSICommand (NPUNITCB, USHORT, UCHAR FAR *, USHORT, ULONG, USHORT, NPIORB_CDB FAR *);
VOID   BuildCDB_SyncCache(NPUNITCB, ULONG, USHORT, NPIORB_CDB FAR *);
VOID   BuildCDB_ReadDVDStructure(NPUNITCB, USHORT, NPIORB_CDB FAR *);
VOID   _loadds FAR  NotifyDoneIORB(PIORB);
// initialization time routines re-used to re-initialize USB devices   //
VOID  _loadds FAR  InitPost(PIORB);                   // 02/02/2000 MB //
USHORT NEAR InitializeDevice (NPUNITCB);                               //
USHORT FAR  _loadds USBCallBck (USHORT cmd, ULONG idData, ULONG cmdData);// 02/02/2000 MB
USHORT      SetDeviceInterface(USHORT adapterDevBus);                    // 02/02/2000 MB
VOID   NEAR GetProductID (NPUNITCB);                                     // 10/23/2000 MB
VOID   NEAR init_scsi_cdrom (NPUNITCB);                                  // 10/23/2000 MB
VOID   NEAR init_proprietary_cdrom (NPUNITCB);                           // 10/23/2000 MB
VOID   NEAR init_atapi_cdrom (NPUNITCB);                                 // 10/23/2000 MB
VOID   NEAR init_audio_caps (NPUNITCB);                                  // 10/23/2000 MB
USHORT NEAR init_submit_cdb (NPUNITCB, NPIORB_CDB, BOOL);                // 10/23/2000 MB


/*-----------------------------------------------*
 * Function declarations for CDBLDCDB  routines  *
 *-----------------------------------------------*/
VOID BuildCBD_ReadCapacity (NPUNITCB, NPIORB FAR *);

/*                                                                    @V156096
** cdhp.c prologs                                                     @V156096
*/                                                                  /*@V156096*/
USHORT HP_GetLastSessionAddr( NPUNITCB, ULONG FAR * );              /*@V156096*/

/*-------------------------------------------------------*
 * Function declarations for CDASUBR assembler routines  *
 *-------------------------------------------------------*/
VOID   FAR  f_ZeroCB (PBYTE, USHORT);
VOID   FAR  f_BlockCopy (PBYTE, PBYTE, USHORT);
ULONG  FAR  f_add32(ULONG, ULONG);
VOID   FAR  f_SWait (PVOID);
VOID   NEAR SWait (PVOID);
VOID   FAR  f_SSig (PVOID);
VOID   NEAR SSig (PVOID);
VOID   NEAR ZeroFSGS (VOID);
VOID   NEAR PadRaw2340 (UCHAR FAR *, USHORT);

ULONG  NEAR HSGtoRedBook (ULONG a);
ULONG  NEAR RedBookToHSG (ULONG a);
UCHAR  NEAR BCDtoBinary (UCHAR a);
UCHAR  NEAR BinaryToBCD (UCHAR a);

/*-----------------------------------*
 * Pragma declarations - DevHelps    *
 *-----------------------------------*/
#pragma alloc_text(Code, DevHelp_VMUnLock)
#pragma alloc_text(Code, DevHelp_VMLock)
#pragma alloc_text(Code, DevHelp_VirtToLin)
#pragma alloc_text(Code, DevHelp_AllocReqPacket)
#pragma alloc_text(Code, DevHelp_FreeReqPacket)

// 10/23/2000 MB - added
// cdqueue.c
USHORT NEAR MapSenseData(NPIORB);
UCHAR  NEAR MapIORBError(USHORT);
USHORT NEAR SubmitIORB_Wait (NPUNITCB pUnitCB, NPIORB   pIORB);
VOID BuildCDB_EnablePMMode (NPUNITCB pUnitCB, NPIORB_CDB FAR *pIORBOut);
VOID BuildCDB_MechanismStatus(NPUNITCB pUnitCB, NPIORB_CDB FAR *pIORBOut,USHORT size);
VOID BuildCDB_SenseCapabilities (NPUNITCB pUnitCB, NPIORB_CDB FAR *pIORBOut);
VOID ADD_BuildCDB_ReadDiskInfo (NPUNITCB pUnitCB, UCHAR type, NPIORB_CDB FAR *pIORBOut);

USHORT PullWaitingQueue (NPUNITCB pUnitCB, NPIORB FAR *pIORB);
VOID QueueIORB (NPUNITCB pUnitCB, NPIORB pIORB);


USHORT ProcessError (NPUNITCB, NPIORB);

// cdiorb.c
VOID ATAPI_BuildCDB_ReadCD (NPUNITCB pUnitCB, ULONG LBA, USHORT transfer_length, ULONG transfer_addr,
                                                             NPIORB_CDB FAR *pIORBOut);
VOID BuildCDB_ModeSense_10 (NPUNITCB pUnitCB, UCHAR page_code, NPIORB_CDB FAR *pIORBOut); // 10/23/2000 MB
VOID BuildCDB_ModeSelect_WP (NPUNITCB pUnitCB, UCHAR *WP_data, NPIORB_CDB FAR *pIORBOut);
VOID BuildCDB_ReadTrackInfo(NPUNITCB pUnitCB, NPIORB_CDB FAR *pIORBOut);
VOID BuildCDB_FormatUnit (NPUNITCB pUnitCB, ULONG blocks, BYTE mediaType, NPIORB_CDB FAR *pIORBOut);
VOID BuildCDB_ReadFormatCapacities(NPUNITCB pUnitCB, NPIORB_CDB FAR *pIORBOut);
VOID BuildCDB_ChangerLoad(NPUNITCB pUnitCB, NPIORB_CDB FAR * pIORBOut,UCHAR Slot);
VOID BuildCDB_ModeSelect_10 (NPUNITCB pUnitCB, USHORT dataLenght, NPIORB_CDB FAR *pIORBOut); // 10/23/2000 MB
VOID BuildCDB_ModeSelect_6 (NPUNITCB pUnitCB, USHORT dataLenght, NPIORB_CDB FAR *pIORBOut); // 10/23/2000 MB
VOID BuildCDB_GetConfiguration (NPUNITCB pUnitCB, USHORT nf, NPIORB_CDB FAR *pIORBOut);

VOID BuildCDB_ReadDiscInfo(NPUNITCB pUnitCB, NPIORB_CDB FAR *pIORBOut);

// cdnec.c
VOID NEC_BuildCDB_GetLastSession (NPUNITCB pUnitCB, NPIORB_CDB FAR *pIORBOut);
VOID NEC46X_BuildCDB_GetLastSession (NPUNITCB pUnitCB, NPIORB_CDB FAR *pIORBOut);
USHORT NEC_GetLastSessionAddr (NPUNITCB pUnitCB, ULONG FAR *session_addr);
USHORT NEC46X_GetLastSessionAddr (NPUNITCB pUnitCB, ULONG FAR *session_addr);



// cdchinon.c
VOID Chinon_BuildCDB_GetLastSession (NPUNITCB pUnitCB, NPIORB_CDB FAR *pIORBOut);
USHORT Chinon_GetLastSessionAddr (NPUNITCB pUnitCB, ULONG FAR *session_addr);



// cdtosh.c
VOID Tosh_BuildCDB_ReadDiskInfo (NPUNITCB pUnitCB, UCHAR type, NPIORB_CDB FAR *pIORBOut);
USHORT Tosh_GetLastSessionAddr (NPUNITCB pUnitCB, ULONG FAR *session_addr);


//  cdsony.c
USHORT Sony_ReadCDDA (NPUNITCB pUnitCB, ULONG LBA, USHORT transfer_count, ULONG ppDataBuff);
USHORT Sony_ChainModeSelectRead_CDDA (NPUNITCB pUnitCB, ULONG LBA, USHORT transfer_count, ULONG ppDataBuff,
                                               USHORT block_length);
VOID Sony_BuildCDB_Read_CDDA (NPUNITCB pUnitCB, ULONG LBA, USHORT transfer_length, ULONG transfer_addr,
                                                             NPIORB_CDB FAR *pIORBOut);
USHORT Sony_ReadCDXA(NPUNITCB pUnitCB, ULONG LBA,USHORT transfer_count,ULONG ppDataBuff,USHORT block_length);
VOID Sony_BuildCDB_Read_CDXA (NPUNITCB pUnitCB, ULONG LBA, USHORT block_length, USHORT transfer_length,
                                       ULONG transfer_addr, UCHAR format, NPIORB_CDB FAR *pIORBOut);

USHORT Sony_GetLastSessionAddr (NPUNITCB pUnitCB, ULONG FAR *session_addr);

// cstrat1.c
USHORT ReadPacket (NPUNITCB pUnitCB, ULONG LBA, USHORT transfer_count, ULONG ppDataBuff, USHORT block_length);
USHORT WritePacket (NPUNITCB pUnitCB, ULONG LBA, USHORT transfer_count, ULONG ppDataBuff, USHORT block_length, BOOL verify);

#ifdef   DEBUG
void FAR dprintf( PSZ, ...);
#endif

