/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT (C) IBM Corporation, 1992                                       */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
/*static char *SCCSID = "@(#)cdnec.c  6.17 92/05/04";*/
#define SCCSID  "@(#)cdnec.c  6.17 92/05/04"

/************************************************************************/
/*                                                                      */
/* Driver Name: OS2CDROM.DMD - OS/2 CD-ROM Device Manager               */
/*              -----------------------------------------               */
/*                                                                      */
/* Source File Name: CDNEC.C                                            */
/*                                                                      */
/* Descriptive Name: Vendor unique command processing for NEC           */
/*                   SCSI-2 CD-ROM Drives                               */
/*                                                                      */
/* Function:                                                            */
/*                                                                      */
/*                                                                      */
/*----------------------------------------------------------------------*/
/*                                                                      */
/*                                                                      */
/* DISCLAIMER OF WARRANTIES.  The following [enclosed] code is          */
/* provided to you solely for the purpose of assisting you in           */
/* the development of your applications. The code is provided           */
/* "AS IS", without warranty of any kind. IBM shall not be liable       */
/* for any damages arising out of your use of this code, even if        */
/* they have been advised of the possibility of such damages.           */
/*                                                                      */
/*----------------------------------------------------------------------*/
/*                                                                      */
/* CHANGE ACTIVITY =                                                    */
/*  DATE      FLAG        APAR   CHANGE DESCRIPTION                     */
/*  --------  ----------  -----  -------------------------------------- */
/* 11/14/97   @190032    190032  Get correct last address for           */
/*                               Multisesion on CDRom NEC 1410a -1610a  */
/*                               -1810a T. Abbondanzio                  */
/************************************************************************/

#include "cdh.h"
#include "necdb.h"


/*------------------------------------------------------------------------
;
;** NEC_GetLastSessionAddr - Get address of last session on multisession
;                            disk
;
;   This routine returns the address of the last session of a multisession
;   photo CD disk.
;
;   USHORT NEC_GetLastSessionAddr(NPUNITCB pUnitCB, ULONG FAR * session_addr)
;
;   ENTRY:    pUnitCB          - Pointer to UnitCB
;             session_addr     - Pointer to returned session addr
;
;   RETURN:   USHORT           - Packet status word
;
;                                if the STERR bit is on, then the disk
;                                  is not a multisession disk and the
;                                  session_addr field is not valid
;
;                                if the STERR bit is NOT set, then the
;                                  disk is a multi-session disk and the
;                                  session addr field is valid
;
;
;   EFFECTS:
;
------------------------------------------------------------------------*/
USHORT NEC_GetLastSessionAddr (pUnitCB, session_addr)

NPUNITCB pUnitCB;
ULONG    FAR *session_addr;

{
   USHORT rc;
   NPIORB_CDB pIORB;
   NEC_DATA_PointInfo NEAR *pCDBData;
   union AddressType ul_LBA;
   ULONG LBA;

   NEC_BuildCDB_GetLastSession (pUnitCB, (NPIORB_CDB FAR *) &pIORB);

   pCDBData = (NEC_DATA_PointInfo NEAR *) pIORB->CDB_data;

   rc = SubmitIORB_Wait(pUnitCB, (NPIORB)pIORB);   // 10/23/2000 MB

   if (rc == STDON)
   {

      rc = STDON + STERR;

      /* If type photo CD in both point entries, and address of last */
      /* session not zero, then multisession disc.                   */

      if ( (pCDBData->point_data[0].control == NEC_PHOTO_CD) &&
           (pCDBData->point_data[1].control == NEC_PHOTO_CD) )
      {
         if ( (pCDBData->point_data[1].imin != 0)  ||
              (pCDBData->point_data[1].isec != 0)  ||
              (pCDBData->point_data[1].iframe != 0) )
         {
            ul_LBA.ul_redbook.frame =
            BCDtoBinary(pCDBData->point_data[1].iframe);
            ul_LBA.ul_redbook.sec =
            BCDtoBinary(pCDBData->point_data[1].isec);
            ul_LBA.ul_redbook.min =
            BCDtoBinary(pCDBData->point_data[1].imin);
            ul_LBA.ul_redbook.zero = 0;

            LBA = (RedBookToHSG (ul_LBA.dword) ) + 150;

            *session_addr = LBA;

            rc = STDON;
         }
      }

   }
   FreeIORB (pUnitCB, pIORB);
   return (rc);
}



/*------------------------------------------------------------------------  *@190032*
;
;** NEC46X_GetLastSessionAddr - Get address of last session on multisession
;                               disk
;
;   This routine returns the address of the last session of a multisession
;   photo CD disk.
;
;   USHORT NEC46X_GetLastSessionAddr(NPUNITCB pUnitCB, ULONG FAR * session_addr)
;
;   ENTRY:    pUnitCB          - Pointer to UnitCB
;             session_addr     - Pointer to returned session addr
;
;   RETURN:   USHORT           - Packet status word
;
;                                if the STERR bit is on, then the disk
;                                  is not a multisession disk and the
;                                  session_addr field is not valid
;
;                                if the STERR bit is NOT set, then the
;                                  disk is a multi-session disk and the
;                                  session addr field is valid
;
;
;   EFFECTS:
;
------------------------------------------------------------------------*/
USHORT NEC46X_GetLastSessionAddr (pUnitCB, session_addr)

NPUNITCB pUnitCB;
ULONG    FAR *session_addr;

{
   USHORT rc;
   USHORT i;
   NPIORB_CDB pIORB;
   NEC46X_DATA_ReadTOC NEAR *pCDBData;
   union ULONGB LBA;

   NEC46X_BuildCDB_GetLastSession (pUnitCB, (NPIORB_CDB FAR *) &pIORB);

   pCDBData = (NEC46X_DATA_ReadTOC NEAR *) pIORB->CDB_data;

   rc = SubmitIORB_Wait(pUnitCB, (NPIORB)pIORB);   // 10/23/2000 MB

   if (rc == STDON)
   {
      rc = STDON + STERR;

      /*
      ** If first session != last session, then multisession disk
      */
      if (pCDBData->first_track_num != pCDBData->last_track_num)
      {
         i = pCDBData->last_track_num - 1;
         LBA.ulbytes.byte_0 = pCDBData->track_desc[i].LBA.ulbytes.byte_3;
         LBA.ulbytes.byte_1 = pCDBData->track_desc[i].LBA.ulbytes.byte_2;
         LBA.ulbytes.byte_2 = pCDBData->track_desc[i].LBA.ulbytes.byte_1;
         LBA.ulbytes.byte_3 = pCDBData->track_desc[i].LBA.ulbytes.byte_0;
         *session_addr = LBA.dword;
         rc = STDON;
      }
      else
      {
         rc = STDON + STERR;
      }

   }
   FreeIORB (pUnitCB, pIORB);
   return (rc);
}




