/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT (C) IBM Corporation, 1992                                       */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
/******************************************************************************/
/*                                                                            */
/*                                                                            */
/*   OCO Source Materials                                                     */
/*                                                                            */
/*   Program Number (if available)                                            */
/*                                                                            */
/*                                                                            */
/*   The source code for this program is not published or otherwise divested  */
/*   of its tradesecrets, irrespective of what has been deposited with the    */
/*   U. S. Copyright Office.                                                  */
/*                                                                            */
/******************************************************************************/
/**************************************************************************
 *
 * SOURCE FILE NAME = CDIRTN.C
 *
 * DESCRIPTIVE NAME = Initialization routines for CD-ROM Device Manager
 *
 *
 * VERSION = V2.0
 *
 * DATE
 *
 * DESCRIPTION
 *
 *
 * FUNCTIONS
 *
 * ENTRY POINTS:
 *
 * DEPENDENCIES:
 *
 * NOTES
 *
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
*/
#undef __JSM_DEBUG__

#include "cdh.h"
#include "devclass.h"          
#include "dskinit.h"

// 02/02/2000 MB
/****************************************************************************
 *
 * FUNCTION NAME = USBCallBck
 *
 * DESCRIPTION   = set interface code based on adapter bus type
 *
 *                 USBCallBck (USHORT cmd, ULONG idData, ULONG cmdData)
 *
 * INPUT         = USHORT cmd - callback command code
 *               = ULONG idData - device identification data (pointer to unit
 *                 control block)
 *               = ULONG cmdData - pointer to command dependent data structure
 *
 * OUTPUT        = n/a
 *
 * RETURN-NORMAL = error code
 * RETURN-ERROR  = n/a
 *
 ****************************************************************************/
USHORT FAR  _loadds USBCallBck (USHORT cmd, ULONG idData, ULONG cmdData)
{
   NPUNITCB    pUnitCB=(NPUNITCB)idData;
   USHORT      rc=0;


   switch (cmd)
   {
   case USB_DMD_REINITIALIZE:
      pUnitCB->Flags|=UCF_NEED_REINIT;  ///////////
//      pUnitCB->Flags|=UCF_UNCERTAIN_MEDIA;   /////////
      break;

   case USB_DMD_SETBUSTYPE:
      pUnitCB->DeviceInfo.interface_type=SetDeviceInterface((USHORT)cmdData);
      break;

   default:
      break;
   }

   return (rc);
}

/****************************************************************************
 *
 * FUNCTION NAME = SetDeviceInterface
 *
 * DESCRIPTION   = set interface code based on adapter bus type
 *
 *                 USHORT SetDeviceInterface(USHORT adapterDevBus)
 *
 * INPUT         = adapterDevBus   - adapter device bus code
 *
 * OUTPUT        = USHORT          - device interface code
 *
 * RETURN-NORMAL = device interface code
 * RETURN-ERROR  = n/a
 *
 ****************************************************************************/

USHORT SetDeviceInterface(USHORT adapterDevBus) // 02/01/2000 MB
{
   USHORT      interface_type;

   if ((adapterDevBus & 0x00FF) == AI_DEVBUS_NONSCSI_CDROM)
      interface_type = INTERFACE_PROPRIETARY;
   else if ((adapterDevBus & 0x00FF) == AI_DEVBUS_ST506)
      interface_type = INTERFACE_ATAPI;
   else
      interface_type = INTERFACE_SCSI;

   return (interface_type);
}

/****************************************************************************
 *
 * FUNCTION NAME = InitializeDevice
 *
 * DESCRIPTION   = initialize the target device
 *
 *                 VOID InitializeDevice(NPUNITCB pUnitCB)
 *
 * INPUT         = pUnitCB         - pointer to UnitCB
 *
 * OUTPUT        = USHORT          - error status word
 *
 * RETURN-NORMAL =
 * RETURN-ERROR  =
 *
 ****************************************************************************/

USHORT InitializeDevice (pUnitCB)

NPUNITCB pUnitCB;
{
   USHORT        i, IORBError;                                      /*V@91985*/
   NPIORB_CDB    pIORB;
   struct Channel *channel;
   struct Audio   *audio;
   USHORT        status, savedErrCode;   // 02/02/2000 MB

   audio = &pUnitCB->DeviceInfo.Audio;
   channel = &audio->channel;

   /*
   ** Issue Test Unit Ready to clear any pending check conditions. Retry
   ** up to 5 times, if still check condition, then return device error
   */
   for (i = 1; i <= 5; i++)
   {
      BuildCDB_TestUnitReady (pUnitCB, (NPIORB_CDB FAR *) &pIORB);
      status=init_submit_cdb (pUnitCB, pIORB, FALSE); // 02/02/2000 MB
      savedErrCode=pIORB->apt.iorbh.ErrorCode; // 02/02/2000 MB
      IORBError=0;

      if (CDFlags & CDF_INIT_COMPLETE)
         FreeIORB (pUnitCB, pIORB);

      if ( ! (status & IORB_ERROR) )
         break;

      IORBError = MapSenseData ((NPIORB)pIORB);                     /*V@91985*/

      if (!IORBError)   // not all ADD drivers return sense data  // 02/02/2000 MB
         IORBError=MapIORBError(savedErrCode);   // remap return code

      IORBError&=STECODE;

      if ( (IORBError == ERROR_I24_NOT_READY) ||    /*V@91985*/
           (IORBError == ERROR_I24_SECTOR_NOT_FOUND) )
         break;

      if (i == 5)
      {
         return (STDON + STERR + ERROR_I24_GEN_FAILURE);
      }
   }

   /*
   ** Then issue a Request Sense Command
   */
   {
      BuildCDB_RequestSense ( pUnitCB, (NPIORB_CDB FAR *) &pIORB);
      init_submit_cdb (pUnitCB, pIORB, TRUE);
   }

   /*
   ** Get the inquiry data
   */
   f_ZeroCB((PBYTE)&pUnitCB->InquiryData, sizeof(pUnitCB->InquiryData)); // 02/02/2000 MB
   if (pUnitCB->UnitInfo.UnitFlags&UF_USB_DEVICE)  // 10/13/2000 MB
   {
      // set default values for USB device INQUIRY data
      pUnitCB->InquiryData.vendor_id[0]='U';   // 02/02/2000 MB
      pUnitCB->InquiryData.vendor_id[1]='S';   // 02/02/2000 MB
      pUnitCB->InquiryData.vendor_id[2]='B';   // 02/02/2000 MB
      pUnitCB->InquiryData.vendor_id[3]=' ';   // 02/02/2000 MB
      pUnitCB->InquiryData.vendor_id[4]=' ';   // 02/02/2000 MB
      pUnitCB->InquiryData.vendor_id[5]=' ';   // 02/02/2000 MB
      pUnitCB->InquiryData.vendor_id[6]=' ';   // 02/02/2000 MB
      pUnitCB->InquiryData.vendor_id[7]=' ';   // 02/02/2000 MB
      pUnitCB->InquiryData.product_id[0]='C';   // 02/02/2000 MB
      pUnitCB->InquiryData.product_id[1]='D';   // 02/02/2000 MB
      pUnitCB->InquiryData.product_id[2]='-';   // 02/02/2000 MB
      pUnitCB->InquiryData.product_id[3]='R';   // 02/02/2000 MB
      pUnitCB->InquiryData.product_id[4]='O';   // 02/02/2000 MB
      pUnitCB->InquiryData.product_id[5]='M';   // 02/02/2000 MB
   }
   audio->capabilities = 0;
   {
      BuildCDB_Inquiry(pUnitCB, (NPIORB_CDB FAR *) &pIORB);
      init_submit_cdb (pUnitCB, pIORB, TRUE);

      /*
      ** Get the vendor and product id code from the inquiry data
      */
      GetProductID (pUnitCB);

      /*
      ** Initialize drive based on interface type
      */
      switch (pUnitCB->DeviceInfo.interface_type)
      {
      case INTERFACE_SCSI:
         init_scsi_cdrom(pUnitCB);
         break;

      case INTERFACE_PROPRIETARY:
         init_proprietary_cdrom(pUnitCB);
         break;

      case INTERFACE_ATAPI:
         init_atapi_cdrom(pUnitCB);
         break;
      }

      /*
      ** Issue a Mode Select to set default density code to CD-ROM
      ** and default block size to 2048 bytes.
      */
      if (pUnitCB->DeviceInfo.interface_type != INTERFACE_ATAPI)
      {
         BuildCDB_ModeSelect (pUnitCB, CD_DENSITY_DEFAULT, 2048,
                              (NPIORB_CDB FAR *) &pIORB);
         init_submit_cdb (pUnitCB, pIORB, TRUE);
      }
   }

   /*
   ** Initialize device info fields
   */
   pUnitCB->DeviceInfo.current_block_size = 2048;
   pUnitCB->DeviceInfo.raw_block_size = 0;
   pUnitCB->DeviceInfo.current_density = CD_DENSITY_DEFAULT;
   pUnitCB->DeviceInfo.disk_density = CD_DENSITY_DEFAULT;

   pUnitCB->DeviceInfo.playing = FALSE;     

   /*
   ** Initialize the audio channels to stereo and max volume.
   */
   channel->input_0  = 0;
   channel->volume_0 = 0xFF;
   channel->input_1  = 1;       
   channel->volume_1 = 0xFF;
   {
      BuildCDB_AudioControl(pUnitCB, (NPIORB_CDB FAR *) &pIORB, TRUE);   // 10/23/2000 MB
      status=init_submit_cdb (pUnitCB, pIORB, TRUE); // 02/02/2000 MB
   }

   /*
   ** If no error, then indicate audio supported on this device
   */
   pUnitCB->Flags &= ~UCF_AUDIO_SUPPORTED;  // 02/02/2000 MB
   if ( ! (status & IORB_ERROR) )  // 02/02/2000 MB
      pUnitCB->Flags |= UCF_AUDIO_SUPPORTED;

   return (STDON);
}

/****************************************************************************
 *
 * FUNCTION NAME = init_scsi_cdrom
 *
 * DESCRIPTION   = initialize scsi cd-rom drive
 *
 *                 VOID init_scsi_cdrom  (NPUNITCB pUnitCB)
 *
 * INPUT         = pUnitCB         - pointer to UnitCB
 *
 * OUTPUT        = USHORT          - error status word
 *
 * RETURN-NORMAL =
 * RETURN-ERROR  =
 *
 ****************************************************************************/

VOID init_scsi_cdrom (pUnitCB)

NPUNITCB pUnitCB;
{
   USHORT n;
   struct Audio   *audio;

   audio = &pUnitCB->DeviceInfo.Audio;

   // set default capabilities because the device may NOT be in the table
   audio->capabilities = DCAPS_XA   |
                         DCAPS_CDDA |
                         DCAPS_MULTISESSION |
                         DCAPS_UPC;                                  
   /*
   ** Set driver capability bits from drive capabilites table
   */

   for (n = 0; drive_caps_table[n].product_id_code; n++)   // 02/02/2000 MB
   {
      if (pUnitCB->DeviceInfo.product_id_code ==
          drive_caps_table[n].product_id_code)
      {
         audio->capabilities = drive_caps_table[n].capabilities;     
         break;
      }
   }

   /*
   ** Initialize the audio capabilities
   */
   init_audio_caps(pUnitCB);

   /*
   ** Some specialized bit twiddling for some SCSI drives.
   **
   ** Hitachi and Texel return Not Ready for Mode Selects when no
   ** media present, so set audio bits directly.
   */

   switch (pUnitCB->DeviceInfo.vendor_id_code)
   {
   case HITACHI:
      audio->capabilities |= (DCAPS_NO_AUDIO_CTRL_DURING_PLAY |
                              DCAPS_NO_CHANNEL_SWAP |
                              DCAPS_INDEPENDENT_VOLUME_LEVELS);
      break;

   case TEXEL:
      audio->capabilities |= (DCAPS_MUTE | DCAPS_INDEPENDENT_VOLUME_LEVELS);
      break;

   case IBM:
      if (pUnitCB->DeviceInfo.product_id_code == TOSHIBA_3301)
         audio->capabilities |= DCAPS_CDDA;
      break;
   }
}

/****************************************************************************
 *
 * FUNCTION NAME = init_proprietary_cdrom
 *
 * DESCRIPTION   = initialize proprietary CD-ROM drive
 *
 *                 VOID init_proprietary_cdrom (NPUNITCB pUnitCB)
 *
 * INPUT         = pUnitCB         - pointer to UnitCB
 *
 * OUTPUT
 *
 * RETURN-NORMAL =
 * RETURN-ERROR  =
 *
 ****************************************************************************/

VOID init_proprietary_cdrom (pUnitCB)

NPUNITCB pUnitCB;
{
   NPIORB_CDB    pIORB;
   union ADD_ReadDiskInfo_Data NEAR *pCDBData;
   struct Audio   *audio;
   USHORT        status;  // 02/02/2000 MB

   audio = &pUnitCB->DeviceInfo.Audio;


   /*
   ** Issue ReadDriveInfo command to get the capabilites of the drive.
   */

   ADD_BuildCDB_ReadDiskInfo (pUnitCB, TYPE_CAPABILITIES_INFO,
                              (NPIORB_CDB FAR *) &pIORB);

   status=init_submit_cdb (pUnitCB, pIORB, FALSE); // 02/02/2000 MB /  10/23/2000 MB

   if ( !(status & IORB_ERROR) )   // 02/02/2000 MB
   {
      pCDBData = (union ADD_ReadDiskInfo_Data NEAR *) pIORB->CDB_data;

      if (pCDBData->capabilities.read_capabilities & CAP_MULTISESSION)
         audio->capabilities |= DCAPS_MULTISESSION;

      if (pCDBData->capabilities.read_capabilities & CAP_MODE2_FORM2)
         audio->capabilities |= DCAPS_XA;

      if (pCDBData->capabilities.read_capabilities & CAP_CDDA)
         audio->capabilities |= DCAPS_CDDA;
   }

   if (CDFlags & CDF_INIT_COMPLETE) // 10/23/2000 MB
      FreeIORB (pUnitCB, pIORB);

   /*
   ** Initialize the audio capabilities
   */

   init_audio_caps(pUnitCB);
}


/****************************************************************************
 *
 * FUNCTION NAME = init_atapi_cdrom
 *
 * DESCRIPTION   = initialize atapi cd-rom drive
 *
 *                 VOID init_atapi_cdrom  (NPUNITCB pUnitCB)
 *
 * INPUT         = pUnitCB         - pointer to UnitCB
 *
 * RETURN-NORMAL =
 * RETURN-ERROR  =
 *
 ****************************************************************************/

VOID init_atapi_cdrom (pUnitCB)

NPUNITCB pUnitCB;
{
   NPIORB_CDB    pIORB;
   struct CapabilitiesParmList_10 NEAR *pCDBData;
   struct Audio   *audio;
   USHORT        status;  // 02/02/2000 MB

   audio = &pUnitCB->DeviceInfo.Audio;

   /*
   ** Issue Mode Sense to read the CD-ROM capabilites page.
   */

   BuildCDB_SenseCapabilities (pUnitCB, (NPIORB_CDB FAR *) &pIORB);
   status=init_submit_cdb (pUnitCB, pIORB, FALSE);  // 02/02/2000 MB   // 10/23/2000 MB

   /*
   ** Set the capability bits in the unit control block
   */

   if ( !(status & IORB_ERROR) )  // 02/02/2000 MB
   {
      pCDBData = (struct CapabilitiesParmList_10 NEAR *) pIORB->CDB_data;

      if (pCDBData->CapPage.capabilities & CP_MULTISESSION)
         audio->capabilities |= DCAPS_MULTISESSION;

      if (pCDBData->CapPage.capabilities & CP_MODE2_FORM2)
         audio->capabilities |= DCAPS_XA;

      if (pCDBData->CapPage.capabilities & CP_CDDA)
         audio->capabilities |= DCAPS_CDDA;

      if (pCDBData->CapPage.capabilities & CP_INDEPENDENT_VOLUME_LEVELS)
         audio->capabilities |= DCAPS_INDEPENDENT_VOLUME_LEVELS;

      if ( (pCDBData->CapPage.num_volume_levels.usbytes.byte_0 != 0) ||
           (pCDBData->CapPage.num_volume_levels.usbytes.byte_1 > 2))
         audio->capabilities |= DCAPS_VARIABLE_VOLUME;

      audio->capabilities |= DCAPS_MUTE;

      if (pCDBData->CapPage.capabilities & CP_UPC)
      {
         audio->capabilities |= DCAPS_UPC;
         audio->capabilities |= DCAPS_UPC_IN_ASCII;
      }
      //SD@135221
      if ((pCDBData->CapPage.capabilities & CP_INDIVIDUAL_CHANGER) == CP_INDIVIDUAL_CHANGER)//SD@135221
      {
         //SD@135221
         audio->capabilities |= DCAPS_INDIVIDUAL_CHANGER;            //SD@135221
      } /* endif */                                                   //SD@135221
      else if ((pCDBData->CapPage.capabilities & CP_CARTRIDGE_CHANGER) == CP_CARTRIDGE_CHANGER)//SD@135221
      {
         //SD@135221
         audio->capabilities |= DCAPS_CARTRIDGE_CHANGER;             //SD@135221
      } /* endelse */                                                 //SD@135221

      if (CDFlags & CDF_INIT_COMPLETE) // 10/23/2000 MB
         FreeIORB (pUnitCB, pIORB);
      //SD@135221
      if (pUnitCB->DeviceInfo.vendor_id_code==TORISAN)                 //SD@135221
      {
         //SD@135221
         if (pUnitCB->DeviceInfo.product_id_code==TORISAN_C3G)          //SD@135221
         {
            //SD@135221
            audio->capabilities |= DCAPS_CARTRIDGE_CHANGER;             //SD@135221
            pUnitCB->DeviceInfo.Slots.Maximum=3;                        //SD@135221
            pUnitCB->DeviceInfo.Slots.Current=0;                        //SD@135221
         } /* endif */                                               //SD@135221
      } /* endif */                                                   //SD@135221
      else if (audio->capabilities & (DCAPS_CARTRIDGE_CHANGER |DCAPS_INDIVIDUAL_CHANGER))//SD@135221
      {
         //SD@135221
         USHORT size;                                                //SD@135221
         if (pUnitCB->DeviceInfo.product_id_code==NEC_251_250)        //SD@135221
         {
            //SD@135221
            size= (4*sizeof(struct SlotTableEntry));                  //SD@135221
         }                                                         //SD@135221
         else                                                        //SD@135221
         {
            //SD@135221
            size=0;                                                   //SD@135221
         }                                                         //SD@135221
         BuildCDB_MechanismStatus (pUnitCB, (NPIORB_CDB FAR *) &pIORB, sizeof(struct Mechanism_Hdr) +size); //SD@135221
         status=init_submit_cdb (pUnitCB, pIORB, FALSE);                           //SD@135221 // 02/02/2000 MB // 10/23/2000 MB
         //SD@135221
         /*                                                          //SD@135221
         ** Set the capability bits in the unit control block        //SD@135221
         */                                                          //SD@135221
                                                                     //SD@135221
         if ( !(status & IORB_ERROR) )              //SD@135221 // 02/02/2000 MB
         {
            //SD@135221
            struct MechanismStatusList NEAR *pCDBData;              //SD@135221
            pCDBData = (struct MechanismStatusList NEAR *) pIORB->CDB_data; //SD@135221
            pUnitCB->DeviceInfo.Slots.Maximum=pCDBData->Mechanism_Header.Number_Of_Slots;//SD@135221
            pUnitCB->DeviceInfo.Slots.Current=pCDBData->Mechanism_Header.CurrentSlot;//SD@135221
         }                                                           //SD@135221
         else                                                        //SD@135221
         {
            //SD@135221
            /*                                                      @V167248
            ** If the CD-ROM told us it was a changer of some       @V167248
            ** description and then could not report thenumber      @V167248
            ** of platters, then assume the changer capability      @V167248
            ** was       and proceed as if it is a regular CD-ROM.  @V167248
            */                                                    /*@V167248*/
            audio->capabilities &= ~(DCAPS_CARTRIDGE_CHANGER |    /*@V167248*/
                                     DCAPS_INDIVIDUAL_CHANGER);   /*@V167248*/
         }                                                           //SD@135221
         if (CDFlags & CDF_INIT_COMPLETE) // 10/23/2000 MB
            FreeIORB (pUnitCB, pIORB);

      } /* endif */                                                   //SD@135221
   }
   else // 10/23/2000 MB
   {

      if (CDFlags & CDF_INIT_COMPLETE)
         FreeIORB (pUnitCB, pIORB);
   }

   /*                                                                        //JSM
   ** Issue Power Management Enable to TEAC ATAPI CD_ROM                     //JSM
   */                                                                        //JSM
   if (pUnitCB->DeviceInfo.product_id_code == TEAC_CD40E )
   {                 //JSM
      BuildCDB_EnablePMMode (pUnitCB, (NPIORB_CDB FAR *) &pIORB);            //JSM
#if defined(__JSM_DEBUG__)
      DevHelp_Save_Message( (NPBYTE) "Power Enable" );
#endif
      status=init_submit_cdb (pUnitCB, pIORB, TRUE);                                      //JSM   // 02/02/2000 MB
#if defined(__JSM_DEBUG__)
      if ( !(status & IORB_ERROR) )
      {    // 02/02/2000 MB
         DevHelp_Save_Message( (NPBYTE) "Power Enabled" );
      }
      else
      {
         DevHelp_Save_Message( (NPBYTE) "Power Enable Failed" );
      } /* endif */
   }
   else
   {
      DevHelp_Save_Message( (NPBYTE) "No Power Enable" );
#endif
   } /* endif */                                                             //JSM

}

/****************************************************************************
 *
 * FUNCTION NAME = init_audio_caps
 *
 * DESCRIPTION   = initialize audio capabilities
 *
 *                 VOID init_audio_caps (NPUNITCB pUnitCB)
 *
 * INPUT         = pUnitCB         - pointer to UnitCB
 *
 * RETURN-NORMAL =
 * RETURN-ERROR  =
 *
 ****************************************************************************/

VOID init_audio_caps(pUnitCB)

NPUNITCB pUnitCB;
{

   NPIORB_CDB    pIORB;
   struct Channel *channel;
   struct Audio   *audio;
   USHORT        status;  // 02/02/2000 MB

   audio = &pUnitCB->DeviceInfo.Audio;
   channel = &audio->channel;

   /*
   **
   ** Determine audio capabilities of the drive by issuing Mode
   ** Selects with different audio control page parameters.
   **
   */

   /*
   ** Determine if the drive supports variable volume control.
   */
   audio->capabilities |= DCAPS_VARIABLE_VOLUME;
   channel->input_0=0;       // 10/24/2000 MB
   channel->volume_0=0xAA;   // 10/24/2000 MB
   channel->input_1=1;       // 10/24/2000 MB
   channel->volume_1=0xAA;   // 10/24/2000 MB
   BuildCDB_AudioControl(pUnitCB, (NPIORB_CDB FAR *) &pIORB, TRUE); // 10/23/2000 MB
   status=init_submit_cdb (pUnitCB, pIORB, TRUE); // 02/02/2000 MB

   if (status & IORB_ERROR) // 02/02/2000 MB
      audio->capabilities &= ~DCAPS_VARIABLE_VOLUME;

   /*
   ** Determine if the drive supports setting the channel select to mute
   */
   audio->capabilities |= DCAPS_MUTE;
   channel->input_0=0xFF;       // 10/24/2000 MB
   channel->volume_0=0xFF;      // 10/24/2000 MB
   channel->input_1=0xFF;       // 10/24/2000 MB
   channel->volume_1=0xFF;      // 10/24/2000 MB
   BuildCDB_AudioControl(pUnitCB, (NPIORB_CDB FAR *) &pIORB, TRUE); // 10/23/2000 MB
   status=init_submit_cdb (pUnitCB, pIORB, TRUE); // 02/02/2000 MB

   if (status & IORB_ERROR) // 02/02/2000 MB
      audio->capabilities &= ~DCAPS_MUTE;

   /*
   ** Determine if the drive supports setting the volume level for
   ** channel 1 to be different from the volume level for channel 2
   */
   audio->capabilities |= DCAPS_INDEPENDENT_VOLUME_LEVELS;
   channel->input_0=0;       // 10/24/2000 MB
   channel->volume_0=0x00;   // 10/24/2000 MB
   channel->input_1=1;       // 10/24/2000 MB
   channel->volume_1=0xFF;   // 10/24/2000 MB
   BuildCDB_AudioControl(pUnitCB, (NPIORB_CDB FAR *) &pIORB, TRUE); // 10/23/2000 MB
   status=init_submit_cdb (pUnitCB, pIORB, TRUE); // 02/02/2000 MB

   if (status & IORB_ERROR) // 02/02/2000 MB
      audio->capabilities &= ~DCAPS_INDEPENDENT_VOLUME_LEVELS;

}


/****************************************************************************
 *
 * FUNCTION NAME = init_submit_cdb
 *
 * DESCRIPTION   = init time submit cdb routine
 *
 *                 VOID init_submit_cdb (NPUNITCB pUnitCB, NPIORB_CDB pIORB)
 *
 * INPUT         = pUnitCB         - pointer to UnitCB
 *                 pIORB           - pointer to IORB
 *
 * RETURN-NORMAL =
 * RETURN-ERROR  =
 *
 ****************************************************************************/

USHORT init_submit_cdb(pUnitCB, pIORB, relFlag)

NPUNITCB pUnitCB;
NPIORB_CDB pIORB;
BOOL       relFlag;
{
   USHORT   status;


   if (CDFlags & CDF_INIT_COMPLETE)
   {
      SubmitIORB_Wait (pUnitCB, (NPIORB)pIORB);   // 10/23/2000 MB
      status=pIORB->apt.iorbh.Status;
      if (relFlag)
         FreeIORB (pUnitCB, pIORB);
   }
   else
   {
      /*
      **  If ATAPI command, change CDB command length to 12.
      */
      if ( (pUnitCB->DeviceInfo.interface_type == INTERFACE_ATAPI) &&
           (pIORB->apt.iorbh.CommandCode == IOCC_ADAPTER_PASSTHRU) )
      {
         pIORB->apt.ControllerCmdLen = ATAPI_CDB_LENGTH;
      }
      /*
      ** Submit CDB.  Wait till done.
      */

      pIORB->apt.iorbh.NotifyAddress = &InitPost;

      (*pUnitCB->AdapterDriverEP) ((PVOID) (pIORB));

      while ( !(pIORB->apt.iorbh.Status & IORB_DONE) )
         DevHelp_ProcBlock( (ULONG) (PVOID)pIORB, (ULONG) 200, WAIT_IS_INTERRUPTABLE );  // 10/23/2000 MB

      status=pIORB->apt.iorbh.Status;

#ifdef   DEBUGi
      {
         dprintf("OS2CDROM init_submit_cdb Status=%x, ErrorCode=%x, pUnitCB=%x\r\n",
                 (PVOID)&pIORB->apt.iorbh.Status, (PVOID)&pIORB->apt.iorbh.ErrorCode, (PVOID)&pUnitCB);
      }
#endif
   }

   return (status);
}



/****************************************************************************
 *
 * FUNCTION NAME = GetProductID
 *
 * DESCRIPTION   = get product id code
 *
 *                 VOID   GetProductID  (NPUNITCB pUnitCB)
 *
 * INPUT         = pUnitCB          - pointer to UnitCB
 *
 * OUTPUT        =
 *
 * RETURN-NORMAL =
 * RETURN-ERROR  =
 *
 ****************************************************************************/

VOID GetProductID (pUnitCB)

NPUNITCB pUnitCB;
{

   USHORT n, rc, product_id_length;

   pUnitCB->DeviceInfo.vendor_id_code = 0;
   pUnitCB->DeviceInfo.product_id_code = 0;

   for ( n = 0; vendor_id_table[n].vendor_id_string; ++n)
   {
      rc = Strncmp(pUnitCB->InquiryData.vendor_id,
                   vendor_id_table[n].vendor_id_string,
                   8 );

      if ( rc )
      {
         pUnitCB->DeviceInfo.vendor_id_code =
         vendor_id_table[n].vendor_id_code;
         break;
      }
   }

   product_id_length = 24;

   for ( n = 0; product_id_table[n].product_id_string; ++n)
   {
      rc = Strncmp(pUnitCB->InquiryData.vendor_id,
                   product_id_table[n].product_id_string,
                   product_id_length );

      if ( rc )
      {
         /* if this is a NEC 260, is it ATAPI compliant? */
         /* mark the product_id_code if it is not        */

         if ( product_id_table[n].product_id_code == NEC_260_17B )
         {
            if (Strncmp(pUnitCB->InquiryData.revision_level,"1.01",4 ))
            {
               pUnitCB->DeviceInfo.product_id_code =
               product_id_table[n].product_id_code;
            }
         }
         else
         {
            pUnitCB->DeviceInfo.product_id_code =
            product_id_table[n].product_id_code;
         }
         break;
      }
   }

   /*
   ** If we find a SCSI-2 drive from a known vendor with a product id
   ** which is different that those known models listed in the table,
   ** then assume it is a future drive model which is upwardly compatible
   ** with it latest known drive, and assign the product id as the last
   ** known drive.  If the drive is truly upwards compatible, then it allows
   ** this level of the CD-ROM driver to work with future drives, and avoids
   ** the need to re-release the driver.
   */

   if ( (pUnitCB->DeviceInfo.product_id_code == 0) &&
        (pUnitCB->InquiryData.ansi_version == 2)  &&
        (pUnitCB->DeviceInfo.interface_type == INTERFACE_SCSI)  )
   {
      switch (pUnitCB->DeviceInfo.vendor_id_code)
      {
      case IBM:
      case TOSHIBA:
         pUnitCB->DeviceInfo.product_id_code = TOSHIBA_3401;
         break;

      case SONY:
         pUnitCB->DeviceInfo.product_id_code = SONY_561;
         break;

      case HITACHI:
         pUnitCB->DeviceInfo.product_id_code = HITACHI_6750;
         break;

      case TEXEL:
         pUnitCB->DeviceInfo.product_id_code = TEXEL_3024K;
         break;

      case PIONEER:
         pUnitCB->DeviceInfo.product_id_code = PIONEER_604X;
         break;

      case CHINON:
         pUnitCB->DeviceInfo.product_id_code = CHINON_535;
         break;

      case LMS:
         pUnitCB->DeviceInfo.product_id_code = LMS_215;
         break;

      case NEC:
         pUnitCB->DeviceInfo.product_id_code = NEC_84_1;
         break;

      case PLEXTOR:                                                   
         pUnitCB->DeviceInfo.product_id_code = PLEXTOR_PX20;
         break;                                                       
      }
   }
}


/****************************************************************************
 *
 * FUNCTION NAME = InitPost
 *
 * DESCRIPTION   = Dummy notification callout for ADDs during init processing
 *
 *                 VOID FAR InitPost(PIORB pIORB)
 *
 * INPUT         = pIORB           - pointer to IORB
 *
 * OUTPUT        =
 *
 * RETURN-NORMAL =
 * RETURN-ERROR  =
 *
 ****************************************************************************/

VOID _loadds FAR InitPost(pIORB)

PIORB pIORB;
{

   if (CDFlags & CDF_INIT_COMPLETE)
   {
      NotifyDoneIORB (pIORB); // 02/02/2000 MB - required for device re-initialization
   }
}

