/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
/**************************************************************************
 *
 * SOURCE FILE NAME = CDIOCTL.H
 *
 * DESCRIPTIVE NAME = Internal data structures for IOCTL handling in
 *                    the OS/2 CD-ROM Device Mgr.
 *
 *
 * VERSION = V2.0
 *
 * DATE
 *
 * DESCRIPTION
 *
 *
 * FUNCTIONS
 *
 * ENTRY POINTS:
 *
 * DEPENDENCIES:
 *
 * NOTES
 *
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
*/

/*----------------------------------------*
 * Category 0x80 CD-ROM IOCTL Definitions *
 *----------------------------------------*/
#define IOC_CDROM            0x80         /* CD-ROM Category Code           */

#define IOCD_RESET           0x40         /* Reset Drive                    */
#define IOCD_EJECT           0x44         /* Eject Disk                     */
#define IOCD_CLOSE_TRAY      0x45         /* Close Tray                     */
#define IOCD_LOCK_UNLOCK     0x46         /* Lock/Unlock Drive Door         */
#define IOCD_SET_ACTIVE_TRAY 0x47         /* set specific tray active       */
#define IOCD_WRITE_CTRL      0x4F         /* Write Drive Control String     */
#define IOCD_SEEK            0x50         /* Seek                           */
#define IOCD_WRITE_LONG      0x52         /* Write Long                     */
#define IOCD_WRITEV_LONG     0x53         /* Write Long Verify              */
#define IOCD_DEVICE_STATUS   0x60         /* Device Status                  */
#define IOCD_IDENTIFY        0x61         /* Identify CD-ROM Driver         */
#define IOCD_SECTOR_SIZE     0x63         /* Return sector size             */
#define IOCD_TRAY_STATUS     0x67         /* Return tray status on changers */
#define IOCD_READ_CTRL       0x6F         /* Read Drive Control String      */
#define IOCD_HEAD_LOCATION   0x70         /* Ret Current Head Location      */
#define IOCD_READ_PREFETCH   0x71         /* Read Prefetch                  */
#define IOCD_READ_LONG       0x72         /* Read Long                      */
#define IOCD_READ_LONG_PRE   0x73         /* Read Long Prefetch             */
#define IOCD_VOLUME_SIZE     0x78         /* Return Volume Size             */
#define IOCD_UPC             0x79         /* Return UPC/EAN code            */
#define IOCD_EXECMD          0x7A         /* Execute device command         */ /* (AK:02-23-2001) */

/*----------------------------------------------*
 * Category 0x81 CD-ROM AUDIO IOCTL Definitions *
 *----------------------------------------------*/
#define IOC_CDROM_AUDIO      0x81         /* CD-ROM Audio Category Code     */

#define IOCD_CHANNEL_CTRL    0x40         /* Audio Channel Control          */
#define IOCD_PLAY            0x50         /* Play Audio                     */
#define IOCD_STOP            0x51         /* Stop Audio                     */
#define IOCD_RESUME          0x52         /* Resume Audio                   */
#define IOCD_CHANNEL_INFO    0x60         /* Return Audio Info              */
#define IOCD_DISK_INFO       0x61         /* Return Disk Info               */
#define IOCD_TRACK_INFO      0x62         /* Return Track Info              */
#define IOCD_QCHANNEL_INFO   0x63         /* Return Q-channel Info          */
#define IOCD_SUBCHANNEL_INFO 0x64         /* Return Sub-channel info        */
#define IOCD_STATUS_INFO     0x65         /* Audio Status Info              */


/*----------------------------------------------*
 * Category 0x82 CD-ROM DRIVE LETTER IOCTL      *
 *----------------------------------------------*/
#define IOC_CDROM_2                 0x82  /* CD-ROM 2 Category Code         */
#define IOCD_RETURN_DRIVE_LETTER    0x60  /* Return drive letter info       */
#define IOCD_RETURN_FEATURES        0x63  /* Return driver's features */

/*------------------------------------*
 * Misc constants                     *
 *------------------------------------*/
#define CD01                        0x31304443L
#define CD                          0x4443
#define OK                          0

#define NO_TABLE_ENTRY              0
#define MINIMUM_TABLE_ENTRY         FUNCTION_CODE_BASE
#define MAXIMUM_TABLE_ENTRY         0x7F
#define MAX_81H_TABLE_ENTRY         0x6F

/*
** VMLOCK flag equates
*/
#define VMDHL_NOBLOCK           0x0001
#define VMDHL_CONTIGUOUS        0x0002
#define VMDHL_16M               0x0004
#define VMDHL_WRITE             0x0008
#define VMDHL_LONG              0x0010
#define VMDHL_VERIFY            0x0020

#define DP_DEVICEATTR_NON_REMOVABLE     0x0001
#define DP_DEVICEATTR_CHANGELINE        0x0002
#define DP_DEVICEATTR_GT16MBSUPPORT     0x0004
/*------------------------------------------------*
 * Cat 0x80, Func 0x40:  Reset Drive              *
 *------------------------------------------------*/
struct ResetDrive {
        ULONG       ID_code;
};

/*------------------------------------------------*
 * Cat 0x80, Func 0x44:  Eject Disk               *
 *------------------------------------------------*/
struct EjectDisk {
        ULONG       ID_code;
};

/*------------------------------------------------*
 * Cat 0x80, Func 0x45:  Close Tray               *
 *------------------------------------------------*/
struct CloseTray {
        ULONG       ID_code;
};

/*------------------------------------------------*
 * Cat 0x80, Func 0x46:  Lock/Unlock Door         *
 *------------------------------------------------*/
struct LockUnlock {
        ULONG       ID_code;
        UCHAR       lock_flag;
};

/*------------------------------------------------*
 * Cat 0x80, Func 0x47:  Set Active Tray          *
 *------------------------------------------------*/
struct SetTray_Parm    {
        UCHAR       Newtray;
};

/*------------------------------------------------*
 * Cat 0x80, Func 0x50:  Seek                     *
 *------------------------------------------------*/
struct Seek  {
        ULONG       ID_code;
        UCHAR       address_mode;
        ULONG       start_sector;
};

/*------------------------------------------------------------*
 * Cat 0x80, Func 0x52/0x53:  Write Long & Write Long Verify  *
 *------------------------------------------------------------*/
struct WriteLong {
        ULONG       ID_code;
        UCHAR       address_mode;
        USHORT      transfer_count;
        ULONG       start_sector;
        UCHAR       reserved;
        UCHAR       interleave_size;
        UCHAR       interleave_skip_factor;
};

/*------------------------------------------------*
 * Cat 0x80, Func 0x60:  Device Status            *
 *------------------------------------------------*/
struct DeviceStatus {
        ULONG       ID_code;
};

struct DeviceStatus_Data {
        ULONG   device_status;
};

/*
** device_status flags
*/
#define DSF_DOOR_OPEN           0x00000001L
#define DSF_DOOR_UNLOCKED       0x00000002L
#define DSF_LONG_SECTORS        0x00000004L /*MSCDEX:Supports raw sector reads*/
#define DSF_READ_WRITE          0x00000008L
#define DSF_PLAY_AUDIO          0x00000010L
#define DSF_INTERLEAVING        0x00000020L
#define DSF_RESERVED1           0x00000040L
#define DSF_PREFETCHING         0x00000080L
#define DSF_AUDIO_CHANNEL       0x00000100L
#define DSF_RED_BOOK            0x00000200L
#define DSF_XA_SUPPORT          0x00000400L /* Can read CD-ROM XA sectors     */
#define DSF_NO_DISK_PRESENT     0x00000800L
#define DSF_PLAYING             0x00001000L /*MSCDEX:Supports R/W sub-channels*/
#define DSF_CARTRIDGE_CHANGER   0x00002000L /*for ATAPI Changer device        */
#define DSF_INDIVIDUAL_CHANGER  0x00004000L /*for ATAPI Changer device        */
#define DSF_SINGLE_MODE         0x00008000L /*for ATAPI Changer device        */
#define DSF_CDDA_SUPPORT        0x40000000L /*Can read 2352 byte CD-DA sectors*/
#define DSF_RIIP                0x80000000L /*Read interleave in progress     */

#define DSF_DEFAULT             0x0312L

/*------------------------------------------------*
 * Cat 0x80, Func 0x61:  Identify CD-ROM Driver   *
 *------------------------------------------------*/
struct IdentifyCDROMdriver {
        ULONG       ID_code;
};

struct IdentifyCDROMdriver_Data {
        ULONG       ID_code;
};

/*------------------------------------------------*
 * Cat 0x80, Func 0x63:  Return Sector Size       *
 *------------------------------------------------*/
struct ReturnSectorSize {
        ULONG       ID_code;
};

struct ReturnSectorSize_Data {
        USHORT      sector_size;
};

/*--------------------------------------------------*
 * Cat 0x80, Func 0x67:  Return Changer Tray status *
 *--------------------------------------------------*/
struct ReturnTrayStatus_Data {
        UCHAR       Count;
        UCHAR       Current;
        UCHAR       AssignedSLot;
};

/*------------------------------------------------*
 * Cat 0x80, Func 0x70:  Location of Head         *
 *------------------------------------------------*/
struct LocationOfHead {
        ULONG       ID_code;
        UCHAR       address_mode;
};

struct LocationOfHead_Data {
        ULONG   location_of_head;
};

/*------------------------------------------------*
 * Cat 0x80, Func 0x71: Read Prefetch             *
 *------------------------------------------------*/
struct ReadPrefetch {
        ULONG       ID_code;
        UCHAR       address_mode;
        USHORT      transfer_count;
        ULONG       start_sector;
        UCHAR       reserved;
        UCHAR       interleave_size;
        UCHAR       interleave_skip_factor;
};

/*------------------------------------------------*
 * Cat 0x80, Func 0x72: Read Long                 *
 *------------------------------------------------*/
struct ReadLong {
        ULONG       ID_code;
        UCHAR       address_mode;
        USHORT      transfer_count;
        ULONG       start_sector;
        UCHAR       reserved;
        UCHAR       interleave_size;
        UCHAR       interleave_skip_factor;
};

/*------------------------------------------------*
 * Cat 0x80, Func 0x73: Read Long Prefetch        *
 *------------------------------------------------*/
struct ReadLongPrefetch {
        ULONG       ID_code;
        UCHAR       address_mode;
        USHORT      transfer_count;
        ULONG       start_sector;
        UCHAR       reserved;
        UCHAR       interleave_size;
        UCHAR       interleave_skip_factor;
};

/*------------------------------------------------*
 * Cat 0x80, Func 0x78: Return Volume Size        *
 *------------------------------------------------*/

struct ReturnVolumeSize {
        ULONG       ID_code;
};

struct ReturnVolumeSize_Data {
        ULONG       volume_size;
};

/*------------------------------------------------*
 * Cat 0x80, Func 0x79: Return UPC/EAN Code       *
 *------------------------------------------------*/
struct UPCCode {
        ULONG       ID_code;
};

struct UPCCodeBytes  {
        UCHAR       upc_byte0;
        UCHAR       upc_byte1;
        UCHAR       upc_byte2;
        UCHAR       upc_byte3;
        UCHAR       upc_byte4;
        UCHAR       upc_byte5;
        UCHAR       upc_byte6;
};

struct UPCCode_Data {
        UCHAR        adr_control;
        struct
        UPCCodeBytes upc_ean_code;
        UCHAR        zero;
        UCHAR        aframe;
};

/* AK: 02-23-2001 - Function 7Ah added */

/* flags for function 7Ah*/
#define EX_DIRECTION_IN 0x0001
#define EX_PLAYING_CHK  0x0002

/*------------------------------------------------*
 * Cat 0x80, Func 0x7A: Execute device command    *
 *------------------------------------------------*/
struct ExecCMD {
        ULONG       ID_code;
        USHORT      data_length;
        USHORT      cmd_length;
        USHORT      flags;
        UCHAR       cmd_buffer[16];
};

/*------------------------------------------------*
 * Cat 0x81, Func 0x40:  Audio Channel Control    *
 *------------------------------------------------*/
struct AudioChannelControl {
        ULONG       ID_code;

};

struct AudioChannelControl_Data {
        UCHAR       input_0;
        UCHAR       volume_0;
        UCHAR       input_1;
        UCHAR       volume_1;
        UCHAR       input_2;
        UCHAR       volume_2;
        UCHAR       input_3;
        UCHAR       volume_3;
};

/*------------------------------------------------*
 * Cat 0x81, Func 0x50:  Play Audio               *
 *------------------------------------------------*/
struct PlayAudio {
        ULONG       ID_code;
        UCHAR       address_mode;
        ULONG       start_sector;
        ULONG       end_sector;
};

/*------------------------------------------------*
 * Cat 0x81, Func 0x51:  Stop Audio               *
 *------------------------------------------------*/
struct StopAudio {
        ULONG       ID_code;
};

/*------------------------------------------------*
 * Cat 0x81, Func 0x52:  Resume Audio             *
 *------------------------------------------------*/
struct ResumeAudio {
        ULONG       ID_code;
};

/*------------------------------------------------*
 * Cat 0x81, Func 0x60:  Audio Channel Info       *
 *------------------------------------------------*/
struct AudioChannelInfo {
        ULONG       ID_code;
};

struct AudioChannelInfo_Data {
        UCHAR       input_0;
        UCHAR       volume_0;
        UCHAR       input_1;
        UCHAR       volume_1;
        UCHAR       input_2;
        UCHAR       volume_2;
        UCHAR       input_3;
        UCHAR       volume_3;
};

/*------------------------------------------------*
 * Cat 0x81, Func 0x61:  Audio Disk Info          *
 *------------------------------------------------*/
struct AudioDiskInfo {
        ULONG       ID_code;
};

struct AudioDiskInfo_Data {
        UCHAR       lowest_track;
        UCHAR       highest_track;
        UCHAR       frame;                      /* leadout track start  */
        UCHAR       sec;
        UCHAR       min;
        UCHAR       zero;
};

/*------------------------------------------------*
 * Cat 0x81, Func 0x62:  Audio Track Info         *
 *------------------------------------------------*/
struct AudioTrackInfo {
        ULONG       ID_code;
        UCHAR       track_number;
};

struct AudioTrackInfo_Data {
        UCHAR       frame;                      /* track start          */
        UCHAR       sec;
        UCHAR       min;
        UCHAR       zero;
        UCHAR       control;
};

/*------------------------------------------------*
 * Cat 0x81, Func 0x63:  Audio Q-Channel Info     *
 *------------------------------------------------*/
struct AudioQChannelInfo {
        ULONG       ID_code;
};

struct AudioQChannelInfo_Data {
        UCHAR       control;
        UCHAR       tno;
        UCHAR       point;
                                           /* running time on the track */
        UCHAR       min;
        UCHAR       sec;
        UCHAR       frame;
        UCHAR       zero;
                                           /*  running time on the disk */
        UCHAR       amin;
        UCHAR       asec;
        UCHAR       aframe;
};

/*------------------------------------------------*
 * Cat 0x81, Func 0x64:  Audio Sub-Channel Info   *
 *------------------------------------------------*/
struct AudioSubChannelInfo {
        ULONG       ID_code;
        ULONG       start_frame;
        ULONG       frame_count;
};

struct AudioSubChannelInfo_Data {
        UCHAR       subchannel_info[96];
};

/*------------------------------------------------*
 * Cat 0x81, Func 0x65:  Audio Status Info        *
 *------------------------------------------------*/
struct AudioStatusInfo {
        ULONG       ID_code;
};

struct AudioStatusInfo_Data {
        USHORT      audio_status;
        ULONG       last_start_location;
        ULONG       last_end_location;
};

/*------------------------------------------------*
 * Cat 0x82, Func 0x60:  Return Drive Letter Info *
 *------------------------------------------------*/

struct DriveLetter_Data {
        USHORT      drive_count;
        USHORT      first_drive_number;
};

// AK: 03/06/2001 - Function 63h added
/*------------------------------------------------*
 * Cat 0x82, Func 0x63:  Return Driver's Features *
 *------------------------------------------------*/

struct DriveFeatures_Data {
        ULONG      driver_status;
};

#define FEATURE_USB_SUPPORT         0x00000001L
#define FEATURE_CDRW_SUPPORT        0x00000002L
#define FEATURE_EXECMD_SUPPORT      0x00000004L

typedef struct _LOCKSTRUC FAR *PLOCKSTRUC;

/*------------------------------------------------*
 * Function declarations and pragma statements    *
 *------------------------------------------------*/
USHORT NEAR CD_GetDeviceParms8(PRP_GENIOCTL, NPUNITCB);
USHORT NEAR CD_GetDeviceParms9(PRP_GENIOCTL, NPUNITCB);
USHORT NEAR CD_RemovableMediaControl(PRP_GENIOCTL, NPUNITCB);
USHORT NEAR CD_RemovableDeviceStatus(PRP_GENIOCTL, NPUNITCB);
USHORT NEAR CD_ResetDrive(PRP_GENIOCTL, NPUNITCB);
USHORT NEAR CD_EjectDisk(PRP_GENIOCTL, NPUNITCB);
USHORT NEAR CD_CloseTray(PRP_GENIOCTL, NPUNITCB);
USHORT NEAR CD_LockUnlock(PRP_GENIOCTL, NPUNITCB);
USHORT NEAR CD_SetActiveTray(PRP_GENIOCTL, NPUNITCB);
USHORT NEAR CD_Seek(PRP_GENIOCTL, NPUNITCB);
USHORT NEAR CD_WriteLong(PRP_GENIOCTL, NPUNITCB);
USHORT NEAR CD_WriteVLong(PRP_GENIOCTL, NPUNITCB);
USHORT NEAR CD_DeviceStatus(PRP_GENIOCTL, NPUNITCB);
USHORT NEAR CD_TrayStatus(PRP_GENIOCTL, NPUNITCB);
USHORT NEAR CD_FormatVerifyTrack(PRP_GENIOCTL, NPUNITCB);
USHORT NEAR CD_Identify(PRP_GENIOCTL, NPUNITCB);
USHORT NEAR CD_ReturnSectorSize(PRP_GENIOCTL, NPUNITCB);
USHORT NEAR CD_HeadLocation(PRP_GENIOCTL, NPUNITCB);
USHORT NEAR CD_ReadPrefetch(PRP_GENIOCTL, NPUNITCB);
USHORT NEAR CD_ReadLong(PRP_GENIOCTL, NPUNITCB);
USHORT NEAR CD_ReadLongPre(PRP_GENIOCTL, NPUNITCB);
USHORT NEAR CD_ReturnVolumeSize(PRP_GENIOCTL, NPUNITCB);
USHORT NEAR CD_GetUPC(PRP_GENIOCTL, NPUNITCB);
USHORT NEAR CD_AudioChannelCtrl(PRP_GENIOCTL, NPUNITCB);
USHORT NEAR CD_Play(PRP_GENIOCTL, NPUNITCB);
USHORT NEAR CD_Stop(PRP_GENIOCTL, NPUNITCB);
USHORT NEAR CD_Resume(PRP_GENIOCTL, NPUNITCB);
USHORT NEAR CD_AudioChannelInfo(PRP_GENIOCTL, NPUNITCB);
USHORT NEAR CD_AudioDiskInfo(PRP_GENIOCTL, NPUNITCB);
USHORT NEAR CD_AudioTrackInfo(PRP_GENIOCTL, NPUNITCB);
USHORT NEAR CD_AudioQChannelInfo(PRP_GENIOCTL, NPUNITCB);
USHORT NEAR CD_AudioSubChannelInfo(PRP_GENIOCTL, NPUNITCB);
USHORT NEAR CD_AudioStatusInfo(PRP_GENIOCTL, NPUNITCB);
USHORT NEAR CD_ExecCMD(PRP_GENIOCTL, NPUNITCB);
USHORT NEAR VerifyParameters (PRP_GENIOCTL, USHORT, USHORT, PLOCKSTRUC);
USHORT NEAR MakeSlotActive(NPUNITCB,UCHAR);

