/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
/**************************************************************************
 *
 * SOURCE FILE NAME = CDINIT.C
 *
 * DESCRIPTIVE NAME = Initialization routines for CD-ROM Device Manager
 *
 *
 * VERSION = V2.0
 *
 * DATE
 *
 * DESCRIPTION
 *
 *
 * FUNCTIONS
 *
 * ENTRY POINTS:
 *
 * DEPENDENCIES:
 *
 * NOTES
 *
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
*/

#undef __JSM_DEBUG__

/* #include "infoseg.h" */  /* @PerfTrace */
#include "cdh.h"
#include "devclass.h"
#include "dskinit.h"

VOID   NEAR CD_Build_UnitCBs (void);
VOID   BuildIORB_UnitControl(USHORT, USHORT);
VOID   NEAR InitCBPool (void);
VOID   NEAR Init_Trace (void);
//USHORT NEAR InitializeDevice (NPUNITCB);            // 02/02/2000 MB
VOID   NEAR GetInitParms (PRPINITIN);
//VOID   NEAR GetProductID (NPUNITCB);                // 02/02/2000 MB
//VOID   NEAR init_scsi_cdrom (NPUNITCB);             // 02/02/2000 MB
//VOID   NEAR init_proprietary_cdrom (NPUNITCB);      // 02/02/2000 MB
//VOID   NEAR init_atapi_cdrom (NPUNITCB);            // 02/02/2000 MB
//VOID   NEAR init_audio_caps (NPUNITCB);             // 02/02/2000 MB
//VOID   NEAR init_submit_cdb (NPUNITCB, NPIORB_CDB); // 02/02/2000 MB

typedef struct InfoSegGDT FAR *PInfoSegGDT;
#define MSG_REPLACEMENT_STRING 1178


/*
** Init data allocated at the end of the data segment.
*/
USHORT          InitData=0;

UCHAR           InitTimeIORB[sizeof(IORB_CDB)]={0};

#define MAX_DT_ADAPTERS  8
#define MAX_DT_UNITS     56
#define MAX_DT_SIZE (sizeof(DEVICETABLE) + ((MAX_DT_ADAPTERS-1) * 2) +        \
              (MAX_DT_ADAPTERS * (sizeof(ADAPTERINFO)-sizeof(UNITINFO))) +    \
              (MAX_DT_UNITS * sizeof(UNITINFO))  )

UCHAR           ScratchBuffer2[MAX_DT_SIZE]={0};       /*Scratch buffer */

USHORT          ReserveDriveLetters = 0;

static UCHAR HeaderIDMsg[] =                                    \
                                                                "\n\r"                                                          \
/*"IBM OS/2 OS2CDROM.DMD (960528)"; */
                                                                "IBM OS/2 OS2CDROM.DMD (000821)"; 


static UCHAR ProductIDMsg[] =                                   \
                                                                "                                ";

MSGTABLE  HeaderMsgParm = { MSG_REPLACEMENT_STRING,
   1,
   HeaderIDMsg,
};


MSGTABLE  ProductIDMsgParm = { MSG_REPLACEMENT_STRING,
   1,
   ProductIDMsg,
};


/****************************************************************************
 *
 * FUNCTION NAME = CD_DriveInit
 *
 * DESCRIPTION   = Initialization for OS2CDROM.DMD
 *
 * INPUT         = pRP           - pointer to Request Packet
 *                 pUnitCB       - pointer to Unit Control Block
 *
 * OUTPUT        =
 *
 * RETURN-NORMAL =
 * RETURN-ERROR  =
 *
 ****************************************************************************/

USHORT near CD_DriveInit(pRP, pUnitCB)

PRPINITIN  pRP;
NPUNITCB   pUnitCB;
{
   USHORT     rc, i, DriveCount;
   PRPINITOUT pRPO = (PRPINITOUT) pRP;   /* Output for Init RP             */

   extern CMDFUNC near functable[];


   /*
   ** Initialize various variables
   */
   CDFlags |= CDF_INIT_TIME;             /* Turn on init time flag         */

   Device_Help = pRP->DevHlpEP;          /* Save ptr to devhelp function   */
   FirstDriveNumber = pRP->DriveNum;     /* First Drive Number             */

   pDataSeg = (PVOID) &pDataSeg;         /* Set up pointer to data segment */
   OFFSETOF(pDataSeg) = 0;

   /*
   ** Get the init parms specified on the BASEDEV= command line
   */
   GetInitParms(pRP);

   /*
   ** Save away the physical and linear addresses of our data segment
   */
   rc = DevHelp_VirtToPhys(pDataSeg, (PULONG) &ppDataSeg);

   rc = DevHelp_VirtToLin((USHORT) (SELECTOROF(pDataSeg)),
                          (ULONG) (OFFSETOF(pDataSeg)),
                          (PLIN) &plDataSeg);

   /*
   ** Put init data at end of _DATA since it'll get discarded later
   */
   PoolSize = INIT_POOL_SIZE;

   FreePoolSpace = INIT_POOL_SIZE;

   CD_Build_UnitCBs();                   /* Build unit control blocks      */

   if (NumCDROMDrives == 0)              /* If no drives, then deinstall   */
   {
      if (ReserveDriveLetters == 0)
      {
         pRPO->Unit = 0;
         pRPO->CodeEnd = 0;
         pRPO->DataEnd = 0;
         ZeroFSGS();
         if (CDFlags & CDF_QUIET)
            return (STDON + STERR + ERROR_I24_QUIET_INIT_FAIL);
         else
            return (STDON + STERR + ERROR_I24_GEN_FAILURE);
      }
      else
      {
         UnitCB_Head = 0;
         pRP->Unit = (CHAR) ReserveDriveLetters;
         pRPO->BPBArray = (PVOID) InitBPBArray;
         for (i = 0; i < ReserveDriveLetters; i++)
            InitBPBArray[i] = &DefaultBPB;

         /*
         ** Return the end of the code and data segments
         */
         pRPO->CodeEnd = (USHORT) CD_DriveInit;
         pRPO->DataEnd = (USHORT) FirstUnitCB;

         CodeBreakAddress = (USHORT) CD_DriveInit;
         DataBreakAddress = (USHORT) FirstUnitCB;
      }
   }
   else                                  /* At least 1 CD-ROM drive exists */
   {
      InitCBPool ();                     /* Initialize the Control Block pool */

      DevHelp_AllocGDTSelector(ReservedSelectors, 2);

      Init_Trace();                      /* Initialize tracing             */


      /*
      ** Set up the return parameters for the INIT packet.
      */
      if (ReserveDriveLetters > NumCDROMDrives)
         DriveCount = ReserveDriveLetters;
      else
         DriveCount = NumCDROMDrives;

      pRP->Unit = (CHAR) DriveCount;     /* Return number of logical drives */

      pRPO->BPBArray = (PVOID) InitBPBArray;

      for (i = 0; i < DriveCount; i++)
         InitBPBArray[i] = &DefaultBPB;

      /*
      ** Return the end of the code and data segments
      */
      pRPO->CodeEnd = (USHORT) CD_DriveInit;
      pRPO->DataEnd = (USHORT) pNextFreeCB;

      CodeBreakAddress = (USHORT) CD_DriveInit;
      DataBreakAddress = (USHORT) pNextFreeCB;

   }
   /*
   ** Dont allow another INIT command to come in
   */
   functable[CMDInit].Strat1Near = CmdErr;     /* Patch strat1 table to disable inits */
   functable[CMDInitBase].Strat1Near = CmdErr; /* Patch strat1 table to disable inits */
   CDFlags &= ~CDF_INIT_TIME;          /* Turn off init time flag             */
   CDFlags |= CDF_INIT_COMPLETE;       /* set init processing done            */  //SD@135221

   return (STDON);                      /* Done with init, so return           */

}


/****************************************************************************
 *
 * FUNCTION NAME = CD_Build_UnitCBs
 *
 * DESCRIPTION   = Build Unit Control Blocks (UnitCBs)
 *
 *                 This routine issues the GetAdapterDeviceTable command
 *                 to each Adapter Device Driver and builds the unit control
 *                 blocks from each Adapter Device Table returned.  Each unit
 *                 control block (UnitCB) represents a physical device unit
 *                 which the device manager manages.
 *
 *                 VOID CD_Build_UnitCS()
 *
 *                 NOTES: UnitCBs built for each CD-ROM target.
 *                        NumCDRomDrives = Number of UnitCBs built
 *
 * INPUT         = NONE
 *
 * OUTPUT        = NONE
 *
 * RETURN-NORMAL =
 * RETURN-ERROR  =
 *
 ****************************************************************************/

void CD_Build_UnitCBs()

{
   USHORT                rc;
   NPUNITCB              pUnitCB;         /* Pointer to current UnitCB    */
   NPUNITCB              pParentUnit;     /* Pointer to parent unit for ATAPI Changers */
   NPIORB_CONFIGURATION  pIORB;           /* ptr to IORB                  */
   DEVICETABLE           *pDeviceTable;   /* ptr to device table          */
   NPADAPTERINFO         pAdapterInfo;    /* near ptr to AdapterInfo      */
   USHORT                driverIndex, adapterIndex, unitIndex, byteIndex, bufferIndex;    /* Index pointers               */
   UCHAR                 slotIndex;        /* Index pointers               */
   USHORT                FilterADDHandle; /* Filter Handle                */
   NPBYTE                pInquiryData;
   struct
   DevClassTableStruc far *pDriverTable;  /* ptr to registered ADD EPs    */
   VOID (FAR * DriverEP) (PIORB_CONFIGURATION);              /* Driver entry point           */    // 10/23/2000 MB
   VOID (FAR * DriverEPF)(PIORB_CONFIGURATION);              /* Filter Driver entry point    */    // 10/23/2000 MB

   (NPUNITCB)pNextFreeCB = FirstUnitCB;   /* Next free is first unit CB   */
   UnitCB_Head = FirstUnitCB;             /* Init UnitCB head pointer     */
   pUnitCB = UnitCB_Head;                 /* Point to first UnitCB        */
   NumUnitCBs = 0;                        /* Init UnitCB count            */


   /*
   ** Get the adapter device tables for each adapter driver and create
   ** the unit control blocks (UnitCBs) from the returned tables.
   */

   rc = DevHelp_GetDOSVar((USHORT) DHGETDOSV_DEVICECLASSTABLE, 1,
                          (PPVOID) &pDriverTable);

   NumDrivers = pDriverTable->DCCount;

   pDeviceTable = (DEVICETABLE *) ScratchBuffer2;

   for (driverIndex = 0; driverIndex < NumDrivers; driverIndex++)
   {
      pIORB = (NPIORB_CONFIGURATION) InitTimeIORB;
      pIORB->iorbh.Length = sizeof(IORB_CONFIGURATION);
      pIORB->iorbh.CommandCode = IOCC_CONFIGURATION;
      pIORB->iorbh.CommandModifier = IOCM_GET_DEVICE_TABLE;
      pIORB->iorbh.Status = 0;
      pIORB->iorbh.ErrorCode = 0;
      pIORB->iorbh.RequestControl = IORB_ASYNC_POST;
      pIORB->iorbh.NotifyAddress = &InitPost;
      pIORB->pDeviceTable = (PVOID) pDeviceTable;
      pIORB->DeviceTableLen = sizeof(ScratchBuffer2);

      OFFSETOF(DriverEP) =  pDriverTable->DCTableEntries[driverIndex].DCOffset;
      SELECTOROF(DriverEP) = pDriverTable->DCTableEntries[driverIndex].DCSelector;

      f_ZeroCB((PBYTE)pDeviceTable, sizeof(ScratchBuffer2));

      (*DriverEP) ((PIORB_CONFIGURATION)pIORB);  // 10/23/2000 MB

      while ( !(pIORB->iorbh.Status & IORB_DONE) )  /* Wait till done */
         ;

      for (adapterIndex = 0; adapterIndex < pDeviceTable->TotalAdapters; adapterIndex++)
      {
         pAdapterInfo =  pDeviceTable->pAdapter[adapterIndex];

         for (unitIndex = 0; unitIndex < pAdapterInfo->AdapterUnits; unitIndex++)
         {
            /*
            ** Only allocate DISK type devices which are not defective
            ** and which dont suppress DASD manager support.
            */
            if ( (pAdapterInfo->UnitInfo[unitIndex].UnitType == UIB_TYPE_CDROM) &&
                 ! (pAdapterInfo->UnitInfo[unitIndex].UnitFlags & UF_DEFECTIVE) )
            {
               /*
               ** Allocate the unit if it's not already allocated
               ** Wait until the request comes back from ADD.
               */

               BuildIORB_UnitControl (IOCM_ALLOCATE_UNIT,
                                      pAdapterInfo->UnitInfo[unitIndex].UnitHandle);

               FilterADDHandle = pAdapterInfo->UnitInfo[unitIndex].FilterADDHandle;

               if ( !FilterADDHandle )
               {
                  (*DriverEP) ((PIORB_CONFIGURATION)pIORB);  // 10/23/2000 MB
               }
               else
               {
                  OFFSETOF(DriverEPF) =
                  pDriverTable->DCTableEntries[FilterADDHandle-1].DCOffset;
                  SELECTOROF(DriverEPF) =
                  pDriverTable->DCTableEntries[FilterADDHandle-1].DCSelector;

                  (*DriverEPF) ((PIORB_CONFIGURATION)(pIORB));  // 10/23/2000 MB
               }

               while ( !(pIORB->iorbh.Status & IORB_DONE) )  /* Wait till done */
                  ;

               /*
               ** If allocation succeeded then add unit to unit tables
               */
               if ( !(pIORB->iorbh.Status & IORB_ERROR) )
               {
                  f_ZeroCB((PBYTE)pUnitCB, sizeof(*pUnitCB) );  // 10/23/2000 MB
                  for (bufferIndex=0; bufferIndex<NUM_OF_BUFFERS; bufferIndex++)
                     pUnitCB->PacketInfo.buf_info[bufferIndex].flags = 0;

                  pUnitCB->UnitInfo = pAdapterInfo->UnitInfo[unitIndex];

                  /*
                  ** Save the callable entry point of the adapter driver. If
                  ** the unit is being filtered, use the entry point of the
                  ** filter driver.
                  */
                  if (FilterADDHandle == 0)
                     pUnitCB->AdapterDriverEP = DriverEP;
                  else
                  {
                     OFFSETOF(pUnitCB->AdapterDriverEP)   =
                     OFFSETOF(DriverEPF);
                     SELECTOROF(pUnitCB->AdapterDriverEP) =
                     SELECTOROF(DriverEPF);
                  }

                  /*
                  ** Set the bus interface type.
                  */
                  pUnitCB->DeviceInfo.interface_type = SetDeviceInterface(pAdapterInfo->AdapterDevBus);  // 02/02/2000 MB

                  /*
                  ** Initialize device.  If failure then deallocate unit
                  */
                  rc=InitializeDevice(pUnitCB);  // 02/02/2000 MB

                  if ((rc & STERR) && !(pAdapterInfo->UnitInfo[unitIndex].UnitFlags&UF_USB_DEVICE) )  // 02/02/2000 MB 
                  {
                     // refuse device only if initialization fails for non-USB device
                     BuildIORB_UnitControl (IOCM_DEALLOCATE_UNIT,
                                            pAdapterInfo->UnitInfo[unitIndex].UnitHandle);

                     (*pUnitCB->AdapterDriverEP) ((PVOID)(pIORB));

                     while ( !(pIORB->iorbh.Status & IORB_DONE) )
                        ;
                  }
                  else
                  {
                     if (pAdapterInfo->UnitInfo[unitIndex].UnitFlags&UF_USB_DEVICE) // 02/02/2000 MB  //
                     {
                        // register DMD callback routine within ADD driver                   //
                        pIORB = (NPIORB_CONFIGURATION) InitTimeIORB;                          //
                        pIORB->iorbh.Length = sizeof(PIORB_SAVE_DMD);                         //
                        pIORB->iorbh.CommandCode = IOCC_CONFIGURATION;                        //
                        pIORB->iorbh.CommandModifier = IOCM_SAVE_DMD_INFO;                    //
                        pIORB->iorbh.Status = 0;                                              //
                        pIORB->iorbh.ErrorCode = 0;                                           //
                        pIORB->iorbh.RequestControl = IORB_ASYNC_POST;                        //
                        pIORB->iorbh.NotifyAddress = &InitPost;                               //
                                                                                              //
                        ((PIORB_SAVE_DMD)pIORB)->dmdCallback=&USBCallBck;                     //
                        ((PIORB_SAVE_DMD)pIORB)->dmdDeviceId=(ULONG)(PVOID)pUnitCB;           // // 10/23/2000 MB
                        (*pUnitCB->AdapterDriverEP) ((PVOID)(pIORB));                         //
                     }                                                       // 02/02/2000 MB //

                     pUnitCB->AdapterNumber = NumAdapters + adapterIndex;
                     pUnitCB->MaxHWSGList = pAdapterInfo->MaxHWSGList;

                     if (pAdapterInfo->AdapterFlags & AF_HW_SCATGAT)
                        pUnitCB->Flags |= UCF_HW_SCATGAT;

                     if (pAdapterInfo->AdapterFlags & AF_16M)
                        pUnitCB->Flags |= UCF_16M;

                     if (pAdapterInfo->AdapterFlags & AF_CHS_ADDRESSING)
                        pUnitCB->Flags |= UCF_CHS_ADDRESSING;

                     /*
                     ** Display vendor, product id and revision code
                     ** if /V parm specified on command line.
                     */
                     if (CDFlags & CDF_VERBOSE)
                     {
                        if (NumUnitCBs == 0)
                           DevHelp_Save_Message( (NPBYTE) &HeaderMsgParm);

                        pInquiryData = &pUnitCB->InquiryData.vendor_id[0];

                        ProductIDMsg[0]=(UCHAR)(pUnitCB->UnitInfo.UnitSCSITargetID+0x30);  // 10/23/2000 MB

                        for (byteIndex = 0; byteIndex < 8; byteIndex++)
                           ProductIDMsg[byteIndex+2] = *(pInquiryData+byteIndex);

                        for (byteIndex = 8; byteIndex < 24; byteIndex++)
                           ProductIDMsg[byteIndex+3] = *(pInquiryData+byteIndex);

                        for (byteIndex = 24; byteIndex < 28; byteIndex++)
                           ProductIDMsg[byteIndex+4] = *(pInquiryData+byteIndex);

                        DevHelp_Save_Message( (NPBYTE) &ProductIDMsgParm);
                     }

                     /*
                     ** Increment drive count and get next one
                     */


                     pParentUnit=pUnitCB;                            //SD@135221
                     pUnitCB->LogDriveNum = NumUnitCBs;
                     // set the first slot number, 0 relative
                     // in case this is an ATAPI Changer
                     pUnitCB->DeviceInfo.Slot=0;                     //SD@135221
                     NumUnitCBs ++;
                     NumCDROMDrives++;
                     pUnitCB->pNextUnitCB = pUnitCB + 1;
                     pUnitCB++;

                     /*                                              //SD@135221
                     *                                               //SD@135221
                     * check for ATAPI Changer type device           //SD@135221
                     *                                               //SD@135221
                     */                                              //SD@135221
                     if ( (pParentUnit->DeviceInfo.interface_type == INTERFACE_ATAPI) &&                                       //SD@135221
                          (pParentUnit->DeviceInfo.Audio.capabilities & (DCAPS_INDIVIDUAL_CHANGER | DCAPS_CARTRIDGE_CHANGER))) //SD@135221
                     {
                        //SD@135221
                        // point parent to itself, used for active slot checking   //SD@135221
                        pParentUnit->pParentUnitCB=pParentUnit;                    //SD@135221
                        // if we are showing these trays as multiple units         //SD@135221
                        if (!(CDFlags & CDF_SINGLE_UNIT))                           //SD@135221
                        {
                           //SD@135221
                           // loop thru sub units, making fake unit control blocks  //SD@135221
                           for (slotIndex=1; slotIndex<pParentUnit->DeviceInfo.Slots.Maximum;slotIndex++ )   //SD@135221
                           {
                              //SD@135221
                              // copy parent info here                               //SD@135221
                              *pUnitCB=*pParentUnit;                                 //SD@135221
                              pUnitCB->pParentUnitCB=pParentUnit;                    //SD@135221
                              // set our logical device info                         //SD@135221
                              pUnitCB->LogDriveNum = NumUnitCBs;                     //SD@135221
                              // save our slot number                                //SD@135221
                              pUnitCB->DeviceInfo.Slot=slotIndex;                    //SD@135221
                              // point to next in chain                              //SD@135221
                              pUnitCB->pNextUnitCB = pUnitCB + 1;                    //SD@135221
                              // increment counters                                  //SD@135221
                              NumUnitCBs ++;                                         //SD@135221
                              NumCDROMDrives++;                                      //SD@135221
                              // increment to next unit control block                //SD@135221
                              pUnitCB++;                                             //SD@135221
                           } /* endfor */                                         //SD@135221
                        } /* endif */                                            //SD@135221
                        else                                                       //SD@135221
                        {
                           //SD@135221
                           pParentUnit->DeviceInfo.Audio.capabilities |= DCAPS_SINGLE_MODE; //SD@135221
                        }                                                        //SD@135221
                     } /* endif */
                  }
               }
            }
         }  /* end unit loop */
      }  /* end adapter loop */
      NumAdapters += pDeviceTable->TotalAdapters;
   }  /* end driver loop */

   (NPUNITCB) pNextFreeCB = pUnitCB;     /* Update next free control blk ptr */
   (pUnitCB-1)->pNextUnitCB = 0;
}



/****************************************************************************
 *
 * FUNCTION NAME = BuildIORB_UnitControl
 *
 * DESCRIPTION   = This routine build a unit control IORB.
 *
 *                 VOID Build_UnitControl(USHORT command_modifier,
 *                                                 USHORT unit_handle);
 *
 * INPUT         = command_modifier   - IORB command modifier code
 *                 unit_handle        - unit handle
 *
 * OUTPUT        = NONE
 *
 * RETURN-NORMAL =
 * RETURN-ERROR  =
 *
 ****************************************************************************/

VOID BuildIORB_UnitControl (command_modifier, unit_handle)

USHORT     command_modifier;
USHORT     unit_handle;

{
   NPIORB_UNIT_CONTROL pIORB;

   pIORB = (NPIORB_UNIT_CONTROL) InitTimeIORB;

   pIORB->iorbh.Length = sizeof(IORB_UNIT_CONTROL);
   pIORB->iorbh.CommandCode = IOCC_UNIT_CONTROL;
   pIORB->iorbh.CommandModifier = command_modifier;
   pIORB->iorbh.Status = 0;
   pIORB->iorbh.ErrorCode = 0;
   pIORB->iorbh.UnitHandle = unit_handle;
   pIORB->iorbh.RequestControl = IORB_ASYNC_POST;
   pIORB->iorbh.NotifyAddress = &InitPost;
   pIORB->Flags = 0;

   pIORB->pUnitInfo = 0;
   pIORB->UnitInfoLen = 0;
}


/****************************************************************************
 *
 * FUNCTION NAME = InitCBPool
 *
 * DESCRIPTION   = Initialize the control block pool
 *
 *                 Initializes the control block pool which is used for IORB,
 *                 CWA and FTDB allocation.
 *
 *                 USHORT InitCBPool ()
 *
 * INPUT         = NONE
 *
 * OUTPUT        = NONE
 *
 * RETURN-NORMAL =
 * RETURN-ERROR  =
 *
 ****************************************************************************/

VOID InitCBPool ()
{
   NPUNITCB pUnitCB;
   NPBYTE   pCB;
   USHORT   NumCBs, CBSize, i;
   USHORT   NumIORBs = 0;

   /*
   ** Calculate the size of the Pool
   */

   CBSize = sizeof(IORB_CDB);

   /*
   ** Calculate the number of IORBs to allocate by summing the
   ** Queuing Counts in each UnitCB.
   */
   NumIORBs = NumCDROMDrives * MAX_IORBS_PER_DRIVE;
   if (NumIORBs > MAX_IORBS_PER_POOL)
      NumIORBs = MAX_IORBS_PER_POOL;

   NumCBs = NumIORBs;

   FreePoolSpace = (USHORT) &InitData - (USHORT) pNextFreeCB;

   /*
   **  Make sure Pool Size isnt greater than available space left in
   **  the data segment.
   */
   if ( ((ULONG)NumCBs * CBSize) < (ULONG)FreePoolSpace)
      PoolSize = NumCBs * CBSize;
   else
   {
      NumCBs = FreePoolSpace / CBSize;
      PoolSize = NumCBs * CBSize;
   }

   /*
   ** Initialize the Control Block Pool
   */

   CB_FreeList = pNextFreeCB;

   pCB = CB_FreeList;

   for (i = 0; i < NumCBs; i++)
   {

      ((NPIORBH) pCB)->pNxtIORB = (PIORBH) (pCB + CBSize);
      pCB += CBSize;
   }

   ((NPIORBH) (pCB - CBSize))->pNxtIORB = 0;    /* Zero terminate list */

   pNextFreeCB = pCB;


   /*
   ** Allocate one dedicated IORB to each Unit
   */

   pCB = CB_FreeList;

   for (pUnitCB = UnitCB_Head, i = 0; i < NumUnitCBs; i++, pUnitCB++)
   {
      pUnitCB->pDedicatedIORB = (NPIORBH) pCB;
      ((NPIORBH) pCB)->pNxtIORB = 0;
      pCB += CBSize;
   }

   CB_FreeList = pCB;          /* Free List now starts past dedicated IORBs */


}


/****************************************************************************
 *
 * FUNCTION NAME = Init_Trace
 *
 * DESCRIPTION   = Initialize internal trace buffer
 *
 *                 VOID Init_Trace ()
 *
 * INPUT         = NONE
 *
 * OUTPUT        = NONE
 *
 * RETURN-NORMAL =
 * RETURN-ERROR  =
 *
 ****************************************************************************/

VOID Init_Trace()
{
   /*
   ** Get pointer to RAS Major Event Code Table
   */
/*
** DevHelp_GetDOSVar(DHGETDOSV_SYSINFOSEG, 0, (PPVOID) &ppSysInfoSeg);
**
** SELECTOROF(pSysInfoSeg) = (USHORT) *ppSysInfoSeg;
** OFFSETOF(pSysInfoSeg) = 0;
**
** pSIS_mec_table = ((PInfoSegGDT)pSysInfoSeg)->SIS_mec_table;
*/

   /*
   ** Get pointer to Performance Major Event Code Table                  @Perftrace
   */
#ifdef TRACING
   DevHelp_GetDOSVar(DHGETDOSV_SYSINFOSEG, 0, (PPVOID) &ppSysInfoSeg); /*@Perftrace*/

   SELECTOROF(pSysInfoSeg) = (USHORT) *ppSysInfoSeg;                   /*@Perftrace*/
   OFFSETOF(pSysInfoSeg) = 0;                                          /*@Perftrace*/

   pSIS_perf_mec_table = ((PInfoSegGDT)pSysInfoSeg)->SIS_perf_mec_table; /*@Perftrace*/
#endif
   /*
   ** Set up internal error tracing buffer.
   ** Note: Always will be enough since init data is > size of trace buffer
   */
   pCDTraceBuf  = pNextFreeCB;
   pNextFreeCB += TRACEBUF_SIZE;
   pCDTraceHead = pCDTraceBuf;
   pCDTraceEnd  = pCDTraceBuf + TRACEBUF_SIZE;

}



/****************************************************************************
 *
 * FUNCTION NAME = GetInitParms
 *
 * DESCRIPTION   = Get init parms from BASEDEV command line
 *
 *                 VOID GetInitParms (PRPINITIN pRP);
 *
 * INPUT         = pRP              - Pointer to init request packet
 *
 * OUTPUT        = VOID
 *
 * RETURN-NORMAL =
 * RETURN-ERROR  =
 *
 ****************************************************************************/

VOID GetInitParms (pRP)

PRPINITIN pRP;

{
   PSZ    pCmdString;
   PSZ    pCmdStringStart;
   USHORT i;
   BYTE   n;

   pCmdStringStart = pRP->InitArgs;

   if (pRP->rph.Cmd == CMDInitBase)
      OFFSETOF(pCmdStringStart)=((PDDD_PARM_LIST)pRP->InitArgs)->cmd_line_args;

   pCmdString = pCmdStringStart;

   /*
   ** Fold characters to upper case
   */
   for (i = 0; *pCmdString != 0 && i < 40; i++, pCmdString++)
   {
      if (*pCmdString >= 'a' &&  *pCmdString <= 'z')
         *pCmdString = (CHAR)(*pCmdString - ('a' - 'A'));   // 10/23/2000 MB
   }


   pCmdString = pCmdStringStart;

   for (i = 0; *pCmdString != 0 && i < 40; i++, pCmdString++)
   {
      if (*pCmdString == '/')
      {
         pCmdString++;
         switch (*pCmdString)
         {
         case 'Q':
            CDFlags |= CDF_QUIET;              /* Turn on quiet flag */
            break;

         case 'V':
            CDFlags |= CDF_VERBOSE;            /* Turn on verbose flag */
            break;

         case 'R':
            n = 0;
            pCmdString++;
            if ( *pCmdString == ':' )
            {
               pCmdString++;
               if ( (*pCmdString >= '0') && (*pCmdString <= '9') )
               {
                  n = (BYTE)(*pCmdString - '0');  // 10/23/2000 MB
                  if ((*(pCmdString+1) >= '0') && (*(pCmdString+1) <= '9'))
                  {
                     n = (BYTE)(10 * n + ( *(pCmdString+1) - '0')); // 10/23/2000 MB
                     pCmdString++;
                  }
               }
            }

            if (n < 23)
               ReserveDriveLetters = n;

            break;

         case 'S':                                   //SD@135221
            CDFlags |= CDF_SINGLE_UNIT;        /* make changer a single disk *///SD@135221
            break;                                  //SD@135221
         }
      }
   }
}

