/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/

/**************************************************************************
 *
 * SOURCE FILE NAME = CDHP.C
 *
 * DESCRIPTIVE NAME = Vendor unique command processing for HP
 *                    SCSI-2 CD-Writer Drives
 *
 *
 * VERSION = V2.0
 *
 * DATE    = 05/28/96, added as part of defect #156096, to support HP CD-ROM
 *
 * DESCRIPTION
 *
 *
 * FUNCTIONS
 *
 * ENTRY POINTS:
 *
 * DEPENDENCIES:
 *
 * NOTES
 *
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
*/

#include "cdh.h"
//#include "cdhp.h"

;/***************************************************************************
;*
;* FUNCTION NAME = HP_GetLastSessionAddr
;*
;* DESCRIPTION   = Get address of last session on multisession disk
;*
;*   This routine returns the address of the last session of a multisession
;*   photo CD disk.
;*
;*   USHORT HP_GetLastSessionAddr (NPUNITCB pUnitCB, ULONG FAR * session_addr)
;*
;* INPUT         = pUnitCB          - Pointer to UnitCB
;*                 session_addr     - Pointer to returned session addr
;*
;* OUTPUT        = USHORT           - Packet status word
;*
;*                                    if the STERR bit is on, then the disk
;*                                      is not a multisession disk and the
;*                                      session_addr field is not valid
;*
;*                                    if the STERR bit is NOT set, then the
;*                                      disk is a multi-session disk and the
;*                                      session addr field is valid
;*
;* RETURN-NORMAL
;*
;* RETURN-ERROR
;*
;**************************************************************************/

USHORT HP_GetLastSessionAddr (pUnitCB, session_addr)

NPUNITCB pUnitCB;
ULONG    FAR *session_addr;

{
   USHORT rc;
   NPIORB_CDB pIORB;
   struct ReadTOC_Data NEAR *pCDBData;
   struct CDB_ReadTOC *pCDB;               /* ptr to CDB               */
   union  AddressType last_session;
   UCHAR  lastsession;

   BuildCDB_ReadTOC (pUnitCB, 0, 1, (NPIORB_CDB FAR *) &pIORB);

   pCDB = (struct CDB_ReadTOC NEAR *) &pIORB->CDB;
   pCDBData = (struct ReadTOC_Data NEAR *) pIORB->CDB_data;

   /*
   ** Set Format field in CDB to return multisession info for Read TOC
   */
   pCDB->control |= 0x40;

   rc = SubmitIORB_Wait (pUnitCB, (NPIORB)pIORB);  // 10/23/2000 MB

   if (rc == STDON)
   {
      lastsession = pCDBData->toc_hdr.first_track;
      FreeIORB (pUnitCB, pIORB);

      BuildCDB_ReadTOC (pUnitCB, 0, 1, (NPIORB_CDB FAR *) &pIORB);

      pCDB = (struct CDB_ReadTOC NEAR *) &pIORB->CDB;
      pCDBData = (struct ReadTOC_Data NEAR *) pIORB->CDB_data;
      pCDB->starting_track = lastsession;
      pCDB->control |= 0x40;

      rc = SubmitIORB_Wait(pUnitCB, (NPIORB)pIORB);     //  10/23/2000 MB

      if (rc == STDON)
      {
         last_session.ul_redbook.min =
         pCDBData->toc_descriptor[0].abs_address.redbook.min;

         last_session.ul_redbook.sec =
         pCDBData->toc_descriptor[0].abs_address.redbook.sec;

         last_session.ul_redbook.frame =
         pCDBData->toc_descriptor[0].abs_address.redbook.frame;

         last_session.ul_redbook.zero = 0;

         last_session.dword = RedBookToHSG (last_session.dword);

         *session_addr = last_session.dword;
      }
   }
   FreeIORB (pUnitCB, pIORB);
   return (rc);
}

