/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
/**************************************************************************
 *
 * SOURCE FILE NAME = CDH.H
 *
 * DESCRIPTIVE NAME = Commonly used .H files for CD-ROM Device Manager
 *
 *
 * VERSION = V2.0
 *
 * DATE
 *
 * DESCRIPTION
 *
 *
 * FUNCTIONS
 *
 * ENTRY POINTS:
 *
 * DEPENDENCIES:
 *
 * NOTES
 *
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
*/

#define INCL_NOBASEAPI
#define INCL_NOPMAPI
#define INCL_ERROR_H

#include "os2.h"
#include "dos.h"
#include "bseerr.h"
#include "misc.h"
#include "cdtrace.h"  /* @Perftrace */
#include <perfhook.h> /* @Perftrace */
#include <infoseg.h> /* @Perftrace */

#include "devhdr.h"
#include "devcmd.h"
#include "strat2.h"
#include "reqpkt.h"
#include "dhcalls.h"
#include "scsi.h"
#include "iorb.h"
#include "cdbscsi.h"
#include "cdgencb.h"
#include "cddefs.h"

#include "cddata.h"
#include "cdproto.h"
#include "cdioctl.h"

#ifndef IOCM_SAVE_DMD_INFO
#define IOCM_SAVE_DMD_INFO        0x0008  /* O                         */  // 02/02/2000 MB
#define UF_USB_DEVICE    0x0800         // USB device - could deny any request until real device is attached //   02/02/2000 MB

/*                                                                    //   02/02/2000 MB   //
** DMD callback registration IORB                  (for IOCC_CONFIGURATION)                //
*/                                                                                         //
typedef USHORT  (FAR  _loadds  *PDMDCBK)(USHORT cmd, ULONG idData, ULONG cmdData);         //
// DMD callback routine call switches                                                      //
#define  USB_DMD_REINITIALIZE    1     // new device attached for existing driver letter   //
#define  USB_DMD_NEW_DEVICE      2     // new device attached (no drive letter)            //
#define  USB_DMD_DETACHED        3     // device detached                                  //
#define  USB_DMD_NEWDETACHED     4     // device detached (driver letter must be deleted)  //
#define  USB_DMD_SETBUSTYPE      5     // set device bus type (interface)                  //
                                                                                           //
typedef struct _IORB_SAVE_DMD   {  /* IOSAVEDMD */                                         //
                                                                                           //
  IORBH            iorbh;               /* IORB Header                  */                 //
  PDMDCBK          dmdCallback;         // far pointer to DMD callback routine             //
  ULONG            dmdDeviceId;         // data used by DMD to identify device             //
                                                                                           //
} IORB_SAVE_DMD, FAR *PIORB_SAVE_DMD, NEAR *NIORB_PSAVE_DMD;          //   02/02/2000 MB   //
#endif

