/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/

/**************************************************************************
 *
 * SOURCE FILE NAME = CDGENCB.H
 *
 * DESCRIPTIVE NAME = Internal control blocks for OS/2 CD-ROM Device Mgr
 *
 *
 * VERSION = V2.0
 *
 * DATE
 *
 * DESCRIPTION
 *
 *
 * FUNCTIONS
 *
 * ENTRY POINTS:
 *
 * DEPENDENCIES:
 *
 * NOTES
 *
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
*/
struct vendor_id_entry {
        UCHAR   *vendor_id_string;
        USHORT  vendor_id_code;
};

struct product_id_entry {
        UCHAR   *product_id_string;
        USHORT  product_id_code;
};

struct drive_caps_entry {
        USHORT  product_id_code;
        USHORT  capabilities;
};

/*
** vendor_id_code definitions
*/
#define TOSHIBA         0x01
#define SONY            0x02
#define HITACHI         0x03
#define NEC             0x04
#define TEXEL           0x05
#define MATSHITA        0x06                    /* PANASONIC            */
#define CHINON          0x07
#define PIONEER         0x08
#define IBM             0x09
#define LMS             0x0A
#define TORISAN         0x0B    /* SD@135221 */
#define TEAC            0x0C    // JSM
#define PLEXTOR         0x0D    
#define PHILIPS         0x0E
#define CREATIVE        0x0F
#define AOPEN           0x10
#define HP		0x11

/*
** product_id_code definitions
*/
#define TOSHIBA_3201    0x01
#define TOSHIBA_3301    0x02
#define TOSHIBA_3401    0x03
#define TOSHIBA_SDM1202 0x04
#define SONY_541        0x11    /* Sony 541, 7211                       */
#define SONY_561        0x12
#define SONY_DDU220E    0x13
#define HITACHI_3750    0x21    /* Hitachi 3750                         */
#define HITACHI_6750    0x22    /* Hitachi 6750                         */
#define HITACHI_GD2500  0x23
#define NEC_84_1        0x31    /* NEC 84-1                             */
#define NEC_260_17B     0x32    /* NEC 260 drive not ATAPI 1.2          */
#define NEC_251_250     0x33    /* NEC 260 drive not ATAPI 2.5 135221   */
#define NEC_46X         0x34    /* NEC 1410A 1610A 1810A                *//*@190032*/
#define TEXEL_3024      0x41    /* Texel 3024, 5024                     */
#define TEXEL_3024K     0x42    /* Texel 3024, 5024 with Kodak Photo CD */
#define PANASONIC_501   0x51    /* Panasonic 501                        */
#define PANASONIC_57x   0x52    /* Panasonic 574                        *//*@V156096*/
#define PANASONIC_58x   0x53    /* Panasonic 581                        *//*@V156096*/
#define PANASONIC_LFD100 0x54
#define CHINON_535      0x61    /* Chinon 535                           */
#define PIONEER_604X    0x71    /* Pioneer 604X                         */
#define LMS_215         0x91    /* LMS 215                              */
#define TORISAN_C3G     0xB1    /* Sanyo 3cd Atapi changer preATAPI spec*//* SD@135221 */
#define TEAC_CD40E      0xC1    /* Thinkpad TEAC CD40E */ //JSM
#define PLEXTOR_PX20    0xD1    /* Plextor CDROM PX-20TS                */
#define PHILIPS_PCA424D 0xE1
#define CREATIVE_5240E  0xF1
#define AOPEN_520S      0x101
#define HP_C4324        0x111   /* Hewlett-Packard C4324 CD-Writer      *//*@V156096*/
#define HP_9100		0x112   /* Hewlett-Packard 9100 CD-Writer */
#define HP_9200		0x113	/* Hewlett-Packard 9200 CD-Write  */


struct  Channel {                               /* audio channel info   */
        UCHAR   input_0;
        UCHAR   volume_0;
        UCHAR   input_1;
        UCHAR   volume_1;
        UCHAR   input_2;
        UCHAR   volume_2;
        UCHAR   input_3;
        UCHAR   volume_3;
};

struct Status {                                 /* audio status info    */
        USHORT          paused          : 1;
        USHORT          bits1           : 15;
        struct
        RedBookAddress  last_start_location;
        struct
        RedBookAddress  last_end_location;
};

struct Audio {                                  /* all audio info       */
        struct
        Status  status;
        struct
        Channel channel;
        ULONG   capabilities;                   /*SD@135221*/
};

struct Slots {                                  /*SD@135221*/
       UCHAR LoadInProgress;                    /*SD@135221*/
       UCHAR Maximum;                           /*SD@135221*/
       UCHAR Current;                           /*SD@135221*/
};                                              /*SD@135221*/

/* Drive capabilities bit definitions */

#define DCAPS_DOOR_LOCKED                0x00000001L            /*SD@135221*/
#define DCAPS_UNCERTAIN_MEDIA            0x00000002L            /*SD@135221*/
#define DCAPS_VARIABLE_VOLUME            0x00000004L            /*SD@135221*/
#define DCAPS_MUTE                       0x00000008L            /*SD@135221*/
#define DCAPS_INDEPENDENT_VOLUME_LEVELS  0x00000010L            /*SD@135221*/
#define DCAPS_NO_AUDIO_CTRL_DURING_PLAY  0x00000020L            /*SD@135221*/
#define DCAPS_NO_CHANNEL_SWAP            0x00000040L            /*SD@135221*/
#define DCAPS_XA                         0x00000080L            /*SD@135221*/
#define DCAPS_CDDA                       0x00000100L            /*SD@135221*/
#define DCAPS_NO_ADR_RETURNED            0x00000200L            /*SD@135221*/
#define DCAPS_UPC                        0x00000400L            /*SD@135221*/
#define DCAPS_UPC_IN_BCD                 0x00000800L            /*SD@135221*/
#define DCAPS_UPC_IN_ASCII               0x00001000L            /*SD@135221*/
#define DCAPS_MODE_WITH_ERR_RECOV        0x00002000L            /*SD@135221*/
#define DCAPS_MULTISESSION               0x00004000L            /*SD@135221*/
#define DCAPS_MULTISESSION_MOUNTED       0x00008000L            /*SD@135221*/
#define DCAPS_INDIVIDUAL_CHANGER         0x00010000L            /*SD@135221*/
#define DCAPS_CARTRIDGE_CHANGER          0x00020000L            /*SD@135221*/
#define DCAPS_SINGLE_MODE                0x00040000L            /*SD@135221*/
/*
        ULONG   door_locked                : 1,
                uncertain_media            : 1,
                variable_volume            : 1,
                mute_support               : 1,
                independent_volume_levels  : 1,
                no_audio_ctrl_during_play  : 1,
                no_channel_swap            : 1,
                xa_support                 : 1,
                cdda_support               : 1,
                no_adr_returned            : 1,
                upc_supported              : 1,
                upc_in_bcd                 : 1,
                upc_in_ascii               : 1,
                mode_with_err_recov        : 1,
                multi_session_support      : 1,
                multi_session_mounted      : 1;
                individual_changer         : 1;
                cartridge_changer          : 1;
};
*/

struct DeviceInfo {
        USHORT vendor_id_code;
        USHORT product_id_code;
        USHORT interface_type;
        USHORT current_block_size;
        USHORT raw_block_size;
        USHORT current_density;
        USHORT disk_density;
        USHORT current_disk_type;
        ULONG  last_session_addr;
        ULONG  volume_descr_terminator;
        USHORT last_cmd;
        USHORT playing;
        USHORT Parentplaying;                                   /*SD@135221*/
        struct
        Audio  Audio;
        union
        AddressType leadout;
        struct                                                  /*SD@135221*/
        Slots Slots;                                            /*SD@135221*/
        UCHAR Slot;                                            /*SD@135221*/  // 10/23/2000 MB
};

#define DISK_TYPE_CDROM 0
#define DISK_TYPE_CDXA  1
#define DISK_TYPE_CDDA  2

/* interface_type definitions */
#define  INTERFACE_SCSI         0x01
#define  INTERFACE_ATAPI        0x02
#define  INTERFACE_PROPRIETARY  0x03



struct  BlockParameters {
        union
        USHORTB   block_size;
        USHORT    density_code;
};


/*
**
** Unit Control Block
** ------------------
**
** This control blocks relates hardware devices to the Adapter
** Dependent Driver which manages them.
**
*/

typedef struct _PRTYQ
{
  NPIORB    Head;
  NPIORB    Tail;
} PRTYQ;

#define  NUM_RLE_QUEUES        9
#define  NUM_RP_QUEUES         2

#define  MAX_PACKET_SIZE      32
#define  MAX_PACKET_LENGTH    65536L
#define  NUM_OF_BUFFERS       4

struct Buffer_Info
{
  USHORT      flags;			  /* Packet flags */
  ULONG       LBA;			  /* LBA */
  UCHAR       access_order;		  /* access order: 0 - last used */
  ULONG       adr_buf;			  /* buffer address */
};

struct Packet_Info
{
  ULONG       sem;			  /* semaphore AK 02/20/02 */
  ULONG       packet_size;		  /* Packet size */
  UCHAR       packet_fp;		  /* 1 - fixed, 0 - variable packet size */
  UCHAR       track_mode;		  /* Track mode */
  UCHAR       write_type;		  /* Write type (00 - packet, ...) */
  UCHAR       block_type;		  /* Block type */
  struct
  Buffer_Info buf_info[NUM_OF_BUFFERS];   /* Buffer Info */
};

typedef struct _UnitControlBlock
{
  struct _UnitControlBlock    *pNextUnitCB;                /* Pointer to Next UnitCB       */ // 10/23/2000 MB
  struct _UnitControlBlock    *pParentUnitCB;              /* Pointer to parent Unit for Atapi Changers  *//*SD@135221*/
  USHORT      Flags;                      /* UnitCB Flags                 */
  USHORT      LogDriveNum;                /* Logical  Drive Number        */
  USHORT      PhysDriveNum;               /* Physical Drive Number        */
  UNITINFO    UnitInfo;                   /* Additional Driver Info       */
  struct
  DeviceInfo  DeviceInfo;                 /* Device Information Block     */
  struct
  Inquiry_Data InquiryData;               /* Device Inquiry Data          */
  UCHAR       Pad;                        /* Word align                   */
  USHORT      ADDHandle;                  /* ADD handle                   */
  USHORT      AdapterNumber;              /* Logical Adapter Number       */
  ULONG       TotalSectors;               /* Total Sectors for this drive */
  ULONG       Reserved;                   /* Read capacity Block Length   */
  USHORT      MaxHWSGList;                /* Max HW scatter/gather list   */
  NPIORBH     pDedicatedIORB;             /* Dedicated IORB for this unit */
  VOID (FAR * AdapterDriverEP)(PVOID);         /* ADD Entry Point              */   // 10/23/2000 MB
  USHORT      NumReqsInProgress;          /* # of requests in progress    */
  USHORT      NumReqsWaiting;             /* Number of requests waiting   */
  NPIORBH     InProgressQueue;            /* Queue of in progress requests*/
  PRTYQ       WaitingQueue;               /* Priority Queues              */
  ULONG       Semaphore;                  /* semaphore for ATAPI changers *//*SD@135221*/
  UCHAR       MediaType;		  /* Media type */
  struct
  Packet_Info PacketInfo;		  /* Info for packet writing */

} UNITCB;


/*------------------------------*
 * Common typedefs              *
 *------------------------------*/
typedef struct _UnitControlBlock   UNITCB, *NPUNITCB;
typedef struct _VolChars           *NPVOLCHARS;
typedef struct _BPB                BPB;
typedef struct _PB_Read_Write      PB_Read_Write, FAR *PPB_Read_Write;
typedef struct _Req_List_Header    Req_List_Header, FAR *PReq_List_Header;
typedef struct {
        USHORT (near *Strat1Near)(PVOID,NPUNITCB);  // 10/23/2000 MB
        BOOL   ChangerAllowed;
        } CMDFUNC;

typedef struct _INITDATA     INITDATA;
typedef struct InfoSegGDT FAR *PInfoSegGDT;  /* @PerfTrace */

/* Flag definitions for Flags field in UNITCB */
#define UCF_IORB_ALLOCATED  0x0001        /* Dedicated IORB allocated       */
#define UCF_HW_SCATGAT      0x0002        /* Unit supports ScatGat in HW    */
#define UCF_16M             0x0004        /* Unit supports > 16M addressing */
#define UCF_CHS_ADDRESSING  0x0008        /* Unit supports CHS Addressing   */
#define UCF_REMOVABLE_NON_FLOPPY  0x0010  /* Removable, non floppy          */
#define UCF_UNCERTAIN_MEDIA 0x0020        /* Uncertain media                */
#define UCF_AUDIO_SUPPORTED 0x0040        /* Audio command set supported    */
#define UCF_PACKET_WRITABLE 0x0080	  /* Packet writing */
#define UCF_NEED_REINIT     0x0100	  /* device need to be re-initialized before processing any request */  // 09/06/2000 MB
#define UCF_GETCONF_NS      0x0200	  /* get configuration request not supported */  // 10/23/2000 MB
#define UCF_DVD_MEDIA       0x0400        /* DVD media */

/* Flag definitions for Flags field in Buffer_Info */
#define PAC_EXIST           0x0001	  /* Buffer exists */
#define PAC_ALLOCATED	    0x0002	  /* Allocated for packet */
#define PAC_UNSAVED         0x0004	  /* Packet saved on disk */
#define PAC_VERIFY          0x0008        /* Write Verify buffer */

/*
** IORB DMWorkSpace Structure
*/

typedef struct _IORB_DMWORK
{
   NPUNITCB      pUnitCB;
   USHORT        Reserved_1;
   PBYTE         pRequest;
   SCATGATENTRY  SGList;
   NPIORB        WaitingQueueLink;
   NPIORB        pCoReqIORB;

} IORB_DMWORK, FAR *PIORB_DMWORK, NEAR *NPIORB_DMWORK;



typedef struct _DRIVERENTRY
{
   UCHAR        DriverName[17];
   PFN          AdapterDriverEP;
} DRIVERENTRY;


typedef struct _DRIVERTABLE
{
   USHORT       NumDrivers;
   DRIVERENTRY  DriverEntry[MAX_DRIVERS];
} DRIVERTABLE;


/*
** Init data allocated at the end of the data segment has the
** following structure:
*/

#define MAX_DEVICE_TABLE_SIZE 1024
/*
**      (sizeof(DEVICETABLE) + ((MAX_ADAPTERS_PER_ADD - 1) * 2) +
**      ((sizeof(ADAPTERINFO) - sizeof(UNITINFO)) * MAX_ADAPTERS_PER_ADD) +
**      sizeof(UNITINFO) * MAX_UNITS_PER_ADD)
*/
typedef struct _INITDATA
{
   UCHAR           ScratchBuffer2[MAX_DEVICE_TABLE_SIZE];  /* Scratch buffer  */
   UCHAR           ScratchIORB[MAX_IORB_SIZE]; /* IORB used during init       */
   RP_RWV          InitPkt;                    /* RP used during init         */
} INITDATA;


