/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
/**************************************************************************
 *
 * SOURCE FILE NAME = CDDATA.H
 *
 * DESCRIPTIVE NAME = Data externs for OS/2 CD-ROM Device Manager
 *
 *
 * VERSION = V2.0
 *
 * DATE
 *
 * DESCRIPTION
 *
 *
 * FUNCTIONS          Externs for data defined in CDDATA.C
 *
 * ENTRY POINTS:
 *
 * DEPENDENCIES:
 *
 * NOTES
 *
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
*/

/*
**  External data declarations in DMDATA.C
*/

extern PFN          Device_Help;          /* far ptr to devhelp function    */

extern PBYTE       pSysInfoSeg;         /* 16:16 addr of sys info seg     */ /*@Perftrace*/
extern ULONG       plSysInfoSeg;        /* linear addr of sys info seg    */ /*@Perftrace*/
extern PBYTE       pSIS_mec_table;      /* 16:16 addr of RAS MEC Table    */ /*@Perftrace*/
extern ULONG       plSIS_mec_table;     /* linear addr of RAS MEC Table   */ /*@Perftrace*/
extern PBYTE       pSIS_perf_mec_table; /* 16:16 addr of PERF MEC Table   */ /*@Perftrace*/
extern ULONG       plSIS_perf_mec_table;/* linear addr of PERF MEC Table  */ /*@Perftrace*/

extern PVOID        pDataSeg;             /* virt ptr of our data segment   */
extern ULONG        ppDataSeg;            /* phys addr of our data segment  */
extern ULONG        plDataSeg;            /* linear addr of our data seg    */
extern USHORT       ScratchBufSem;        /* Semaphore for ScratchBuffer    */
extern USHORT       CDFlags;              /* Global driver flags            */

extern NPUNITCB     UnitCB_Head;          /* near ptr to first UnitCB       */

extern NPBYTE       pNextFreeCB;          /* ptr to next free control blk   */

extern USHORT       NumDrivers;           /* number of adapter drivers      */
extern USHORT       NumUnitCBs;           /* number of unit control blocks  */
extern USHORT       NumCDROMDrives;       /* number of CD-ROM drives        */
extern USHORT       FirstDriveNumber;     /* First CD-ROM drive number      */
extern USHORT       NumAdapters;          /* number of adapters             */
extern USHORT       CD_NumReqsInProgress; /* num requests in progress       */
extern USHORT       CD_NumReqsWaiting;    /* num requests on waiting queues */
extern USHORT       TraceFlags;           /* Trace Flags                    */
extern NPBYTE       pCDTraceBuf;          /* pointer to internal trace buffer*/
extern NPBYTE       pCDTraceHead;         /* pointer to head of trace buffer */
extern NPBYTE       pCDTraceEnd;          /* pointer to end of trace buffer */

extern NPBYTE       CB_FreeList;          /* Control Block Free List for    */
                                          /*  IORBs and CWAs                */
extern USHORT       PoolSem;              /* Pool semaphore                 */
extern USHORT       PoolSize;             /* Size of control block pool     */
extern USHORT       FreePoolSpace;        /* Free space left in pool        */
extern USHORT       CodeBreakAddress;     /* end of code segment address    */
extern USHORT       DataBreakAddress;     /* end of data segment address    */

extern DriverCaps   DriverCapabilities;   /* Driver Capabilities structure  */

extern PBPB DummyBPB;                     /* Pointer to BPB for drive aliasing*/
extern BPB  DefaultBPB;                   /* Pointer to BPB for drive aliasing*/

extern NPBPB InitBPBArray[MAX_DRIVE_LETTERS]; /* BPB array returned in INIT packet*/
extern IORB_CDB     default_iorb_cdb;
extern UCHAR        volume_id_string[];
extern struct vendor_id_entry vendor_id_table [];     // 02/02/2000 MB
extern struct product_id_entry product_id_table [];   // 02/02/2000 MB
extern struct drive_caps_entry drive_caps_table [];   // 02/02/2000 MB
extern UNITCB       FirstUnitCB[];        /* First UnitCB allocated here    */
extern UCHAR        CBPool[];             /* Start of Pool                  */
extern USHORT       InitData;             /* Start of Init data             */
extern SEL	    ReservedSelectors[];

extern UCHAR        InitTimeIORB[];

