/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
/**************************************************************************
 *
 * SOURCE FILE NAME = CDDATA.C
 *
 * DESCRIPTIVE NAME = Static/Initialization data for CD-ROM Device Mgr
 *
 *
 * VERSION = V2.0
 *
 * DATE
 *
 * DESCRIPTION
 *
 *
 * FUNCTIONS
 *
 * ENTRY POINTS:
 *
 * DEPENDENCIES:
 *
 * NOTES
 *
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
*/

#define INCL_NOBASEAPI
#define INCL_NOPMAPI
#define INCL_ERROR_H

#include "os2.h"
#include "misc.h"
#include "cddefs.h"
#include "strat2.h"
#include "reqpkt.h"
#include "iorb.h"
#include "scsi.h"
#include "cdbscsi.h"
#include "cdgencb.h"

/*
**  GLOBAL DATA
**  -----------
**  1. Static data
**  2. Dynamic data allocated at init time:
**     - UnitCB
**  3. Dynamic data allocated at run time:
**     - IORB
**  4. Static init data discarded after init time
*/

#define MAXADAPTERDRIVERS       32         /* Max adapter device drivers     */


PFN             Device_Help=0L;            /* far ptr to devhelp function    */

PBYTE           pSysInfoSeg=0L;            /* 16:16 addr of sys info seg     */ /*@PerfTrace*/
PBYTE           pSIS_mec_table=0L;         /* 16:16 addr of RAS MEC Table    */ /*@PerfTrace*/
PBYTE           pSIS_perf_mec_table=0L;    /* 16:16 addr of PERF MEC Table   */ /*@PerfTrace*/

PVOID           pDataSeg=0L;               /* virt ptr of our data segment   */
ULONG           ppDataSeg=0L;              /* phys addr of our data segment  */
ULONG           plDataSeg=0L;              /* linear addr of our data seg    */
USHORT          ScratchBufSem=0;           /* Semaphore for ScratchBuffer    */
USHORT          CDFlags=0;                 /* Global driver flags            */

NPUNITCB        UnitCB_Head=0;             /* near ptr to first UnitCB       */

NPBYTE          pNextFreeCB=0;             /* ptr to next free control blk   */

USHORT          NumDrivers=0;              /* number of adapter drivers      */
USHORT          NumUnitCBs=0;              /* number of unit control blocks  */
USHORT          NumCDROMDrives=0;          /* number of CD-ROM drives        */
USHORT          FirstDriveNumber=0;        /* First CD-ROM drive number      */
USHORT          NumAdapters=0;             /* number of adapters             */
USHORT          CD_NumReqsInProgress=0;    /* num requests in progress       */
USHORT          CD_NumReqsWaiting=0;       /* num requests on waiting queues */
USHORT          TraceFlags=0;              /* Trace Flags                    */
NPBYTE          pCDTraceBuf=0;             /* pointer to internal trace buffer*/
NPBYTE          pCDTraceHead=0;            /* pointer to head of trace buffer */
NPBYTE          pCDTraceEnd=0;             /* pointer to end of trace buffer */

NPBYTE          CB_FreeList=0;             /* Control Block Free List for    */
                                           /*  IORBs and CWAs                */

USHORT          PoolSem=0;                 /* Pool semaphore                 */
USHORT          PoolSize=0;                /* Size of control block pool     */
USHORT          FreePoolSpace=0;           /* Free space left in pool        */
USHORT          CodeBreakAddress=0;        /* end of code segment address    */
USHORT          DataBreakAddress=0;        /* end of data segment address    */

SEL		ReservedSelectors[2]={0,0};/* Reserved GDT selectors         */

NPBPB InitBPBArray[MAX_DRIVE_LETTERS]={0}; /*BPB array returned in INIT packet*/

BPB  DefaultBPB = {2048, 1, 0, 0, 0, 0, 0xF0, 0, 0xFFFF, 1, 0, 270000L, 0};

UCHAR  volume_id_string[] = "CD001";

/*
** Default CDB Passthru IORB
*/
IORB_CDB  default_iorb_cdb = {

   sizeof(IORB_ADAPTER_PASSTHRU),            /* IORB Length                */
   0,                                        /* Unit Identifier            */
   IOCC_ADAPTER_PASSTHRU,                    /* Command Code               */
   IOCM_EXECUTE_CDB,                         /* Command Modifier           */
   IORB_ASYNC_POST + IORB_REQ_STATUSBLOCK,   /* Request Control Flags      */
   0,                                        /* Status                     */
   0,                                        /* Error Code                 */
   0,                                        /* Cmd completion timeout (s) */
   sizeof(SCSI_STATUS_BLOCK),                /* Status block length        */
   0,                                        /* Status block               */
   0,                                        /* Reserved, MBZ              */
   0,                                        /* Pointer to next IORB       */
   0,                                        /* Notification Address       */
   0,                                        /* For use by DM              */
   0,                                        /* For use by ADD             */

   0,                                        /* Count of S/G list elements */ // 10/23/2000 MB
   0,                                        /* far ptr to S/G List        */
   0,                                        /* physical addr of S/G List  */
   0,                                        /* Length of CDB              */
   0,                                        /* Pointer to CDB             */
   0,                                        /* phys ptr to SCB            */
   0                                         /* Flags                      */
};

// 02/02/2000 MB - added vendor/product/capability data table definitions
struct vendor_id_entry vendor_id_table [] =
{
   { "IBM     ", IBM},
   { "TOSHIBA ", TOSHIBA},
   { "SONY    ", SONY},
   { "HITACHI ", HITACHI},
   { "NEC     ", NEC},
   { "TEXEL   ", TEXEL},
   { "CHINON  ", CHINON},
   { "MATSHITA", MATSHITA},                      /* PANASONIC */
   { "PIONEER ", PIONEER},
   { "LMS     ", LMS},
   { "TORiSAN ", TORISAN},                       //SD@135221
   { "PLEXTOR ", PLEXTOR},                       /* PLEXTOR */  
   { "TEAC    ", TEAC},                         /* Thinkpad TEAC CD-40E */ // JSM
   { "PHILIPS ", PHILIPS},
   { "CREATIVE", CREATIVE},
   { "AOpen   ", AOPEN},
   {NULL,0  }  // 08/02/2000 MB - item added to mark last array element

};

struct product_id_entry product_id_table [] =
{
   { "TOSHIBA CD-ROM XM-3301TA", TOSHIBA_3301},
   { "TOSHIBA CD-ROM XM-3401TA", TOSHIBA_3401},
   { "TOSHIBA DVD-ROM SD-M1202",	TOSHIBA_SDM1202},
   { "IBM     CDRM00101     !D", TOSHIBA_3301},  /* IBM CD-ROM II             */
   { "IBM     CDRM00201     !E", TOSHIBA_3401},  /* IBM Enhanced CD-ROM II    */
   { "IBM     CDRM00203       ", TOSHIBA_3401},  /* IBM Enhanced CD-ROM II    */ //SM153992
   { "IBM     CD-ROM DRIVE:XM ", TOSHIBA_3301},  /* IBM CD-ROM II for RS6000  */
   { "TOSHIBA CD-ROM DRIVE:XM ", TOSHIBA_3201},  /* 2,3,4,5 = byte 0 of revision*/
   { "SONY    CD-ROM CDU-561  ", SONY_561},
   { "SONY    CD-ROM CDU-541  ", SONY_541},      /* CDU-7211, 541             */
   { "SONY    DVD-ROM DDU220E ",	SONY_DDU220E}, 
   { "HITACHI CDR-3750        ", HITACHI_3750},
   { "HITACHI CDR-6750        ", HITACHI_6750},
   { "HITACHI DVD-ROM GD-2500 ",	HITACHI_GD2500},
   { "MATSHITACD-ROM CR-5XX   ", PANASONIC_501}, /* PANASONIC CR-501          */
   { "MATSHITAPD-2 LF-D100    ", PANASONIC_LFD100}, /* DVD-RAM */
   { "TEXEL   CD-ROM          ", TEXEL_3024},    /* Texel 3024,5024           */
   { "TEXEL   CD-ROM DM-XX24 K", TEXEL_3024K},   /* Texel 3024,5024 with Kodak*/
   { "PIONEER CD-ROM DRM-604X ", PIONEER_604X},  /* Pioneer DRM-604X          */
   { "CHINON  CD-ROM CDS-535  ", CHINON_535},    /* Chinon 535                */
   { "LMS     CM215           ", LMS_215},       /* LMS CM215                 */
   { "NEC     CD-ROM DRIVE:841", NEC_84_1},      /* NEC 84-1                  */
   { "NEC     CD-ROM DRIVE:500", NEC_84_1},      /* NEC 500                   */ //SM153992
   { "NEC     CD-ROM DRIVE:260", NEC_260_17B},
   { "NEC     CD-ROM DRIVE:251", NEC_251_250},                                  /*@V156096*/
   { "NEC     CD-ROM DRIVE:462", NEC_46X},                                    /*@190032*/
   { "NEC     CD-ROM DRIVE:463", NEC_46X},                                    /*@190032*/
   { "NEC     CD-ROM DRIVE:464", NEC_46X},                                    /*@190032*/
   { "NEC     CD-ROM DRIVE:465", NEC_46X},                                    /*@225115*/
   { "NEC     CD-ROM DRIVE:466", NEC_46X},                                    /*@225115*/
   { "NEC     CD-ROM DRIVE:467", NEC_46X},                                    /*@225115*/
   { "NEC     CD-ROM DRIVE:468", NEC_46X},                                    /*@225115*/
   { "NEC     CD-ROM DRIVE:469", NEC_46X},                                    /*@225115*/
   { "TORiSAN CD-ROM CDR-C3G  ", TORISAN_C3G},   /* Sanyo ATAPI Changer       */ //SD@135221
   { "HP      C4324/C4325     ", HP_C4324},      /* Hewlett-Packard CD-Writer *//*@V156096*/
   { "PLEXTOR CD-ROM PX-4XCS  ", SONY_561},      /* PLEXTOR - @V3.0RV01       */
   { "TEAC    CD-40E          ", TEAC_CD40E},    /* Thinkpad TEAC CD40E       */ //JSM
   { "PLEXTOR CD-ROM PX-20TS  ", PLEXTOR_PX20},  /* PLEXTOR                   */ 
   { "PHILIPS PCA424D DVD-ROM ", PHILIPS_PCA424D},
   { "CREATIVEDVD5240E-1      ", CREATIVE_5240E},
   { "AOpen   PD-2 DVD-520S   ", AOPEN_520S},    /* DVD-RAM */
   { "HP      CD-Writer+ 9100 ", HP-9100},	 /* CD-Writer */
   { "HP      CD-Writer+ 9200 ", HP-9200},	 /* CD-Writer */
   {NULL,0} // 08/02/2000 MB - item added to mark last array element
};


/* Drive capabilities table */

struct drive_caps_entry drive_caps_table [] =
{
   {TOSHIBA_3301,  DCAPS_XA | DCAPS_UPC},
   {TOSHIBA_3401,  DCAPS_XA | DCAPS_CDDA | DCAPS_MULTISESSION | DCAPS_UPC},
   {SONY_561,      DCAPS_XA | DCAPS_CDDA | DCAPS_MULTISESSION | DCAPS_UPC |
                   DCAPS_UPC_IN_ASCII},
   {SONY_541,      DCAPS_XA | DCAPS_NO_ADR_RETURNED | DCAPS_UPC |
                   DCAPS_UPC_IN_BCD | DCAPS_MODE_WITH_ERR_RECOV},

   {HITACHI_3750,  0},
   {HITACHI_6750,  DCAPS_XA | DCAPS_MULTISESSION},
   {PANASONIC_501, DCAPS_UPC},
   {TEXEL_3024,    DCAPS_XA | DCAPS_NO_ADR_RETURNED | DCAPS_UPC |
                   DCAPS_UPC_IN_BCD | DCAPS_MODE_WITH_ERR_RECOV},
   {TEXEL_3024K,   DCAPS_XA | DCAPS_NO_ADR_RETURNED | DCAPS_UPC |
                   DCAPS_UPC_IN_BCD | DCAPS_MODE_WITH_ERR_RECOV |
                   DCAPS_MULTISESSION},
   {PIONEER_604X,  DCAPS_XA | DCAPS_MULTISESSION},
   {CHINON_535,    DCAPS_XA | DCAPS_MULTISESSION},
   {LMS_215,       DCAPS_XA | DCAPS_MULTISESSION},
   {NEC_84_1,      DCAPS_XA | DCAPS_MULTISESSION},
   {NEC_46X,       DCAPS_XA | DCAPS_MULTISESSION},                   /*@190032*/
   {HP_C4324,      DCAPS_XA | DCAPS_CDDA | DCAPS_MULTISESSION | DCAPS_UPC},
   {PLEXTOR_PX20,  DCAPS_XA | DCAPS_CDDA | DCAPS_MULTISESSION | DCAPS_UPC},      
   {0,0} // 08/02/2000 MB - item added to mark last array element 
};

/*
**  UnitCBs are allocated after all static data
*/
UNITCB          FirstUnitCB[1]={0};     /* First UnitCB allocated here       */

USHORT          CBPool[24*KB]={0};      /* Pool for Control blocks           */

