/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT (C) IBM Corporation, 1992                                       */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
/*static char *SCCSID = "@(#)cdchinon.h  6.5 92/05/04";*/
/*     SCCSID = @(#)cdchinon.h   6.5 92/05/04                           */

/************************************************************************/
/*                                                                      */
/* Driver Name: OS2CDROM.DMD - OS/2 CD-ROM Device Manager               */
/*              -----------------------------------------               */
/*                                                                      */
/* Source File Name: CDCHINON.H                                         */
/*                                                                      */
/* Descriptive Name: Vendor unique command descriptor blocks for Chinon */
/*                                                                      */
/* Function:                                                            */
/*                                                                      */
/*                                                                      */
/*----------------------------------------------------------------------*/
/*                                                                      */
/*                                                                      */
/* DISCLAIMER OF WARRANTIES.  The following [enclosed] code is          */
/* provided to you solely for the purpose of assisting you in           */
/* the development of your applications. The code is provided           */
/* "AS IS", without warranty of any kind. IBM shall not be liable       */
/* for any damages arising out of your use of this code, even if        */
/* they have been advised of the possibility of such damages.           */
/*                                                                      */
/*----------------------------------------------------------------------*/
/*                                                                      */
/* Change Log                                                           */
/*                                                                      */
/* Mark    Date      Programmer  Comment                                */
/* ----    ----      ----------  -------                                */
/* @nnnn   mm/dd/yy  NNN                                                */
/*                                                                      */
/*                                                                      */
/************************************************************************/

/*      CD-ROM device specific data structures      */

#define CHINON_GET_LAST_SESSION  0x26

/************************************************/
/* Chinon SCSI Get Last Session   (0x26)        */
/************************************************/
struct CHINON_CDB_GetLastSession {
        UCHAR   OpCode;

        UCHAR   reserved_1  : 5;
        UCHAR   LUN         : 3;

        UCHAR   reserved_2;
        UCHAR   reserved_3;
        UCHAR   reserved_4;
        UCHAR   reserved_5;
        UCHAR   reserved_6;
        UCHAR   reserved_7;
        UCHAR   reserved_8;

        UCHAR   control;
};


struct CHINON_LastSessionData {

        union
        ULONGB  LBA;            /* LBA of last session */

        union
        ULONGB  block_length;   /* current block length */

};
