/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
/**************************************************************************
 *
 * SOURCE FILE NAME = CDBSCSI.H
 *
 * DESCRIPTIVE NAME = SCSI Command Descriptor Block definitions for
 *                    the OS/2 CD-ROM Device Mgr.
 *
 *
 * VERSION = V2.0
 *
 * DATE
 *
 * DESCRIPTION
 *
 *
 * FUNCTIONS
 *
 * ENTRY POINTS:
 *
 * DEPENDENCIES:
 *
 * NOTES
 *
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
*/

/*
**    CD-ROM device specific data structures
*/
union ULONGB  {                           /* to pick apart a long */
        ULONG           dword;
        struct {
                USHORT  word_0;
                USHORT  word_1;
        } ulbwords;
        struct {
                UCHAR   byte_0;
                UCHAR   byte_1;
                UCHAR   byte_2;
                UCHAR   byte_3;
        } ulbytes;
};


union ULONGW  {
        ULONG           dword;
        struct {
                USHORT  word_0;
                USHORT  word_1;
        } ulwords;
};

struct  bytes     {
        UCHAR     byte_0;
        UCHAR     byte_1;
};

union   USHORTB {
        USHORT          word;
        struct {
                UCHAR   byte_0;
                UCHAR   byte_1;
        } usbytes;
};

struct ul_RedBookAddress {
        UCHAR       frame;
        UCHAR       sec;
        UCHAR       min;
        UCHAR       zero;
};

struct HSGaddress {
        UCHAR       byte_0;
        UCHAR       byte_1;
        UCHAR       byte_2;
        UCHAR       byte_3;
};

struct RedBookAddress {
        UCHAR    zero;
        UCHAR    min;
        UCHAR    sec;
        UCHAR    frame;
};


struct MSF0 {
        UCHAR    min;
        UCHAR    sec;
        UCHAR    frame;
        UCHAR    zero;
};


union AddressType {
        struct
        ul_RedBookAddress ul_redbook;
        struct
        HSGaddress        hsg;
        struct
        RedBookAddress    redbook;
        struct
        MSF0              msf0;
        ULONG             dword;

};



struct SCSI_command {
        UCHAR   byte_0;
        UCHAR   byte_1;
        UCHAR   byte_2;
        UCHAR   byte_3;
        UCHAR   byte_4;
        UCHAR   byte_5;
        UCHAR   byte_6;
        UCHAR   byte_7;
        UCHAR   byte_8;
        UCHAR   byte_9;
        UCHAR   byte_10;
        UCHAR   byte_11;
        UCHAR   byte_12;
        UCHAR   byte_13;
        UCHAR   byte_14;
        UCHAR   byte_15;
};

/************************************************
 * SCSI Test Unit Ready  (0x00)                 *
 ************************************************/
struct CDB_TestUnitReady {

        UCHAR   OpCode;

        UCHAR   Reserved_1 : 5;
        UCHAR   LUN        : 3;

        UCHAR   Reserved_2;
        UCHAR   Reserved_3;
        UCHAR   Reserved_4;
        UCHAR   Control;
};

/*
** CDB Control Bit Flags
*/
#define CDB_CONTROL_LINK   0x01
#define CDB_CONTROL_FLAG   0x02

/*
** CDB Control Bits - IBM vendor specific field in bits 6 & 7
*/
#define CDB_CONTROL_LBA    0x00
#define CDB_CONTROL_HEADER 0x40
#define CDB_CONTROL_TRACK  0x80

#define SCSI_READ_DISC_INFO   0x51   
#define SCSI_READ_TRACK_INFO  0x52
#define SCSI_READ_FORMAT_CAPACITIES 0x23
#define SCSI_SYNCHRONIZE_CACHE 0x35

/************************************************
 * SCSI Rezero Unit      (0x01)                 *
 ************************************************/
struct CDB_RezeroUnit {

        UCHAR   OpCode;

        UCHAR   reserved_1 : 5;
        UCHAR   LUN        : 3;

        UCHAR   reserved_2;
        UCHAR   reserved_3;
        UCHAR   reserved_4;
        UCHAR   control;
};

/************************************************
 * SCSI Request Sense    (0x03)                 *
 ************************************************/
struct CDB_RequestSense {

        UCHAR   OpCode;

        UCHAR   reserved_1 : 5;
        UCHAR   LUN        : 3;

        UCHAR   reserved_2;
        UCHAR   reserved_3;
        UCHAR   alloc_length;
        UCHAR   control;
};


struct Sense_Data
{
        UCHAR   error_code                  : 7;
        UCHAR   valid                       : 1;

        UCHAR   segment_number;

        UCHAR   sense_key                   : 4;
        UCHAR   reserved_1                  : 1;
        UCHAR   ILI                         : 1;
        UCHAR   EOM                         : 1;
        UCHAR   filemark                    : 1;

        union
	ULONGB  information;

        UCHAR   additional_sense_length;
        UCHAR   command_specific_info[4];
        UCHAR   additional_sense_code;
        UCHAR   additional_sense_code_qualifier;
        UCHAR   FRU_Code;
        UCHAR   sensekey_specific[3];
};

/************************************************
 * SCSI Read(6)          (0x08)                 *
 ************************************************/
struct CDB_Read_6 {

        UCHAR   OpCode;

        UCHAR   LBA_msb     : 5;
        UCHAR   LUN         : 3;

        union
        USHORTB LBA;
        UCHAR   transfer_length;
        UCHAR   control;
};

/************************************************
 * SCSI Read(10)         (0x28)                 *
 ************************************************/
struct CDB_Read_10 {
        UCHAR   OpCode;

        UCHAR   RelAdr      : 1;
        UCHAR   Reserved_1  : 2;
        UCHAR   FUA         : 1;
        UCHAR   DPO         : 1;
        UCHAR   LUN         : 3;

        union
        ULONGB  LBA;
        UCHAR   reserved_2;
        union
        USHORTB transfer_length;
        UCHAR   control;
};

/************************************************
 * SCSI Read(12)         (0xA8)                 *
 ************************************************/
struct CDB_Read_12 {
        UCHAR   OpCode;

        UCHAR   RelAdr      : 1;
        UCHAR   reserved_1  : 7;

        union
        ULONGB  LBA;
        union
        ULONGB  transfer_length;
        UCHAR   reserved_2;
        UCHAR   control;
};

/************************************************
 * SCSI Write(10)         (0x2A)                *
 ************************************************/
struct CDB_Write_10 {
        UCHAR   OpCode;

        UCHAR   RelAdr      : 1;
        UCHAR   Reserved_1  : 2;
        UCHAR   FUA         : 1;
        UCHAR   DPO         : 1;
        UCHAR   LUN         : 3;

        union
        ULONGB  LBA;
        UCHAR   reserved_2;
        union
        USHORTB transfer_length;
        UCHAR   control;
};

/************************************************
 * SCSI Write and Verify (10)         (0x2E)    *
 ************************************************/
struct CDB_WriteV_10 {
        UCHAR   OpCode;

        UCHAR   RelAdr      : 1;
        UCHAR   Reserved_1  : 2;
        UCHAR   FUA         : 1;
        UCHAR   DPO         : 1;
        UCHAR   LUN         : 3;

        union
        ULONGB  LBA;
        UCHAR   reserved_2;
        union
        USHORTB transfer_length;
        UCHAR   control;
};

/************************************************
 * SCSI Seek(6)          (0x0B)                 *
 ************************************************/
struct CDB_Seek_6 {

        UCHAR   OpCode;

        UCHAR   LBA_msb     : 5;
        UCHAR   LUN         : 3;

        union
        USHORTB LBA;
        UCHAR   reserved_1;
        UCHAR   control;
};

/************************************************
 * SCSI Seek(10)         (0x2B)                 *
 ************************************************/
struct CDB_Seek_10 {

        UCHAR   OpCode;

        UCHAR   reserved_1  : 5;
        UCHAR   LUN         : 3;

        union
        ULONGB  LBA;
        UCHAR   reserved_2;
        UCHAR   reserved_3;
        UCHAR   reserved_4;
        UCHAR   control;
};

/************************************************
 * SCSI Inquiry Command  (0x12)                 *
 ************************************************/
struct CDB_Inquiry {

        UCHAR   OpCode;

        UCHAR   EVPD       : 1;
        UCHAR   reserved_1 : 4;
        UCHAR   LUN        : 3;

        UCHAR   page_code;
        UCHAR   reserved_2;
        UCHAR   alloc_length;
        UCHAR   control;
};

struct Inquiry_Data
{
        USHORT  peripheral_device_type      : 8;
        USHORT  device_type_qualifier       : 7;
        USHORT  removable_medium            : 1;
        USHORT  ansi_version                : 3;
        USHORT  ecma_version                : 3;
        USHORT  iso_version                 : 2;
        USHORT  response_data_format        : 4;
        USHORT  bits                        : 4;
        UCHAR   additional_length;
        UCHAR   zeros [3];
        UCHAR   vendor_id [8];
        UCHAR   product_id [16];
        UCHAR   revision_level [4];
        UCHAR   scsi_firmware_date [8];
//      UCHAR   zero;
};

/************************************************
 * SCSI Format Unit Command   (0x04)            *
 ************************************************/

struct CDB_FormatUnit {

        UCHAR   OpCode;

        UCHAR   format_code : 3;
        UCHAR   CmpList     : 1;
        UCHAR   FmtData     : 1;
        UCHAR   LUN         : 3;

        UCHAR   reserved_1;
        union
        USHORTB interleave_value;
        UCHAR   control;
};

struct CDRWFMTDescriptor {
	UCHAR   init_pattern[4];

	UCHAR   reserved_1 : 6;
	UCHAR   Grow       : 1;
	UCHAR   Sess       : 1;

	UCHAR	reserved_2[3];

	union
	ULONGB  format_size;
};

struct FMT1Descriptor {
	union
	ULONGB  num_of_blocks;

	UCHAR	reserved_1  : 2;
	UCHAR   format_type : 6;

	UCHAR	parameter[3];
};

union FormatDescriptor {
	struct CDRWFMTDescriptor CDRW_descriptor;
	struct FMT1Descriptor    FMT1_descriptor;
};

struct FormatUnit_ParmList {
	UCHAR   reserved_1;

	UCHAR   VS        : 1;
	UCHAR   IMMED     : 1;
	UCHAR   DSP       : 1;
	UCHAR   IP        : 1;
	UCHAR   STPF      : 1;
	UCHAR   DCRT      : 1;
	UCHAR   DPRY      : 1;
	UCHAR   FOV       : 1;

	union
	USHORTB format_descr_length;

	union   FormatDescriptor Descriptor;
};

/************************************************
 * SCSI Mode Select Command(6)   (0x15)         *
 ************************************************/

struct CDB_ModeSelect {

        UCHAR   OpCode;

        UCHAR   SP         : 1;
        UCHAR   reserved_1 : 3;
        UCHAR   PF         : 1;
        UCHAR   LUN        : 3;

        UCHAR   reserved_2;
        UCHAR   reserved_3;
        UCHAR   parm_length;
        UCHAR   control;
};


/************************************************
 * SCSI Mode Select Command(10)     (0x55)      *
 ************************************************/

struct CDB_ModeSelect_10 {

        UCHAR   OpCode;

        UCHAR   SP         : 1;
        UCHAR   reserved_1 : 3;
        UCHAR   PF         : 1;
        UCHAR   LUN        : 3;

        UCHAR   reserved_2;
        UCHAR   reserved_3;
        UCHAR   reserved_4;
        UCHAR   reserved_5;
        UCHAR   reserved_6;
        union
        USHORTB parm_length;
        UCHAR   control;
};


/*  Mode Parameter Header for 6 byte Mode Select command*/

struct ModeSelectHdr {
        UCHAR     mode_data_length;
        UCHAR     medium_type;
        UCHAR     device_specific_parm;
        UCHAR     block_descriptor_len;
};


/*  Mode Parameter Header for 10 byte Mode Select command */

struct ModeSelectHdr_10 {
        union
        USHORTB   mode_data_length;
        UCHAR     medium_type;
        UCHAR     device_specific_parm;
        UCHAR     reserved_1;
        UCHAR     reserved_2;
        union
        USHORTB   block_descriptor_len;
};



/*
** CD-ROM Medium Type Codes
*/
#define CD_MEDIUM_DEFAULT              0x00
#define CD_MEDIUM_120_CDROM_DATA       0x01
#define CD_MEDIUM_120_CDDA_AUDIO       0x02
#define CD_MEDIUM_120_CDROM_COMBINED   0x03
#define CD_MEDIUM_RESERVED             0x04
#define CD_MEDIUM_80_CDROM_DATA        0x05
#define CD_MEDIUM_80_CDDA_AUDIO        0x06
#define CD_MEDIUM_80_CDROM_COMBINED    0x07

#define CD_MEDIUM_CLOSED_NODISC        0x70     /* ATAPI ONLY */
#define CD_MEDIUM_OPEN_NOCADDY         0x71     /* ATAPI ONLY */
#define CD_MEDIUM_CLOSED_MEDIUM_ERROR  0x72     /* ATAPI ONLY */



struct BlockDescriptor {
        UCHAR     density_code;
        UCHAR     block_count_0;
        UCHAR     block_count_1;
        UCHAR     block_count_2;
        UCHAR     reserved_1;
        UCHAR     block_length_0;
        UCHAR     block_length_1;
        UCHAR     block_length_2;
};

/*
** CD-ROM Density Codes
*/
#define CD_DENSITY_DEFAULT             0x00
#define CD_DENSITY_USER_DATA           0x01    /* 2048 bytes per sector */
#define CD_DENSITY_AUX_DATA            0x02    /* 2336 bytes per sector */
#define CD_DENSITY_TAG                 0x03    /* 2340 bytes per sector */
#define CD_DENSITY_AUDIO               0x04    /* 1/75 of a second      */

#define CD_DENSITY_CDXA                0X81    /* CD-ROM XA             */
#define CD_DENSITY_CDDA                0x82    /* CD-DA                 */
#define CD_DENSITY_CDXA_83             0x83    /* CD-ROM XA on Tosh3401 */

/*
** CD-ROM Audio Control Parameters Page -  Page Code 0x0E
*/
struct Page_AudioCtrl {

        UCHAR     page_code   : 6;
        UCHAR     reserved_1  : 1;
        UCHAR     PS          : 1;

        UCHAR     page_length;

        UCHAR     reserved_2  : 1;
        UCHAR     SOTC        : 1;
        UCHAR     Immed       : 1;
        UCHAR     reserved_3  : 5;

        UCHAR     reserved_4;
        UCHAR     reserved_5;

        UCHAR     LBA_format  : 4;
        UCHAR     reserved_6  : 3;
        UCHAR     APRVal      : 1;

        union
        USHORTB   LBAsPerSec;

        UCHAR     output0_select : 4;
        UCHAR     reserved_7     : 4;
        UCHAR     output0_volume;

        UCHAR     output1_select : 4;
        UCHAR     reserved_8     : 4;
        UCHAR     output1_volume;

        UCHAR     output2_select : 4;
        UCHAR     reserved_9     : 4;
        UCHAR     output2_volume;

        UCHAR     output3_select : 4;
        UCHAR     reserved_10    : 4;
        UCHAR     output3_volume;
};

/*
** Output Port Channel Selection
*/
#define  PCS_MUTED              0x00
#define  PCS_CHANNEL0           0x01
#define  PCS_CHANNEL1           0x02
#define  PCS_CHANNEL0_1         0x03
#define  PCS_CHANNEL2           0x04
#define  PCS_CHANNEL3           0x08

/*
** CD-ROM Parameters Page -  Page Code 0x0D
*/
struct Page_CDROM {

        UCHAR     page_code   : 6;
        UCHAR     reserved_1  : 1;
        UCHAR     PS          : 1;

        UCHAR     page_length;
        UCHAR     reserved_2;

        UCHAR     inactivity_timer : 4;
        UCHAR     reserved_3       : 4;

        union
        USHORTB   Num_S_per_M;

        union
        USHORTB   Num_F_per_S;
};

/*
** Read Error Recovery Parameters Page -  Page Code 0x01
*/
struct Page_ReadError {

        UCHAR     page_code   : 6;
        UCHAR     reserved_1  : 1;
        UCHAR     PS          : 1;

        UCHAR     page_length;
        UCHAR     error_parm;
        UCHAR     retry_count;

        UCHAR     reserved_2;
        UCHAR     reserved_3;
        UCHAR     reserved_4;
        UCHAR     reserved_5;
};


/* Read Error Recovery Parm definitions  (error_parm)        */

#define RE_DCR   0x01           /* Transfer Block            */
#define RE_DTE   0x02           /* Read Continuous           */
#define RE_PER   0x04           /* Post Error                */
#define RE_RC    0x10           /* Disable Transfer on Error */
#define RE_TB    0x20           /* Disable Correction        */



/*
** Verify Error Recovery Parameters Page -  Page Code 0x07
*/
struct Page_VerifyError {

        UCHAR     page_code   : 6;
        UCHAR     reserved_1  : 1;
        UCHAR     PS          : 1;

        UCHAR     page_length;
        UCHAR     error_parm;
        UCHAR     retry_count;

        UCHAR     reserved_2;
        UCHAR     reserved_3;
        UCHAR     reserved_4;
        UCHAR     reserved_5;
};

/*
** ATAPI CD-ROM Capabilites and Mechanical Status Page - Page Code 0x2A **
*/
struct Page_Capabilities {

        UCHAR     page_code   : 6;
        UCHAR     reserved_1  : 1;
        UCHAR     PS          : 1;

        UCHAR     page_length;
        UCHAR     read_capabilities;
        UCHAR     write_capabilities;
        ULONG     capabilities;

        union
        USHORTB   max_speed;

        union
        USHORTB   num_volume_levels;

        union
        USHORTB   drive_buffer_size;

        union
        USHORTB   current_drive_speed;

        UCHAR     num_adpcm_decoders;
        UCHAR     reserved_4;
        UCHAR     reserved_5;
        UCHAR     reserved_6;
};

/* Capabilities bit field definitions */

#define CP_AUDIO_PLAY                0x00000001
#define CP_XA                        0x00000002
#define CP_RESERVED_1                0x00000004
#define CP_RESERVED_2                0x00000008
#define CP_MODE2_FORM1               0x00000010
#define CP_MODE2_FORM2               0x00000020
#define CP_MULTISESSION              0x00000040
#define CP_RESERVED_3                0x00000080
#define CP_CDDA                      0x00000100
#define CP_CDDA_ACCURATE             0x00000200
#define CP_RW_CHANNEL_SUPPORT        0x00000400
#define CP_RW_DEINTERLEAVED          0x00000800
#define CP_C2_POINTERS               0x00001000
#define CP_ISRC                      0x00002000
#define CP_UPC                       0x00004000
#define CP_RESERVED_4                0x00008000
#define CP_LOCK                      0x00010000
#define CP_LOCK_STATE                0x00020000
#define CP_PREVENT_JUMPER            0x00040000
#define CP_EJECT                     0x00080000
#define CP_RESERVED_5                0x00100000
#define CP_TRAY_LOADER               0x00200000
#define CP_POPUP_LOADER              0x00400000
#define CP_RESERVED_LOADER           0x00800000
#define CP_INDIVIDUAL_CHANGER        0x00800000
#define CP_CARTRIDGE_CHANGER         0x00A00000
#define CP_INDEPENDENT_VOLUME_LEVELS 0x01000000
#define CP_SEPARATE_CHANNEL_MUTE     0x02000000
#define CP_CHANGER_DISC_PRESENT      0x04000000
#define CP_RESERVED_7                0x08000000
#define CP_RESERVED_8                0x10000000
#define CP_RESERVED_9                0x20000000
#define CP_RESERVED_10               0x40000000
#define CP_RESERVED_11               0x80000000

#define WRITE_CDR_ENABLED	0x01
#define WRITE_CDRW_ENABLED	0x02
#define WRITE_DVDR_ENABLED	0x10
#define WRITE_DVDRAM_ENABLED	0x20

struct Page_Write_Parameters  {
        UCHAR     page_code   : 6;
        UCHAR     reserved_1  : 1;
        UCHAR     PS          : 1;

        UCHAR     page_length;

	UCHAR	  write_type  : 4;
	UCHAR	  test_write  : 1;
	UCHAR	  LS_V	      : 1;
	UCHAR	  BUFE        : 1;
	UCHAR	  reserved_2  : 1;

	UCHAR	  track_mode  : 4;
	UCHAR	  copy	      : 1;
	UCHAR	  FP	      : 1;
	UCHAR	  multi_session : 2;

	UCHAR	  data_block_type : 4;
	UCHAR	  reserved_3      : 4;

	UCHAR	  link_size;
	UCHAR	  reserved_4;

	UCHAR	  host_application_code : 6;
	UCHAR	  reserved_5		: 2;

	UCHAR	  session_format;
	UCHAR	  reserved_6;

	union
	ULONGB	  packet_size;

	union
	USHORTB   audio_pause_length;

	UCHAR	  media_catalog_number[16];
	UCHAR	  ISRC[16];
	UCHAR	  sub_header_byte_0;
	UCHAR	  sub_header_byte_1;
	UCHAR	  sub_header_byte_2;
	UCHAR	  sub_header_byte_3;
};

union ModeSelectDescriptors  {
        struct BlockDescriptor  BlockDescriptor;
        struct Page_AudioCtrl   audio_control;
        struct Page_CDROM       CDROM;
        struct Page_ReadError   ReadError;
        struct Page_VerifyError VerifyError;
	struct Page_Capabilities Capabilities;
	struct Page_Write_Parameters WritePar;
};

struct ModeSelectParmList {
        struct ModeSelectHdr          ModeSelectHdr;
        union  ModeSelectDescriptors  Descriptors;
};

struct ModeSelectParmList_10 {
        struct ModeSelectHdr_10       ModeSelectHdr;
        union  ModeSelectDescriptors  Descriptors;
};

struct CapabilitiesParmList_10 {
        struct ModeSelectHdr_10       ModeParmHdr;
        struct Page_Capabilities      CapPage;
};

struct ModeSelectBlockError {
        struct ModeSelectHdr          ModeSelectHdr;
        struct BlockDescriptor        BlockDescriptor;
        struct Page_ReadError         ReadError;
};

/*
** Mode Page Codes
*/
#define PAGE_READ_ERROR         0x01
#define PAGE_DISCONNECT         0x02
#define PAGE_WRITE		0x05
#define PAGE_VERIFY_ERROR       0x07
#define PAGE_CACHING            0x08
#define PAGE_PERIPHERAL         0x09
#define PAGE_CONTROL_MODE       0x0A
#define PAGE_MEDIUM             0x0B
#define PAGE_CDROM              0x0D
#define PAGE_AUDIO_CONTROL      0x0E
#define PAGE_CAPABILITIES       0x2A
#define PAGE_ALL                0x3F

/************************************************
 * SCSI Reserve Command (0x16)                  *
 ************************************************/

struct CDB_Reserve {

        UCHAR   OpCode;

        UCHAR   extent     : 1;
        UCHAR   device_ID  : 3;
        UCHAR   ThirdPty   : 1;
        UCHAR   LUN        : 3;

        UCHAR   reservation_ID;
        union
        USHORTB extent_list_length;
        UCHAR   control;
};

/************************************************
 * SCSI Release Command (0x17)                  *
 ************************************************/

struct CDB_Release {

        UCHAR   OpCode;

        UCHAR   extent     : 1;
        UCHAR   device_ID  : 3;
        UCHAR   ThirdPty   : 1;
        UCHAR   LUN        : 3;

        UCHAR   reservation_ID;
        UCHAR   reserved_1;
        UCHAR   reserved_2;
        UCHAR   control;
};


/************************************************
 * SCSI Mode Sense(6)   (0x1A)                  *
 ************************************************/

struct CDB_ModeSense_6 {

        UCHAR   OpCode;

        UCHAR   reserved_1 : 3;
        UCHAR   DBD        : 1;
        UCHAR   reserved_2 : 1;
        UCHAR   LUN        : 3;

        UCHAR   page_code  : 6;
        UCHAR   PC         : 2;

        UCHAR   reserved_3;
        UCHAR   alloc_length;
        UCHAR   control;
};

/************************************************
 * SCSI Mode Sense(10)  (0x5A)                  *
 ************************************************/

struct CDB_ModeSense_10 {

        UCHAR   OpCode;

        UCHAR   reserved_1 : 3;
        UCHAR   DBD        : 1;
        UCHAR   reserved_2 : 1;
        UCHAR   LUN        : 3;

        UCHAR   page_code  : 6;
        UCHAR   PC         : 2;

        UCHAR   reserved_3;
        UCHAR   reserved_4;
        UCHAR   reserved_5;
        UCHAR   reserved_6;

        union
        USHORTB alloc_length;
        UCHAR   control;
};

struct ModeSenseHdr_10 {
        union
        USHORTB   mode_data_length;
        UCHAR     medium_type;
        UCHAR     reserved_1 : 4;
        UCHAR     cache      : 1;
        UCHAR     reserved_2 : 2;
        UCHAR     WP         : 1;
        UCHAR     reserved_3;
        UCHAR     reserved_4;
        union
        USHORTB   block_descriptor_len;
};

struct ModeSenseParmList_10 {
        struct ModeSenseHdr_10       ModeSenseHdr;
        union  ModeSelectDescriptors  Descriptors;
};

/* Page Control Field Definitions for Mode Sense */

#define PC_CURRENT     0x00
#define PC_CHANGEABLE  0x01
#define PC_DEFAULT     0x02
#define PC_SAVED       0x03

/* Medium types mmmm in the MediumType field mmmmXXXX of the Mode Sense Header */

#define MEDIUM_TYPE_CDROM	0
#define MEDIUM_TYPE_CDR		0x10
#define MEDIUM_TYPE_CDRW	0x20
#define MEDIUM_TYPE_DVDROM	0x40

/************************************************
 * SCSI Read Disc information  (0x51)           *
 ************************************************/

struct CDB_ReadDiscInfo {

        UCHAR   OpCode;

        UCHAR   reserved_1 : 5;
        UCHAR   LUN        : 3;

        UCHAR   reserved_2 [5];

        union
        USHORTB alloc_length;
        UCHAR   control;
};

struct ReadDiscInfo_Data {
        
        union
        USHORTB disc_info_length;

        UCHAR   disc_status : 2;
        UCHAR   last_status : 2;
        UCHAR   erasable    : 1;
        UCHAR   reserved_1  : 3;

	UCHAR	first_track;
	UCHAR	number_of_sessions_lsb;
	UCHAR	first_track_in_last_lsb;
	UCHAR	last_track_in_last_lsb;

	UCHAR	reserved_2  : 5;
	UCHAR	URU	    : 1;
	UCHAR	DBC_V	    : 1;
	UCHAR	DID_V	    : 1;

	UCHAR	disc_type;
	UCHAR	number_of_sessions_msb;
	UCHAR	first_track_in_last_msb;
	UCHAR	last_track_in_last_msb;

	union
	ULONGB	disc_ident;

	union
	ULONGB	lead_in;

	union
	ULONGB	lead_out;

	UCHAR	bar_code[8];
	UCHAR   reserved_3;
	UCHAR	number_OPC;
};

/************************************************
 * SCSI Read Track information  (0x52)          *
 ************************************************/

struct CDB_ReadTrackInfo {

        UCHAR   OpCode;

	UCHAR   Address    : 2;
        UCHAR   reserved_1 : 3;
        UCHAR   LUN        : 3;

	union
	ULONGB  LBA;
	
        UCHAR   reserved_2;

        union
        USHORTB alloc_length;
        UCHAR   control;
};

struct ReadTrackInfo_Data {
        
        union
        USHORTB track_info_length;

	UCHAR   track_number_LSB;
	UCHAR   session_number_LSB;
	UCHAR   reserved_1;

	UCHAR   track_mode  : 4;
	UCHAR   copy        : 1;
	UCHAR   damage      : 1;
	UCHAR   reserved_2  : 2;

	UCHAR   data_mode   : 4;
	UCHAR   FP	    : 1;
	UCHAR   packet_inc  : 1;
	UCHAR   blank       : 1;
	UCHAR   RT          : 1;

	UCHAR   NWA_V       : 1;
	UCHAR   LRA_V       : 1;
	UCHAR   reserved_3  : 6;

	union
	ULONGB  track_start;

	union
	ULONGB  next_address;

	union
	ULONGB  free_blocks;

	union
	ULONGB	FP_size;

	union
	ULONGB	track_size;

//	union                   // 10/23/2000 MB - deleted unused structure members to
//	ULONGB	LRA;           // make structure compatible with HP CD Writer
//
//	UCHAR	track_number_MSB;
//	UCHAR	session_number_MSB;
//	UCHAR	reserved_4 [2];
};


/************************************************
 * SCSI Read Format Capacities  (0x23)          *
 ************************************************/

struct CDB_ReadFormatCapacities {

        UCHAR   OpCode;

        UCHAR   reserved_1 : 5;
        UCHAR   LUN        : 3;

        UCHAR   reserved_2[5];

        union
        USHORTB alloc_length;

        UCHAR   control;
};

struct ReadFormatCapacities_Data {

	UCHAR	reserved_1[3];
	UCHAR	list_length;

	union
	ULONGB	num_of_blocks;

	UCHAR	descriptor_type : 2;
	UCHAR	reserved_2      : 6;

	UCHAR	block_length[3];
};

/************************************************
 * SCSI SyncCache         (0x35)                *
 ************************************************/
struct CDB_SyncCache {
        UCHAR   OpCode;

        UCHAR   RelAdr      : 1;
        UCHAR   Immed       : 1;
        UCHAR   Reserved_1  : 3;
        UCHAR   LUN         : 3;

        union
        ULONGB  LBA;
        UCHAR   Reserved_2;
        union
        USHORTB transfer_length;
        UCHAR   control;
};

/************************************************
 * SCSI Start Stop Unit Command (0x1B)          *
 ************************************************/

struct CDB_StartStopUnit {

        UCHAR   OpCode;

        UCHAR   Immed     : 1;
        UCHAR   reserved_1: 4;
        UCHAR   LUN       : 3;

        UCHAR   reserved_2;
        UCHAR   reserved_3;

        UCHAR   start     : 1;
        UCHAR   LoEj      : 1;
        UCHAR   reserved_4: 6;

        UCHAR   control;
};

/************************************************
 * SCSI Send Diagnostic Command (0x1D)          *
 ************************************************/

struct CDB_SendDiagnostic {

        UCHAR   OpCode;

        UCHAR   UnitOfL    : 1;
        UCHAR   DevOfL     : 1;
        UCHAR   SelfTest   : 1;
        UCHAR   reserved_1 : 1;
        UCHAR   PF         : 1;
        UCHAR   LUN        : 3;

        UCHAR   reserved_2;
        union
        USHORTB parm_length;
        UCHAR   control;
};


/************************************************
 * SCSI Prevent Allow Medium Removal (0x1E)     *
 ************************************************/

struct CDB_PreventAllowRemoval {

        UCHAR   OpCode;

        UCHAR   reserved_1    : 5;
        UCHAR   LUN           : 3;

        UCHAR   reserved_2;
        UCHAR   reserved_3;

        UCHAR   prevent       : 1;
        UCHAR   reserved_4    : 7;

        UCHAR   control;

};

/************************************************
 * SCSI Read Capacity Command (0x25)            *
 ************************************************/

struct CDB_ReadCapacity {

        UCHAR   OpCode;

        UCHAR   RelAdr     : 1;
        UCHAR   reserved_1 : 4;
        UCHAR   LUN        : 3;

        union
        ULONGB  LBA;
        UCHAR   reserved_2;
        UCHAR   reserved_3;

        UCHAR   PMI        : 1;
        UCHAR   reserved_4 : 7;

        UCHAR   control;
};


struct ReadCapacity_Data {
        union
        ULONGB  capacity_LBA;
        union
        ULONGB  capacity_block_length;
};


/************************************************
 * SCSI Prefetch Command (0x34)                 *
 ************************************************/
struct CDB_Prefetch {

        UCHAR   OpCode;

        UCHAR   RelAdr      : 1;
        UCHAR   Immed       : 1;
        UCHAR   Reserved_1  : 3;
        UCHAR   LUN         : 3;

        union
        ULONGB  LBA;
        UCHAR   reserved_2;
        union
        USHORTB transfer_length;
        UCHAR   Control;
};



/************************************************
 * SCSI Read Sub-Channel Command  (0x42)        *
 ************************************************/

struct CDB_ReadSubChannel {

        UCHAR   OpCode;

        UCHAR   reserved_1  : 1;
        UCHAR   MSF         : 1;
        UCHAR   reserved_2  : 3;
        UCHAR   LUN         : 3;

        UCHAR   reserved_3  : 6;
        UCHAR   SubQ        : 1;
        UCHAR   reserved_4  : 1;

        UCHAR   data_format;
        UCHAR   reserved_5;
        UCHAR   reserved_6;
        UCHAR   track_number;
        union
        USHORTB alloc_length;
        UCHAR   control;
};

/*
** SubChannel Data Format Codes
*/
#define RSC_Q_SUB_CHANNEL            0X00
#define RSC_CURRENT_POSITION         0X01
#define RSC_MEDIA_CAT_NUM            0x02
#define RSC_TRACK_ISRC               0x03


struct SubChannel_Hdr {
        UCHAR     reserved_1;
        UCHAR     audio_status;
        union
        USHORTB   data_length;
};

/*
** Audio Status Codes
*/
#define AS_NOT_SUPPORTED              0x00
#define AS_PLAY_IN_PROGRESS           0X11
#define AS_PLAY_PAUSED                0x12
#define AS_PLAY_COMPLETE              0x13
#define AS_PLAY_ERROR                 0x14
#define AS_NO_STATUS                  0x15

/*
** ADR Sub-channel Q Field
*/
#define ADR_NO_Q_INFO                 0x00
#define ADR_CURRENT_POSITION          0x01
#define ADR_MEDIA_CAT_NUM             0x02
#define ADR_TRACK_ISRC                0x03

/*
** Sub-channel Q Control Bits
*/
#define QCTL_PRE_EMPHASIS             0x01
#define QCTL_COPY_PERMITTED           0x02
#define QCTL_DATA_TRACK               0x04
#define QCTL_FOUR_CHANNEL             0x08


struct SubQ_Channel_Data {
        struct
        SubChannel_Hdr  sub_channel_hdr;

        UCHAR        data_format_code;

        UCHAR        control  : 4;
        UCHAR        ADR      : 4;

        UCHAR        track_number;
        UCHAR        index_number;
        union
        AddressType  abs_address,
                     rel_address;
        UCHAR        reserved_1  : 7;
        UCHAR        mcval       : 1;
        UCHAR        media_catalog_no [15];
        UCHAR        tcval_zero;
        UCHAR        isrc [15];
};


struct SubChannel_Position {

        struct
        SubChannel_Hdr  sub_channel_hdr;

        UCHAR            data_format_code;

        UCHAR            control  : 4;
        UCHAR            ADR      : 4;

        UCHAR            track_number;
        UCHAR            index_number;
        union
        AddressType      abs_address,
                         rel_address;
};

struct SubChannel_Media_Cat {
        struct
        SubChannel_Hdr    sub_channel_hdr;
        UCHAR             data_format_code;
        UCHAR             reserved_1;
        UCHAR             reserved_2;
        UCHAR             reserved_3;
        UCHAR             reserved_4  : 7;
        UCHAR             mcval       : 1;
        UCHAR             media_catalog_no [15];
};

struct SubChannel_ISRC {
        struct
        SubChannel_Hdr  sub_channel_hdr;
        UCHAR           data_format_code;
        UCHAR           control;
        UCHAR           track_number;
        UCHAR           reserved_1;
        UCHAR           tcval;
        UCHAR           media_catalog_number [15];
};



union CDROM_SubChannel_Info {
        struct SubQ_Channel_Data     q_sub_channel;
        struct SubChannel_Position   current_position;
        struct SubChannel_Media_Cat  media_cat_number;
        struct SubChannel_ISRC       track_ISRC;
};



/************************************************
 * SCSI Read TOC Command          (0x43)        *
 ************************************************/

struct CDB_ReadTOC {

        UCHAR   OpCode;

        UCHAR   Reserved_1   : 1;
        UCHAR   MSF          : 1;
        UCHAR   Reserved     : 3;
        UCHAR   LUN          : 3;

        UCHAR   Reserved_2;
        UCHAR   Reserved_3;
        UCHAR   Reserved_4;
        UCHAR   Reserved_5;

        UCHAR   starting_track;
        union
        USHORTB alloc_length;
        UCHAR   control;
};

struct TOC_Hdr {
        union
        USHORTB toc_datalength;
        UCHAR   first_track;
        UCHAR   last_track;
};

struct TOC_Descriptor {
        UCHAR   reserved_1;
        UCHAR   control   : 4;
        UCHAR   ADR       : 4;
        UCHAR   track_num;
        UCHAR   reserved_3;
        union
        AddressType abs_address;
};

struct ReadTOC_Data {
        struct
        TOC_Hdr        toc_hdr;
        struct
        TOC_Descriptor toc_descriptor[1];
};

/************************************************
 * SCSI Read Header Command       (0x44)        *
 ************************************************/

struct CDB_ReadHeader {

        UCHAR   OpCode;

        UCHAR   reserved_1   : 1;
        UCHAR   MSF          : 1;
        UCHAR   reserved_2   : 3;
        UCHAR   LUN          : 3;

        union
        ULONGB  LBA;
        UCHAR   reserved_3;
        union
        USHORTB alloc_length;
        UCHAR   control;
};



struct ReadHeader_Data {
        UCHAR   cdrom_data_mode;
        UCHAR   reserved_1;
        UCHAR   reserved_2;
        UCHAR   reserved_3;
        union
        AddressType abs_address;
};


/* CD-ROM Data Mode Codes (cdrom_data_mode) */

#define RH_MODE_ZERO     0x00
#define RH_MODE_LEC      0x01
#define RH_MODE_DATA     0x02


/************************************************
 * SCSI Play Audio(10) Command    (0x45)        *
 ************************************************/

struct CDB_PlayAudio_10 {

        UCHAR   OpCode;

        UCHAR   RelAdr      : 1;
        UCHAR   reserved_1  : 4;
        UCHAR   LUN         : 3;

        union
        ULONGB  LBA;
        UCHAR   reserved_2;
        union
        USHORTB transfer_length;
        UCHAR   control;
};


/************************************************
 * SCSI Play Audio(12) Command    (0xA5)        *
 ************************************************/

struct CDB_PlayAudio_12 {

        UCHAR   OpCode;

        UCHAR   RelAdr      : 1;
        UCHAR   reserved_1  : 4;
        UCHAR   LUN         : 3;

        union
        ULONGB  LBA;
        union
        ULONGB  transfer_length;
        UCHAR   reserved_2;
        UCHAR   control;
};

/************************************************
 * SCSI Play Audio MSF Command    (0x47)        *
 ************************************************/

struct CDB_PlayAudio_MSF {

        UCHAR   OpCode;

        UCHAR   reserved_1  : 5;
        UCHAR   LUN         : 3;

        UCHAR   reserved_2;
        UCHAR   starting_M;
        UCHAR   starting_S;
        UCHAR   starting_F;
        UCHAR   ending_M;
        UCHAR   ending_S;
        UCHAR   ending_F;
        UCHAR   control;
};

/************************************************
 * SCSI Play Audio Track Index  Command (0x48)  *
 ************************************************/

struct CDB_PlayAudio_TrackIndex {

        UCHAR   OpCode;

        UCHAR   reserved_1   : 5;
        UCHAR   LUN          : 3;

        UCHAR   reserved_2;
        UCHAR   reserved_3;
        UCHAR   starting_track;
        UCHAR   starting_index;
        UCHAR   reserved_4;
        UCHAR   ending_track;
        UCHAR   ending_index;
        UCHAR   control;
};

/************************************************
 * SCSI Play Audio Track Relative (10)  (0x49)  *
 ************************************************/

struct CDB_PlayAudio_TrackRel_10 {

        UCHAR   OpCode;

        UCHAR   reserved_1   : 5;
        UCHAR   LUN          : 3;

        union
        ULONGB  track_rel_LBA;
        UCHAR   starting_track;
        union
        USHORTB transfer_length;
        UCHAR   control;
};


/************************************************
 * SCSI Play Audio Track Relative (12)  (0xA9)  *
 ************************************************/

struct CDB_PlayAudio_TrackRel_12 {

        UCHAR   OpCode;

        UCHAR   reserved_1   : 5;
        UCHAR   LUN          : 3;

        union
        ULONGB  track_rel_LBA;
        union
        ULONGB  transfer_length;
        UCHAR   starting_track;
        UCHAR   control;
};


/************************************************
 * SCSI Pause Resume Command            (0x4B)  *
 ************************************************/

struct CDB_PauseResume {

        UCHAR   OpCode;

        UCHAR   reserved_1  : 5;
        UCHAR   LUN         : 3;

        UCHAR   reserved_2;
        UCHAR   reserved_3;
        UCHAR   reserved_4;
        UCHAR   reserved_5;
        UCHAR   reserved_6;
        UCHAR   reserved_7;

        UCHAR   resume     : 1;
        UCHAR   reserved_8 : 7;

        UCHAR   control;
};

/************************************************
 * SCSI  GET CONFIGURATION Command     (0x46)   *
 ************************************************/

#define SCSI_GET_CONFIGURATION		0x46

#define FEATURE_RANDOM_WRITABLE		0x20
#define FEATURE_INCREMENTAL_WRITABLE 	0x21

#define PROFILE_CDROM		8
#define PROFILE_CDR		9
#define PROFILE_CDRW		0x0A
#define PROFILE_DVDROM		0x10
#define PROFILE_DVDR		0x11
#define PROFILE_DVDRAM		0x12

struct CDB_GetConfiguration {

        UCHAR   OpCode;

        UCHAR   RT          : 2;
        UCHAR   reserved_1  : 6;

        union
        USHORTB  SFN;

        UCHAR reserved_2;
        UCHAR reserved_3;
        UCHAR reserved_4;

	union
	USHORTB  alloc_length;

	UCHAR control;
};

struct FeatureHdr {
	union
	ULONGB  DataLength;

	UCHAR   reserved_1;
	UCHAR   reserved_2;

	union
	USHORTB CurrentProfile;
};

struct IncrementalFeature {
	union
	USHORTB FeatureCode;

	UCHAR Current	   : 1;
	UCHAR Persistent   : 1;
	UCHAR Version      : 4;
	UCHAR reserved_1   : 2;

	UCHAR AddLength;

	union
	USHORTB DataType;

	UCHAR reserved_2;
	UCHAR NumLinkSizes;

	union {
	  struct {
	     UCHAR LinkSize;
	     UCHAR Pad[3];
	  } CD;
	  struct {
	     UCHAR LinkSize[2];
	     UCHAR Pad[2];
	  } DVD;
	};
};

struct RandomWritableFeature {
	union
	USHORTB FeatureCode;

	UCHAR Current	   : 1;
	UCHAR Persistent   : 1;
	UCHAR Version      : 4;
	UCHAR reserved_1   : 2;

	UCHAR AddLength;

	union
	ULONGB  LastLogBlockAddress;

	union
	ULONGB  LogBlockSize;

	union
	USHORTB Blocking;

	UCHAR  reserved_2;
	UCHAR  reserved_3;
};

union FeatureDescriptors {
	struct IncrementalFeature IncrFeature;
	struct RandomWritableFeature RandomFeature;
};

struct Configuration {
        struct FeatureHdr          FeatureHdr;
        union  FeatureDescriptors  Descriptors;
};

/************************************************
 * ATAPI  Unique Command Packets                *
 ************************************************/
#define ATAPI_CDB_LENGTH        0x0C         /* All CDBs are 12 bytes */
#define ATAPI_STOP_PLAYSCAN     0x4E         /* Stop Play Scan   */
#define ATAPI_READ_CD           0xBE         /* Read CD          */
#define ATAPI_READ_CD_MSF       0xB9         /* Read CD MSF      */
#define ATAPI_AUDIO_SCAN        0xBA         /* Audio Scan       */
#define ATAPI_SET_CDROM_SPEED   0xBB         /* Set CD-ROM Speed */

#define ATA_ENABLE_PM_MODE      0xC1         /* Enable Power Management */ // JSM


/************************************************
 * ATAPI  Stop Play Scan Command        (0x4E)  *
 ************************************************/

struct CDB_StopPlayScan  {

        UCHAR   OpCode;
        UCHAR   reserved_1;
        UCHAR   reserved_2;
        UCHAR   reserved_3;
        UCHAR   reserved_4;
        UCHAR   reserved_5;
        UCHAR   reserved_6;
        UCHAR   reserved_7;
        UCHAR   reserved_8;
        UCHAR   reserved_9;
        UCHAR   reserved_10;
        UCHAR   reserved_11;
};

#define ATAPI_MECHANISM_STATUS 0xBD                             /*SD@135221*/
                                                                /*SD@135221*/
struct CDB_MechanismStatus {                                    /*SD@135221*/
                                                                /*SD@135221*/
        UCHAR OpCode;                                           /*SD@135221*/
        UCHAR Reserved_1;                                       /*SD@135221*/
        UCHAR Reserved_2;                                       /*SD@135221*/
        UCHAR Reserved_3;                                       /*SD@135221*/
        UCHAR Reserved_4;                                       /*SD@135221*/
        UCHAR Reserved_5;                                       /*SD@135221*/
        UCHAR Reserved_6;                                       /*SD@135221*/
        UCHAR Reserved_7;                                       /*SD@135221*/
        union                                                   /*SD@135221*/
        USHORTB Allocation_Length;                              /*SD@135221*/
        UCHAR Reserved_10;                                      /*SD@135221*/
        UCHAR Reserved_11;                                      /*SD@135221*/
                                                                /*SD@135221*/
};                                                              /*SD@135221*/
                                                                /*SD@135221*/
struct SlotTableEntry {                                         /*SD@135221*/
        UCHAR DiscPresent :1;                                   /*SD@135221*/
        UCHAR Reserved_1  :6;                                   /*SD@135221*/
        UCHAR DiscChanged :1;                                   /*SD@135221*/
        UCHAR Reserved_2[3];                                    /*SD@135221*/
};                                                              /*SD@135221*/
                                                                /*SD@135221*/
struct Mechanism_Hdr {                                          /*SD@135221*/
        UCHAR Fault        :1;                                  /*SD@135221*/
        UCHAR ChangerState :2;                                  /*SD@135221*/
        UCHAR CurrentSlot  :5;                                  /*SD@135221*/
        UCHAR CD_MachanismState :3;                             /*SD@135221*/
        UCHAR Reserved_1   :5;                                  /*SD@135221*/
        UCHAR LBA[3];                                           /*SD@135221*/
        UCHAR Number_Of_Slots;                                  /*SD@135221*/
        union                                                   /*SD@135221*/
        USHORTB SlotTableLength;                                /*SD@135221*/
};                                                              /*SD@135221*/
                                                                /*SD@135221*/
struct MechanismStatusList {                                    /*SD@135221*/
        struct                                                  /*SD@135221*/
        Mechanism_Hdr Mechanism_Header;                         /*SD@135221*/
        struct                                                  /*SD@135221*/
        SlotTableEntry SlotTableEntry;                          /*SD@135221*/
};                                                              /*SD@135221*/
                                                                /*SD@135221*/
#define ATAPI_CHANGER_LOAD 0xA6                                 /*SD@135221*/
#define SANYO_ATAPI_CHANGER_LOAD SCSI_TEST_UNIT_READY           /*SD@135221*/
                                                                /*SD@135221*/
struct CDB_LoadSLot {                                           /*SD@135221*/
        UCHAR OpCode;                                           /*SD@135221*/
        UCHAR Immed :1;                                         /*SD@135221*/
        UCHAR Reserved_1 :7;                                    /*SD@135221*/
        UCHAR Reserved_2[2];                                    /*SD@135221*/
        UCHAR Start  :1;                                        /*SD@135221*/
        UCHAR LoUnLo :1;                                        /*SD@135221*/
        UCHAR Reserved_3 :6;                                    /*SD@135221*/
        UCHAR Reserved_4[3];                                    /*SD@135221*/
        UCHAR NewSlot;                                          /*SD@135221*/
        UCHAR Reserved_5[3];                                    /*SD@135221*/
};                                                              /*SD@135221*/

/************************************************
 * SCSI  READ DVD STRUCTURE Command     (0xAD)  *
 ************************************************/

#define SCSI_READ_DVD_STRUCTURE		0xAD

#define READDVD_FORMAT_00    0
#define READDVD_FORMAT_C0    0xC0

#define BOOKTYPE_DVDROM      0x00
#define BOOKTYPE_DVDRAM      0x01
#define BOOKTYPE_DVDR        0x02

struct CDB_ReadDVDStructure {

        UCHAR   OpCode;

        UCHAR   reserved_1  : 5;
        UCHAR   LUN         : 3;

        union
        ULONGB  address;

        UCHAR   layer_number;
        UCHAR   format;

        union
        USHORTB alloc_length;

        UCHAR   reserved_2 : 6;
        UCHAR   AGID       : 2;

        UCHAR   control;
};

struct ReadDVDStrucHdr {
        union
        USHORTB Data_Length;

        UCHAR  reserved_1;
        UCHAR  reserved_2;
};

struct Format_00 {
        UCHAR  part_ver  : 4;
        UCHAR  book_type : 4;

        UCHAR  min_rate  : 4;
        UCHAR  disk_size : 4;
};

struct Format_C0 {
        UCHAR  WP_flags   : 4;
        UCHAR  reserved_1 : 4;
};

union ReadDVDDataFormats  {
        struct Format_00  DataFormat_0;
        struct Format_C0  DataFormat_C0;
};

struct ReadDVDParmList {
        struct ReadDVDStrucHdr     Header;
        union  ReadDVDDataFormats  DataFormat;
};


/************************************************
 * ATAPI  READ CD Command               (0xD4)  *
 ************************************************/

struct CDB_ReadCD {

        UCHAR   OpCode;

        UCHAR   reserved_1  : 2;
        UCHAR   data_type   : 3;
        UCHAR   reserved_2  : 3;

        union
        ULONGB  LBA;

        UCHAR transfer_length_msb;
        UCHAR transfer_length;
        UCHAR transfer_length_lsb;

        USHORT reserved_3   : 1;
        USHORT error_flag   : 2;
        USHORT edc_ecc      : 1;
        USHORT user_data    : 1;
        USHORT headers      : 2;
        USHORT sync         : 1;
        USHORT subchannel   : 4;
        USHORT reserved_4   : 4;

        USHORT reserved_5;
};

/************************************************
 * ATAPI  READ CD MSF Command           (0xD5)  *
 ************************************************/

struct CDB_ReadCD_MSF {

        UCHAR   OpCode;

        UCHAR   reserved_1  : 2;
        UCHAR   data_type   : 3;
        UCHAR   reserved_2  : 3;

        UCHAR   reserved_3;
        UCHAR   starting_M;
        UCHAR   starting_S;
        UCHAR   starting_F;
        UCHAR   ending_M;
        UCHAR   ending_S;
        UCHAR   ending_F;

        USHORT reserved_4   : 1;
        USHORT error_flag   : 2;
        USHORT edc_ecc      : 1;
        USHORT user_data    : 1;
        USHORT headers      : 2;
        USHORT sync         : 1;
        USHORT subchannel   : 4;
        USHORT reserved_5   : 4;

        USHORT reserved_6;
};

/* READ CD Expected User Data Type Defitions- (data_type) */

#define RCD_TYPE_ANY     0x00    /* Any data type     */
#define RCD_TYPE_CDDA    0x01    /* CDDA audio sector */
#define RCD_TYPE_2048    0x02    /* 2048 byte data sector - Mode 1 or Form 1 */
#define RCD_TYPE_2336    0x03    /* 2336 byte Mode 2 data  */
#define RCD_TYPE_2328    0x04    /* 2328 byte Mode 2 Form 2 */

/* READ CD Header Code Definitions (headers) */

#define RCD_HEADER_NONE       0x00    /* No header data */
#define RCD_HEADER_HEADER     0x01    /* 4 byte Mode 1 or Form 1 header */
#define RCD_HEADER_SUBHEADER  0x02    /* 8 byte Mode 2 subheader */
#define RCD_HEADER_ALL        0x03    /* Both header and subheader */

/* READ CD Error Flag Definitions (error_flag) */

#define RCD_ERRFLG_NONE       0x00    /* No error info */
#define RCD_ERRFLG_C2         0x01    /* C2 Error Flag Pointer bits */
#define RCD_ERRFLG_C2_BLOCK   0x02    /* C2 Error Flags and Block Error Byte */

/* READ CD Sub-channel Data Selection Definitions (subchannel) */

#define RCD_SUB_NONE          0x00    /* No subchannel data */
#define RCD_SUB_RAW           0x01    /* Raw subchannel data */
#define RCD_SUB_Q             0x02    /* Q data */
#define RCD_R_W               0x04    /* R-W subchannel data */


/************************************************
 * ATAPI  AUDIO SCAN Command            (0xD8)  *
 ************************************************/

struct CDB_AudioScan {

        UCHAR   OpCode;

        UCHAR   reserved_1  : 4;
        UCHAR   direct      : 1;
        UCHAR   reserved_2  : 3;

        union
        AddressType scan_address;

        UCHAR   reserved_3;
        UCHAR   reserved_4;
        UCHAR   reserved_5;

        UCHAR   reserved_6  : 6;
        UCHAR   type        : 2;

        UCHAR   reserved_7;
        UCHAR   reserved_8;
};

/************************************************
 * ATAPI  Set CD-ROM Speed Command      (0xDA)  *
 ************************************************/

struct CDB_SetSpeed  {

        UCHAR   OpCode;

        UCHAR   reserved_1;

        union
        USHORTB drive_speed;

        UCHAR   reserved_2;
        UCHAR   reserved_3;
        UCHAR   reserved_4;
        UCHAR   reserved_5;
        UCHAR   reserved_6;
        UCHAR   reserved_7;
        UCHAR   reserved_8;
        UCHAR   reserved_9;
};

/************************************************
 * ATA  Enable Power Managementd        (0xC1)  *
 ************************************************/

struct CDB_EnablePMMode  {

        UCHAR   OpCode;
        UCHAR   reserved_1;
        UCHAR   reserved_2;
        UCHAR   reserved_3;
        UCHAR   reserved_4;
        UCHAR   reserved_5;
        UCHAR   reserved_6;
        UCHAR   reserved_7;
        UCHAR   reserved_8;
        UCHAR   reserved_9;
        UCHAR   reserved_10;
        UCHAR   reserved_11;
};


/************************************************
 *  Adapter Device Driver Vendor unique command *
 *                                              *
 *  Read Disk Information               (0xF0)  *
 ************************************************/
#define ADD_READ_DISK_INFO  0xF0


struct ADD_CDB_ReadDiskInfo {

        UCHAR   OpCode;

        UCHAR   type         : 2;
        UCHAR   reserved_1   : 3;
        UCHAR   LUN          : 3;


        UCHAR   reserved_2;
        UCHAR   reserved_3;
        UCHAR   reserved_4;
        UCHAR   reserved_5;
        UCHAR   reserved_6;
        UCHAR   reserved_7;
        UCHAR   reserved_8;

        UCHAR   control;
};

#define TYPE_CAPABILITIES_INFO 0x00
#define TYPE_LASTSESSION_INFO  0x01


struct RDI_Capabilities {
        UCHAR   read_capabilities;
        UCHAR   reserved_1;
        union
        USHORTB max_block_length;
};

/*
** read_capabilities bit flag definitions
*/
#define CAP_MULTISESSION   0x01
#define CAP_MODE2_FORM1    0x02
#define CAP_MODE2_FORM2    0x04
#define CAP_CDDA           0x08


struct RDI_LastSession {
        UCHAR   reserved;
        UCHAR   amin;
        UCHAR   asec;
        UCHAR   aframe;
};

union ADD_ReadDiskInfo_Data
{
        struct RDI_Capabilities   capabilities;
        struct RDI_LastSession    last_session;
};



/***********************************************************************
 * ADAPTER PASS THROUGH IORB           (for IOCC_ADAPTER_PASSTHRU)     *
 ***********************************************************************/
#define FILTER_WORKSPACE_SIZE   24

typedef struct _IORB_CDB           {  /* IOCDB */

  IORB_ADAPTER_PASSTHRU  apt;
  SCSI_STATUS_BLOCK      status_block;
  UCHAR                  pad;
  struct Sense_Data      sense_data;
  struct SCSI_command    CDB;
  UCHAR                  CDB_data[64];
  UCHAR                  filter_workspace[FILTER_WORKSPACE_SIZE];

} IORB_CDB, FAR *PIORB_CDB, *NPIORB_CDB;




