/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
/**************************************************************************
 *
 * SOURCE FILE NAME = NECDB.H
 *
 * DESCRIPTIVE NAME = Internal data structures for IOCTL handling in
 *                    the OS/2 CD-ROM Device Mgr.
 *
 *
 * VERSION = V2.0
 *
 * DATE
 *
 * DESCRIPTION
 *
 *
 * FUNCTIONS
 *
 * ENTRY POINTS:
 *
 * DEPENDENCIES:
 *
 * NOTES
 *
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
*/

/*
** NEC Vendor Unique Command Codes (group 6 commands)
*/
#define NEC_AUDIO_TRACK_SEARCH   0xD8
#define NEC_PLAY_AUDIO           0xD9
#define NEC_STILL                0xDA
#define NEC_SET_STOP_TIME        0xDB
#define NEC_EJECT                0xDC
#define NEC_READ_SUB_Q           0xDD
#define NEC_READ_TOC             0xDE

/*                                                             
** NEC46X Vendor Unique Command Codes (group 6 (scsi-2) commands)
*/                                                               /*@190032*/
#define NEC46X_READ_TOC             0x43

/*
** NEC Vendor Unique Command Descriptor Blocks
*/

/******************************
 * Audio Track Search   0xD8  *
 ******************************/

typedef struct {

   UCHAR                OpCode;

   UCHAR                play        : 1;
   UCHAR                reserved_1  : 7;

   UCHAR    search_min;
   UCHAR    search_sec;
   UCHAR    search_frame;
   UCHAR    search_zero;

   UCHAR                reserved_2;
   UCHAR                reserved_3;
   UCHAR                reserved_4;
   UCHAR                reserved_5   : 6;
   UCHAR                addr_type : 2;

} NEC_CDB_AudioTrackSearch, FAR *pNEC_CDB_AudioTrackSearch;


/******************************
 * Play Audio           0xD9  *
 ******************************/

typedef struct {

        UCHAR           OpCode;

        UCHAR           play_mode   : 2;
        UCHAR           reserved_1  : 6;

   UCHAR    completion_min;
   UCHAR    completion_sec;
   UCHAR    completion_frame;
   UCHAR    completion_zero;

        UCHAR           reserved_2;
        UCHAR           reserved_3;
        UCHAR           reserved_4;

        UCHAR           reserved_5  : 6;
        UCHAR           addr_type   : 2;

} NEC_CDB_PlayAudio, FAR *pNEC_CDB_PlayAudio;


/*
** Play mode definitions
*/
#define NEC_PLAY_MUTE            0x00
#define NEC_PLAY_LEFT            0x01
#define NEC_PLAY_RIGHT           0x02
#define NEC_PLAY_STEREO          0x03
#define NEC_PLAY_PREVIOUS_MODE   0x04

/*
** Address type definitions
*/
#define NEC_ADDR_HSG 0x00; /* search/playback address is logical block address*/
#define NEC_ADDR_MSF 0x01; /* search/playback address is min/sec/frm address  */
#define NEC_ADDR_TNO 0x02; /* search/playback address is a track number       */
#define NEC_ADDR_PRV 0x03; /* search/playback address remains the same        */

/******************************
 * Still                0xDA  *
 ******************************/

typedef struct {

        UCHAR           OpCode;

        UCHAR           reserved_1;
        UCHAR           reserved_2;
        UCHAR           reserved_3;
        UCHAR           reserved_4;
        UCHAR           reserved_5;
        UCHAR           reserved_6;
        UCHAR           reserved_7;
        UCHAR           reserved_8;

        UCHAR           control;

} NEC_CDB_Still, FAR *pNEC_CDB_Still;


/******************************
 * Set Stop Time        0xDB  *
 ******************************/

typedef struct {

        UCHAR           OpCode;

        UCHAR           Set_time_min   : 5;
        UCHAR           reserved_1     : 3;
        UCHAR           Set_time_sec;

        UCHAR           reserved_2;
        UCHAR           reserved_3;
        UCHAR           reserved_4;
        UCHAR           reserved_5;
        UCHAR           reserved_6;
        UCHAR           reserved_7;

        UCHAR           control;

} NEC_CDB_SetStopTime, FAR *pNEC_CDB_SetStopTime;


/******************************
 * Eject                0xDC  *
 ******************************/

typedef struct {

        UCHAR           OpCode;

        UCHAR           immediate   : 1;
        UCHAR           reserved_1  : 7;

        UCHAR           reserved_2;
        UCHAR           reserved_3;
        UCHAR           reserved_4;
        UCHAR           reserved_5;
        UCHAR           reserved_6;
        UCHAR           reserved_7;
        UCHAR           reserved_8;

        UCHAR           control;

} NEC_CDB_Eject, FAR *pNEC_CDB_Eject;


/******************************
 * Read Subcode Q       0xDD  *
 ******************************/

typedef struct {

        UCHAR           OpCode;

        UCHAR           alloc_length   : 5;
        UCHAR           reserved_1     : 3;

        UCHAR           reserved_2;
        UCHAR           reserved_3;
        UCHAR           reserved_4;
        UCHAR           reserved_5;
        UCHAR           reserved_6;
        UCHAR           reserved_7;
        UCHAR           reserved_8;

        UCHAR           control;

} NEC_CDB_ReadSubQ, FAR *pNEC_CDB_ReadSubQ;

/*
** Read Sub Q data contenets
*/
typedef struct {

        UCHAR           playback_status;
        UCHAR           control;
        UCHAR           tno;
        UCHAR           point;
        UCHAR           min;
        UCHAR           sec;
        UCHAR           frame;
        UCHAR           amin;
        UCHAR           asec;
        UCHAR           aframe;

} NEC_DATA_SubQChannel, FAR *pNEC_DATA_SubQChannel;

/*
** Playback status definitions
*/
#define NEC_PLAY_IN_PROGRESS  0x00
#define NEC_PLAY_STILL        0x01
#define NEC_PLAY_PAUSED       0x02
#define NEC_PLAY_COMPLETE     0x03


/******************************
 * Read TOC             0xDE  *
 ******************************/

typedef struct {

        UCHAR           OpCode;

        UCHAR           data_type   : 2;
        UCHAR           reserved_1  : 6;

        UCHAR           TNO;

        UCHAR           reserved_2;
        UCHAR           reserved_3;
        UCHAR           reserved_4;
        UCHAR           reserved_5;
        UCHAR           reserved_6;
        UCHAR           reserved_7;

        UCHAR           control;

} NEC_CDB_ReadTOC, FAR *pNEC_CDB_ReadTOC;


/******************************
 * Read TOC             0x43  *
 ******************************/ /*@190032*/

typedef struct {

        UCHAR           OpCode;

        UCHAR           reserved_1a : 6;
        UCHAR           MSF_flag    : 1;
        UCHAR           reserved_1b  : 1;

        UCHAR           reserved_2;
        UCHAR           reserved_3;
        UCHAR           reserved_4;
        UCHAR           reserved_5;
        UCHAR           start_track;
        UCHAR           allocLen_msb;
        UCHAR           allocLen_lsb;

        UCHAR           control;

} NEC46X_CDB_ReadTOC, FAR *pNEC46X_CDB_ReadTOC;


/*
** Data type definitions
*/
#define NEC_MINMAX_INFO    0x00
#define NEC_LEADOUT_INFO   0x01
#define NEC_TRACK_INFO     0x02
#define NEC_POINT_INFO     0x03


typedef struct {

        UCHAR           min_tno;
        UCHAR           max_tno;

        UCHAR           reserved_1;
        UCHAR           reserved_2;

} NEC_DATA_MinMax, FAR *pNEC_DATA_MinMax;

typedef struct {

        UCHAR           amin;
        UCHAR           asec;
        UCHAR           aframe;

        UCHAR           reserved_1;

} NEC_DATA_LeadOut, FAR *pNEC_DATA_LeadOut;

typedef struct {

        UCHAR           amin;
        UCHAR           asec;
        UCHAR           aframe;

        UCHAR           control  : 4;
   UCHAR    ADR      : 4;

} NEC_DATA_TrackInfo, FAR *pNEC_DATA_TrackInfo;


typedef struct {

        UCHAR           control;
        UCHAR           reserved_1;
        UCHAR           point;
        UCHAR           imin;
        UCHAR           isec;
        UCHAR           iframe;
        UCHAR           reserved_2;
        UCHAR           pmin;
        UCHAR           psec;
        UCHAR           pframe;

} NEC_DATA_Point, FAR *pNEC_DATA_Point;


typedef struct {

        UCHAR           data_count_msb;
        UCHAR           data_count_lsb;
        NEC_DATA_Point  point_data[1];

} NEC_DATA_PointInfo, FAR *pNEC_DATA_PointInfo;


/*                                              
**  Data Structures NEC46X Read TOC Command
*/                                              /*@190032*/
typedef struct {

        UCHAR           reserved_1;
        UCHAR           control;
        UCHAR           track_num;
        UCHAR           reserved_2;
        union           ULONGB LBA;

} NEC46X_TOC_Track, FAR *pNEC46X_TOC_Track;

typedef struct {

        UCHAR           data_count_msb;
        UCHAR           data_count_lsb;
        UCHAR           first_track_num;
        UCHAR           last_track_num;
        NEC46X_TOC_Track track_desc[1];

} NEC46X_DATA_ReadTOC, FAR *pNEC46X_DATA_ReadTOC;




/*
** Control type definitions
*/

#define NEC_AUDIO_TRACK    0x01
#define NEC_DATA_TRACK     0x41
#define NEC_PHOTO_CD       0x45



