/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
/**************************************************************************
 *
 * SOURCE FILE NAME = PARSECMD.C
 *
 * DESCRIPTIVE NAME =  IBMATAPI.FLT - Filter Driver for ATAPI DISK
 *
 *
 *
 * VERSION = V2.0
 *
 * DATE
 *
 * DESCRIPTION : Parser routine that calls the command parser
 *
 * Purpose:
 *
 *
*/
#include "os2.h"
#include "dos.h"
#include "dskinit.h"

#include "iorb.h"
#include "addcalls.h"
#include "dhcalls.h"
#include "apmcalls.h"                                               /*@V151168*/

#include "scsi.h"
#include "cdbscsi.h"

#include "cmdpdefs.h"
#include "cmdpext.h"
#include "atapicon.h"
#include "atapireg.h"
#include "atapityp.h"
#include "atapiext.h"

/*------------------------------------*/                                  /*@V151345*/
/*                                    */                                  /*@VVVVVVV*/
/*                                    */
/*                                    */
/*------------------------------------*/

#define PCF_ADAPTER0    0x00008000
#define PCF_ADAPTER1    0x00004000
#define PCF_ADAPTER2    0x00002000                                 /*@V87325*/
#define PCF_ADAPTER3    0x00001000                                 /*@V87325*/

#define PCF_IGNORE      0x00000800
#define PCF_RESET       0x00000400
#define PCF_PORT        0x00000200
#define PCF_IRQ         0x00000100
#define PCF_DM          0x00000080

#define PCF_UNIT0       0x00000040
#define PCF_UNIT1       0x00000020
#define PCF_GEO         0x00000010
#define PCF_TIMEOUT     0x00000008
#define PCF_LBAMODE     0x00000004
#define PCF_SMS         0x00000002
#define PCF_ATAPI       0x00000001                                       /*@V93531*/

#define PCF_DMATYPE     0x00080000
#define PCF_DMACHANNEL  0x00040000
#define PCF_DMASGP      0x00020000
#define PCF_BMDMA       0x00010000

#define PCF_FORCE       0x00100000                                  /*@V149971*/
#define PCF_PCMCIA      0x00200000                                  /*@V155162*/
#define PCF_PS2LED      0x00400000                                  /*@V182291*/
#define PCF_L_FLOPPY    0x00800000

#define PCF_CLEAR_ADAPTER (PCF_IGNORE | PCF_IRQ  | PCF_PORT | PCF_DM |    \
                           PCF_RESET | PCF_UNIT0  | PCF_UNIT1  | PCF_DMATYPE | \
                           PCF_DMACHANNEL | PCF_DMASGP | PCF_BMDMA | PCF_PCMCIA | \
                           PCF_PS2LED )

#define PCF_CLEAR_UNIT (PCF_GEO | PCF_TIMEOUT | PCF_DM    | PCF_LBAMODE | \
                        PCF_SMS | PCF_ATAPI   | PCF_FORCE | PCF_BMDMA   | \
                        PCF_UNIT0  | PCF_UNIT1 )

/*ͻ
                                  
                                  
*/
USHORT NEAR ParseCmdLine( PDDD_PARM_LIST pADDParms, NPATBL npAT )
{
   PSZ           pCurrChar;
   USHORT        LtoUval = 'a' - 'A';
   USHORT        rc = 0;

   PSZ           pCmdLine;
   CC            cc;
   NPSZ          pOutBuf;

   ULONG         Flags = 0;
   ULONG         Mask;

   NPUTBL        npUT;
   NPATBL        npATABLE = npAT;

   USHORT        AdptId;
   USHORT        UnitId;

   pOutBuf = poutbuf;

   pCmdLine = MAKEP( SELECTOROF(pADDParms), (USHORT) pADDParms->cmd_line_args );

   /*ͻ
     Parse the command Line                      
   */
   cc = Command_Parser( (PSZ)          pCmdLine,
                        (POPTIONTABLE) &opttable,
                        (PBYTE)        pOutBuf,
                        (USHORT)       outbuf_len );

   if ( cc.ret_code == NO_ERR )
   {
     while ( !rc && pOutBuf[1] != (UCHAR) TOK_ID_END )
     {

       length = pOutBuf[0];

       switch ( pOutBuf[1] )
       {
          /*-------------------------------------------*/
          /* Verbose Mode - /V                         */
          /*                                           */
          /*-------------------------------------------*/

         case TOK_ID_V:

           Verbose = TRUE;
           break;

          /*-------------------------------------------*/
          /* NOT Verbose Mode - /!V                    */
          /*                                           */
          /*-------------------------------------------*/

         case TOK_ID_NOT_V:

           Verbose = FALSE;
           break;

          /*-------------------------------------------*/
          /* Adapter - /A:n                            */
          /*                                           */
          /*-------------------------------------------*/

         case TOK_ID_ADAPTER:

           AdptId = pOutBuf[2];

           switch (AdptId)
           {
              case  0: Mask = PCF_ADAPTER0; break;
              case  1: Mask = PCF_ADAPTER1; break;
              case  2: Mask = PCF_ADAPTER2; break;
              case  3: Mask = PCF_ADAPTER3;
           }

           if ( (AdptId > (MAX_ADAPTERS-1)) || (Flags & Mask))
           {
             rc = 1;
             break;
           }
           npAT = npATABLE + AdptId;
           break;

        /*-------------------------------------------*/
        /* Unit Number - /U:0, /U:1                  */
        /*                                           */
        /*-------------------------------------------*/

        case TOK_ID_UNIT:

            UnitId = pOutBuf[2];

            Mask = (!UnitId) ? PCF_UNIT0 : PCF_UNIT1;
            if ( (UnitId > (MAX_UNITS-1)) || (Flags & Mask))
            {
              rc = 1;
              break;
            }
            Flags &= ~(PCF_CLEAR_UNIT);
            Flags |= Mask;
            npUT   = &npAT->Unit[UnitId];
            break;

          /*-------------------------------------------*/
          /* Large Floppy - /LF                        */
          /*                                           */
          /*-------------------------------------------*/

         case TOK_ID_LF:

           npUT->Flags |= UCBF_LARGE_FLOPPY;
           Flags        = 0;
           break;

          /*-------------------------------------------*/
          /* NOT Large Floppy - /!LF                   */
          /*                                           */
          /*-------------------------------------------*/

         case TOK_ID_NOT_LF:

           npUT->Flags &= ~UCBF_LARGE_FLOPPY;
           Flags        = 0;
           break;

        /*-------------------------------------------*/
        /* Ignore Adapter - /I                       */
        /*                                           */
        /*-------------------------------------------*/

        case TOK_ID_IGNORE:

          if ( (Flags & PCF_IGNORE) )
          {
            rc = 1;
            break;
          }

          Flags |= PCF_IGNORE;

          npAT->Flags |= ATBF_DISABLED;

          break;

          /*-------------------------------------------*/
          /* Unknown Switch                            */
          /*                                           */
          /*-------------------------------------------*/

         default:
           rc = 1;
           break;
       }

       if ( !rc ) pOutBuf += length;
     }
   }
   else if ( cc.ret_code != NO_OPTIONS_FND_ERR )
   {
     rc = 1;
   }

   return( rc );
}

