/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
/**************************************************************************
 *
 * SOURCE FILE NAME =  CMDPDEFS.H
 *
 * DESCRIPTIVE NAME =  IBMATAPI.FLT - Filter Driver for ATAPI Disks
 *
 *
 *
 * VERSION = V1.0
 *
 * DATE
 *
 * DESCRIPTION :
 *
 * Purpose:  This file is automatically included in the files
 *           which generate the parser tables:
 *
 *             CMDPDSKT.C - Command Table for Diskette ADDs
 *             CMDPDISK.C - Command Table for ST-506 DASD ADDs
 *             CMDPSCSI.C - Command Table for SCSI ADDs
 *
 *
*/
/*
 * Edit History for defect # 148406:
 *
 * Edit    Date    Comments
 * ----- --------  -------------------------------------------------------------
 * [001] 05-10-95  Integrated changes Shishir Shah made to original 2.1 version
 *                 of IBM1S506 driver to implement block mode and slave DMA. In
 *                 this file it involved the addition of several tokens to the
 *                 load option token definitions. /jlh
 * [002] 06-12-95  Added Bus Master DMA token definitions. /jlh
 *
 * [003] 08-31-95  Integrated latest IBM driver changes. IBM changes flagged with
 *                 unique IBM change codes as in table above. /jlh
 *
*/


/*                                                            */
/* TOKEN IDs  - opt.id definitions                            */
/*                                                            */
/* note:  - Assign a unique token id (1 - 255) for each valid */
/*          option.                                           */
/*                                                            */

#define TOK_ID_ADAPTER        1
#define TOK_ID_PORT           2
#define TOK_ID_UNIT           3
#define TOK_ID_DMA            4
#define TOK_ID_IRQ            5
#define TOK_ID_AHS            6
#define TOK_ID_NOT_AHS        7
#define TOK_ID_FORMAT         8
#define TOK_ID_S_BYTES        9
#define TOK_ID_MCA           10
#define TOK_ID_PS2           TOK_ID_MCA
#define TOK_ID_SLOT          11
#define TOK_ID_DM            12
#define TOK_ID_NOT_DM        13
#define TOK_ID_SM            14
#define TOK_ID_NOT_SM        15
#define TOK_ID_HCW           16
#define TOK_ID_NOT_HCW       17
#define TOK_ID_HCR           18
#define TOK_ID_NOT_HCR       19
#define TOK_ID_DEV0          20
#define TOK_ID_CAM           21
#define TOK_ID_NOT_CAM       22
#define TOK_ID_FDT           23
#define TOK_ID_NOT_FDT       24
#define TOK_ID_GEO           25
#define TOK_ID_SMS           26
#define TOK_ID_NOT_SMS       27
#define TOK_ID_SN            28
#define TOK_ID_NOT_SN        29
#define TOK_ID_ET            30
#define TOK_ID_NOT_ET        31
#define TOK_ID_CHGLINE       32
#define TOK_ID_TIMEOUT       33
#define TOK_ID_IGNORE        34
#define TOK_ID_V             35
#define TOK_ID_NOT_V         36
#define TOK_ID_LBAMODE       37
#define TOK_ID_RESET         38
#define TOK_ID_NORESET       39
#define TOK_ID_ATAPI         40                                      /*@V93531*/
#define TOK_ID_NOT_ATAPI     41                                      /*@V93531*/
#define TOK_ID_FORCE         42                                     /*@V149971*/
#define TOK_ID_PCMCIA        43                                     /*@V155162*/
/* Incremented token ids for DMA (below) by 1 */                    /*@V149971*//*@V155162*/

/* Begin [001] [003] */

#define TOK_ID_DMATYPE       44
#define TOK_ID_DMACHNL       45
#define TOK_ID_DMASGP        46                                      /* [002] */
#define TOK_ID_NOT_DMASG     47
#define TOK_ID_NEC           48


/* End [001] */

/* Begin [002] */
                                                                     /*@V151345*/
                                                                     /*@VVVVVVV*/
#define TOK_ID_BM_DMA        49        /* Bus Master DMA enable */
#define TOK_ID_NOT_BM_DMA    50        /* Bus Master DMA disable */
#define TOK_ID_DMASG         51        /* DMA scatter/gather enable */
                                                                     /*@AAAAAAA*/
                                                                     /*@V151345*/
/* End [002] [003] */

#define TOK_ID_PS2LED        52        /* PS2, force drive light control */  /*@V182291*/

#define TOK_ID_NOT_LF        53        /*  NOT Large Floppy      (PRM) V189445*/
#define TOK_ID_LF            54        /*  Large Floppy (LS-120) (PRM) V189445*/
