/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
/**************************************************************************
 *
 * SOURCE FILE NAME =  CMDPDATA.H
 *
 * DESCRIPTIVE NAME =  IBMATAPI.FLT - Filter driver for ATAPI Disk
 *
 *
 *
 * VERSION = V1.0
 *
 * DATE
 *
 * DESCRIPTION : Global data for Command Parser
 *
 * Purpose:
 *
*/


#include "os2.h"
#include "dos.h"
#include "dskinit.h"

#include "iorb.h"
#include "addcalls.h"
#include "dhcalls.h"
#include "apmcalls.h"                                               /*@V151168*/
#include "cmdparse.h"                                               /*@V151168*/
#include "cmdpdefs.h"                                               /*@V151168*/

/*-------------------------------------------------------------------*/
/*                                                                   */
/*      Command Line Parser Data                                     */
/*                                                                   */
/*                                                                   */
/*-------------------------------------------------------------------*/

#define TOKVBUF_LEN 255

PSZ        pcmdline1              = 0;
PSZ        pcmdline_slash         = 0;
PSZ        pcmdline_start         = 0;
INT        tokv_index             = 0;
INT        state_index            = 0;
INT        length                 = 0;
CHARBYTE   tokvbuf[TOKVBUF_LEN]   = { 0 };
POPT       pend_option            = 0;
POPT       ptable_option          = 0;
BYTE       *poutbuf1              = 0;
BYTE       *poutbuf_end           = 0;
CC         cc                     = { 0, 0 };

#define OUTBUF_LEN       255

BYTE     outbuf[OUTBUF_LEN] = {0};
USHORT   outbuf_len         = OUTBUF_LEN + 1;
PBYTE    poutbuf            = outbuf;

#define ENTRY_STATE        0
#define MAX_STATES         3

/*                                  opt.state[] initialization definitions    */
/*                                                                            */
/*                                              ____ entry state              */
/*                                              |                   previous  */
/*                                              v                     opt |   */
/*  ----Command Line Option --------           ----- STATE TABLE -----    |   */
/*  token id          string   type             0   1   2   3             |   */
/*                                                                        |   */
/*                                              *  /A:  /I  /U: <-----------  */
/*                                                          /T:               */

UCHAR TOK_ID_Vtxt[]          = "/V";
UCHAR TOK_ID_NOT_Vtxt[]      = "/!V";
UCHAR TOK_ID_ADAPTERtxt[]    = "/A:";
UCHAR TOK_ID_IGNOREtxt[]     = "/I";
UCHAR TOK_ID_Utxt[]          = "/U:";
UCHAR TOK_ID_UNITtxt[]       = "/UNIT:";
UCHAR TOK_ID_FORCEtxt[]      = "/FORCE";
UCHAR TOK_ID_LFtxt[]         = "/LF";
UCHAR TOK_ID_NOT_LFtxt[]     = "/!LF";
UCHAR TOK_ID_BM_DMAtxt[]     = "/BM";                                                /* [014] */
UCHAR TOK_ID_Not_BM_DMAtxt[] = "/!BM";

/* OPTION TOKENS */

UCHAR TOK_ID_ENDtxt[]        = "\0";

OPT OPT_VERBOSE =
    {TOK_ID_V,          TOK_ID_Vtxt,          TYPE_0,        {0,  1,  2,  3}};

OPT OPT_NOT_VERBOSE =
    {TOK_ID_NOT_V,      TOK_ID_NOT_Vtxt,      TYPE_0,        {0,  1,  2,  3}};

OPT OPT_ADAPTER =
    {TOK_ID_ADAPTER,    TOK_ID_ADAPTERtxt,    TYPE_D,        {1,  1,  1,  1}};     /*@V75103*/

OPT OPT_IGNORE =
    {TOK_ID_IGNORE,     TOK_ID_IGNOREtxt,     TYPE_0,        {E,  2,  E,  E}};

OPT OPT_U    =
    {TOK_ID_UNIT,       TOK_ID_Utxt,          TYPE_D,        {E,  3,  E,  3}};

OPT OPT_UNIT =
    {TOK_ID_UNIT,       TOK_ID_UNITtxt,       TYPE_D,        {E,  3,  E,  3}};

OPT OPT_FORCE =
    {TOK_ID_FORCE,      TOK_ID_FORCEtxt,      TYPE_0,        {E,  E,  E,  3}};

OPT OPT_LF =
    {TOK_ID_LF,         TOK_ID_LFtxt,         TYPE_0,        {E,  1,  2,  3}};

OPT OPT_NOT_LF =
    {TOK_ID_NOT_LF,     TOK_ID_NOT_LFtxt,     TYPE_0,        {E,  1,  2,  3}};

OPT OPT_BM_DMA  =
    {TOK_ID_BM_DMA,     TOK_ID_BM_DMAtxt,     TYPE_0,        {E,  1,  2,  3}};

OPT OPT_NOT_BM_DMA  =
    {TOK_ID_NOT_BM_DMA, TOK_ID_Not_BM_DMAtxt, TYPE_0,        {E,  1,  2,  3}};

OPT OPT_END =
    {TOK_ID_END,        TOK_ID_ENDtxt,        TYPE_0,        {O,  O,  O,  O}};



/*                                                                      */
/*   The following is a generic OPTIONTABLE for ADDs which support disk */
/*   devices.                                                           */
/*                                                                      */
OPTIONTABLE  opttable =

{   ENTRY_STATE, MAX_STATES,
    { (POPT) &OPT_VERBOSE,
      (POPT) &OPT_NOT_VERBOSE,
      (POPT) &OPT_ADAPTER,
      (POPT) &OPT_IGNORE,
      (POPT) &OPT_U,
      (POPT) &OPT_UNIT,
      (POPT) &OPT_LF,
      (POPT) &OPT_NOT_LF,
      (POPT) &OPT_END
    }
};
