/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
/**************************************************************************
 *
 * SOURCE FILE NAME = ATAPIPRO.H
 *
 * DESCRIPTIVE NAME = Proto-types for ATAPI driver
 *
 *
 *
 * VERSION = 1.0
 *
 * DATE
 *
 * DESCRIPTION :
 *
 * Purpose:
 *
 *
 *
 *
 *
*/

/*
ZDDDDDDDDDDDD?
3 ATAPIISM.C 3
@DDDDDDDDDDDDY
*/

VOID FAR StartOSMRequest           ( NPACB npACB );
VOID NEAR StartISM                 ( NPACB npACB );
VOID NEAR ISMStartState            ( NPACB npACB );
VOID NEAR InterruptState           ( NPACB npACB );
VOID NEAR PutByteInSGList          ( NPACB npACB, USHORT Data );
VOID NEAR StartATA_ATAPICmd        ( NPACB npACB );                  /*V189445*/
VOID NEAR SetATAPICmd              ( NPACB npACB );
VOID NEAR SetATACmd                ( NPACB npACB );
VOID NEAR WriteATAPIPkt            ( NPACB npACB );
VOID NEAR InitializeISM            ( NPACB npACB );
USHORT NEAR DRQ_AND_BSY_CLEAR_WAIT ( NPACB npACB );
VOID FAR IRQTimeOutHandler         ( ULONG TimerHandle, ULONG Parm1,
                                                        ULONG Parm2 );

VOID   NEAR PerfBMComplete        ( NPACB npACB ); /*V189445*/
USHORT NEAR FakeATA_ATAPI         ( NPACB npACB ); /*V189445*/

USHORT FAR _loadds AdapterIRQ0     ();
USHORT FAR _loadds AdapterIRQ1     ();
USHORT FAR _loadds AdapterIRQ2     ();
USHORT FAR _loadds AdapterIRQ3     ();
USHORT NEAR AdptInterrupt          ( NPACB npACB );
USHORT NEAR GetRegister            ( NPACB npACB, USHORT Register );

VOID   NEAR StopBMDMA              ( NPACB npACB );              /*V189445*/
VOID   NEAR ClearBMISTA_INT        ( USHORT data, NPACB npACB ); /*V189445*/
VOID   NEAR ClearBMISTA_error      ( USHORT data, NPACB npACB ); /*V189445*/

/*
ZDDDDDDDDDDDD?
3 ATAPIOSM.C 3
@DDDDDDDDDDDDY
*/

VOID   FAR  StartOSM              ( NPACB npACB );
VOID   NEAR StartIORB             ( NPACB npACB );
VOID   NEAR CompleteIORB          ( NPACB npACB );
VOID   NEAR Execute_CDB           ( NPACB npACB );
VOID   NEAR FreeHWResources       ( NPACB npACB );
USHORT NEAR ImmediateSuspendCheck ( NPACB npACB );
VOID   NEAR GetDeviceTable        ( NPACB npACB );
VOID   NEAR Suspend_Complete      ( NPACB npACB );
VOID   NEAR Resume_Complete       ( NPACB npACB );
USHORT FAR  NextIORB              ( NPACB npACB );
VOID   NEAR GetMediaGeometry      ( NPACB npACB );
VOID   NEAR GetDeviceGeometry     ( NPACB npACB );
VOID   NEAR UnitStatusMediaSense  ( NPACB npACB, USHORT command ); /*V189445*/
VOID   NEAR GetChangeLineState    ( NPACB npACB );
VOID   NEAR JustGo2CompleteIORB   ( NPACB npACB );
VOID   NEAR ISMComplete           ( NPACB npACB );
VOID   NEAR ValidateAndSend       ( NPACB npACB, USHORT command ); /*V189445*/
VOID   NEAR SetupAndExecute       ( NPACB npACB, USHORT command ); /*V189445*/
VOID   NEAR PerfBMComplete        ( NPACB npACB ); /*V189445*/
VOID   NEAR ProcessTURSense       ( NPACB npACB ); /*V189445*/
VOID   NEAR ProcessSenseData      ( NPACB npACB, UCHAR ASC ); /*V189445*/
VOID   NEAR ProcessNONSense       ( NPACB npACB );            /*V240175*/
UCHAR  NEAR SetMediaFlags         ( NPACB npACB, UCHAR ASC ); /*V189445*/
VOID   NEAR SetIORBError          ( NPACB npACB, UCHAR ASC ); /*V189445*/
VOID   NEAR ProcessIdentify       ( NPACB npACB ); /*V189445*/
USHORT NEAR MediaInvalid4Drive    ( NPACB npACB ); /*V189445*/
VOID   NEAR ExtractMediaGeometry  ( NPACB npACB ); /*V189445*/
VOID   NEAR GetDefinedDeviceGEO   ( NPACB npACB, PGEOMETRY pGeometry ); /*V189445*/
VOID   NEAR ClearCurrentMediaGEO  ( NPACB npACB ); /*V189445*/
VOID   NEAR SetCmdError           ( NPACB npACB ); /*V189445*/
VOID   NEAR Format_Track          ( NPACB npACB ); /*V189595*/
VOID   NEAR Format_NOT            ( NPACB npACB ); /*V189445*/
VOID   NEAR SetMediaGeometry      ( NPACB npACB ); /*V189595*/
VOID   NEAR SetLogicalGeometry    ( NPACB npACB ); /*V189595*/
VOID   NEAR GetLockStatus         ( NPACB npACB ); /*V189445*/
USHORT NEAR WhichnpACB            ( NPACB npACB ); /*V189445*/

/*
ZDDDDDDDDDDDD?
3 ATAPINIT.C 3
@DDDDDDDDDDDDY
*/
VOID   FAR  DriverInit            ( PRPINITIN  pRPH );
VOID   NEAR SetupADDVars          ();
NPBYTE FAR  InitAllocate          ( USHORT Size );
VOID   NEAR AllocateUnit          ( NPACB npACB );
VOID   NEAR DeallocateUnit        ( NPACB npACB );
VOID   NEAR ChangeUnitInfo        ( NPACB npACB );
VOID   FAR  InitDeAllocate        ( USHORT Size );
VOID   NEAR PrintInfo             ( NPATBL npAT );
VOID   NEAR DisplayInfo           ( NPATBL npAT );
VOID   NEAR TTYWrite              ( PSZ Buf );
USHORT NEAR ParseCmdLine          ( PDDD_PARM_LIST pADDParms, NPATBL npAT );
USHORT NEAR ClaimUnit             ( NPATBL npAT, BOOL Resume,       /*@V155162*/
                                    USHORT UnitHandle,
                                    PUNITINFO pOldUnitInfo,
                                    VOID (FAR *DriverEP)() );
USHORT NEAR Issue_ReportResources ( PRESOURCE_ENTRY pRE,
                                    USHORT UnitHandle, VOID (FAR *DriverEP)());
USHORT NEAR AllocDeallocChangeUnit( PUNITINFO pUI, USHORT UnitHandle,
                                    USHORT funtion, VOID (FAR *DriverEP)() );

VOID   NEAR ConfigureACB          ( NPATBL npAT );
USHORT NEAR ATAPIIdentify         ( NPATBL npAT );
USHORT NEAR ATAPIReset            ( NPATBL npAT ); /* chl */
USHORT NEAR ConfigureController   ( NPATBL npAT, USHORT AdapterId );
USHORT NEAR ConfigureUnit         ( NPATBL npAT, USHORT AdapterId, USHORT UnitId );
VOID   NEAR GetATAPIUnits         ();
USHORT NEAR CheckController       ( NPATBL npAT );
USHORT NEAR CheckSectorReg        ( NPATBL npAT );
VOID   NEAR SelectUnit            ( NPACB npACB, USHORT UnitId );
USHORT FAR  CheckReady            ( NPACB npACB );
USHORT NEAR InitSuspendResumeOtherAdd ( NPACB npACB, USHORT function ); /*V189445*/
VOID   FAR  _loadds NotifyIORBDone( PIORB pIORB );                  /*@V153151*/
USHORT NEAR GetIdentifyData       ( NPACB npACB, USHORT UnitId, PBYTE pID );
VOID   FAR  CalibrateTimers       ( NPACB npACB );
VOID   FAR  CalibrateTimer        ( ULONG hCalibrateTimer, ULONG Unused1,
                                                           ULONG Unused2 );
VOID   NEAR ScanForLegacyFloppies ();                               /*@V189445*/
VOID   NEAR RemoveB_DriveFlag     ();                               /*@V189592*/
VOID   NEAR SetupIdentifySGlist();
VOID   NEAR DefaultLargeFloppyOn( NPATBL npAT );

typedef
VOID   (FAR *PCV)                 ();

ULONG  FAR  CalibrateWorker       ( NPACB npACB, PCV npWorker );
VOID   FAR  ElapsedTimer          ( ULONG hElapsedTimer, ULONG Unused1,
                                                         ULONG Unused2);
VOID   NEAR ResetController       ( NPACB npACB );


/*
ZDDDDDDDDDDDD?
3 ATAPIGEN.C 3
@DDDDDDDDDDDDY
*/

VOID   FAR  IODelay                        ();
VOID   NEAR setmem                         ( PBYTE d, USHORT c, USHORT len );
VOID   NEAR memcopy                        ( PBYTE d, PBYTE s, USHORT len );
VOID   NEAR strncpy                        ( PSZ d, PSZ s, USHORT n );
BOOL   NEAR strncmp                        ( PSZ d, PSZ s, USHORT n );
ULONG  VirtToPhys                          ( PBYTE VirtAddr);
USHORT NEAR SuspendOtherAdd                ( NPACB npACB );
USHORT NEAR ResumeOtherAdd                 ( NPACB npACB );
ULONG  NEAR QueryOtherAdd                  ( NPACB npACB );
VOID   FAR  _loadds NotifySuspendResumeDone( PIORB pIORB );
VOID   NEAR IDECDStr                       ();
USHORT FAR BSY_CLR_DRQ_SET_WAIT            ( NPACB npACB );

VOID   NEAR ATAPCompleteInit               ( NPACB npACB );         /*@V151168*/
USHORT FAR  APMEventHandler                ( PAPMEVENT );           /*@V151168*/
USHORT NEAR APMSuspend                     ();                      /*@V151168*/
USHORT NEAR APMResume                      ();                      /*@V151168*/


/*
ZDDDDDDDDDDDD?
3 ATAPIORB.C 3
@DDDDDDDDDDDDY
*/
typedef PIORB FAR *PPIORB;

VOID   FAR _loadds ATAPIADDEntry  ( PIORBH pNewIORB );
PIORB  NEAR PreProcessIORBs( NPACB npACB, PPIORB ppNewIORB );
VOID   NEAR RemoveIORB( PIORB pIORB, PIORB pIORBPrev, PPIORB pIORBFirst );
USHORT NEAR SuspendIORB( NPACB npACB, PIORB pIORB );
USHORT NEAR ResumeIORB( NPACB npACB, PIORB pIORB );
USHORT NEAR ActivateACBCheck( NPACB npACB );
USHORT NEAR Valid_CDB_Length_Check( PIORBH pIORB, NPACB npACB );
UCHAR  NEAR x2BCD ( UCHAR Data );
VOID   NEAR Convert_17B_to_ATAPI( ULONG pPhysData );

/*
ZDDDDDDDDDD?
3 PRINTF.C 3
@DDDDDDDDDDY
*/
VOID NEAR sprintf( PSZ s, PSZ fmt, ... );

/*
ZDDDDDDDDDDDDD?
3 dprintf.asm 3
@DDDDDDDDDDDDDY
*/

VOID NEAR dprintf(CHAR FAR * msg, ...);
