/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
/**************************************************************************
 *
 * SOURCE FILE NAME = ATAPIOSM.C
 *
 * DESCRIPTION : OUTER STATE MACHINE for ATAPI driver
 *
 *
 *
 * VERSION = 1.0
 *
 * DATE
 *
 * DESCRIPTION :
 *
 * Purpose:
 *
 *
*/

#define INCL_NOBASEAPI
#define INCL_NOPMAPI
#include "os2.h"
#include "dos.h"
#include "dskinit.h"

#include "iorb.h"
#include "addcalls.h"
#include "dhcalls.h"
#include "apmcalls.h"                                               /*@V151168*/

#define INCL_INITRP_ONLY
#include "reqpkt.h"

#include "scsi.h"
#include "cdbscsi.h"

#include "atapicon.h"
#include "atapireg.h"
#include "atapityp.h"
#include "atapiext.h"
#include "atapipro.h"

/*ͻ
                                  
  StartOSM                        
                                  
  Outer State Machine Router      
                                  
*/
VOID FAR StartOSM ( NPACB npACB )
{
   DISABLE

   npACB->OSMUseCount++;

   if ( npACB->OSMUseCount == 1 )
   {
      do
      {
         ENABLE
         do
         {
            npACB->OSMFlags &= ~ACBOF_WAITSTATE;
            switch ( npACB->OSMState )
            {
               case ACBOS_START_IORB:
                  StartIORB( npACB );
                  break;

               case ACBOS_ISM_COMPLETE:
                  ISMComplete( npACB );
                  break;

               case ACBOS_COMPLETE_IORB:
                  CompleteIORB( npACB );
                  break;

               case ACBOS_RESUME_COMPLETE:
                  Resume_Complete( npACB );
                  break;

               case ACBOS_SUSPEND_COMPLETE:
                  Suspend_Complete( npACB );
                  break;

               default:
                  _asm { int 3 }
                  break;
            }

         } while ( !(npACB->OSMFlags & ACBOF_WAITSTATE) );

         DISABLE

      } while ( --npACB->OSMUseCount );

   } /* endif */
   ENABLE
}

/* ͻ
                                  
                                  
                                  
*/
VOID NEAR StartIORB ( NPACB npACB )
{
   NPUCB   npUCB;
   PIORB   pIORB     = npACB->pIORB;
   USHORT  CmdError  = 0;
   USHORT  Command   = 0;
   USHORT  Modifier  = 0;

   if (pIORB)
   {
      Command    = pIORB->CommandCode;
      Modifier   = pIORB->CommandModifier;

      npACB->IORBError  = 0;
      npACB->TimerFlags = 0;
      npUCB             = (NPUCB) pIORB->UnitHandle;
      if (!npUCB) {
         _asm INT 3
      }
      npACB->npUCB      = npUCB;
      npACB->UnitId     = npACB->npUCB->UnitId;
      npACB->ISMFlags   = 0;

      switch ( Command )
      {
         case IOCC_CONFIGURATION:

            switch ( Modifier )
            {
               case IOCM_GET_DEVICE_TABLE:
                  GetDeviceTable( npACB );
                  break;

               case IOCM_COMPLETE_INIT:
                  ATAPICompleteInit( npACB );                       /*@V151168*/
                  break;

               default:
                  CmdError = 1;
            }
            break;

         case IOCC_UNIT_CONTROL:
            switch ( Modifier )
            {
               case IOCM_ALLOCATE_UNIT:
                  AllocateUnit( npACB );
                  break;

               case IOCM_DEALLOCATE_UNIT:
                  DeallocateUnit( npACB );
                  break;

               case IOCM_CHANGE_UNITINFO:
                  ChangeUnitInfo( npACB );
                  break;

               default:
                  CmdError = 1;
            }
            break;

         case IOCC_GEOMETRY:
            switch ( Modifier )
            {
               case IOCM_GET_MEDIA_GEOMETRY:
                  GetMediaGeometry( npACB );
                  break;

               case IOCM_SET_MEDIA_GEOMETRY:
                  SetMediaGeometry( npACB );
                  break;

               case IOCM_GET_DEVICE_GEOMETRY:
                  GetDeviceGeometry( npACB );
                  break;

               case IOCM_SET_LOGICAL_GEOMETRY:    /*Ŀ
                  SetLogicalGeometry( npACB );     Command Not Supported 
                  break;                          */

               default:
                  CmdError = 1;
            }
            break;

         case IOCC_EXECUTE_IO:
            switch ( Modifier )
            {
               case IOCM_READ:
               case IOCM_WRITE:
               case IOCM_READ_VERIFY:
               case IOCM_WRITE_VERIFY:                               /*V190376*/
                  ValidateAndSend( npACB, Modifier );
                  break;

               case IOCM_READ_PREFETCH:
               default:
                  CmdError = 1;
            }
            break;

         case IOCC_FORMAT:
            switch ( Modifier )
            {
               case IOCM_FORMAT_TRACK:
                  Format_Track( npACB );                             /*V189595*/
                  break;

               case IOCM_FORMAT_MEDIA:            /*Ŀ
               case IOCM_FORMAT_PROGRESS:          Commands Not Supported 
                  Format_NOT( npACB );            */
                  break;

               default:
                  CmdError = 1;
            }
            break;

         case IOCC_UNIT_STATUS:
            switch ( Modifier )
            {
               case IOCM_GET_UNIT_STATUS:
                  UnitStatusMediaSense( npACB, Modifier );
                  break;

               case IOCM_GET_CHANGELINE_STATE:    /*Ŀ
                  GetChangeLineState( npACB );     Command Not Supported 
                  break;                          */

               case IOCM_GET_LOCK_STATUS:
                  GetLockStatus( npACB );
                  break;

               case IOCM_GET_MEDIA_SENSE:
                  UnitStatusMediaSense( npACB, Modifier );
                  break;

               default:
                  CmdError = 1;
            }
            break;

         case IOCC_DEVICE_CONTROL:
            switch ( Modifier )
            {
               case IOCM_ABORT:
               case IOCM_RESET:
               case IOCM_SUSPEND:
               case IOCM_RESUME:
               case IOCM_GET_QUEUE_STATUS:
                  JustGo2CompleteIORB( npACB );
                  break;

               case IOCM_LOCK_MEDIA:
               case IOCM_UNLOCK_MEDIA:
               case IOCM_EJECT_MEDIA:
                  ValidateAndSend( npACB, (Modifier + LOCKUNLOCKEJECT) );
                  break;

               default:
                  CmdError = 1;
            }
            break;

         case IOCC_ADAPTER_PASSTHRU:
            switch ( Modifier )
            {
               case IOCM_EXECUTE_ATA:           /* Continue on to Execute CDB */
                  /*--------------*/
                  /* ATA Commands */
                  /*--------------*/

                  npACB->ISMFlags |= ACBIF_ATA_OPERATION;

               case IOCM_EXECUTE_CDB:
                  Execute_CDB( npACB );
                  break;
                                            /*Ŀ
               case IOCM_EXECUTE_SCB:        Command Not Supported 
                                            */
               default:
                  CmdError = 1;
            }
            break;

         default:
            CmdError = 1;
      }

      if ( CmdError )
      {
         SetCmdError( npACB );
      }

   } else {
                                      /* How did we get here? */
      _asm { int 3 }
      npACB->OSMFlags |= ACBOF_WAITSTATE;
   }
}

/*ͻ
                                  
 ISMComplete()                    
                                  
*/
VOID NEAR ISMComplete ( NPACB npACB )
{
   UCHAR                    Element;
   PSCSI_STATUS_BLOCK       pSCSISB;
   PIORBH                   pIORB;
   UCHAR                    ASC;
   NPUCB                    npUCB = npACB->npUCB;

   pIORB = npACB->pIORB;

   npACB->OSMFlags &= ~ACBOF_WAITSTATE;

   /*ͻ
    Is a Test Unit Ready in Progress ?       
   */
   if( npACB->OSMReqFlags & ACBR_TEST_UNIT_RDY )
   {
      if( npACB->OSMFlags & ACBOF_SENSE_DATA_ACTIVE )
      {
         npACB->OSMFlags    &= ~ACBOF_SENSE_DATA_ACTIVE;
         npACB->OSMReqFlags &= ~ACBR_SENSE_DATA;

         ProcessTURSense( npACB );
      }
      else if( npACB->OSMReqFlags & ACBR_SENSE_DATA )
      {
         SetupAndExecute( npACB, SAE_REQUESTSENSE );

      } else {                                                    /* SUCCESS */

         npUCB->MediaStatus &= ~(MF_MC | MF_NOMED);
         npACB->OSMState     = ACBOS_START_IORB;
      }
   }
   /*ͻ
    is an internal request sense in progress 
   */
   else if ( npACB->OSMFlags & ACBOF_SENSE_DATA_ACTIVE )
   {
      npACB->OSMFlags    &= ~ACBOF_SENSE_DATA_ACTIVE;
      npACB->OSMReqFlags &= ~ACBR_SENSE_DATA;

      /*---------------------------------------------------------*/
      /* if we are putting the sense data in the users buffer,   */
      /* make a copy so it can be examined with the debugger     */
      /*---------------------------------------------------------*/
      if ( npACB->pIORB->RequestControl & IORB_REQ_STATUSBLOCK )
      {
         pSCSISB = MAKEP(SELECTOROF(npACB->pIORB),
                                          (NPBYTE) npACB->pIORB->pStatusBlock);
         switch( WhichnpACB( npACB ) )                               /*V189445*/
         {
            case 0:
               memcopy( (PBYTE) &SenseDataBuf,
                          MAKEP( SELECTOROF( pSCSISB ),
                                   OFFSETOF( pSCSISB->SenseData) ),
                                   SENSE_DATA_BYTES );
               break;
            case 1:
               memcopy( (PBYTE) &SenseDataBuf1,
                          MAKEP( SELECTOROF( pSCSISB ),
                                   OFFSETOF( pSCSISB->SenseData) ),
                                   SENSE_DATA_BYTES );
               break;
            case 2:
               memcopy( (PBYTE) &SenseDataBuf2,
                          MAKEP( SELECTOROF( pSCSISB ),
                                   OFFSETOF( pSCSISB->SenseData) ),
                                   SENSE_DATA_BYTES );
               break;
            case 3:
            default:
               memcopy( (PBYTE) &SenseDataBuf3,
                          MAKEP( SELECTOROF( pSCSISB ),
                                   OFFSETOF( pSCSISB->SenseData) ),
                                   SENSE_DATA_BYTES );
               break;
         }
      }

     /*ͻ
      pass sense data back to caller if requested 
     */
      if ( !(npACB->OSMReqFlags & ACBR_RESET))
      {
         pSCSISB = MAKEP(SELECTOROF(npACB->pIORB),
                                          (NPBYTE) npACB->pIORB->pStatusBlock);

         if ( npACB->pIORB->pStatusBlock)                           /*@VXXXXXX*/
         {                                                          /*@VXXXXXX*/
            if ( npACB->pIORB->RequestControl & IORB_REQ_STATUSBLOCK )
               pSCSISB->Flags |= STATUS_SENSEDATA_VALID;

            npACB->pIORB->Status    |=  IORB_STATUSBLOCK_AVAIL;     /*@VXXXXXX*/

            ASC = pSCSISB->SenseData->AddSenseCode;

         } else {

            switch( WhichnpACB( npACB ) )                            /*V189445*/
            {
               case 0:
                  ASC = SenseDataBuf[12];
                  break;
               case 1:
                  ASC = SenseDataBuf1[12];
                  break;
               case 2:
                  ASC = SenseDataBuf2[12];
                  break;
               case 3:
               default:
                  ASC = SenseDataBuf3[12];
                  break;
            }
         }

         ProcessSenseData( npACB, ASC );
      }
   }

   /*ͻ
    Is this an internal Identify request (GetMediaGeometry) 
   */
   else if( npACB->OSMFlags & ACBOF_IDENTIFY_ACTIVE )
   {
      ProcessIdentify( npACB );
   }

   /*ͻ
        was a reset request successful          
   */
   else if ( npACB->OSMFlags & ACBOF_RESET_ACTIVE )
   {
      npACB->npUCB->ReqFlags &= ~UCBR_RESET;                  /* Clear Flags */
      npACB->ISMFlags        &= ~ACBIF_ATA_OPERATION;
      npACB->OSMFlags        &= ~ACBOF_RESET_ACTIVE;

      if ( BSYWAIT(npACB) )                               /* successful reset */
      {
         npACB->OSMReqFlags &= ~ACBR_RESET;
         npACB->OSMState     = ACBOS_START_IORB;
         npACB->IORBStatus   = 0;
         npACB->IORBError    = 0;

      } else {

         npACB->OSMState = ACBOS_ISM_COMPLETE;
      }
   }

   /*ͻ
        was there a request for a reset ?       
   */
   else if ( npACB->OSMReqFlags & ACBR_RESET )
   {
      cResets++;
      npACB->cResetRequests++;

      /*ͻ
       if over the reset limit, return error 
      */
      if ( npACB->cResetRequests > MAXRESETS )
      {
         npACB->IORBError  = IOERR_DEVICE_NONSPECIFIC;

         npACB->OSMReqFlags &= ~ACBR_RESET;
         npACB->OSMState     = ACBOS_COMPLETE_IORB;

      } else {

         /*ͻ
            Issue Reset request      
         */
         SetupAndExecute( npACB, SAE_RESET );
      }
   }

   /*ͻ
    was there a request for sense data  
   */
   else if ( npACB->OSMReqFlags & ACBR_SENSE_DATA )
   {
      SetupAndExecute( npACB, SAE_REQUESTSENSE );

   } else {

      npACB->OSMState  = ACBOS_COMPLETE_IORB;
   }
}

/*ͻ
                                  
                                  
*/
VOID NEAR CompleteIORB ( NPACB npACB )
{
   PIORB    pIORB;
   USHORT   ErrorCode = 0;
   NPUCB    npUCB;

   pIORB     = npACB->pIORB;
   npUCB     = npACB->npUCB;
   ErrorCode = npACB->IORBError;

   if ( npACB->TimerFlags ) {
      ErrorCode = IOERR_UNIT_NOT_READY;
   }

   if ( ErrorCode ) {
      pIORB->ErrorCode  = ErrorCode;
      pIORB->Status    |= IORB_ERROR;
   }

   /*ͻ
         Mark it DONE       
   */
   pIORB->Status |= IORB_DONE;

   npACB->pIORB = 0;

   if ( pIORB->RequestControl & IORB_ASYNC_POST )
   {
      if (( npACB->npUCB->Capabilities & UCBC_SPEC_REV_17B)     &&
          ( npACB->npCmdIO->ATAPIPkt[0] == SCSI_MODE_SENSE_10 ) &&
          (( npACB->npCmdIO->ATAPIPkt[2] & REV_17B_PAGE_CODE_MASK)
                                   == REV_17B_PAGE_CAPABILITIES))
      {
         Convert_17B_to_ATAPI( npACB->npCmdIO->IOSGPtrs.pSGList->ppXferBuf );
      }

      (*pIORB->NotifyAddress)(pIORB);
   }

   DISABLE

   if (( npACB->ResourceFlags & ACBRF_SHARED     ) &&
       ( npACB->ResourceFlags & ACBRF_CURR_OWNER ) )
   {
      if ( npACB->pHeadIORB )                             /* more stuff to do */
      {
         if ( QueryOtherAdd( npACB ) )        /* other add has stuff in queue */
         {
            npACB->OSMState       = ACBOS_RESUME_COMPLETE;
            npACB->OSMFlags      |= ACBOF_WAITSTATE;
            npACB->ResourceFlags &= ~ACBRF_CURR_OWNER;
            ENABLE
            SuspendResumeOtherAdd( npACB, IOCM_RESUME );

         } else {                                /* other add has empty queue */

            npACB->OSMState = ACBOS_START_IORB;

            if ( NextIORB( npACB ) ) {
               _asm int 3                    /* we said above we had stuff to */
            }                                /* do and now we don't ? */
         }
      } else {                               /* no more work to do */

         npACB->OSMState       = ACBOS_RESUME_COMPLETE;
         npACB->OSMFlags      |= ACBOF_WAITSTATE;
         npACB->ResourceFlags &= ~ACBRF_CURR_OWNER;                  /*V@93531*/
         ENABLE
         SuspendResumeOtherAdd( npACB, IOCM_RESUME );
      }
   } else {

      npACB->OSMState = ACBOS_START_IORB;

      if ( NextIORB( npACB ) )                      /* DISABLE is in NextIORB */
      {
         npACB->OSMFlags |= ACBOF_WAITSTATE;
         npACB->OSMFlags &= ~ACBOF_SM_ACTIVE;
      }
   }
   ENABLE
}

/*ͻ
                                  
 ProcessTURSense()                
*/
VOID  NEAR ProcessTURSense( NPACB npACB )
{
   UCHAR ASC;

   npACB->OSMState = ACBOS_START_IORB;
                                                 /* ASC Additional Sense Code */
   switch( WhichnpACB( npACB ) )                                /*V189445*/
   {
      case 0:
         ASC = SenseDataBuf[12];
         break;
      case 1:
         ASC = SenseDataBuf1[12];
         break;
      case 2:
         ASC = SenseDataBuf2[12];
         break;
      case 3:
      default:
         ASC = SenseDataBuf3[12];
         break;
   }

   if( SetMediaFlags( npACB, ASC ))
   {
      npACB->OSMReqFlags &= ~ACBR_TEST_UNIT_RDY;     /* Turn off TUR on Error */
      SetIORBError( npACB, ASC );
   }
}

/*ͻ
                                  
 ProcessSenseData()               
*/
VOID  NEAR ProcessSenseData( NPACB npACB, UCHAR ASC )
{
   SetMediaFlags( npACB, ASC );

   SetIORBError(  npACB, ASC );
}

/*ͻ
                                  
                                  
*/
UCHAR  NEAR SetMediaFlags( NPACB npACB, UCHAR ASC )
{
   NPUCB   npUCB     = npACB->npUCB;
   UCHAR   realerror = 0;

   switch( ASC )
   {
   case ASC_MEDIUM_NOT_PRESENT:
      npUCB->MediaStatus &= ~MF_MC;
      npUCB->MediaStatus |= MF_NOMED;
      break;

   case ASC_MEDIA_CHANGED:
      npUCB->MediaStatus &= ~MF_NOMED;
      npUCB->MediaStatus |= MF_MC;
      break;

   case ASC_WRITE_PROTECTED_MEDIA:
      npUCB->MediaStatus |= MF_WRT_PT;
      break;

   default:
      realerror = 1;
      break;
   }
   return( realerror );
}

/*ͻ
                                  
                                  
*/
VOID  NEAR SetIORBError( NPACB npACB, UCHAR ASC )
{
   if ( ASC > MaxAddSenseDataEntry )
   {
      npACB->IORBError = IOERR_ADAPTER_REFER_TO_STATUS;

   } else {

      npACB->IORBError = AddSenseDataMap[ASC];
   }

   npACB->OSMState = ACBOS_COMPLETE_IORB;
}

/* ͻ
                                  
                                  
                                  
*/
VOID NEAR Resume_Complete( NPACB npACB )
{
   DISABLE
   npACB->suspended = 1;

   npACB->OSMFlags |= ACBOF_WAITSTATE;

   if ( NextIORB( npACB) )
   {
      npACB->OSMState  = ACBOS_START_IORB;
      npACB->OSMFlags &= ~ACBOF_SM_ACTIVE;

   } else {

      npACB->OSMState  = ACBOS_SUSPEND_COMPLETE;
      ENABLE

      SuspendResumeOtherAdd( npACB, IOCM_SUSPEND );
   }
}

/* ͻ
                                  
                                  
                                  
*/
VOID NEAR Suspend_Complete( NPACB npACB )
{
   DISABLE
     npACB->suspended      = 0;
     npACB->OSMState       = ACBOS_START_IORB;
     npACB->OSMFlags      &= ~ACBOF_WAITSTATE;                 /*V@93531*/
     npACB->ResourceFlags |= ACBRF_CURR_OWNER;                 /*V@93531*/
   ENABLE
}

/* ͻ
                                  
                                  
                                  
*/
USHORT FAR NextIORB( NPACB npACB )
{
   DISABLE
   if ( npACB->pIORB = npACB->pHeadIORB ) {

      if ( !(npACB->pHeadIORB = npACB->pIORB->pNxtIORB) ) {

         npACB->pFootIORB = 0;
      }
   }

   return( (npACB->pIORB) ? 0 : 1);
}

/*ͻ
                        IOCC_CONFIGUARTION Functions                          
ͼ
ͻ
                                  
                                  
                                  
 */
VOID NEAR GetDeviceTable( NPACB npACB )
{
   PIORB_CONFIGURATION pIORB = (PIORB_CONFIGURATION) npACB->pIORB;

   USHORT        RequiredLength;
   PDEVICETABLE  pDT;

   RequiredLength = sizeof( DEVICETABLE );

   if ( pIORB->DeviceTableLen < RequiredLength )
   {
      npACB->IORBError = IOERR_CMD_SYNTAX;

   } else {

      pDT = pIORB->pDeviceTable;

      pDT->ADDLevelMajor = ADD_LEVEL_MAJOR;
      pDT->ADDLevelMinor = ADD_LEVEL_MINOR;
      pDT->ADDHandle     = ADDHandle;
      pDT->TotalAdapters = 0;
   }

   npACB->OSMState = ACBOS_COMPLETE_IORB;
}

/*ͻ
                        IOCC_UNIT_CONTROL Functions                           
ͼ
ͻ
                                  
                                  
*/
VOID NEAR AllocateUnit( NPACB npACB )                                /*V190566*/
{
   USHORT              UnitHandle;
   NPUCB               npUCB;

   npUCB = npACB->npUCB;

   UnitHandle   = npUCB->ADDUnitHandle;               /* ADD Handle */

   if( AllocDeallocChangeUnit( NULL, UnitHandle, IOCM_ALLOCATE_UNIT,
                                                     npUCB->AdapterDriverEP ) )
   {
      npACB->IORBError = IOERR_UNIT_ALLOCATED;
   }

   npACB->OSMState = ACBOS_COMPLETE_IORB;
}

/*ͻ
                                  
                                  
*/
VOID NEAR DeallocateUnit( NPACB npACB )                              /*V190566*/
{
   USHORT              UnitHandle;
   NPUCB               npUCB = npACB->npUCB;

   UnitHandle   = npUCB->ADDUnitHandle;               /* ADD Handle */

   if( AllocDeallocChangeUnit( NULL, UnitHandle, IOCM_DEALLOCATE_UNIT,
                                                      npUCB->AdapterDriverEP ))
   {
      npACB->IORBError = IOERR_UNIT_NOT_ALLOCATED;
   }

   npACB->OSMState = ACBOS_COMPLETE_IORB;
}

/*ͻ
                                  
                                  
*/
VOID NEAR ChangeUnitInfo( NPACB npACB )                              /*V190566*/
{
   PIORB_UNIT_CONTROL  pIORB;
   USHORT              UnitHandle;
   PUNITINFO           pUI;
   NPUCB               npUCB = npACB->npUCB;

   pIORB = (PIORB_UNIT_CONTROL) npACB->pIORB;

   pUI = pIORB->pUnitInfo;

   UnitHandle   = npUCB->ADDUnitHandle;              /* ADD Handle */

   AllocDeallocChangeUnit( pUI, UnitHandle, IOCM_CHANGE_UNITINFO, npUCB->AdapterDriverEP);

   npACB->OSMState = ACBOS_COMPLETE_IORB;
}

/*ͻ
                                  
                                  
*/
VOID NEAR GetChangeLineState( NPACB npACB )
{
   SetCmdError( npACB );
}

/*ͻ
                                  
                                  
*/
VOID NEAR GetLockStatus( NPACB npACB )
{
   PIORB_UNIT_STATUS   pIORB = (PIORB_UNIT_STATUS) npACB->pIORB;

   pIORB->UnitStatus = 0x03;   /* Eject, Lock, Unlock supported, *//* @V191681*/
                               /* but no lock status             */
   npACB->OSMState   = ACBOS_COMPLETE_IORB;
}

/*ͻ
                          IOCC_GEOMETRY Functions                             
*/
/*ͻ
                                  
                                  
 GetMediaGeometry()               
*/
VOID NEAR GetMediaGeometry( NPACB npACB )
{
   /*Ŀ
    Issue Test Unit Ready on the very first access  
    to the unit or if required by the device        
   */
   if((  npACB->npUCB->DrvDefFlags & DDF_TESTUNITRDY_REQ )  ||
      (!(npACB->npUCB->DrvDefFlags & DDF_1ST_TUR_4_GMG   ))    )
   {
      if( !( npACB->OSMReqFlags & ACBR_TEST_UNIT_RDY ))
      {
         SetupAndExecute( npACB, SAE_TESTUNITREADY );
         return;
      }
      npACB->npUCB->DrvDefFlags |=  DDF_1ST_TUR_4_GMG;
      npACB->OSMReqFlags        &= ~ACBR_TEST_UNIT_RDY;
   }
   /*Ŀ
    Issue Identify Data or NON_Sense for ZIP250 
   */
   if( npACB->npUCB->DriveDef == UCBD_ZIP250 )
   {
      SetupAndExecute( npACB, SAE_INTERNAL_NON_SENSE );           
   } else {
      SetupAndExecute( npACB, SAE_INTERNAL_IDENTIFY );
   }
}

/*ͻ
                                  
                                  
 GetDeviceGeometry()              
*/
VOID NEAR GetDeviceGeometry( NPACB npACB )
{
   PIORB       pIORB = npACB->pIORB;
   GEOMETRY    DevGEO;

   /*Ŀ
    Get Geometry based on Drive defintion 
   */
   GetDefinedDeviceGEO( npACB, (PGEOMETRY) &DevGEO );

   /*Ŀ
    Return the Geometry in the IORB       
   */
   *((PIORB_GEOMETRY) pIORB)->pGeometry = DevGEO;

   npACB->OSMState = ACBOS_COMPLETE_IORB;
}

/* ͻ
                                  
                                  
*/
VOID NEAR SetMediaGeometry( NPACB npACB )
{
   PIORB_GEOMETRY  pIORB = (PIORB_GEOMETRY)npACB->pIORB;
   PGEOMETRY       pGEO  = pIORB->pGeometry;

   npACB->OSMState = ACBOS_COMPLETE_IORB;
}

/* ͻ
                                  
                                  
*/
VOID NEAR SetLogicalGeometry( NPACB npACB )
{
   SetCmdError( npACB );
}

/*ͻ
                         IOCC_EXECUTE_IO Functions                            
*/
/*ͻ
                                  
                                  
                                  
*/
VOID NEAR ValidateAndSend( NPACB npACB, USHORT command )
{
   /*Ŀ
    Issue Test Unit Ready if reqired for the device 
   */
   if( npACB->npUCB->DrvDefFlags & DDF_TESTUNITRDY_REQ )
   {
      if( !( npACB->OSMReqFlags & ACBR_TEST_UNIT_RDY ))
      {
         SetupAndExecute( npACB, SAE_TESTUNITREADY );
         return;
      }
      npACB->OSMReqFlags &= ~ACBR_TEST_UNIT_RDY;
   }

   /*Ŀ
    Check Media in the drive      
   */
   if( MediaInvalid4Drive( npACB )) {
      return;
   }

   switch ( command )
   {
   case IOCM_READ:
      SetupAndExecute( npACB, SAE_READ );
      break;

   case IOCM_READ_VERIFY:
      SetupAndExecute( npACB, SAE_READ_VERIFY );
      break;

   case IOCM_WRITE:
      SetupAndExecute( npACB, SAE_WRITE );
      break;

   case IOCM_WRITE_VERIFY:                                           /*V190376*/
      SetupAndExecute( npACB, SAE_WRITE_VERIFY );
      break;

   case ( IOCM_LOCK_MEDIA + LOCKUNLOCKEJECT ):                       /*V190376*/
      SetupAndExecute( npACB, SAE_LOCK_MEDIA );
      break;

   case ( IOCM_UNLOCK_MEDIA + LOCKUNLOCKEJECT ):                     /*V190376*/
      SetupAndExecute( npACB, SAE_UNLOCK_MEDIA );
      break;

   case ( IOCM_EJECT_MEDIA + LOCKUNLOCKEJECT ):                      /*V190376*/
      SetupAndExecute( npACB, SAE_EJECT_MEDIA );
      break;

   default:
      SetCmdError( npACB );
   }
}

/*ͻ
                         IOCC_FORMAT Functions                                
*/
/* ͻ
                                  
                                  
*/
VOID NEAR Format_Track( NPACB npACB )                                /*V189595*/
{
   SetupAndExecute( npACB, SAE_FORMAT_TRACK );
}

/* ͻ
                                  
                                  
*/
VOID NEAR Format_NOT( NPACB npACB )
{
   SetCmdError( npACB );
}

/*ͻ
                        IOCC_UNIT_STATUS Functions                            
*/
/*ͻ
                                  
                                  
*/
VOID NEAR UnitStatusMediaSense( NPACB npACB, USHORT command )
{
   PIORB_UNIT_STATUS  pIORB = (PIORB_UNIT_STATUS) npACB->pIORB;
   NPUCB              npUCB = npACB->npUCB;
   USHORT             mediatype;

   pIORB->UnitStatus = 0;            /* US_MEDIA_UNKNOWN = 0 */

   /*Ŀ
    Issue Test Unit Ready 
   */
   if( !( npACB->OSMReqFlags & ACBR_TEST_UNIT_RDY ))
   {
      SetupAndExecute( npACB, SAE_TESTUNITREADY );
      return;
   }

   npACB->OSMReqFlags &= ~ACBR_TEST_UNIT_RDY;

   /*Ŀ
    If Media Changed, then we should return the error 
   */
   if( npUCB->MediaStatus & MF_MC )
   {
      npACB->IORBError = IOERR_MEDIA_CHANGED;
   }
   /*Ŀ
    Media is NOT present in unit 
   */
   else if( npUCB->MediaStatus & MF_NOMED )
   {
      if( command == IOCM_GET_MEDIA_SENSE ) {
         npACB->IORBError = IOERR_MEDIA_NOT_PRESENT;
      }

   } else {
      /*Ŀ
       Media is Present in the Drive
      */
      if( command == IOCM_GET_MEDIA_SENSE )
      {
         mediatype = (npUCB->MediaType & 0x30);
                                                                     /*V190435*/
         if( mediatype == UHD_MEDIUM )
         {
            pIORB->UnitStatus = US_MEDIA_LARGE_FLOPPY;         /* > 2.88 MB */
         }
         else if( mediatype == HD_MEDIUM )
         {
            pIORB->UnitStatus = US_MEDIA_144MB;                /* 144 MB */
         }
         else if( mediatype == DD_MEDIUM )
         {
            pIORB->UnitStatus = US_MEDIA_720KB;                /* 720 KB */
         }

      } else {

         /*Ŀ
          Media is present in the drive = US_READY  
         */
         pIORB->UnitStatus = ( US_READY | US_POWER );
      }
   }

   npACB->OSMState = ACBOS_COMPLETE_IORB;
}

/*ͻ
                       IOCC_DEVICE_CONTROL Functions                          
*/
/*ͻ
                                  
                                  
*/
VOID NEAR JustGo2CompleteIORB( NPACB npACB )
{
   npACB->OSMState = ACBOS_COMPLETE_IORB;
}

/*ͻ
                      IOCC_ADAPTER_PASSTHRU Functions                         
*/
/*ͻ
                                  
                                  
*/
VOID NEAR Execute_CDB ( NPACB npACB)
{
   SetupAndExecute( npACB, SAE_EXECUTE_CDB );
}

/*ͻ
                      Other Routines                                          
*/
/*ͻ
                                  
 MediaInvalid4Drive()             
*/
USHORT NEAR MediaInvalid4Drive( NPACB npACB )
{
   NPUCB     npUCB = npACB->npUCB;
   USHORT    MediaValidity;
   USHORT    Element;
   USHORT    ErrorCode;
   GEOMETRY  Current;
   GEOMETRY  DriveCap;                              /* Logical Drive */

   MediaValidity = MV_INVALID;
   ErrorCode     = IOERR_UNIT_NOT_READY;

   /*Ŀ
    If Media Changed, then let them know  
   */
   if( npUCB->MediaStatus & MF_MC )
   {
      ErrorCode = IOERR_MEDIA_CHANGED;
   }

   /*Ŀ
    If No medium, then we should attempt the request  
   */
   else if( npUCB->MediaStatus & MF_NOMED )
   {
      MediaValidity = MV_VALID;

   } else {

      /*Ŀ
       If NO Validity required, current Media is VALID 
      */
      if( !(npACB->npUCB->DrvDefFlags & DDF_VALIDITY_REQ) )
      {
         MediaValidity = MV_VALID;

      } else {

         /*Ŀ
          Validity is Required, so ck Current vs DriveDef 
         */
         /*Ŀ
          Get Drive Definition  
         */
         GetDefinedDeviceGEO( npACB, (PGEOMETRY) &DriveCap );

         /*Ŀ
           Get Current Media  
         */
         Current = npUCB->MediaGEO;

         /*Ŀ
          Check Media is same as device capability
         */
         if( (Current.TotalCylinders  == DriveCap.TotalCylinders ) &&
             (Current.NumHeads        == DriveCap.NumHeads       ) &&
             (Current.SectorsPerTrack == DriveCap.SectorsPerTrack) &&
             (Current.BytesPerSector  == DriveCap.BytesPerSector )    )
         {
            MediaValidity = MV_VALID;

         } else {

            /*Ŀ
             Check other LOWER valid Media for the drive 
             ie: 720kb media in a 1.44mb drive           
            */
            Element = (UCBD_DD * 4);
            if( ( npUCB->DriveDef         == UCBD_HD ) &&
                ( Current.TotalCylinders  == DriveMediaType[ Element ]     ) &&
                ( Current.NumHeads        == DriveMediaType[ Element + 1 ] ) &&
                ( Current.SectorsPerTrack == DriveMediaType[ Element + 2 ] ) &&
                ( Current.BytesPerSector  == DriveMediaType[ Element + 3 ] )    )
            {
               MediaValidity = MV_VALID;
            }
         }
      }
   }

   if( MediaValidity == MV_INVALID )
   {
      npACB->IORBError = ErrorCode;
      npACB->OSMState  = ACBOS_COMPLETE_IORB;
   }

   return( MediaValidity );
}

/*ͻ
                                  
 SetupAndExecute()                
*/
VOID NEAR  SetupAndExecute( NPACB npACB, USHORT command )
{
   ULONG                  ppExternalSenseDataBuf;
   PSCSI_STATUS_BLOCK     pSCSISB;
   PIORB_EXECUTEIO        pIORB = (PIORB_EXECUTEIO) npACB->pIORB;
   PIORB_ADAPTER_PASSTHRU pIORB_PT;
   PIORB_FORMAT           pIORB_FMT;
   PFORMAT_CMD_TRACK      pFMT;
   USHORT                 mediatype;
   CHS_ADDR               CHSAddr;
   ULONG                  cXferBytes  = 0;                            /*V190040*/
   PSCATGATENTRY          pTempSGList = pIORB->pSGList;
   USHORT                 i;
   UCHAR                  byteswap;

   /*Ŀ
    Clear SG Pointer Entries              
   */
   setmem ( (PBYTE) &npACB->npCmdIO->IOSGPtrs, 0, sizeof (ADD_XFER_IO) );

   /*Ŀ
    Clear the ATAPI PacKet                
   */
   for( i=0; i < MAX_ATAPI_PKT_SIZE; i++ ) {
      npACB->npCmdIO->ATAPIPkt[i] = 0;
   }

   /*Ŀ
    Clear bytes counts for transfers      
   */
   npACB->npCmdIO->cXferBytesRemain   = 0;
   npACB->npCmdIO->cXferBytesComplete = 0;

   switch( command )
   {
      case SAE_TESTUNITREADY:
         npACB->npCmdIO->ATAPIPkt[0]  = FXP_TESTUNIT_READY;
         npACB->OSMReqFlags          |= ACBR_TEST_UNIT_RDY;
         break;

      case SAE_INTERNAL_NON_SENSE:
         /*Ŀ
          Note: we are setting npCmdIO to InternalCmd 
         */
         npACB->npCmdIO = &npACB->InternalCmd;

         npACB->npCmdIO->cXferBytesRemain = NONSENSE_DATA_BYTES;

         npACB->npCmdIO->IOSGPtrs.Mode          = PORT_TO_SGLIST;
         npACB->npCmdIO->IOSGPtrs.cSGList       = 1;
         npACB->npCmdIO->IOSGPtrs.iPortAddress  = npACB->IOPorts[FI_PDATA];
         npACB->npCmdIO->IOSGPtrs.iSGList       = 0;
         npACB->npCmdIO->IOSGPtrs.SGOffset      = 0;
         npACB->npCmdIO->IOSGPtrs.iSGListStart  = 0;
         npACB->npCmdIO->IOSGPtrs.SGOffsetStart = 0;

         switch( WhichnpACB( npACB ) )
         {
            case 0:
               NonSenseDataSGList.ppXferBuf     = ppNonSenseDataBuf;
               NonSenseDataSGList.XferBufLen    = NONSENSE_DATA_BYTES;
               npACB->npCmdIO->IOSGPtrs.pSGList = &NonSenseDataSGList;
               break;
            case 1:
               NonSenseDataSGList1.ppXferBuf    = ppNonSenseDataBuf1;
               NonSenseDataSGList1.XferBufLen   = NONSENSE_DATA_BYTES;
               npACB->npCmdIO->IOSGPtrs.pSGList = &NonSenseDataSGList1;
               break;
            case 2:
               NonSenseDataSGList2.ppXferBuf    = ppNonSenseDataBuf2;
               NonSenseDataSGList2.XferBufLen   = NONSENSE_DATA_BYTES;
               npACB->npCmdIO->IOSGPtrs.pSGList = &NonSenseDataSGList2;
               break;
            case 3:
            default:
               NonSenseDataSGList3.ppXferBuf    = ppNonSenseDataBuf3;
               NonSenseDataSGList3.XferBufLen   = NONSENSE_DATA_BYTES;
               npACB->npCmdIO->IOSGPtrs.pSGList = &NonSenseDataSGList3;
               break;
         }

         for ( i=0; i < MAX_ATAPI_PKT_SIZE; i++ ) {
            npACB->npCmdIO->ATAPIPkt[i] = 0;
         }
         npACB->npCmdIO->ATAPIPkt[0] = FXP_NON_SENSE;
         npACB->npCmdIO->ATAPIPkt[2] = 0x01;               /* Format Data */
         npACB->npCmdIO->ATAPIPkt[4] = 88;
         npACB->OSMFlags             |= ACBOF_IDENTIFY_ACTIVE;
         break;

      case SAE_INTERNAL_IDENTIFY:

         switch( WhichnpACB( npACB ) )                               /*V189445*/
         {
            case 0:
               IDDataSGList.ppXferBuf           = ppIdentDataBuf;
               npACB->npCmdIO->IOSGPtrs.pSGList = &IDDataSGList;
               break;
            case 1:
               IDDataSGList.ppXferBuf           = ppIdentDataBuf1;
               npACB->npCmdIO->IOSGPtrs.pSGList = &IDDataSGList1;
               break;
            case 2:
               IDDataSGList.ppXferBuf           = ppIdentDataBuf2;
               npACB->npCmdIO->IOSGPtrs.pSGList = &IDDataSGList2;
               break;
            case 3:
            default:
               IDDataSGList.ppXferBuf           = ppIdentDataBuf3;
               npACB->npCmdIO->IOSGPtrs.pSGList = &IDDataSGList3;
               break;
         }

         npACB->npCmdIO->cXferBytesRemain = IDENTIFY_DATA_BYTES;

         npACB->npCmdIO->IOSGPtrs.Mode         = PORT_TO_SGLIST;
         npACB->npCmdIO->IOSGPtrs.cSGList      = 1;
         npACB->npCmdIO->IOSGPtrs.iPortAddress = npACB->IOPorts[FI_PDATA];

         npACB->npUCB->ReqFlags |= UCBR_IDENTIFY;
         npACB->ISMFlags        |= ACBIF_ATA_OPERATION;            /* ATA CMD */
         npACB->OSMFlags        |= ACBOF_IDENTIFY_ACTIVE;
         break;

     case SAE_READ:
         npACB->npCmdIO->IOSGPtrs.Mode         = PORT_TO_SGLIST;      /*From Device*/
         npACB->npCmdIO->IOSGPtrs.cSGList      = pIORB->cSGList;
         npACB->npCmdIO->IOSGPtrs.pSGList      = pIORB->pSGList;
         npACB->npCmdIO->IOSGPtrs.iPortAddress = npACB->IOPorts[FI_PDATA];

                  npACB->npCmdIO->ATAPIPkt[0] = FXP_READ_10;       /* READ */
          (ULONG) npACB->npCmdIO->ATAPIPkt[2] = pIORB->RBA;        /* LBA */
         (USHORT) npACB->npCmdIO->ATAPIPkt[7] = pIORB->BlockCount; /* Transfer Length */

                            byteswap = npACB->npCmdIO->ATAPIPkt[7];
         npACB->npCmdIO->ATAPIPkt[7] = npACB->npCmdIO->ATAPIPkt[8];
         npACB->npCmdIO->ATAPIPkt[8] = byteswap;
                            byteswap = npACB->npCmdIO->ATAPIPkt[2];
         npACB->npCmdIO->ATAPIPkt[2] = npACB->npCmdIO->ATAPIPkt[5];
         npACB->npCmdIO->ATAPIPkt[5] = byteswap;
                            byteswap = npACB->npCmdIO->ATAPIPkt[3];
         npACB->npCmdIO->ATAPIPkt[3] = npACB->npCmdIO->ATAPIPkt[4];
         npACB->npCmdIO->ATAPIPkt[4] = byteswap;

         for ( i=0; i < pIORB->cSGList; i++, pTempSGList++) {
            cXferBytes += pTempSGList->XferBufLen;
         }
         npACB->npCmdIO->cXferBytesRemain = cXferBytes;
         break;

      case SAE_WRITE:
      case SAE_WRITE_VERIFY:
         npACB->npCmdIO->IOSGPtrs.Mode          = SGLIST_TO_PORT;
         npACB->npCmdIO->IOSGPtrs.cSGList       = pIORB->cSGList;
         npACB->npCmdIO->IOSGPtrs.pSGList       = pIORB->pSGList;
         npACB->npCmdIO->IOSGPtrs.iPortAddress  = npACB->IOPorts[FI_PDATA];

         if( command == SAE_WRITE ) {
            npACB->npCmdIO->ATAPIPkt[0] = FXP_WRITE_10;             /* WRITE  */
         } else {
            npACB->npCmdIO->ATAPIPkt[0] = FXP_WRITE_VERIFY;         /* VERIFY */
         }
          (ULONG) npACB->npCmdIO->ATAPIPkt[2] = pIORB->RBA;        /* LBA */
         (USHORT) npACB->npCmdIO->ATAPIPkt[7] = pIORB->BlockCount; /* Transfer Length */

                            byteswap = npACB->npCmdIO->ATAPIPkt[7];
         npACB->npCmdIO->ATAPIPkt[7] = npACB->npCmdIO->ATAPIPkt[8];
         npACB->npCmdIO->ATAPIPkt[8] = byteswap;
                            byteswap = npACB->npCmdIO->ATAPIPkt[2];
         npACB->npCmdIO->ATAPIPkt[2] = npACB->npCmdIO->ATAPIPkt[5];
         npACB->npCmdIO->ATAPIPkt[5] = byteswap;
                            byteswap = npACB->npCmdIO->ATAPIPkt[3];
         npACB->npCmdIO->ATAPIPkt[3] = npACB->npCmdIO->ATAPIPkt[4];
         npACB->npCmdIO->ATAPIPkt[4] = byteswap;

         for ( i=0; i < pIORB->cSGList; i++, pTempSGList++) {
            cXferBytes += pTempSGList->XferBufLen;
         }
         npACB->npCmdIO->cXferBytesRemain = cXferBytes;
         break;

      case SAE_READ_VERIFY:
         npACB->npCmdIO->ATAPIPkt[0]  = FXP_VERIFY;     /* Verify media only */
         npACB->npCmdIO->ATAPIPkt[1] &= ~BYTECHK;       /* ByteChk = 0       */

          (ULONG) npACB->npCmdIO->ATAPIPkt[2] = pIORB->RBA;        /* LBA */
         (USHORT) npACB->npCmdIO->ATAPIPkt[7] = pIORB->BlockCount; /* Verification */
                                                                   /* Length       */
                            byteswap = npACB->npCmdIO->ATAPIPkt[7];
         npACB->npCmdIO->ATAPIPkt[7] = npACB->npCmdIO->ATAPIPkt[8];
         npACB->npCmdIO->ATAPIPkt[8] = byteswap;
                            byteswap = npACB->npCmdIO->ATAPIPkt[2];
         npACB->npCmdIO->ATAPIPkt[2] = npACB->npCmdIO->ATAPIPkt[5];
         npACB->npCmdIO->ATAPIPkt[5] = byteswap;
                            byteswap = npACB->npCmdIO->ATAPIPkt[3];
         npACB->npCmdIO->ATAPIPkt[3] = npACB->npCmdIO->ATAPIPkt[4];
         npACB->npCmdIO->ATAPIPkt[4] = byteswap;
         break;

      case SAE_REQUESTSENSE:
         npACB->OSMFlags |= ACBOF_SENSE_DATA_ACTIVE;
         /*Ŀ
          Note: we are setting npCmdIO to InternalCmd 
         */
         npACB->npCmdIO = &npACB->InternalCmd;

         npACB->npCmdIO->cXferBytesRemain = SENSE_DATA_BYTES;

         switch( WhichnpACB( npACB ) )                          /*V189445*/
         {
            case 0:
               SenseDataSGList.ppXferBuf   = ppSenseDataBuf;
               SenseDataSGList.XferBufLen  = SENSE_DATA_BYTES;
               break;
            case 1:
               SenseDataSGList1.ppXferBuf  = ppSenseDataBuf1;
               SenseDataSGList1.XferBufLen = SENSE_DATA_BYTES;
               break;
            case 2:
               SenseDataSGList2.ppXferBuf  = ppSenseDataBuf2;
               SenseDataSGList2.XferBufLen = SENSE_DATA_BYTES;
               break;
            case 3:
            default:
               SenseDataSGList3.ppXferBuf  = ppSenseDataBuf3;
               SenseDataSGList3.XferBufLen = SENSE_DATA_BYTES;
               break;
         }

         if( npACB->OSMReqFlags & ACBR_TEST_UNIT_RDY )
         {
           /* Using above setup Do not return Sense Data */

         } else {

            if ( npACB->pIORB->RequestControl & IORB_REQ_STATUSBLOCK )
            {
               pSCSISB = MAKEP(SELECTOROF(npACB->pIORB),
                              (NPBYTE) npACB->pIORB->pStatusBlock);

               npACB->npCmdIO->cXferBytesRemain = pSCSISB->ReqSenseLen;
               ppExternalSenseDataBuf = VirtToPhys ( (PBYTE) pSCSISB->SenseData );

               switch( WhichnpACB( npACB ) )                         /*V189445*/
               {
                  case 0:
                     SenseDataSGList.XferBufLen  = pSCSISB->ReqSenseLen;
                     SenseDataSGList.ppXferBuf   = ppExternalSenseDataBuf;
                     break;
                  case 1:
                     SenseDataSGList1.XferBufLen = pSCSISB->ReqSenseLen;
                     SenseDataSGList1.ppXferBuf  = ppExternalSenseDataBuf;
                     break;
                  case 2:
                     SenseDataSGList2.XferBufLen = pSCSISB->ReqSenseLen;
                     SenseDataSGList2.ppXferBuf  = ppExternalSenseDataBuf;
                     break;
                  case 3:
                     SenseDataSGList3.XferBufLen = pSCSISB->ReqSenseLen;
                     SenseDataSGList3.ppXferBuf  = ppExternalSenseDataBuf;
                  default:
                     break;
               }
            }
         }
         npACB->npCmdIO->IOSGPtrs.Mode         = PORT_TO_SGLIST;
         npACB->npCmdIO->IOSGPtrs.cSGList      = 1;
         switch( WhichnpACB( npACB ) )                              /*V189445*/
         {
            case 0:
               npACB->npCmdIO->IOSGPtrs.pSGList = &SenseDataSGList;
               break;
            case 1:
               npACB->npCmdIO->IOSGPtrs.pSGList = &SenseDataSGList1;
               break;
            case 2:
               npACB->npCmdIO->IOSGPtrs.pSGList = &SenseDataSGList2;
               break;
            case 3:
            default:
               npACB->npCmdIO->IOSGPtrs.pSGList = &SenseDataSGList3;
               break;
         }
         npACB->npCmdIO->IOSGPtrs.iPortAddress = npACB->IOPorts[FI_PDATA];
         npACB->npCmdIO->IOSGPtrs.iSGList       = 0;
         npACB->npCmdIO->IOSGPtrs.SGOffset      = 0;
         npACB->npCmdIO->IOSGPtrs.iSGListStart  = 0;
         npACB->npCmdIO->IOSGPtrs.SGOffsetStart = 0;

         for ( i=0; i < MAX_ATAPI_PKT_SIZE; i++ ) {
            npACB->npCmdIO->ATAPIPkt[i] = 0;
         }
         npACB->npCmdIO->ATAPIPkt[0] = FXP_REQUEST_SENSE;
         npACB->npCmdIO->ATAPIPkt[4] = sizeof( SENSE_DATA );  /* 18  */
         break;

      case SAE_LOCK_MEDIA:                                           /* LOCK */
         npACB->npCmdIO->ATAPIPkt[4] = 0x01;  /* Prevent bit */
         /*Ŀ
          vv FALL THROUGH vv
         */
      case SAE_UNLOCK_MEDIA:                                       /* UNLOCK */
         npACB->npCmdIO->ATAPIPkt[0] = FXP_PRV_ALWMEDRMVL;
         break;

      case SAE_EJECT_MEDIA:                                         /* EJECT */
         npACB->npCmdIO->ATAPIPkt[0] = FXP_START_STOPUNIT;
         npACB->npCmdIO->ATAPIPkt[4] = EJECT_THE_MEDIA;
         break;

      case SAE_RESET:                                              /* RESET */
         npACB->OSMFlags         |= ACBOF_RESET_ACTIVE;
         npACB->npUCB->ReqFlags  |= UCBR_RESET;
         npACB->ISMFlags         |= ACBIF_ATA_OPERATION;
         break;

      case SAE_EXECUTE_CDB:
         pIORB_PT = (PIORB_ADAPTER_PASSTHRU) npACB->pIORB;
         if (pIORB_PT->ControllerCmdLen <= npACB->npUCB->CmdPacketLength )
         {
            /*Ŀ
             Fill in the atapi packet              
            */
            for( i=0 ; i < pIORB_PT->ControllerCmdLen; i++ ) {
               npACB->npCmdIO->ATAPIPkt[i] = pIORB_PT->pControllerCmd[i];
            }

            /*Ŀ
             determine number of bytes in s/g list 
            */
            for ( i=0; i < pIORB_PT->cSGList; i++, pTempSGList++) {
               cXferBytes += pTempSGList->XferBufLen;
            }
            npACB->npCmdIO->cXferBytesRemain = cXferBytes;

            if( cXferBytes )                   /* Data area is allocated */
            {
               npACB->npCmdIO->IOSGPtrs.Mode         = PORT_TO_SGLIST;
               npACB->npCmdIO->IOSGPtrs.cSGList      = pIORB_PT->cSGList;
               npACB->npCmdIO->IOSGPtrs.pSGList      = pIORB_PT->pSGList;
               npACB->npCmdIO->IOSGPtrs.iPortAddress = npACB->IOPorts[FI_PDATA];
            }

            if ( npACB->ISMFlags & ACBIF_ATA_OPERATION ) {
               if ( npACB->npUCB->ReqFlags & UCBR_IDENTIFY )
               {
                  npACB->npCmdIO->IOSGPtrs.Mode = PORT_TO_SGLIST;
               }
            }
         } else {
            SetCmdError( npACB );
            return;
         }
         break;

      case SAE_FORMAT_TRACK:                                         /*V189595*/
         if( npACB->npUCB->DriveDef > UCBD_UHD ) {
            SetCmdError( npACB );
            return;
         }

         pIORB_FMT =      (PIORB_FORMAT) npACB->pIORB;               /*VVVVVVV*/
         pFMT      = (PFORMAT_CMD_TRACK) pIORB_FMT->pFormatCmd;

         npACB->npCmdIO->IOSGPtrs.Mode          = SGLIST_TO_PORT;
         npACB->npCmdIO->IOSGPtrs.cSGList       = pIORB_FMT->cSGList;
         npACB->npCmdIO->IOSGPtrs.pSGList       = pIORB_FMT->pSGList;
         npACB->npCmdIO->IOSGPtrs.iPortAddress  = npACB->IOPorts[FI_PDATA];

         for ( i=0; i < pIORB_FMT->cSGList; i++, pTempSGList++) {
            cXferBytes += pTempSGList->XferBufLen;
         }
         npACB->npCmdIO->cXferBytesRemain = cXferBytes;

         if (pIORB->iorbh.RequestControl & IORB_CHS_ADDRESSING )
         {
           CHSAddr = *(PCHS_ADDR) &pFMT->RBA;
         } else {
           f_ADD_ConvRBAtoCHS( pFMT->RBA, &npACB->npUCB->MediaGEO, &CHSAddr );
         }

         npACB->npCmdIO->ATAPIPkt[0] = FXP_FORMAT_UNIT;        /* Format CMD  */

         mediatype = (npACB->npUCB->MediaType & 0x30);         /* Unformatted */
         if( mediatype == HD_MEDIUM ) {
            mediatype |= 0x04;      /* Formatted HD */
         } else {
            mediatype |= 0x01;      /* Formatted DD or UHD */
         }
         npACB->npCmdIO->ATAPIPkt[2]  = mediatype;        /* Valid Media Type */

         npACB->npCmdIO->ATAPIPkt[6] |= 0x20;        /* sector size (nx(256)) */

         npACB->npCmdIO->ATAPIPkt[6] |= (( CHSAddr.Head & 1 ) << 2);  /* Head */

         if( (mediatype & 0x30) < 0x30 ) {                 /* HD or DD only!  */
            npACB->npCmdIO->ATAPIPkt[6] |= 0x02;           /* Single Track FMT*/
         }

         if( pFMT->Flags & FF_VERIFY ) {
            npACB->npCmdIO->ATAPIPkt[6] |= 0x01;        /* Verdor Cert/Verify */
         }

         npACB->npCmdIO->ATAPIPkt[7] = CHSAddr.Cylinder;     /* TRACK */
         break;                                                      /*AAAAAAA*/
                                                                     /*V189595*/
      default:
         SetCmdError( npACB );
         return;
   }

   npACB->OSMFlags |= ACBOF_WAITSTATE;
   npACB->OSMState  = ACBOS_ISM_COMPLETE;

   StartOSMRequest( npACB );
}

/*ͻ
                                  
                                  
*/
VOID NEAR ProcessIdentify( NPACB npACB )
{
   NPUCB   npUCB = npACB->npUCB;
   PIORBH  pIORB = npACB->pIORB;

   npACB->OSMFlags &= ~ACBOF_IDENTIFY_ACTIVE;

   if( pIORB->Status & IORB_ERROR )
   {
      /* Return the error */

   } else {

      if( npUCB->DriveDef == UCBD_ZIP250 )                     
      {
         ProcessNONSense( npACB );

      } else {

         /*Ŀ
           Get the Media geometry   
         */
         ExtractMediaGeometry( npACB );
      }

      if( MediaInvalid4Drive( npACB ))
      {
         /*Ŀ
          Media changed error                      
          IORBError is set in MediaInvalid4Drive() 
         */
         return;
      }

      /*Ŀ
       If No Medium, then we should return error    
      */
      if( npUCB->MediaStatus & MF_NOMED )
      {
         npACB->IORBError = IOERR_MEDIA_NOT_PRESENT;

      } else {

         /*Ŀ
          Return the media geometry 
         */
         *((PIORB_GEOMETRY) pIORB)->pGeometry = npUCB->MediaGEO;
      }
   }
   npACB->OSMState  = ACBOS_COMPLETE_IORB;
}

/* ͻ
                                  
 ExtractMediaGeometry()           
*/
VOID NEAR ExtractMediaGeometry( NPACB npACB )
{
   NPUCB            npUCB = npACB->npUCB;
   NPIDENTIFYDATA   npID;

   switch( WhichnpACB( npACB ) )                                     /*V189445*/
   {
      case 0:
         npID = (NPIDENTIFYDATA) IdentDataBuf;
         break;
      case 1:
         npID = (NPIDENTIFYDATA) IdentDataBuf1;
         break;
      case 2:
         npID = (NPIDENTIFYDATA) IdentDataBuf2;
         break;
      case 3:
      default:
         npID = (NPIDENTIFYDATA) IdentDataBuf3;
         break;
   }

   if( npUCB->DriveDef == UCBD_NONE )
   {
      npUCB->MediaStatus = MF_NOMED;
   }
   else if( npUCB->DriveDef < UCBD_ZIP100 )                    
   {
      /*Ŀ
                 LS-120 Drive                
      */
      npUCB->MediaType = (0x3F & npID->MediaTypeCode);

      if( !(npUCB->MediaType))
      {
         npUCB->MediaStatus = MF_NOMED;

         ClearCurrentMediaGEO( npACB );

      }else{
         npUCB->MediaGEO.TotalCylinders  = npID->CurrentCylHdSec[0];
         npUCB->MediaGEO.NumHeads        = npID->CurrentCylHdSec[1];
         npUCB->MediaGEO.SectorsPerTrack = npID->CurrentCylHdSec[2];
         npUCB->MediaGEO.BytesPerSector  = npID->BytesPerSector;
         npUCB->MediaGEO.Reserved        = 0;
         npUCB->MediaGEO.TotalSectors    =
                               (ULONG) ( npUCB->MediaGEO.TotalCylinders *
                                         npUCB->MediaGEO.NumHeads       *
                                         npUCB->MediaGEO.SectorsPerTrack  );
         npUCB->MediaStatus &= ~( MF_NOMED | MF_MC );
      }
   } else {

      /*Ŀ
       ZIP drives that don't report geometry in Identify Data 
      */
      npUCB->MediaType = 0;                                          /*V189595*/

      if( npUCB->MediaStatus & MF_NOMED )
      {
         ClearCurrentMediaGEO( npACB );

      } else {

         GetDefinedDeviceGEO( npACB, (PGEOMETRY) &(npUCB->MediaGEO) );
      }
   }
}

/* ͻ
                                  
                                  
*/
VOID NEAR GetDefinedDeviceGEO( NPACB npACB, PGEOMETRY npGEO )
{
   NPUCB     npUCB = npACB->npUCB;
   ULONG     TotalCyl     = 0;
   USHORT    NumHeads     = 0;
   USHORT    SectPerTrack = 0;
   USHORT    Element;

   /*Ŀ
    Get Geometry based on Drive defintion 
   */
   if( npUCB->DriveDef > UCBD_MAX_DRIVE_TYPE )
   {
      Element = 0;
   } else {
      Element = (npUCB->DriveDef * 4);
   }
                 TotalCyl = DriveMediaType[ Element ];
                 NumHeads = DriveMediaType[ Element + 1 ];
             SectPerTrack = DriveMediaType[ Element + 2 ];
   npGEO->BytesPerSector  = DriveMediaType[ Element + 3 ];
   npGEO->Reserved        = 0;
   npGEO->NumHeads        = NumHeads;
   npGEO->TotalCylinders  = TotalCyl;
   npGEO->SectorsPerTrack = SectPerTrack;
   npGEO->TotalSectors    = (ULONG) ( TotalCyl     *
                                      NumHeads     *
                                      SectPerTrack   );
}

/* ͻ
                                  
                                  
*/
VOID NEAR ClearCurrentMediaGEO( NPACB npACB )
{
   NPUCB  npUCB = npACB->npUCB;

   npUCB->MediaGEO.TotalCylinders  = 0;
   npUCB->MediaGEO.NumHeads        = 0;
   npUCB->MediaGEO.Reserved        = 0;
   npUCB->MediaGEO.SectorsPerTrack = 0;
   npUCB->MediaGEO.BytesPerSector  = 0;
   npUCB->MediaGEO.TotalSectors    = 0;
}

/* ͻ
                                  
                                  
*/
USHORT NEAR WhichnpACB( NPACB npACB )                               /*V189445*/
{
   USHORT i, j;

   j = MAX_ADAPTERS-1;                   /* default */

   for ( i=0; i < MAX_ADAPTERS; i++ )
   {
      if( npACB == ACBPtrs[ i ].npACB )
      {
         j = i;
         break;
      }
   }

   return( j );
}

/* ͻ
                                  
                                  
*/
VOID NEAR SetCmdError( NPACB npACB )
{
   npACB->IORBError = IOERR_CMD_NOT_SUPPORTED;
   npACB->OSMState  = ACBOS_COMPLETE_IORB;
   npACB->OSMFlags  &= ~ACBOF_WAITSTATE;
}

/*ͻ
                                  
 ProcessNONSense()                
*/                                 /*V240175*/
VOID  NEAR ProcessNONSense( NPACB npACB )
{
   UCHAR   Element, FormatType;
   NPUCB   npUCB = npACB->npUCB;

   switch( WhichnpACB( npACB ) )
   {
      case 0:
          FormatType = NonSenseDataBuf[2];
          break;
      case 1:
          FormatType = NonSenseDataBuf1[2];
          break;
      case 2:
          FormatType = NonSenseDataBuf2[2];
          break;
      case 3:
      default:
          FormatType = NonSenseDataBuf3[2];
          break;
   }
   if( FormatType == 0x01 )
   {
      Element = ( UCBD_ZIP100 * 4 );                    /* 100MB */
   } else {
      Element = ( UCBD_ZIP250 * 4 );         /* 0x02 */ /* 250MB or Empty */
   }

   npUCB->MediaGEO.TotalCylinders  = DriveMediaType[Element];
   npUCB->MediaGEO.NumHeads        = DriveMediaType[Element+1];
   npUCB->MediaGEO.SectorsPerTrack = DriveMediaType[Element+2];
   npUCB->MediaGEO.BytesPerSector  = DriveMediaType[Element+3];
   npUCB->MediaGEO.Reserved        = 0;
   npUCB->MediaGEO.TotalSectors    =
                           (ULONG) ( npUCB->MediaGEO.TotalCylinders *
                                     npUCB->MediaGEO.NumHeads       *
                                     npUCB->MediaGEO.SectorsPerTrack  );
}                                                                   /*VA240175*/
