/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
/**************************************************************************
 *
 * SOURCE FILE NAME =     ATAPIORB.C
 *
 * DESCRIPTIVE NAME =     ATAPI IORB Interface to State Machine
 *
 *
 *
 * VERSION = 1.0
 *
 * DATE
 *
 * DESCRIPTION :
 *
 * Purpose:
 *
 *
 *
 *
 *
*/

#define INCL_NOBASEAPI
#define INCL_NOPMAPI
#include "os2.h"
#include "dos.h"
#include "dskinit.h"

#include "iorb.h"
#include "addcalls.h"
#include "dhcalls.h"
#include "apmcalls.h"                                               /*@V151168*/

#define INCL_INITRP_ONLY
#include "reqpkt.h"

#include "scsi.h"
#include "cdbscsi.h"

#include "atapicon.h"
#include "atapireg.h"
#include "atapityp.h"
#include "atapiext.h"
#include "atapipro.h"


VOID FAR _loadds ATAPIADDEntry( PIORBH pNewIORB )
{
   PIORBH    pNewsTailIORB;  /* The tail of the iorb chain for pNewIORB *//*@V102677*/
   NPACB     npACB;
   NPUCB     npUCB;

   /*Ŀ
    Queue IORBs which don't address 
    a specific unit to ACB 0 Unit 0 
   */

   if (pNewIORB->CommandCode == IOCC_CONFIGURATION)
   {
      pNewIORB->UnitHandle = (USHORT) (npUCB = ACBPtrs[0].npACB->npUCB);

   } else {

      npUCB = (NPUCB) pNewIORB->UnitHandle;
   }

   /*                                                                 @V155162
   ** If the HW is not present, reject commands that require HW.      @V155162
   */                                                               /*@V155162*/

   if( (pNewIORB->CommandCode != IOCC_UNIT_CONTROL) &&              /*@V155162*/
       (npUCB->Flags & UCBF_NOTPRESENT) )                           /*@V155162*/
   {                                                                /*@V155162*/
      if( (pNewIORB->CommandCode == IOCC_ADAPTER_PASSTHRU) &&       /*@V155162*/
          (pNewIORB->CommandModifier ==  IOCM_EXECUTE_CDB) )        /*@V155162*/
      {                                                             /*@V155162*/
         if( ((PIORB_ADAPTER_PASSTHRU)pNewIORB)->pControllerCmd[0]  /*@V155162*/
             == 0 )                                                 /*@V155162*/
         {    // Test Unit Ready Request                            /*@V155162*/
            if( npUCB->Flags & UCBF_MEDIACHANGED )                  /*@V155162*/
            {                                                       /*@V155162*/
               npUCB->Flags &= ~UCBF_MEDIACHANGED;                  /*@V155162*/
               pNewIORB->Status = IORB_ERROR | IORB_DONE;           /*@V155162*/
               pNewIORB->ErrorCode = IOERR_MEDIA_CHANGED;           /*@V155162*/
            }                                                       /*@V155162*/
            else                                                    /*@V155162*/
            {                                                       /*@V155162*/
               pNewIORB->Status = IORB_DONE;                        /*@V155162*/
            }                                                       /*@V155162*/
         }                                                          /*@V155162*/
         else                                                       /*@V155162*/
         {                                                          /*@V155162*/
            pNewIORB->Status    = IORB_DONE | IORB_ERROR;           /*@V155162*/
            pNewIORB->ErrorCode = IOERR_UNIT_NOT_READY;             /*@V155162*/
         }                                                          /*@V155162*/
      }                                                             /*@V155162*/
      else                                                          /*@V155162*/
      {                                                             /*@V155162*/
         pNewIORB->Status    = IORB_DONE | IORB_ERROR;              /*@V155162*/
         pNewIORB->ErrorCode = IOERR_UNIT_NOT_READY;                /*@V155162*/
      }                                                             /*@V155162*/
                                                                    /*@V155162*/
      if ( pNewIORB->RequestControl & IORB_ASYNC_POST )             /*@V155162*/
      {                                                             /*@V155162*/
         (*pNewIORB->NotifyAddress)(pNewIORB);                      /*@V155162*/
      }                                                             /*@V155162*/
                                                                    /*@V155162*/
      return;                                                       /*@V155162*/
   }                                                                /*@V155162*/

   npACB = npUCB->npACB;

   /* remove Valid_CDB_Length, ck performed in setupandexecute() V189445 */

   DISABLE

   /*Ŀ
      Put new IORB on end of Queue 
     */
   if (!npACB->pHeadIORB)
      npACB->pHeadIORB = pNewIORB;
   else
      npACB->pFootIORB->pNxtIORB = pNewIORB;


   /*Ŀ*/                               /*@V102677*/
   /*Find end of chained request*/                               /*@V102677*/
   /**/                               /*@V102677*/
   for ( pNewsTailIORB = pNewIORB;                                 /*@V102677*/
         pNewsTailIORB->RequestControl & IORB_CHAIN;               /*@V102677*/
         pNewsTailIORB = pNewsTailIORB->pNxtIORB                   /*@V102677*/
       )                                                           /*@V102677*/
     ;                                                             /*@V102677*/
                                                                   /*@V102677*/
   /*Ŀ*/                 /*@V102677*/
   /* Point the foot of the IORB Queue to the */                 /*@V102677*/
   /* tail of the new IORB chain.             */                 /*@V102677*/
   /**/                 /*@V102677*/
   npACB->pFootIORB = pNewsTailIORB;                               /*@V102677*/
                                                                   /*@V102677*/
   /*Ŀ*/                      /*@V102677*/
   /*Make sure pNxtIORB for the for the  */                      /*@V102677*/
   /*Last IORB on our Q is clear.        */                      /*@V102677*/
   /**/                      /*@V102677*/
   npACB->pFootIORB->pNxtIORB = 0;                                 /*@V102677*/

   if ( !(npACB->OSMFlags & ACBOF_SM_ACTIVE))
   {
      npACB->OSMFlags |= ACBOF_SM_ACTIVE;

      NextIORB(npACB);

      npACB->OSMState       = ACBOS_START_IORB;
      npACB->IORBStatus     = 0;
      npACB->IORBError      = 0;
      npACB->cResetRequests = 0;
      npACB->npCmdIO        = &npACB->ExternalCmd;

      if (  ( npACB->ResourceFlags & ACBRF_SHARED ) &&
           !( npACB->ResourceFlags & ACBRF_CURR_OWNER ) &&
           !( pNewIORB->CommandCode == IOCC_CONFIGURATION ) &&
           !( pNewIORB->CommandCode == IOCC_UNIT_CONTROL )  &&      /*@V132280*/
           !( pNewIORB->CommandCode == IOCC_RESOURCE ) )            /*@V132280*/
      {

         npACB->OSMState = ACBOS_SUSPEND_COMPLETE;

         ENABLE

         SuspendResumeOtherAdd( npACB, IOCM_SUSPEND );
      }
      else
      {
         ENABLE
         StartOSM( npACB );
      }
   }
   ENABLE
}

VOID NEAR Convert_17B_to_ATAPI( ULONG pPhysData )
{
   struct translatetable
   {
      ULONG OldValue;
      ULONG NewValue;
   };

   PBYTE  pData;
   USHORT ModeFlag;
   ULONG  Capabilities_17B = *pData+4;
   PBYTE  pCaps            =  pData+4;
   UCHAR  i, tsize;

   static struct translatetable table[] =
   {
      { CP_AUDIO_PLAY ,                 CP_AUDIO_PLAY },
      { REV_17B_CP_MODE2_FORM1,         CP_MODE2_FORM1 },
      { REV_17B_CP_MODE2_FORM2,         CP_MODE2_FORM2 },
      { REV_17B_CP_READ_CDDA,           CP_CDDA },
      { REV_17B_CP_PHOTO_CD,            CP_MULTISESSION },
      { REV_17B_CP_EJECT,               CP_EJECT },
      { REV_17B_CP_LOCK,                CP_LOCK },
      { REV_17B_CP_UPC,                 CP_UPC },
      { REV_17B_CP_ISRC,                CP_ISRC },
      { REV_17B_CP_INDEPENDENT_VOL_LEV, CP_INDEPENDENT_VOLUME_LEVELS },
      { REV_17B_CP_SEPARATE_CH_MUTE,    CP_SEPARATE_CHANNEL_MUTE },
      { REV_17B_CP_TRAY_LOADER,         CP_TRAY_LOADER },
      { REV_17B_CP_POPUP_LOADER,        CP_POPUP_LOADER },
      { REV_17B_CP_RESERVED_LOADER,     CP_RESERVED_LOADER },
      { REV_17B_CP_PREVENT_JUMPER,      CP_PREVENT_JUMPER },
      { REV_17B_CP_LOCK_STATE,          CP_LOCK_STATE },
      { REV_17B_CP_CDDA_ACCURATE,       CP_CDDA_ACCURATE },
      { REV_17B_CP_C2_POINTERS,         CP_C2_POINTERS }
   };

   tsize = sizeof(table) / sizeof(struct translatetable);

   if ( DevHelp_PhysToVirt( (ULONG)   pPhysData,
                             (USHORT)  1,
                             (PVOID)   &pData,
                             (PUSHORT) &ModeFlag  ) )
   {
      _asm { int 3 }
   }

   Capabilities_17B = *pData+4;
   pCaps            =  pData+4;

   *pCaps = 0;

   for (i=0; i < tsize; i++ )
   {
      if ( Capabilities_17B & table[i].OldValue )
      {
         *pCaps |= table[i].NewValue;
      }
   }
}
