/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
/**************************************************************************
 *
 * SOURCE FILE NAME = ATAPINIT.C
 *
 * DESCRIPTION : IBM ATAPI Disk Type driver initialization
 *
 *
 *
 * VERSION = 1.0
 *
 * DATE
 *
 * DESCRIPTION :
 *
 * Purpose:
 *
 *
*/

#define INCL_NOBASEAPI
#define INCL_NOPMAPI
#define INCL_DOSERRORS
#include "os2.h"
#include "dos.h"
#include "bseerr.h"
#include "devclass.h"
#include "dskinit.h"

#include "iorb.h"
#include "addcalls.h"
#include "dhcalls.h"
#include "apmcalls.h"                                               /*@V151168*/

#define INCL_INITRP_ONLY
#include "reqpkt.h"

#include "scsi.h"
#include "cdbscsi.h"

#include "atapicon.h"
#include "atapireg.h"
#include "atapityp.h"
#include "atapiext.h"
#include "atapipro.h"
#include "rmcalls.h"

static strnswap( PSZ d, PSZ s, USHORT n );

VOID NEAR set_data_in_sg( PBYTE, PIORB_ADAPTER_PASSTHRU, USHORT );  /*@V151168*/

// If the CDROM is not present, use this code to Fake the           /*@V151168*/
// operations so that OS2CDROM.DMD believes that a CD-ROM           /*@V151168*/
// is really there but empty                                        /*@V151168*/

                                                                    /*@V151168*/
/*----------------------------------------------------------------*//*@V151168*/
/* Function:   Copy data from buffer to S/G list.                 *//*@V151168*/
/* Input:      pbuf, pIORB, buf_len                               *//*@V151168*/
/* Output:     none                                               *//*@V151168*/
/*----------------------------------------------------------------*//*@V151168*/
VOID NEAR set_data_in_sg( PBYTE pbuf, PIORB_ADAPTER_PASSTHRU pIORB, /*@V151168*/
                          USHORT buf_len )                          /*@V151168*/
{                                                                   /*@V151168*/
   UCHAR    i;                                                      /*@V151168*/
   PSCATGATENTRY  pTempSGList;                                      /*@V151168*/
   ULONG    ppSrcDst;            /* physical address */             /*@V151168*/
   PBYTE    pSrcDst;             /* virtual address by PhysToVirt *//*@V151168*/
   USHORT   XferCur;             /* segment length */               /*@V151168*/
   USHORT   ModeFlag;            /* for PhysToVirt */               /*@V151168*/
   USHORT   copy_bytes;                                             /*@V151168*/
   USHORT   total_bytes; /* total_bytes + nokori_bytes == buf_len *//*@V151168*/
   USHORT   nokori_bytes;                                           /*@V151168*/
                                                                    /*@V151168*/
   pTempSGList = pIORB->pSGList;                                    /*@V151168*/
   total_bytes = 0;                                                 /*@V151168*/
   nokori_bytes = buf_len;                                          /*@V151168*/
                                                                    /*@V151168*/
   for (i=0; i<pIORB->cSGList && total_bytes<buf_len ; i++,         /*@V151168*/
        pTempSGList++) {                                            /*@V151168*/
                                                                    /*@V151168*/
      ppSrcDst = pTempSGList->ppXferBuf;                            /*@V151168*/
      XferCur = pTempSGList->XferBufLen;                            /*@V151168*/
                                                                    /*@V151168*/
      if ( DevHelp_PhysToVirt( ppSrcDst, XferCur,                   /*@V151168*/
                               (PVOID) &pSrcDst, &ModeFlag ) ) {    /*@V151168*/
#ifdef DEBUG                                                        /*@V151168*/
         INT3;                                                      /*@V151168*/
#endif                                                              /*@V151168*/
      }                                                             /*@V151168*/
                                                                    /*@V151168*/
      copy_bytes = ( XferCur < nokori_bytes ) ? XferCur :           /*@V151168*/
                                                nokori_bytes;       /*@V151168*/
      memcopy( pSrcDst, pbuf, copy_bytes);                          /*@V151168*/
                                                                    /*@V151168*/
      total_bytes += copy_bytes;    /* update # of copied bytes */  /*@V151168*/
      pbuf += copy_bytes;           /* increment pointer */         /*@V151168*/
      nokori_bytes -= copy_bytes;/* update # of byte to be copied *//*@V151168*/
   } /* endfor */                                                   /*@V151168*/
}                                                                   /*@V151168*/

/*
ͻ
                                  
                                  
ͼ */
VOID   FAR  _loadds NotifyIORBDone( PIORB pIORB )                   /*@V153151*/
{
   USHORT     AwakeCount;
   PUCHAR     pWSFlags = pIORB->DMWorkSpace;              /* work space flags */

   DISABLE
   if ( ( pIORB->Status & IORB_DONE ) && ( *pWSFlags & WSF_PROC_BLOCK ) )
   {
      *pWSFlags &= ~WSF_PROC_BLOCK;
      DevHelp_ProcRun( (ULONG) pIORB, &AwakeCount );
   }
   ENABLE
}

/*
ͻ
                                  
                                  
ͼ */
USHORT NEAR ATAPIIdentify( NPATBL npAT )
{
   NPIDENTIFYDATA    npID;
   NPUTBL            npUT;
   NPACB             npACB = npAT->npACB;
   NPUCB             npUCB;
   USHORT            rc;
   USHORT            UnitType = 0xff;
   USHORT            UnitId;
   UCHAR             mediatype;

   npID   = (NPIDENTIFYDATA) ScratchBuf;
   UnitId = npACB->npUCB->UnitId;
   npUT   = &npAT->Unit[UnitId];
   npUCB  = npACB->npUCB;
   npUCB->Capabilities = 0;                                          /*@V93531*/

   if ( !(rc=GetIdentifyData( npACB, UnitId, (PBYTE) npID )))
   {
      /*Ŀ
       Save Model/Serial/Firmware Information 
      */
      strnswap( npUT->ModelNum, npID->ModelNum, sizeof(npID->ModelNum)+2 );
      strnswap( npUT->Serial,   npID->Serial,   sizeof(npID->Serial)   );
      strnswap( npUT->Firmware, npID->Firmware, sizeof(npID->Firmware) );

      if( strncmp( npUT->Serial, BlankSerial, sizeof(npID->Serial) ) )
         npUT->Serial[0] = 0;

      /*Ŀ
       CMD Packet Size   
      */
      switch (npID->GenConfig.CmdPktSize)
      {
         case 0 : npUCB->CmdPacketLength = 12;
                  break;

         case 1 : npUCB->CmdPacketLength = 16;
                  break;

         default: npUCB->CmdPacketLength = 00;
                  rc = 1;
      }

      /* Ŀ
       CMD DRQ Type      
      */
      switch (npID->GenConfig.CmdDRQType)
      {
         case 0 : npUCB->Capabilities |= UCBC_MICROPROCESSOR_DRQ;
                  break;

         case 1 : npUCB->Capabilities |= UCBC_INTERRUPT_DRQ;
                  break;

         case 2 : npUCB->Capabilities |= UCBC_ACCELERATED_DRQ;
                  break;

         default: npUCB->Capabilities |= UCBC_MICROPROCESSOR_DRQ;
                  rc = 1;
      }

      /*Ŀ
       Protocol Type     
      */
      switch (npID->GenConfig.ProtocolType)
      {
         case 0 :
         case 1 : npUCB->Capabilities |= UCBC_ATA;
                  break;

         case 2 :
         case 3 : npUCB->Capabilities |= UCBC_ATAPI;
                  break;

         default: npUCB->Capabilities |= UCBC_ATA;
                  rc = 1;
      }

      /*Ŀ
       Device Type       
      */
      switch ( UnitType = npID->GenConfig.DeviceType )
      {
         case UIB_TYPE_DISK :
                  npUCB->Capabilities |= UCBC_DIRECT_ACCESS_DEVICE;

                  /*Ŀ
                        Check for LS-120 Drive          
                  */
                  if( strncmp( npUT->ModelNum, LS120ID, LS120ID_STRGSIZE)) /*V189865*/
                  {
                     UnitType           = LS_120;
                     npUCB->DriveDef    = UCBD_UHD;
                     npUCB->DrvDefFlags = 0;
                     npUCB->MediaType   = npID->MediaTypeCode;
                     if((npID->MediaStatusWord & 0x03) == 0x01)
                     {
                        npUCB->StatusNotify = SN_STATUS_SUPPORTED; 