/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
/**************************************************************************
 *
 * SOURCE FILE NAME = ATAPIDAT.C
 *
 * DESCRIPTION : Global Data for ATAPI Filter driver
 *
 *
 *
 * VERSION = 1.0
 *
 * DATE
 *
 * DESCRIPTION :
 *
 * Purpose:
 *
 *
*/
#define INCL_NOBASEAPI
#define INCL_NOPMAPI
#include "os2.h"
#include "dos.h"
#include "dskinit.h"

#include "iorb.h"
#include "addcalls.h"
#include "dhcalls.h"
#include "apmcalls.h"                                               /*@V151168*/

#define INCL_INITRP_ONLY
#include "reqpkt.h"

#include "scsi.h"
#include "cdbscsi.h"

#include "atapicon.h"
#include "atapireg.h"
#include "atapityp.h"
#include "atapiext.h"
#include "atapipro.h"


ACBPTRS      ACBPtrs[MAX_ADAPTERS] = { { 0, &AdapterIRQ0 },
                                       { 0, &AdapterIRQ1 },
                                       { 0, &AdapterIRQ2 },
                                       { 0, &AdapterIRQ3 } };

/* Global Variables for Initialization */

                            /* { Cyl, Heads, Sect/Track, Bytes/Sector }*/
USHORT  DriveMediaType[ 32 ] = {   0,  0,  0,   0,      /*  UCBD_NONE       */
                                  80,  2,  9, 512,      /*  UCBD_DD   720KB */
                                  80,  2, 18, 512,      /*  UCBD_HD   1.44MB*/
                                 963,  8, 32, 512,      /*  UCBD_UHD  120MB */
                                  96, 64, 32, 512,      /*  UCBD_ZIP  100MB */
                                   0,  0,  0, 512,      /*  UCBD_JAZZ 1GB   */
                                 239, 64, 32, 512,      /*  UCBD_ZIP  250MB */
                                  96, 64, 32, 512};     /*  UCBD_ZIP  Generic*/

USHORT       startresume           = 0;
USHORT       startsuspend          = 0;
PFN          Device_Help           = 0L;
USHORT       ADDHandle             = 0;
USHORT       cAdapters             = 0;
USHORT       cUnits                = 0;
USHORT       InitActive            = 0;
USHORT       InitIOComplete        = 0;
USHORT       MachineID             = 0;
USHORT       Calibrate             = 0;
ULONG        WaitDRQCount          = 0;
ULONG        WaitBSYCount          = 0;                              /*V@93531*/
ULONG        CheckReadyCount       = 0;
ULONG        IODelayCount          = 0;
ULONG        ElapsedTimerHandle    = 0;
UCHAR        AdapterName[17]       = "ATAPI Fake Adpt ";            /*@V189001*/
LIN          plDataSeg             = 0;
LIN          plSwapCode            = 0;
USHORT       SwapCodeLen           = 0;
USHORT       ADDLockCount          = 0;
LIN          plADDLockHandle       = 0;
#define      TASKTIME               -1L
PULONG       pNestedIntCount       = 0;
USHORT       cInt                  = 0;
UCHAR        ADDLockHandle[12]     = { 0 };

UCHAR        IdentDataBuf[IDENTIFY_DATA_BYTES] = { 0xFF };
ULONG        ppIdentDataBuf          = 0;
SCATGATENTRY IDDataSGList            = { 0, IDENTIFY_DATA_BYTES };     /*V189445 */

UCHAR        IdentDataBuf1[IDENTIFY_DATA_BYTES] = { 0xFF };
ULONG        ppIdentDataBuf1         = 0;
SCATGATENTRY IDDataSGList1           = { 0, IDENTIFY_DATA_BYTES };     /*V189445 */

UCHAR        IdentDataBuf2[IDENTIFY_DATA_BYTES] = { 0xFF };
ULONG        ppIdentDataBuf2         = 0;
SCATGATENTRY IDDataSGList2           = { 0, IDENTIFY_DATA_BYTES };     /*V189445 */

UCHAR        IdentDataBuf3[IDENTIFY_DATA_BYTES] = { 0xFF };
ULONG        ppIdentDataBuf3         = 0;
SCATGATENTRY IDDataSGList3           = { 0, IDENTIFY_DATA_BYTES };     /*V189445*/

UCHAR        SenseDataBuf[SENSE_DATA_BYTES] = { 0 };
ULONG        ppSenseDataBuf          = 0;
SCATGATENTRY SenseDataSGList         = { 0, SENSE_DATA_BYTES };

UCHAR        SenseDataBuf1[SENSE_DATA_BYTES] = { 0 };
ULONG        ppSenseDataBuf1         = 0;
SCATGATENTRY SenseDataSGList1        = { 0, SENSE_DATA_BYTES };        /*V189445*/

UCHAR        SenseDataBuf2[SENSE_DATA_BYTES] = { 0 };
ULONG        ppSenseDataBuf2         = 0;
SCATGATENTRY SenseDataSGList2        = { 0, SENSE_DATA_BYTES };        /*V189445*/

UCHAR        SenseDataBuf3[SENSE_DATA_BYTES] = { 0 };
ULONG        ppSenseDataBuf3         = 0;
SCATGATENTRY SenseDataSGList3        = { 0, SENSE_DATA_BYTES };        /*V189445*/


UCHAR        NonSenseDataBuf[NONSENSE_DATA_BYTES] = { 0 };           /*V240175*/
ULONG        ppNonSenseDataBuf           = 0;
SCATGATENTRY NonSenseDataSGList          = { 0, NONSENSE_DATA_BYTES };

UCHAR        NonSenseDataBuf1[NONSENSE_DATA_BYTES] = { 0 };
ULONG        ppNonSenseDataBuf1          = 0;
SCATGATENTRY NonSenseDataSGList1         = { 0, NONSENSE_DATA_BYTES };

UCHAR        NonSenseDataBuf2[NONSENSE_DATA_BYTES] = { 0 };
ULONG        ppNonSenseDataBuf2          = 0;
SCATGATENTRY NonSenseDataSGList2         = { 0, NONSENSE_DATA_BYTES };

UCHAR        NonSenseDataBuf3[NONSENSE_DATA_BYTES] = { 0 };
ULONG        ppNonSenseDataBuf3          = 0;
SCATGATENTRY NonSenseDataSGList3         = { 0, NONSENSE_DATA_BYTES };/*V240175*/


USHORT AddSenseDataMap[] = {
   0,                                /* 00h No sense information              */
   IOERR_RBA_ADDRESSING_ERROR,       /* 01h No index/sector signal            */
   IOERR_RBA_ADDRESSING_ERROR,       /* 02h No seek complete                  */
   IOERR_RBA_CRC_ERROR,              /* 03h Write fault                       */
   IOERR_UNIT_NOT_READY,             /* 04h Drive not ready                   */
   IOERR_ADAPTER_DEVICE_TIMEOUT,     /* 05h LUN not selected                  */
   IOERR_RBA_ADDRESSING_ERROR,       /* 06h No track zero found                           */
   IOERR_ADAPTER_REFER_TO_STATUS,    /* 07h Multiple drives selected          */
   IOERR_ADAPTER_DEVICE_TIMEOUT,     /* 08h Logical unit communication failure*/
   IOERR_RBA_ADDRESSING_ERROR,       /* 09h Track following error             */
   IOERR_ADAPTER_REFER_TO_STATUS,    /* 0Ah Reserved                          */
   IOERR_ADAPTER_REFER_TO_STATUS,    /* 0Bh Reserved                          */
   IOERR_RBA_CRC_ERROR,              /* 0Ch Write Error                       */
   IOERR_ADAPTER_REFER_TO_STATUS,    /* 0Dh Reserved                          */
   IOERR_ADAPTER_REFER_TO_STATUS,    /* 0Eh Reserved                          */
   IOERR_ADAPTER_REFER_TO_STATUS,    /* 0Fh Reserved                          */
   IOERR_RBA_ADDRESSING_ERROR,       /* 10h ID CRC or ECC error               */
   IOERR_RBA_CRC_ERROR,              /* 11h Unrecovered Read error            */
   IOERR_RBA_ADDRESSING_ERROR,       /* 12h No address mark found             */
   IOERR_RBA_ADDRESSING_ERROR,       /* 13h No addr mark in data field        */
   IOERR_RBA_ADDRESSING_ERROR,       /* 14h No record found                   */
   IOERR_RBA_ADDRESSING_ERROR,       /* 15h Seek positioning error            */
   IOERR_RBA_ADDRESSING_ERROR,       /* 16h Data synchroniztion mark error    */
   IOERR_RBA_CRC_ERROR,              /* 17h Recovered read w/ retries         */
   IOERR_RBA_CRC_ERROR,              /* 18h Recovered read data w/correction  */
   IOERR_ADAPTER_REFER_TO_STATUS,    /* 19h Defect list error                 */
   IOERR_ADAPTER_REFER_TO_STATUS,    /* 1Ah Parameter overrun                 */
   IOERR_ADAPTER_DEVICEBUSCHECK,     /* 1Bh Synchronous transfer err          */
   IOERR_ADAPTER_REFER_TO_STATUS,    /* 1Ch Primary defect list not found     */
   IOERR_ADAPTER_REFER_TO_STATUS,    /* 1Dh Compare error                     */
   IOERR_RBA_ADDRESSING_ERROR,       /* 1Eh Recovered ID with ECC correction  */
   IOERR_ADAPTER_REFER_TO_STATUS,    /* 1Fh Reserved                          */
   IOERR_CMD_SYNTAX,                 /* 20h Invalid command op code           */
   IOERR_RBA_ADDRESSING_ERROR,       /* 21h Illegal logical blk addr          */
   IOERR_CMD_SYNTAX,                 /* 22h Illegal func for dev type         */
   IOERR_ADAPTER_REFER_TO_STATUS,    /* 23h Reserved                          */
   IOERR_CMD_SYNTAX,                 /* 24h Illegal field in CDW              */
   IOERR_CMD_SYNTAX,                 /* 25h Invalid LUN                       */
   IOERR_CMD_SYNTAX,                 /* 26h Invalid param list field          */
   IOERR_MEDIA_WRITE_PROTECT,        /* 27h Write protected                   */
   IOERR_MEDIA_CHANGED,              /* 28h Medium changed                    */
   IOERR_DEVICE_RESET,               /* 29h Power on reset or bus device reset*/
   IOERR_MEDIA_CHANGED,              /* 2Ah Mode select parameters changed    */
   IOERR_ADAPTER_REFER_TO_STATUS,    /* 2Bh Reserved                          */
   IOERR_ADAPTER_REFER_TO_STATUS,    /* 2Ch Reserved                          */
   IOERR_ADAPTER_REFER_TO_STATUS,    /* 2Dh Reserved                          */
   IOERR_ADAPTER_REFER_TO_STATUS,    /* 2Eh Reserved                          */
   IOERR_ADAPTER_REFER_TO_STATUS,    /* 2Fh Reserved                          */
   IOERR_MEDIA_NOT_SUPPORTED,        /* 30h Incompatible cartridge            */
   IOERR_MEDIA_NOT_FORMATTED,        /* 31h Medium format corrupted           */
   IOERR_MEDIA_NOT_FORMATTED,        /* 32h No defect spare location available*/
   IOERR_ADAPTER_REFER_TO_STATUS,    /* 33h Reserved                          */
   IOERR_ADAPTER_REFER_TO_STATUS,    /* 34h Reserved                          */
   IOERR_ADAPTER_REFER_TO_STATUS,    /* 35h Reserved                          */
   IOERR_ADAPTER_REFER_TO_STATUS,    /* 36h Reserved                          */
   IOERR_ADAPTER_REFER_TO_STATUS,    /* 37h Reserved                          */
   IOERR_ADAPTER_REFER_TO_STATUS,    /* 38h Reserved                          */
   IOERR_ADAPTER_REFER_TO_STATUS,    /* 39h Reserved                          */
   IOERR_MEDIA_NOT_PRESENT,          /* 3Ah Medium Not Present                */
   IOERR_ADAPTER_REFER_TO_STATUS,    /* 3Bh Reserved                          */
   IOERR_ADAPTER_REFER_TO_STATUS,    /* 3Ch Reserved                          */
   IOERR_ADAPTER_REFER_TO_STATUS,    /* 3Dh Reserved                          */
   IOERR_UNIT_NOT_READY,             /* 3Eh LUN  not self-configured yet      */
   IOERR_ADAPTER_REFER_TO_STATUS,    /* 3Fh Reserved                          */
   IOERR_DEVICE_DIAGFAIL,            /* 40h RAM failure                       */
   IOERR_DEVICE_DIAGFAIL,            /* 41h Data path diagnostic failure      */
   IOERR_DEVICE_DIAGFAIL,            /* 42h Power-on diag failure             */
   IOERR_DEVICE_DEVICEBUSCHECK,      /* 43h Message reject error              */
   IOERR_DEVICE,                     /* 44h Internal controller error         */
   IOERR_UNIT_NOT_READY,             /* 45h Select/reselect failed            */
   IOERR_DEVICE_BUSY,                /* 46h Unsuccessful soft reset           */
   IOERR_DEVICE_DEVICEBUSCHECK,      /* 47h SCSI interface parity error       */
   IOERR_DEVICE_DEVICEBUSCHECK,      /* 48h Initiator detected error          */
   IOERR_DEVICE_DEVICEBUSCHECK,      /* 49h Inappropriate/illegal message     */
   IOERR_ADAPTER_REFER_TO_STATUS,    /* 50H - Reserved                      */
   IOERR_ADAPTER_REFER_TO_STATUS,    /* 51H - Reserved                      */
   IOERR_ADAPTER_REFER_TO_STATUS,    /* 52H - Reserved                      */
   IOERR_ADAPTER_REFER_TO_STATUS,    /* 53H - Media Load or eject failed    */
   IOERR_ADAPTER_REFER_TO_STATUS,    /* 54H - Reserved                      */
   IOERR_ADAPTER_REFER_TO_STATUS,    /* 55H - Reserved                      */
   IOERR_ADAPTER_REFER_TO_STATUS,    /* 56H - Reserved                      */
   IOERR_ADAPTER_REFER_TO_STATUS,    /* 57H - Unable to recover TOC         */
   IOERR_ADAPTER_REFER_TO_STATUS,    /* 58H - Reserved                      */
   IOERR_ADAPTER_REFER_TO_STATUS,    /* 59H - Reserved                      */
   IOERR_ADAPTER_REFER_TO_STATUS,    /* 5AH - Operator request/state change */
   IOERR_ADAPTER_REFER_TO_STATUS,    /* 5BH - LOG exception                 */
   IOERR_ADAPTER_REFER_TO_STATUS,    /* 5CH - Reserved                      */
   IOERR_ADAPTER_REFER_TO_STATUS,    /* 5DH - Reserved                      */
   IOERR_ADAPTER_REFER_TO_STATUS,    /* 5EH - Reserved                      */
   IOERR_ADAPTER_REFER_TO_STATUS,    /* 5FH - Reserved                      */
   IOERR_ADAPTER_REFER_TO_STATUS,    /* 60H - Reserved                      */
   IOERR_ADAPTER_REFER_TO_STATUS,    /* 61H - Reserved                      */
   IOERR_ADAPTER_REFER_TO_STATUS,    /* 62H - Reserved                      */
   IOERR_ADAPTER_REFER_TO_STATUS,    /* 63H - End of User area encountered  */
   IOERR_MEDIA_NOT_SUPPORTED         /* 64H - Illegal Mode for this track   */
   };

USHORT      MaxAddSenseDataEntry = (sizeof( AddSenseDataMap )/sizeof( USHORT ));


USHORT       LevelInterrupt = 0;                                    /*@V117508*/
USHORT       cResets        = 0;    /* Global reset counter */

IORB_ADAPTER_PASSTHRU InitIORB     = { 0 };               /*@V153151*//*190566*/

UNITINFO     NewUnitInfo = { 0 };                                   /*@V189592*/

ATBL         AdapterTable[MAX_ADAPTERS] =
{
   /*Ŀ
      Port, IRQ, IRQHandler,       Flags,            Status, npACB, cUnits 
                                            Unit Flags, Unit Status        
                                            Unit Flags, Unit Status        
     */
     {0,     0, &AdapterIRQ0, ATBF_DISABLED | ATBF_SHARED_ADAPTER, 0, 0 ,0,
                                                  {{0, UTS_NOT_PRESENT},
                                                   {0, UTS_NOT_PRESENT}} },

     {0,     0, &AdapterIRQ1, ATBF_DISABLED | ATBF_SHARED_ADAPTER, 0, 0 ,0,
                                                  {{0, UTS_NOT_PRESENT},
                                                   {0, UTS_NOT_PRESENT}} },

     {0,     0, &AdapterIRQ2, ATBF_DISABLED | ATBF_SHARED_ADAPTER, 0, 0 ,0,
                                                  {{0, UTS_NOT_PRESENT},
                                                   {0, UTS_NOT_PRESENT}} },

     {0,     0, &AdapterIRQ3, ATBF_DISABLED | ATBF_SHARED_ADAPTER, 0, 0 ,0,
                                                  {{0, UTS_NOT_PRESENT},
                                                   {0, UTS_NOT_PRESENT}} }
};                                                                /* @V197168 */

UCHAR        APMResumeEvent=0;                                    

/*Data transfered to fix trap at resume - V258232 - AG */

/* ATAPI Identify Data */
IDENTIFYDATA   atapi_identify_data = {
   {0x00, 0x02, 0x01, 0x05, 0x02},  /* General Config. */
   {0}, 0, 0, {0},                                                  /*@V189001*/
   "                    ",                      /* Serial Number */
   0x03, 0x80, 0x00,
   "1.0J    ",                                  /* Firmware Revision */
   "CD-40E                                  ",  /* Model Number */
   {0}, 0x0f00, 0x00, 0x0300, 0x0200, 0x02,
   {0}, {0}, {0},
   0x0107, 0x03, 0x01, 0x96, 0xc8, 0xb4, 0xb4,
   {0}, 0, {0}                                                      /*@V189001*/
};    /* End of Teac CD-40E support for ThinkPad 755CD */           /*@V151168*/

SCATGATENTRY          IdentifySGList         = { 0, 512 };          /*@V153151*/

UCHAR       TimersCalibrated       = 0;                             /* moved for @V155162*/
ULONG       CalibrateTimerHandle   = 0;                             /* moved for @V155162*/
ULONG       CallWorkerSync         = 0;                             /* moved for @V155162*/
ULONG       CallWorker             = 0;                             /* moved for @V155162*/

UCHAR        ScratchBuf[SCRATCH_BUF_SIZE]  = { 0 };
UCHAR        ScratchBuf1[SCRATCH_BUF_SIZE] = { 0 };
UCHAR        ScratchBuf2[SCRATCH_BUF_SIZE] = { 0 };		   

BOOL         A_Found;                                               /*@V189592*/
BOOL         B_Found;                                               /*@V189592*/
BOOL         ScannedAlready = FALSE;                                /*@V189592*/


/*
** Initialize device strings.
*/
CHAR        MatshitaID[]           = "                    MATSHITA CR-571 0.2d"; /*@V155162*/
CHAR        Nec01ID[]              = "NEC                 CD-ROM DRIVE:260    "; /*@V155162*/
CHAR        Nec01FWID[]            = "1.01    ";                                 /*@V155162*/
CHAR        Nec02ID[]              = "EN C                DCR-MOD IREV2:06    "; /*@V155162*/
CHAR        LS120ID[]              = "LS-120 ";
CHAR        ZIP100_DriveID[]       = "IOMEGA  ZIP 100";            
CHAR        ZIP250_DriveID[]       = "IOMEGA  ZIP 250";            
CHAR        ZIPGEN_DriveID[]       = "IOMEGA  ZIP ";               
CHAR        BlankSerial[]          = "                    ";                     /*@V155162*/


/*End of transfered data - V258232*/

UCHAR        ACBPool[]             = { 0 };
USHORT       ACBPoolAvail          = ACB_POOL_SIZE + TIMER_POOL_SIZE +
                                     UNITINFO_POOL_SIZE;
NPBYTE       npACBPool             = ACBPool;

/* The throw away section begins with npACBPool.  (At the end of init, it has
   been incremented by the amount of used memory for internal structures.  Any
   unused portion, and all the init data is then thrown away.) */

VOID         (FAR *savedDriverEP)();                                /*@V189592*/

USHORT       ComPort               = COM2ADDRESS;
USHORT       AdaptersForced        = 0;                             /*@V151168*/


/* Teac CD-40E internal ThinkPad 755CD support data */              /*@V151168*/
                                                                    /*@VVVVVVV*/
/* SCSI Sense Data */
SCSI_REQSENSE_DATA   no_audio_status = {
/* Error,   Sense Key,       Additional Len,  ASC,  ASCQ */
/* ----     ----             ----             ----  ---- */
   0x70, 0, 0x00, {0,0,0,0}, 0x0a, {0,0,0,0}, 0x00, 0x15, 0, {0,0,0}};

SCSI_REQSENSE_DATA   medium_not_present = {
   0x70, 0, 0x02, {0,0,0,0}, 0x0a, {0,0,0,0}, 0x3a, 0x00, 0, {0,0,0}};

SCSI_REQSENSE_DATA   invalid_field_in_cmd_pkt = {
   0x70, 0, 0x05, {0,0,0,0}, 0x0a, {0,0,0,0}, 0x24, 0x00, 0, {0,0,0}};

SCSI_REQSENSE_DATA   invalid_cmd_op_code = {
   0x70, 0, 0x05, {0,0,0,0}, 0x0a, {0,0,0,0}, 0x20, 0x00, 0, {0,0,0}};


/* SCSI Inquiry data */
SCSI_INQDATA   inquiry_data = {
   0x05, 0x80, 0x00, 0x01, 0x1f, 0x00, 0x00, 0x00,
   "TEAC    ",                /* Vendor Identification */
   "CD-40E          ",        /* Product Identification */
   "1.0J"                     /* Product Revision */
};


/* SCSI Mode Sense data */
UCHAR    mode_sense_10_page_cap[LEN_MODE_SENSE_10] = {
   0x00, 0x16, 0x71, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x2a, 0x0e, 0x00, 0x00, 0x71, 0x63, 0x29, 0x00,
   0x01, 0x61, 0x00, 0x10, 0x00, 0x40, 0x01, 0x61
};


#ifdef PRE_RELEASE
BOOL         Verbose               = TRUE;
#else
BOOL         Verbose               = FALSE;
#endif
BOOL         Installed             = FALSE;
BOOL         Force                 = FALSE;                         /*@V151168*/

IDCTABLE    DDTable                = { 0 };


#define      MSG_REPLACEMENT_STRING  1178


MSGTABLE     InitMsg               = { MSG_REPLACEMENT_STRING,
                                       1,
                                       0                      };

UCHAR AdptMsg0[] = "OK";
UCHAR AdptMsg1[] = "Adapter not located";
UCHAR AdptMsg2[] = "Adapter skipped";
UCHAR AdptMsg3[] = "Failed to set IRQ";

NPSZ AdptMsgs[] = { AdptMsg0,
                    AdptMsg1,
                    AdptMsg2,
                    AdptMsg3 };

UCHAR UnitMsg0[] = "OK - Device Filtered";
UCHAR UnitMsg1[] = "";

NPSZ UnitMsgs[] = { UnitMsg0,
                    UnitMsg1 };

UCHAR ProtocolTypeMsg0[] = "     ATA";
UCHAR ProtocolTypeMsg1[] = "     ATA";
UCHAR ProtocolTypeMsg2[] = "   ATAPI";
UCHAR ProtocolTypeMsg3[] = "Reserved";

NPSZ ProtocolTypeMsgs[] = { ProtocolTypeMsg0,
                            ProtocolTypeMsg1,
                            ProtocolTypeMsg2,
                            ProtocolTypeMsg3 };

UCHAR DeviceTypeMsg0[] = "             Reserved";
UCHAR DeviceTypeMsg1[] = " Direct-Access Device";
UCHAR DeviceTypeMsg2[] = "               CD-ROM";
UCHAR DeviceTypeMsg3[] = "Optical Memory Device";
UCHAR DeviceTypeMsg4[] = "              Unknown";

NPSZ DeviceTypeMsgs[] = { DeviceTypeMsg1, DeviceTypeMsg0,
                          DeviceTypeMsg0, DeviceTypeMsg0,
                          DeviceTypeMsg0, DeviceTypeMsg2,
                          DeviceTypeMsg0, DeviceTypeMsg3,
                          DeviceTypeMsg0, DeviceTypeMsg0,
                          DeviceTypeMsg0, DeviceTypeMsg0,
                          DeviceTypeMsg0, DeviceTypeMsg0,
                          DeviceTypeMsg0, DeviceTypeMsg0,
                          DeviceTypeMsg0, DeviceTypeMsg0,
                          DeviceTypeMsg0, DeviceTypeMsg0,
                          DeviceTypeMsg0, DeviceTypeMsg0,
                          DeviceTypeMsg0, DeviceTypeMsg0,
                          DeviceTypeMsg0, DeviceTypeMsg0,
                          DeviceTypeMsg0, DeviceTypeMsg0,
                          DeviceTypeMsg0, DeviceTypeMsg0,
                          DeviceTypeMsg0, DeviceTypeMsg4 };

UCHAR CMDDRQTypeMsg0[] = "Microprocessor DRQ";
UCHAR CMDDRQTypeMsg1[] = "     Interrupt DRQ";
UCHAR CMDDRQTypeMsg2[] = "   Accelerated DRQ";
UCHAR CMDDRQTypeMsg3[] = "          Reserved";

NPSZ CMDDRQTypeMsgs[] = { CMDDRQTypeMsg0,
                          CMDDRQTypeMsg1,
                          CMDDRQTypeMsg2,
                          CMDDRQTypeMsg3 };

UCHAR        ParmErrMsg[]          = " Warning: IBMATAPI.FLT - Invalid CONFIG.SYS parameters";
UCHAR        UninstallMsg[]        = " Warning: IBMATAPI.FLT - Driver did not load";
#ifdef PRE_RELEASE
UCHAR        VersionMsg[]          =
            "ͻ\r\n"
            " PRE-RELEASE!!!                                           \r\n"
            " IBM ATAPI (IDE) DISK Filter for OS/2 2.x - 4.x (991019)  \r\n"
            "ͼ\0";
#else
UCHAR        VersionMsg[]          =
            "ͻ\r\n"
            " IBM ATAPI (IDE) DISK Filter for OS/2 2.x - 4.x (991019)  \r\n"
            "ͼ\0";
#endif /* PRE_RELEASE */
UCHAR        DevEqualsMsg[]        =
                   "ͻ\r\n"
                   "                                                    \r\n"
                   " IBM ATAPI (IDE) DISK Driver for OS/2 requires      \r\n"
                   " the following statement in your config.sys file:   \r\n"
                   "                                                    \r\n"
                   " BASEDEV=IBMATAPI.flt                               \r\n"
                   "ͼ\0";

UCHAR                 StringBuffer[80] = { 0 };
UCHAR                 INTStringBuffer[80] = { 0 };

UCHAR        SearchKeytxt[]        = "IDE_0";
HDRIVER      hDriver               = 0L;
PFN          RM_Help               = 0L;
PFN          RM_Help0              = 0L;
PFN          RM_Help3              = 0L;
ULONG        RMFlags               = 0L;

UCHAR  DrvrNameTxt[]     = "IBMATAPI.FLT";
USHORT DrvrNameSize      = sizeof(DrvrNameTxt);
UCHAR  DrvrDescriptTxt[] = "IBM Filter Driver for IDE ATAPI DISKs";
UCHAR  VendorNameTxt[]   = "IBM OS/2";

DRIVERSTRUCT DriverStruct =
{
   DrvrNameTxt,                              /* DrvrName                */
   DrvrDescriptTxt,                          /* DrvrDescript            */
   VendorNameTxt,                            /* VendorName              */
   CMVERSION_MAJOR,                          /* MajorVer                */
   CMVERSION_MINOR,                          /* MinorVer                */
   2000,02,23,                               /* Date                    */
   0,                                        /* DrvrFlags               */
   DRT_ADDDM,                                /* DrvrType                */
   DRS_FILTER,                               /* DrvrSubType             */
   NULL                                      /* DrvrCallback            */
};

/*----------------------------------------------*/
/* Device Description                           */
/*----------------------------------------------*/
UCHAR DevDescriptNameTxt[] = "ATAPI_0 IDE DISK Drive";

DEVICESTRUCT DevStruct =
{
   DevDescriptNameTxt,   /* DevDescriptName; */
   DS_REMOVEABLE_MEDIA,  /* DevFlags;        */                      /*V190316*/
   DS_TYPE_DISK          /* DevFlags;        */
};

