/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
/**************************************************************************
 *
 * SOURCE FILE NAME = ATAPICON.H
 *
 * DESCRIPTION : Locally defined equates.
 *
 *
 *
 * VERSION = 1.0
 *
 * DATE
 *
 * DESCRIPTION :
 *
 * Purpose:
 *
 *
 *
 *
 *
*/
/*
 * Edit History for Feature # 149178:
 *
 * Edit    Date    Comments
 * ----- --------  -------------------------------------------------------------
 * [001] 01-03-96  Added definitions required for Bus Master DMA support. /jlh
 *
 */

/*---------------------------------------*/
/* Maximum Adapters/Units                */
/*---------------------------------------*/
#define MAX_ADAPTERS    4
#define MAX_UNITS       2
#define MAX_ID_RETRIES  2                      

/*---------------------------------------*/
/* DASD Device Type                      */
/*---------------------------------------*/
#define LS_120          0x0010               /* UIB_TYPE_LS120  */   /*V189001*/
#define ZIP_DRIVE       0x0011               /* UIB_TYPE_ZIP_DRIVE*/ /*V189001*/

#define LS120ID_STRGSIZE     7                                      /*V189001*/
#define ZIP100ID_STRGSIZE   15                                      /*V240175*/
#define ZIP250ID_STRGSIZE   ZIP100ID_STRGSIZE                       /*V240175*/
#define ZIPGENID_STRGSIZE   12                                      /*V240175*/

/*------------------------*/
/* Media Validity Values  */                      /* MediaInvalid4Drive()   */
/*------------------------*/
#define  MV_VALID       0x00                      /* Media Valid - Continue */
#define  MV_INVALID     0x01                      /* Media Invalid  */

/*---------------------------------------*/
/* Setup and Execute commands            */                          /*V189001*/
/*---------------------------------------*/
#define SAE_TESTUNITREADY      1
#define SAE_INTERNAL_IDENTIFY  2
#define SAE_READ               3
#define SAE_READ_VERIFY        4
#define SAE_WRITE              5
#define SAE_WRITE_VERIFY       6                                     /*V190376*/
#define SAE_REQUESTSENSE       7
#define SAE_GETMEDIASTATUS     8
#define SAE_LOCK_MEDIA         9
#define SAE_UNLOCK_MEDIA      10
#define SAE_EJECT_MEDIA       11
#define SAE_RESET             12
#define SAE_EXECUTE_CDB       13
#define SAE_FORMAT_TRACK      14                                     /*V189595*/
#define SAE_INTERNAL_NON_SENSE 15                                    /*V240175*/

#define MAX_ATAPI_PKT_SIZE    16                                     /*V189001*/

#define LOCKUNLOCKEJECT       10                                     /*V190376*/

/*------------------------*/
/* Drive Definition Flags */                   /* UCB->DrvDefFlags */
/*------------------------*/
#define  DDF_TESTUNITRDY_REQ 0x01 /* Bit field if TUR must be xcuted prior to others */
#define  DDF_VALIDITY_REQ    0x02 /* Bit field to indicate if media must be     */
                                  /* Validated for this drive ie: 1.44 in LS120 */
#define  DDF_1ST_TUR_4_GMG   0x04 /* indicate first time for TUR in GetMedaiaGEO */

/*-------------------------*/
/* Media Type Codes        */                   /* UCB->MediaType */
/*-------------------------*/
#define  UHD_MEDIUM         0x0030      /* LS-120   Media 120 MB  Value */
#define   HD_MEDIUM         0x0020      /*                1.44 MB Value */
#define   DD_MEDIUM         0x0010      /*                720 KB  Value */

/*---------------------*/
/* Media Status Flags  */
/*---------------------*/
#define  MF_RD_PT           0x80     /* Read Protected    */
#define  MF_WRT_PT          0x40     /* Write Proteted    */
#define  MF_MC              0x20     /* Medium Changed    */
#define  MF_RSVD            0x10     /*   RESERVED        */
#define  MF_MCR             0x08     /* Eject Pressed - Medium Change Request */
#define  MF_RSVD1           0x04     /*   RESERVED        */
#define  MF_NOMED           0x02     /* No Medium Present */
#define  MF_RSVD2           0x01     /*   RESERVED        */

/*-----------------------------*/
/* Sense Data defines          */
/*-----------------------------*/
#define  ASC_WRITE_PROTECTED_MEDIA   0x27
#define  ASC_MEDIA_CHANGED           0x28
#define  ASC_BUS_DEVICE_RESET        0x29
#define  ASC_MEDIUM_NOT_PRESENT      0x3A

/*-----------------------------*/
/* Status Notification Support */
/*-----------------------------*/
#define SN_PRV_ENAB             0x01     /* Media Status Previously Enabled */
#define SN_LOCK                 0x02     /* Locking inhibit Eject Capable   */
#define SN_POWER_EJ             0x04     /* 1 = Power Eject Mechanism       */
                                         /* 0 = Unlocks when Eject sent     */
/*      NOT_USED                0x08     /* Not Used                        */
#define SN_REENABLE_MEDIASTATUS 0x10     /* Re-enable Media Status Notify   */
#define SN_MEDIA_STATUS_ACTIVE  0x20     /* Media Status is Active          */
#define SN_MEDIA_STATUS_ENABLED 0x40     /* Media Status is Enabled         */
#define SN_STATUS_SUPPORTED     0x80     /* Is Media Status Notify Supported*/


#define  BYTECHK         0x02      /* Verify bit for media verification */

/*--------------------*/
/* START/STOP OPTIONS */
/*--------------------*/
#define   STOP_THE_MEDIA  0x00
#define  EJECT_THE_MEDIA  0x02
#define  START_THE_MEDIA  0x01

#define  IDENTIFY_DATA_BYTES  512

/*-------------------*/
/* TimeOut Equates   */
/*-------------------*/

/*---------------------------------------*/
/* TimeOut for RESET to complete (30s)   */
/*                                       */
/* After a RESET the drive is checked    */
/* every 200ms.                          */
/*---------------------------------------*/
#define DELAYED_RESET_MAX       (30*1000L)
#define DELAYED_RESET_INTERVAL  200L
#define ATAPI_RESET_DELAY 20                                            /*@V162970*/
#define ATAPI_NUM_RETRIES 5                                             /*@V162970*/

/*----------------------------------------------*/
/* TimeOut for IRQ from last interrupt (5s)     */
/*----------------------------------------------*/
#define IRQ_TIMEOUT_INTERVAL    (5*1000L)

/*----------------------------------------------*/
/* Retry Delay interval (200ms)                 */
/*----------------------------------------------*/
#define DELAYED_RETRY_INTERVAL  200L

/*---------------------------------------*/
/* Minimum User Timeout (5s)             */
/*---------------------------------------*/
#define MIN_USER_TIMEOUT        (IRQ_TIMEOUT_INTERVAL / 1000L)

/*---------------------------------------*/
/* Default User Timeout (30s)            */
/*---------------------------------------*/
#define DEFAULT_USER_TIMEOUT    30

/*---------------------------------------*/
/* Maximum Cmd/Data Error Retries        */
/*---------------------------------------*/
#define MAX_DATA_ERRORS         25

/*---------------------------------------*/
/* Initialization unit timeouts          */
/*---------------------------------------*/
#define INIT_TIMEOUT_LONG       (10*1000L)
#define INIT_TIMEOUT_SHORT      (    500L)                         /*@V117508*/
#define IRQ_TIMEOUT_LENGTH      ( 2*1000l)                         /*@V117508*/

/*---------------------------------------*/
/* Elapsed Timer Interval (200ms)        */
/*---------------------------------------*/
#define ELAPSED_TIMER_INTERVAL  200

/*---------------------------------------*/
/* Calibrate Loop Counter                */
/*---------------------------------------*/
#define CALIBRATE_LOOP_COUNT            1024
#define CALIBRATE_TIMER_INTERVAL        (4*31L)
#define CALIBRATE_INTERVAL_ACTUAL       (CALIBRATE_TIMER_INTERVAL + 31L)

/*---------------------------------------*/
/* Maximum PIO Delays (us)               */
/*---------------------------------------*/
#define MAX_WAIT_DRQ                 30                          /*V@93531*/
#define MAX_WAIT_BSY                  2000                          /*V@93531*/
#define MAX_WAIT_READY                1000

/*---------------------------------------*/
/* Maximum Transfer - MultiBlock Mode    */
/*---------------------------------------*/
#define MAX_MULTMODE_BLK                 16

/*---------------------------------------*/
/* Maximum Transfer - Bytes              */
/*---------------------------------------*/
#define MAX_XFER_BYTES_PER_INTERRUPT   8192

/*---------------------------------------*/
/* Maximum Transfer - Overall            */
/*---------------------------------------*/
#define MAX_XFER_SEC                    256

/*---------------------------------------*/
/* Mask to remove High Byte              */
/*---------------------------------------*/
#define LOW_BYTE_MASK                0x00FF

#define SECTORSHIFT             9

#define SCRATCH_BUF_SIZE        1024
#define SENSE_DATA_BYTES          18
#define NONSENSE_DATA_BYTES       88                                
#define DEVICE_TABLE_SIZE        512                                /*@Vvbr*/

#define TIMERS_PER_ACB          2

#define TIMER_POOL_SIZE         (sizeof(ADD_TIMER_POOL) +                     \
                                      ((TIMERS_PER_ACB * MAX_ADAPTERS))       \
                                * sizeof(ADD_TIMER_DATA))

#define ACB_POOL_SIZE           (MAX_ADAPTERS * (sizeof(ACB) + (MAX_UNITS *   \
                                (sizeof(UCB)))))

#define UNITINFO_POOL_SIZE      (sizeof(UNITINFO) * MAX_ADAPTERS * MAX_UNITS)


/*-------------------------------*/
/* Miscellaneous                 */
/*-------------------------------*/
#define ENABLE  _asm{ sti }
#define DISABLE _asm{ cli }
#define INT3   _asm{ int 3 }

#define uSPerMS                 1000

#define      COM1ADDRESS           0x03F8
#define      COM2ADDRESS           0x02F8
#define      COM3ADDRESS           0x03E8
#define      COM4ADDRESS           0x02E8

#define      MAXRESETS       4

#define      TASKTIME               -1L

#define  LEN_MODE_SENSE_10    24                                    /*@V151168*/

/* Begin [001] */

/* Miscellaneous constants */

#define MR_64K_LIMIT    0x00010000L         /* 64K memory limit */
#define MR_4K_LIMIT     0x00001000L         /* 4K memory limit */

/* End [001] */
