/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
/**************************************************************************
 *
 * SOURCE FILE NAME = HICDB.H
 *
 * DESCRIPTIVE NAME = Internal data structures for IOCTL handling in
 *                    the OS/2 CD-ROM Device Mgr.
 *
 *
 * VERSION = V2.0
 *
 * DATE
 *
 * DESCRIPTION
 *
 *
 * FUNCTIONS
 *
 * ENTRY POINTS:
 *
 * DEPENDENCIES:
 *
 * NOTES
 *
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
*/

/*
** Hitachi Vendor Unique Command Codes (group 6 commands)
*/
#define HIT_PLAY_AUDIO     0xE0
#define HIT_PAUSE          0xE1
#define HIT_PLAY_TNO       0xE2
#define HIT_DISK_INFO      0xE3
#define HIT_EJECT          0xE4
#define HIT_AUDIO_STATUS   0xE5
#define HIT_POWER_SAVE     0xE6
#define HIT_TEST           0xE7
#define HIT_EXT_DISK_INFO  0xE8

/*
** Hitachi Vendor Unique Command Descriptor Blocks
*/
/******************************
 * Play Audio           0xE0  *
 ******************************/

typedef struct {

   UCHAR    OpCode;

   UCHAR    immed       : 1;
   UCHAR    play_mode   : 2;
   UCHAR    reserved_1  : 2;
   UCHAR    LUN         : 3;

   UCHAR    start_min;
   UCHAR    start_sec;
   UCHAR    start_frame;

   UCHAR    reserved_2;
   UCHAR    reserved_3;

   UCHAR    end_min;
   UCHAR    end_sec;
   UCHAR    end_frame;

   UCHAR    reserved_4;

   UCHAR    control;

} HIT_CDB_PlayAudio, FAR *pHIT_CDB_PlayAudio;

/*
** Play mode definitions
*/
#define HIT_PLAY_MUTE      0x03
#define HIT_PLAY_RIGHT     0x02
#define HIT_PLAY_LEFT      0x01
#define HIT_PLAY_STEREO    0x00


/******************************
 * Pause                0xE1  *
 ******************************/

typedef struct {

   UCHAR    OpCode;

   UCHAR    reserved_1  : 5;
   UCHAR    LUN         : 3;

   UCHAR    reserved_2;
   UCHAR    reserved_3;
   UCHAR    reserved_4;
   UCHAR    reserved_5;
   UCHAR    reserved_6;
   UCHAR    reserved_7;
   UCHAR    reserved_8;
   UCHAR    reserved_9;
   UCHAR    reserved_10;

   UCHAR    control;

} HIT_CDB_Pause, FAR *pHIT_CDB_Pause;


/******************************
 * Disk Information     0xE3  *
 ******************************/

typedef struct {

   UCHAR    OpCode;

   UCHAR    UPC         : 1;
   UCHAR    reserved_1  : 4;
   UCHAR    LUN         : 3;

   UCHAR    reserved_2;
   UCHAR    reserved_3;
   UCHAR    reserved_4;
   UCHAR    reserved_5;
   UCHAR    reserved_6;
   UCHAR    reserved_7;
   UCHAR    reserved_8;

   UCHAR    alloc_length_msb;
   UCHAR    alloc_length_lsb;

   UCHAR    control;

} HIT_CDB_DiskInfo, FAR *pHIT_CDB_DiskInfo;


/*
** UPC Code Data
*/

typedef struct {

   UCHAR    ADR      : 4;
   UCHAR    control  : 4;

   UCHAR    N1    : 4;
   UCHAR    N2    : 4;
   UCHAR    N3    : 4;
   UCHAR    N4    : 4;
   UCHAR    N5    : 4;
   UCHAR    N6    : 4;
   UCHAR    N7    : 4;
   UCHAR    N8    : 4;
   UCHAR    N9    : 4;
   UCHAR    N10   : 4;
   UCHAR    N11   : 4;
   UCHAR    N12   : 4;
   UCHAR    N13   : 4;
   UCHAR    zero_1: 4;

   UCHAR    zero_2;

   UCHAR    aframe;

} HIT_DATA_UPCCode, FAR *pHIT_DATA_UPCCode;

/*
** Disk Information Data
*/

typedef struct {

   UCHAR    amin     : 7;
   UCHAR    data    : 1;
   UCHAR    asec;
   UCHAR    aframe;

} TRACK_INFO;

typedef struct {

   UCHAR    audio       : 1;
   UCHAR    data        : 1;
   UCHAR    reserved_1  : 6;

   UCHAR    min_tno;
   UCHAR    max_tno;

   UCHAR    lead_min;
   UCHAR    lead_sec;
   UCHAR    lead_frame;

   TRACK_INFO  track_info[99];

} HIT_DATA_DiskInfo, FAR *pHIT_DATA_DiskInfo;


/******************************
 * Eject                0xE4  *
 ******************************/

typedef struct {

   UCHAR    OpCode;

   UCHAR    reserved_1  : 5;
   UCHAR    LUN         : 3;

   UCHAR    reserved_2;
   UCHAR    reserved_3;
   UCHAR    reserved_4;
   UCHAR    reserved_5;
   UCHAR    reserved_6;
   UCHAR    reserved_7;
   UCHAR    reserved_8;
   UCHAR    reserved_9;

   UCHAR    eject       : 1;
   UCHAR    mode        : 1;
   UCHAR    reserved_10 : 8;

   UCHAR    control;

} HIT_CDB_Eject, FAR *pHIT_CDB_Eject;


/******************************
 * Audio Status         0xE5  *
 ******************************/

typedef struct {

   UCHAR    OpCode;

   UCHAR    reserved_1  : 5;
   UCHAR    LUN         : 3;

   UCHAR    reserved_2;
   UCHAR    reserved_3;
   UCHAR    reserved_4;
   UCHAR    reserved_5;
   UCHAR    reserved_6;
   UCHAR    reserved_7;
   UCHAR    reserved_8;
   UCHAR    reserved_9;
   UCHAR    reserved_10;

   UCHAR    control;

} HIT_CDB_AudioStatus, FAR *pHIT_CDB_AudioStatus;

/*
** Audio Status Data
*/

typedef struct {

   UCHAR    play_status : 1;
   UCHAR    reserved_1  : 7;

   UCHAR    ADR      : 4;
   UCHAR    control  : 4;

   UCHAR    tno;
   UCHAR    point;

   UCHAR    min;
   UCHAR    sec;
   UCHAR    frame;

   UCHAR    zero;

   UCHAR    amin;
   UCHAR    asec;
   UCHAR    aframe;

} HIT_DATA_AudioStatus, FAR *pHIT_DATA_AudioStatus;


