/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
/**************************************************************************
 *
 * SOURCE FILE NAME = FLTSTRAT.C
 *
 * DESCRIPTIVE NAME = Strategy 1 interface for CDROM Filter Driver
 *
 *
 * VERSION = V2.0
 *
 * DATE
 *
 * DESCRIPTION
 *
 *
 * FUNCTIONS   Provides validation and routing of Strategy 1 requests
 *             received from the OS/2 Kernel.
 *
 *
 * ENTRY POINTS:
 *
 * DEPENDENCIES:
 *
 * NOTES
 *
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
*/

#include "flthdr.h"

extern USHORT InitComplete;

/****************************************************************************
 *
 * FUNCTION NAME = CD_Filter_Strat1
 *
 * DESCRIPTION   =
 *
 *
 * INPUT         = ES:BX Pointer to Request Packet
 *
 * OUTPUT        = ES:BX Pointer to Request Packet
 *
 * RETURN-NORMAL =
 *
 * RETURN-ERROR  =
 *
 ****************************************************************************/

VOID NEAR CD_Filter_Strat1()
{

 PRPH           pRPH;
 USHORT         Cmd;

 _asm
   {
     mov word ptr pRPH[0], bx
     mov word ptr pRPH[2], es
   }

   Cmd = pRPH->Cmd;
   if ( (Cmd == CMDInitBase) && !InitComplete )
   {
      pRPH->Status = CD_Filter_Init( (PRPINITIN) pRPH );
   }
   else if ((Cmd == CMDOpen) || (Cmd == CMDClose))
   {
      pRPH->Status = STDON;
   }
   else
   {
      pRPH->Status = STDON + STERR + ERROR_I24_BAD_COMMAND;
   }

  _asm
  {
     leave
     retf
  }
}

