/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
/**************************************************************************
 *
 * SOURCE FILE NAME = FLTDEF.H
 *
 * DESCRIPTIVE NAME =
 *
 *
 * VERSION = V2.0
 *
 * DATE
 *
 * DESCRIPTION
 *
 * FUNCTIONS
 *
 * ENTRY POINTS:
 *
 * DEPENDENCIES:
 *
 * NOTES
 *
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
*/

/*
** Action codes for state machine
*/
#define CALL_ADD_AND_RET                    0x00
#define CALL_ADD_AND_NOTIFY_FILTER          0x01
#define CALL_ADD_AND_NOTIFY_CDM             0x02
#define NOTIFY_CDM                          0x03
#define NOTIFY_CDM_WITH_ERROR               0x04


#define MAX_UNITS              24
#define FILTERFLAGS            0
#define DRIVERCLASS_ADD        1

#define FF_INIT_TIME           0x0001
#define FF_REGISTERED          0x0002
#define FF_PLAY_STOPPED        0x0004


struct Vendor {
        UCHAR   *name;
/*      USHORT  vendor; */
};


/*
** IORB Filter WorkSpace structure
*/
typedef struct _IORB_FLTWORK
{
   UCHAR     input_parm_0;
   UCHAR     input_parm_1;
   PIORB     (FAR *CDM_NotifyAddress)(PIORB);      /* Notification Address  */
   USHORT    (NEAR *completion_address)(PIORB_CDB);
   NPUNITCB  pUnitCB;
   union     AddressType  end_play_address;
   SCATGATENTRY  SGList;
   USHORT    flags;
} IORB_FLTWORK, FAR *PIORB_FLTWORK, NEAR *NPIORB_FLTWORK;


#define FWF_SKIP_ERROR_CHECK    0x0001


/*
** IORB DMWorkSpace Structure
*/
typedef struct _IORB_DMWORK
{
   NPUNITCB      pUnitCB;
   USHORT        Reserved_1;
   PBYTE         pRequest;
   SCATGATENTRY  SGList;
   NPIORB        WaitingQueueLink;
   NPIORB        pCoReqIORB;

} IORB_DMWORK, FAR *PIORB_DMWORK, NEAR *NPIORB_DMWORK;


/*
** Function declarations
*/
USHORT  Filter_Seek_6 (PIORB_CDB);
USHORT  Filter_Read_6 (PIORB_CDB);
USHORT  Filter_ModeSelect (PIORB_CDB);
USHORT  Filter_StartStopUnit (PIORB_CDB);
USHORT  Filter_PreventAllowRemoval(PIORB_CDB);
USHORT  Filter_Seek_10 (PIORB_CDB);
USHORT  Filter_ReadSubChannel (PIORB_CDB);
USHORT  Filter_ReadTOC (PIORB_CDB);
USHORT  Filter_ReadHeader (PIORB_CDB);
/*USHORT  Filter_PlayAudio_10 (PIORB_CDB);        */
USHORT  Filter_PlayAudio_MSF (PIORB_CDB);
/*USHORT  Filter_PlayAudio_Track (PIORB_CDB);     */
/*USHORT  Filter_PlayAudio_Track_Rel (PIORB_CDB); */
USHORT  Filter_Pause_Resume (PIORB_CDB);
/*USHORT  Filter_PlayAudio_12 (PIORB_CDB);        */
/*USHORT  Filter_Read_12 (PIORB_CDB);             */
/*USHORT  Filter_PlayAudio_Track_12 (PIORB_CDB);  */
USHORT  Filter_CmdError (PIORB_CDB);

VOID    _loadds FAR  NotifyDoneIORB(PIORB);
VOID    FAR  InitPost(PIORB);
VOID    _loadds FAR  Filter_IORB (PIORB);

VOID   NEAR ZeroFSGS (VOID);


/*
** Function declarations for assembler routines
*/
VOID   FAR  f_ZeroCB (PBYTE, USHORT);

/*
** Pragma declarations - DevHelps
*/
#pragma alloc_text(Code, DevHelp_VirtToLin)
