/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
/* SCCSID = %W% %E% */
/**************************************************************************
 *
 * SOURCE FILE NAME =    ATAPIREG.h
 *
 * DESCRIPTIVE NAME = ATAPI.ADD - Adapter Driver for ATAPI/IDE-CD ROMs
 *
 *
 * VERSION = V1.0
 *
 * DATE 1/1/94
 *
 * DESCRIPTION : Register equates for ATAPI devices.
 *
 * FUNCTIONS
 *
 * ENTRY POINTS:
 *
 * DEPENDENCIES:
 *
 * NOTES:
 *
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
*/
/* drives */

#define UNIT0  0x00
#define UNIT1  0x10

/* Status bits */

#define FX_BUSY      0x0080        /* Status port busy bit                    */
#define FX_READY     0x0040        /* Status port ready bit                   */
#define FX_WRTFLT    0x0020        /* Write Fault                             */
#define FX_DRQ       0x0008        /* Data Request bit                        */
#define FX_ERROR     0x0001        /* Error status                            */


/* I/O ports for AT hard drives */

#define FX_PRIMARY   0x01F0        /* Default primary   ports                 */
#define FX_SECONDARY 0x0170        /* Default secondary ports                 */

/* Default address for the io ports
Ŀ
 SIZE   NAME       ADDRESS   Description                                      
                                       
 WORD   DATA       0x01F0    data register                                    
 BYTE   FEATURE    0x01F1    feature register                                 
 BYTE   ERROR      0x01F1    error register                                   
 BYTE   INTREASON  0x01F2    interrupt reason register                        
 BYTE   SAMTAG     0x01F3    reserved for SAM TAG Byte                        
 BYTE   BYTECTL    0x01F4    byte Count (Low order) register                  
 BYTE   BYTECTH    0x01F5    byte Count (high order) register                 
 BYTE   DRVSLCT    0x01F6    drive select register                            
 BYTE   CMD        0x01F7    command register                                 
 BYTE   STATUS     0x01F7    status register                                  
 BYTE   DEVCON     0x03F6    device control register                          

*/

/* Array indices (IOPorts[] and IORegs[]) for I/O port address and contents   */

/* Output Regs */

#define FI_PDATA      0                   /* data register                    */
#define FI_PFEATURE   1                   /* feature register                 */
#define FI_PINTREASON 2                   /* interrupt reason register        */
#define FI_PSECCOUNT  2                   /* ATA sector count register        */
#define FI_PSAMTAG    3                   /* reserved for SAM TAG Byte        */
#define FI_PBYTECTL   4                   /* byte Count (Low order) register  */
#define FI_PBYTECTH   5                   /* byte Count (high order) register */
#define FI_PDRVSLCT   6                   /* drive select register            */
#define FI_PCMD       7                   /* command register                 */
#define FI_PDEVCON    8                   /* device control register          */

/* Input Regs */

#define FI_PERROR    9                    /* error register                   */
#define FI_PSTATUS  10                    /* status register                  */

/* Bit Masks to determine if a register is desired to be written/read         */

#define FM_PDATA      (1<< FI_PDATA     ) /* data register                    */
#define FM_PFEATURE   (1<< FI_PFEATURE  ) /* feature register                 */
#define FM_PERROR     (1<< FI_PERROR    ) /* error register                   */
#define FM_PINTREASON (1<< FI_PINTREASON) /* interrupt reason register        */
#define FM_PSAMTAG    (1<< FI_PSAMTAG   ) /* reserved for SAM TAG Byte        */
#define FM_PBYTECTL   (1<< FI_PBYTECTL  ) /* byte Count (Low order) register  */
#define FM_PBYTECTH   (1<< FI_PBYTECTH  ) /* byte Count (high order) register */
#define FM_PDRVSLCT   (1<< FI_PDRVSLCT  ) /* drive select register            */
#define FM_PCMD       (1<< FI_PCMD      ) /* command register                 */
#define FM_PDEVCON    (1<< FI_PDEVCON   ) /* device control register          */

// Removed drive select due to call to selectunit.                  /*@V195083*/
#define FM_PATAPI_CMD (FM_PFEATURE | FM_PBYTECTL | FM_PBYTECTH | \
                       FM_PCMD)                                     /*@V195083*/

// Removed drive select due to call to selectunit.                  /*@V195083*/
#define FM_PATA_CMD   (FM_PCMD)                                     /*@V195083*/   

/* Default Register Values */

#define DEFAULT_ATAPI_FEATURE_REG     0x00
#define DMA_ON                        0x01

#define DEFAULT_ATAPI_DRV_SLCT_REG    0xA0
#define REV_17B_SET_LBA               0x40

#define DEFAULT_ATAPI_DEVCON_REG      0x08
#define INTERRUPT_DISABLE             0x02

/*
Ŀ
Interrupt Reason                defined value                                 
                                                                              
 IO    DRQ   COD                                                              
  0     1     1           IR_PKTREADY - Device is ready to accept             
                                        Packet Commands                       
  1     1     1            IR_MESSAGE - Ready to send message data to host    
  1     1     0   IR_XFER_FROM_DEVICE - Data is ready to be transfered to Host
  0     1     0     IR_XFER_TO_DEVICE - Device is ready to receive data       
  1     0     1           IR_COMPLETE - Status Register contains              
                                        completion status                     
                                                                              

*/

/* Interrupt Reason Register */

#define IRR_COD               0x01
#define IRR_IO                0x02

/* Interrupt Reson Register to Reason code masks */

#define IRM_IO                0x04
#define IRM_DRQ               0x02
#define IRM_COD               0x01

/* Interrupt Reason Codes */

#define IR_PKTREADY           0x03
#define IR_MESSAGE            0x07
#define IR_XFER_FROM_DEVICE   0x06
#define IR_XFER_TO_DEVICE     0x02
#define IR_COMPLETE           0x05

#define SENSEKEY_MASK         0XFF00

/* Interrupt control */

#define IRQ_FIXED_PRIMARY  0x000E  /* Fixed interrupt IRQ #                 */

/* ATA commands */
#define FX_CKPWRMODE 0x00E5        /* Check Power Mode                      */
#define FX_EXDRVDIAG 0x0090        /* Execute Drive Diagnostics             */
#define FX_IDLEIMM   0x00E1        /* Idle Immediate                        */
#define FX_NOP       0x0000        /* NOP                                   */
#define FX_SEEK      0x0070        /* Seek                                  */
#define FX_SETFTURE  0x00EF        /* Set Features                          */
#define FX_SLEEP     0x00E6        /* Sleep                                 */
#define FX_STDBYIMM  0x00E0        /* Stand By Immediate                    */

/* ATA Atapi Commands */
#define FX_SOFTRESET     0x0008    /* ATAPI Soft Reset                      */
#define FX_PKTCMD        0x00A0    /* ATAPI Packet Command                  */
#define FX_IDENTIFYDRIVE 0x00A1    /* ATAPI Identify Drive                  */

/* Spec Revision 1.7 B */
#define REV_17B_ATAPI_AUDIO_SCAN       0xD8
#define REV_17B_ATAPI_SET_CDROM_SPEED  0xDA
#define REV_17B_ATAPI_READ_CD          0xD4
#define REV_17B_ATAPI_READ_CD_MSF      0xD5

/* Mode Sense Page Codes  Capabilities Page */
#define REV_17B_PAGE_CAPABILITIES      0x0F

/* Page code Mask for mode sense */
#define REV_17B_PAGE_CODE_MASK         0x38

/* REV 1.7B Capabilities bit field definitions */

#define REV_17B_CP_MODE2_FORM1                 0x00000002
#define REV_17B_CP_MODE2_FORM2                 0x00000004
#define REV_17B_CP_READ_CDDA                   0x00000008
#define REV_17B_CP_PHOTO_CD                    0x00000020
#define REV_17B_CP_EJECT                       0x00000040
#define REV_17B_CP_LOCK                        0x00000080
#define REV_17B_CP_UPC                         0x00000200
#define REV_17B_CP_ISRC                        0x00000400
#define REV_17B_CP_INDEPENDENT_VOL_LEV         0x00000800
#define REV_17B_CP_SEPARATE_CH_MUTE            0x00001000
#define REV_17B_CP_TRAY_LOADER                 0x00002000
#define REV_17B_CP_POPUP_LOADER                0x00004000
#define REV_17B_CP_RESERVED_LOADER             0x00008000
#define REV_17B_CP_PREVENT_JUMPER              0x00010000
#define REV_17B_CP_LOCK_STATE                  0x00020000
#define REV_17B_CP_CDDA_ACCURATE               0x00040000
#define REV_17B_CP_C2_POINTERS                 0x00080000
