/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1992 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 source code is provided to you solely for       */
/*    the purpose of assisting you in your development of OS/2 device        */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Developer Connection Device Driver       */
/*    Source Kit for OS/2. This Copyright statement may not be removed.      */
/*                                                                           */
/*****************************************************************************/
/* SCCSID = src/dev/dasd/cdrom/atapi/atapicon.h, cdatapi, c.basedd 98/09/15 */
/**************************************************************************
 *
 * SOURCE FILE NAME = ATAPICON.H
 *
 * DESCRIPTION : Locally defined equates.
 *
 *
 *
 * VERSION = 1.0
 *
 * DATE
 *
 * DESCRIPTION :
 *
 * Purpose:
 *
 *
 *
 *
 *
*//*
 * Edit History for Feature # 149178:
 *
 * Edit    Date    Comments
 * ----- --------  -------------------------------------------------------------
 * [001] 01-03-96  Added definitions required for Bus Master DMA support. /jlh
 *
 */

/*---------------------------------------*/
/* Maximum Adapters/Units                */
/*---------------------------------------*/
#define MAX_ADAPTERS    4
#define MAX_UNITS       2

/*-------------------*/
/* TimeOut Equates   */
/*-------------------*/

/*---------------------------------------*/
/* TimeOut for RESET to complete (30s)   */
/*                                       */
/* After a RESET the drive is checked    */
/* every 200ms.                          */
/*---------------------------------------*/
#define DELAYED_RESET_MAX       (30*1000L)
#define DELAYED_RESET_INTERVAL  200L
#define ATAPI_RESET_DELAY 20                                            /*@V162970*/
#define ATAPI_NUM_RETRIES 5                                             /*@V162970*/

/*----------------------------------------------*/
/* TimeOut for IRQ from last interrupt (5s)     */
/*----------------------------------------------*/
#define IRQ_TIMEOUT_INTERVAL    (5*1000L)

/*----------------------------------------------*/
/* Retry Delay interval (200ms)                 */
/*----------------------------------------------*/
#define DELAYED_RETRY_INTERVAL  200L

/*---------------------------------------*/
/* Minimum User Timeout (5s)             */
/*---------------------------------------*/
#define MIN_USER_TIMEOUT        (IRQ_TIMEOUT_INTERVAL / 1000L)

/*---------------------------------------*/
/* Default User Timeout (30s)            */
/*---------------------------------------*/
#define DEFAULT_USER_TIMEOUT    30

/*---------------------------------------*/
/* Maximum Cmd/Data Error Retries        */
/*---------------------------------------*/
#define MAX_DATA_ERRORS         25

/*---------------------------------------*/
/* Initialization unit timeouts          */
/*---------------------------------------*/
#define INIT_TIMEOUT_LONG       (10*1000L)
#define INIT_TIMEOUT_SHORT      (    500L)                         /*@V117508*/
#define IRQ_TIMEOUT_LENGTH      ( 5*1000L)                         /*@V117508*/  //HCT

/*---------------------------------------*/
/* Elapsed Timer Interval (200ms)        */
/*---------------------------------------*/
#define ELAPSED_TIMER_INTERVAL  200

/*---------------------------------------*/
/* Calibrate Loop Counter                */
/*---------------------------------------*/
#define CALIBRATE_LOOP_COUNT            1024
#define CALIBRATE_TIMER_INTERVAL        (4*31L)
#define CALIBRATE_INTERVAL_ACTUAL       (CALIBRATE_TIMER_INTERVAL + 31L)

/*---------------------------------------*/
/* Maximum PIO Delays (us)               */
/*---------------------------------------*/
#define MAX_WAIT_DRQ                    50                          /*V@93531*/  //HCT D205281/
#define MAX_WAIT_BSY                  2000                          /*V@93531*/
#define MAX_WAIT_READY                1000

/*---------------------------------------*/
/* Maximum Transfer - MultiBlock Mode    */
/*---------------------------------------*/
#define MAX_MULTMODE_BLK                 16

/*---------------------------------------*/
/* Maximum Transfer - Bytes              */
/*---------------------------------------*/
#define MAX_XFER_BYTES_PER_INTERRUPT   8192

/*---------------------------------------*/
/* Maximum Transfer - Overall            */
/*---------------------------------------*/
#define MAX_XFER_SEC                    256

/*---------------------------------------*/
/* Mask to remove High Byte              */
/*---------------------------------------*/
#define LOW_BYTE_MASK                0x00FF

#define SECTORSHIFT             9

#define SCRATCH_BUF_SIZE        1024
#define SENSE_DATA_BYTES        18

#define TIMERS_PER_ACB          2

#define TIMER_POOL_SIZE         (sizeof(ADD_TIMER_POOL) +                     \
                                      ((TIMERS_PER_ACB * MAX_ADAPTERS))       \
                                * sizeof(ADD_TIMER_DATA))

#define ACB_POOL_SIZE           (MAX_ADAPTERS * (sizeof(ACB) + (MAX_UNITS *   \
                                (sizeof(UCB)))))

#define UNITINFO_POOL_SIZE      (sizeof(UNITINFO) * MAX_ADAPTERS * MAX_UNITS)


/*-------------------------------*/
/* Miscellaneous                 */
/*-------------------------------*/
#define ENABLE  _asm{ sti }
#define DISABLE _asm{ cli }
#define INT3   _asm{ int 3 }

#define uSPerMS                 1000

#define      COM1ADDRESS           0x03F8
#define      COM2ADDRESS           0x02F8
#define      COM3ADDRESS           0x03E8
#define      COM4ADDRESS           0x02E8

#define      MAXRESETS       4                                      
#define      MAXRESUMERESETS 1

#define      TASKTIME               -1L

#define  LEN_MODE_SENSE_10    24                                    /*@V151168*/

/* Begin [001] */

/* Miscellaneous constants */

#define MR_64K_LIMIT    0x00010000L         /* 64K memory limit */
#define MR_4K_LIMIT     0x00001000L         /* 4K memory limit */

/* End [001] */
