/* update installation disks                                      */
/* 05.20.2000: initial version (0.1)                              */
/* 06.04.2000: added support for incorporating DD Fixpak (0.2)    */
/* 08.19.2000: made it more robust                                */
/* 08.27.2000: made it look nicer (0.3)                           */
/* 09.24.2000: perliminary support bootable CD added              */
/* 09.30.2000: added support for virtual floppy                   */
/* 10.01.2000: small improvements                                 */

parse arg cddir fpdir n.errors n.warnings n.elapsed log ver expert

if iddir = '' | fpdir = '' then do
	say
	say ' Update OS/2 installation diskettes with fixpak.'
	say ' Usage: updif <directory installation CD> <directory fixpak files>'
	say ' Example: updif e:\updcd\burn e:\updcd\fix'
	exit 1
end

/* we need to know the absolute path */
cdir  = directory()
fpdir = directory(fpdir)
cdir  = directory(cdir) 
cddir = directory(cddir) 
cdir  = directory(cdir)
iddir = cddir||'\DISKIMGS\OS2\35'
exdir = cddir||'\DISKIMGS'

/* reset some variables */
if log = '' then log = 'updif.log'
if ver = '' then ver = 0.5
if n.errors = '' then n.errors = 0
if n.warnings = '' then n.warnings = 0
if n.elapsed = '' then n.elapsed = 0
if expert  = '' then expert = 1

/* learn drive letter floppy */
call rxfuncadd sysdriveinfo, rexxutil, sysdriveinfo
flpdrv = translate('k:') /* <----- change it match your virtual floppy */
parse value sysdriveinfo(flpdrv) with . . flpsz .
if flpsz <> 1457664 then flpdrv = 'A:' /* use A: otherwise */

/* reset screen */
say '1B'x || '[36;44m'
say '1B'x || '[1m'
'@cls'
call rxfuncadd syscurstate, rexxutil, syscurstate
call syscurstate off
say '1B'x || '[2;2HUpdate OS/2 installation CD-ROM, version 'ver
say '1B'x || '[4;2HTarget directory      : 'substr(flpdrv'\', 1, 50)
say '1B'x || '[5;2HSource directory      : 'substr(iddir, 1, 50)
say '1B'x || '[7;2HCurrent activity      : 'substr('Thinking...', 1, 50)
say '1B'x || '[8;2HTarget object         : 'substr('Searching...', 1, 50)
say '1B'x || '[9;2HSource object         : 'substr('Searching...', 1, 50)
say '1B'x || '[11;2HUpdate action         : 'substr('Searching...', 1, 50)
say '1B'x || '[12;2HUpdate return code    : 0'
say '1B'x || '[14;2HElapsed time [m]      : 'trunc(time('E')/60 + n.elapsed, 2)
say '1B'x || '[15;2HNumber of errors      : 'n.errors
say '1B'x || '[16;2HNumber of warnings    : 'n.warnings
say '1B'x || '[17;2HUpdate log            : 'log
say '1B'x || '[19;2H'

rc = lineout(log, 'Info: Creating installation floppies from 'iddir' and 'fpdir'... ('date() time()', version 'ver')')
rc = lineout(log)
call create_flop 'DISK0'
call report_status
call create_flop 'DISK1_CD'
call report_status
call create_flop 'DISK2'
call report_status

if n.elapsed > 0 then do
	rc = lineout('result.out', n.errors||' '||n.warnings, 1)
end
exit 

/* create and update install floppy */
create_flop: procedure expose log iddir fpdir cddir exdir n. ver flpdrv

	parse arg disk
	image = iddir || '\' || disk || '.dsk'

	/* ask the user to do something useful :-) */
	say '1B'x || '[7;26HCreating 'disk

	/* create installation floppy */
	rcode = 1
	do while rcode <> 0
		say '1B'x || '[19;2HPlease insert a blank floppy in drive 'flpdrv' and press ENTER'
		if expert = 0 then '@pause >nul 2>>&1'
		say '1B'x || '[19;2H'substr(' ', 1, 70)
		/* call execute '@'exdir'\xdfcopy 'image flpdrv' /Y' */
		call execute '@'exdir'\loaddskf 'image flpdrv' /Y /Q /S /F '
		rcode = result
		if rcode <> 0 then do
			say '1B'x || '[19;2HError creating floppy, press any key to try it again'
			'@pause >nul 2>>&1'
		end
	end

	/* create some space */
	if stream(flpdrv'\bundle', 'c', 'query exists') <> '' then call execute '@del 'flpdrv'\bundle'
	if stream(flpdrv'\readme.ins', 'c', 'query exists') <> '' then call execute '@del 'flpdrv'\readme.ins'
	if stream(flpdrv'\IBM2FLPY.ADD', 'c', 'query exists') <> '' then call execute '@del 'flpdrv'\IBM2*'

	/* update floppy */
	'@del result.out >nul 2>>&1'
	'@call updcd 'flpdrv fpdir n.errors n.warnings trunc(time('E')/60 + n.elapsed, 2) log ver
	res = linein('result.out')
	rc = lineout('result.out')
	parse var res n.errors n.warnings

	/* postprocessing floppy */
	say '1B'x || '[7;26H'substr('Postprocessing 'disk, 1, 50)

	if translate(disk) = 'DISK0' then do
		if n.elapsed > 0 then do
			call execute '@del 'flpdrv'\os2krnli'
			call execute '@xcopy 'flpdrv'\*     'cddir'\updcd\bootimg\DISK_0_1.IMG\.'
			call execute '@copy 'fpdir'\os2krnl 'cddir'\updcd\bootimg\DISK_0_1.IMG\.'
		end
		call execute '@copy 'fpdir'\os2krnl 'flpdrv'\os2krnli'
	end

	if translate(disk) = 'DISK1_CD' then do
		config_file = flpdrv'\CONFIG.SYS'
		i = 1
		do while lines(config_file)
			l.i = linein(config_file)
			i = i+1
		end
		rc = lineout(config_file)
		l.0 = i - 1
		call execute '@del 'config_file
		do i = 1 to l.0
			if pos('IBM2', translate(l.i)) > 0 then iterate /* remove PS/2 drivers */
			rc = lineout(config_file, l.i)
		end
		rc = lineout(config_file)

		if n.elapsed > 0 then do
			call execute '@xcopy 'flpdrv'\* 'cddir'\updcd\bootimg\DISK_0_1.IMG'
			config_file = cddir'\updcd\bootimg\DISK_0_1.IMG\CONFIG.SYS'
			i = 1
			do while lines(config_file)
				l.i = linein(config_file)
				i = i+1
			end
			rc = lineout(config_file)
			l.0 = i - 1
			call execute '@del 'config_file
			do i = 1 to l.0
				select 
					when pos('IBM1FLPY.ADD', translate(l.i)) > 0 then do
						rc = lineout(config_file, 'basedev=IBM1FLPY.ADD /A:0 /FORCE:1 /U:0 /F:2.88MB')
					end
					when pos('IBMIDECD.FLT', translate(l.i)) > 0 then do
						rc = lineout(config_file, l.i)
						rc = lineout(config_file, 'BASEDEV=CD_BOOT.FLT /D:3')
					end
					otherwise
						rc = lineout(config_file, l.i)
				end
			end
			rc = lineout(config_file, 'SET BOOTEDFROMCD=YES')
			rc = lineout(config_file)
		end
	end

	if translate(disk) = 'DISK2' then do
		if n.elapsed > 0 then call execute '@xcopy 'flpdrv'\* 'cddir'\updcd\bootimg\DISK_2.IMG\.'
	end

	/* generate updated image */
	say '1B'x || '[4;2HTarget directory      : 'substr(iddir, 1, 50)
	say '1B'x || '[5;2HSource directory      : 'substr(flpdrv'\', 1, 50)
	say '1B'x || '[7;26H'substr('Updating CD image', 1, 50)
	say '1B'x || '[19;2H'substr(' ', 1, 70)
	/* call execute '@'exdir'\xdfcopy 'flpdrv image' /Y' */
	call execute '@savedskf 'flpdrv image

return

/* execute command, display it and write to log */ 
execute: procedure expose log n. iddir flpdrv

	parse arg comm
	parse upper var comm comm1 comm2 comm3 comm4 rest
	say '1B'x || '[8;26H'substr(comm3, 1, 50)
	say '1B'x || '[9;26H'substr(comm2, 1, 50)
	say '1B'x || '[11;26H'substr(comm1, 2, 50)
	comm '>nul 2>>&1'
	rcode = rc
	say '1B'x || '[12;26H'rcode' '

	if rcode <> 0 then do
		rc = lineout(log, 'Error: 'comm' (rc='rcode')')
		rc = lineout(log)
		n.errors = n.errors + 1
	end
	else do
		rc = lineout(log, 'Info: 'comm' (rc='rcode')')
		rc = lineout(log)
	end

	call report_status

return rcode

/* display status */
report_status: procedure expose n. iddir flpdrv

	say '1B'x || '[4;2HTarget directory      : 'substr(flpdrv'\', 1, 50)
	say '1B'x || '[5;2HSource directory      : 'substr(iddir, 1, 50)
	say '1B'x || '[7;2HCurrent activity      : 'substr('Thinking...', 1, 50)
	say '1B'x || '[8;2HTarget object         : 'substr('Searching...', 1, 50)
	say '1B'x || '[9;2HSource object         : 'substr('Searching...', 1, 50)
	say '1B'x || '[11;2HUpdate action         : 'substr('Searching...', 1, 50)
	say '1B'x || '[12;2HUpdate return code    : 0'
	say '1B'x || '[14;2HElapsed time [m]      : 'trunc(time('E')/60 + n.elapsed, 2)
	say '1B'x || '[15;2HNumber of errors      : 'n.errors
	say '1B'x || '[16;2HNumber of warnings    : 'n.warnings
	say '1B'x || '[19;2H'

return
