/* install plug-in FAT32 driver      */
/* place the following files in this */
/* directory from the FAT32 package: */
/* FAT32.IFS                         */
/* CACHEF32.EXE                      */
/* F32STAT.EXE                       */
/* MONITOR.EXE                       */
/* UFAT32.DLL                        */
/* PARTFILT.FLT                      */
/* fat32.txt                         */
/* partfilt.txt                      */
/* partfilt.doc                      */


parse arg target source

/* exit if package does not exist */
if stream(source'\updcd\addons\fat32\fat32.ifs', 'c', 'query exists') = '' then exit

/* copy files but do not overwrite them if they are already there */
if stream(target'\os2\FAT32.IFS', 'c', 'query exists') = '' then do
	'copy 'source'\updcd\addons\fat32\FAT32.IFS 'target'\os2\.'
end
if stream(target'\os2\CACHEF32.EXE', 'c', 'query exists') = '' then do
	'copy 'source'\updcd\addons\fat32\CACHEF32.EXE 'target'\os2\.'
end
if stream(target'\os2\F32STAT.EXE', 'c', 'query exists') = '' then do
	'copy 'source'\updcd\addons\fat32\F32STAT.EXE 'target'\os2\.'
end
if stream(target'\os2\MONITOR.EXE', 'c', 'query exists') = '' then do
	'copy 'source'\updcd\addons\fat32\MONITOR.EXE 'target'\os2\.'
end
if stream(target'\os2\DLL\UFAT32.DLL', 'c', 'query exists') = '' then do
	'copy 'source'\updcd\addons\fat32\UFAT32.DLL 'target'\os2\dll\.'
end
if stream(target'\os2\boot\PARTFILT.FLT', 'c', 'query exists') = '' then do
	'copy 'source'\updcd\addons\fat32\PARTFILT.FLT 'target'\os2\boot\.'
end
if stream(target'\os2\help\fat32.txt', 'c', 'query exists') = '' then do
	'copy 'source'\updcd\addons\fat32\fat32.txt 'target'\os2\help\.'
end
if stream(target'\os2\help\partfilt.txt', 'c', 'query exists') = '' then do
	'copy 'source'\updcd\addons\fat32\partfilt.txt 'target'\os2\help\.'
end
if stream(target'\os2\help\partfilt.doc', 'c', 'query exists') = '' then do
	'copy 'source'\updcd\addons\fat32\partfilt.doc 'target'\os2\help\.'
end


/* change config.sys if needed */
cfgfile = target'\config.sys'
q = 1
do while lines(cfgfile)
	l.q = linein(cfgfile)
	if pos('FAT32.IFS', translate(l.q)) > 0 
		then exit /* the driver is already added, leave the config.sys alone */
	q = q+1
end
rc = lineout(cfgfile)
l.0 = q-1

/* backup config.sys */
'copy 'cfgfile target'\config.f32' 
'del 'cfgfile
gevonden = 0
do q=1 to l.0
	if pos('HPFS.IFS', translate(l.q)) > 0 then do
		/* add FAT32 driver after HPFS.IFS */
		gevonden = 1
	end
	rc = lineout(cfgfile, l.q)
	if gevonden = 1 then do
		rc = lineout(cfgfile, ' ')
		rc = lineout(cfgfile, 'REM UpdCD')
		rc = lineout(cfgfile, 'IFS='target'\OS2\FAT32.IFS')
		rc = lineout(cfgfile, 'CALL='target'\OS2\CACHEF32.EXE')
		rc = lineout(cfgfile, 'BASEDEV=PARTFILT.FLT /P 0B /W') 
		gevonden = 0
	end
end
rc = lineout(cfgfile)

exit
