/* install plug-in DANI IDE driver   */
/* place the following files in this */
/* directory from the DANI package:  */
/* DaniS506.ADD                      */
/* DaniS506.DOC                      */
/* DiskInfo.exe                      */
/* DumpIDE.EXE                       */

parse arg target source

/* exit if package does not exist */
if stream(source'\updcd\addons\daniide\DaniS506.ADD', 'c', 'query exists') = '' then exit

/* copy files but do not overwrite them if they are already there */
if stream(target'\os2\boot\DaniS506.ADD', 'c', 'query exists') = '' then do
	'copy 'source'\updcd\addons\daniide\DaniS506.ADD 'target'\os2\boot\.'
end
if stream(target'\os2\help\DaniS506.DOC', 'c', 'query exists') = '' then do
	'copy 'source'\updcd\addons\daniide\DaniS506.DOC 'target'\os2\help\.'
end
if stream(target'\os2\DiskInfo.exe', 'c', 'query exists') = '' then do
	'copy 'source'\updcd\addons\daniide\DiskInfo.exe 'target'\os2\.'
end
if stream(target'\os2\DumpIDE.EXE', 'c', 'query exists') = '' then do
	'copy 'source'\updcd\addons\daniide\DumpIDE.EXE 'target'\os2\.'
end

/* change config.sys if needed */
cfgfile = target'\config.sys'
q = 1
do while lines(cfgfile)
	l.q = linein(cfgfile)
	if pos('DANIS506.ADD', translate(l.q)) > 0 
		then exit /* the driver is already added, leave the config.sys alone */
	q = q+1
end
rc = lineout(cfgfile)
l.0 = q-1

/* backup config.sys */
'copy 'cfgfile target'\config.dni' 
'del 'cfgfile
do q=1 to l.0
	if pos('IBM1S506.ADD', translate(l.q)) > 0 then do
		/* add DANI driver */
		rc = lineout(cfgfile, ' ')
		rc = lineout(cfgfile, 'REM UpdCD')
		rc = lineout(cfgfile, 'BASEDEV=DANIS506.ADD')
		/* rem IBM driver out */
		l.q = 'REM UpdCD '||l.q 
	end
	rc = lineout(cfgfile, l.q)
end
rc = lineout(cfgfile)

exit
