/* install plug-in DANI FLT driver   */
/* place the following files in this */
/* directory from the DANI package:  */
/* DaniATAPI.DOC -> DaniATAP.DOC     */
/* DaniATAPI.FLT -> DaniATAP.FLT     */
/* rename the files as shown above   */


parse arg target source

target = 'd:'
source = 'e:'

/* exit if package does not exist */
if stream(source'\updcd\addons\daniflt\DaniATAP.FLT', 'c', 'query exists') = '' then exit

/* copy files but do not overwrite them if they are already there */
if stream(target'\os2\boot\DaniATAP.FLT', 'c', 'query exists') = '' then do
	'copy 'source'\updcd\addons\daniflt\DaniATAP.FLT 'target'\os2\boot\.'
end
if stream(target'\os2\help\DaniATAP.DOC', 'c', 'query exists') = '' then do
	'copy 'source'\updcd\addons\daniflt\DaniATAP.DOC 'target'\os2\help\.'
end

/* change config.sys if needed */
cfgfile = target'\config.sys'
q = 1
do while lines(cfgfile)
	l.q = linein(cfgfile)
	if pos('DaniATAP.FLT', translate(l.q)) > 0 
		then exit /* the driver is already added, leave the config.sys alone */
	q = q+1
end
rc = lineout(cfgfile)
l.0 = q-1

/* backup config.sys */
'copy 'cfgfile target'\config.dnf' 
'del 'cfgfile
gevonden = 0
do q=1 to l.0
	if (pos('IBMIDECD.FLT', translate(l.q)) > 0 | pos('IBMATAPI.FLT', translate(l.q)) > 0) & gevonden = 0 then do
		/* add DANI driver */
		rc = lineout(cfgfile, ' ')
		rc = lineout(cfgfile, 'REM UpdCD')
		rc = lineout(cfgfile, 'BASEDEV=DaniATAP.FLT')
		/* rem IBM driver out */
		l.q = 'REM UpdCD '||l.q 
		rc = lineout(cfgfile, l.q)
		gevonden = 1
		iterate
	end
	if (pos('IBMIDECD.FLT', translate(l.q)) > 0 | pos('IBMATAPI.FLT', translate(l.q)) > 0) & gevonden = 1 then do
		rc = lineout(cfgfile, ' ')
		rc = lineout(cfgfile, 'REM UpdCD')
		l.q = 'REM UpdCD '||l.q 
		gevonden = 2
	end
	rc = lineout(cfgfile, l.q)
end
rc = lineout(cfgfile)

exit
