/* */

'@echo off'
/*****************************************************************************/
/* WFDESK                                                                    */
/*                                                                           */
/*      This command file is an alternative to phase 2 of the WorkFrame/2    */
/* installation.  It will build all necessary WorkPlace Shell objects.       */
/* Please note that this command file does little error checking and         */
/* attempts no recovery if it fails.                                         */
/* If a failure does occur, clean up WPS completely by deleting both the     */
/* WorkFrame/2 folder on the desktop and WorkFrame/2 templates.  After you   */
/* have rebooted, run this command file with a long pause_time (at least 5   */
/* seconds).  After each failure, perform the clean up, reboot and double    */
/* the pause_time until pause 2 of the installation succeeds.                */
/*****************************************************************************/

/*---------------------------------------------------------------------------*/
/* PARSE COMMAND-LINE                                                        */
/*---------------------------------------------------------------------------*/
parse source os kind command  /* store command file name */
parse upper arg boot_drive wf2_directory pause_time

if (boot_drive = '' | boot_drive = '/?' | boot_drive = '?' | wf2_directory = '' | wf2_directory = '/?' | wf2_directory = '?') then
do
      say 'Usage: 'command' boot_drive wf2_directory [pause_time]'
      say ''
      say '      where boot_drive = drive where OS/2 is installed (e.g., C:).'
      say '         wf2_directory = full path name where WorkFrame/2 is installed (e.g., C:\IBMWF).'
      say '            pause_time = number of seconds to pause between system commands (e.g., 5).'
      say '                         (Range is between 0 and 999; default is zero - 0).'
      say '                         (Note: On very slow machines it may be necessary to pause a considerable amount.)'
      exit(0)
end

/*---------------------------------------------------------------------------*/
/* DEFINE SYSTEM FUNCTIONS                                                   */
/*---------------------------------------------------------------------------*/
call rxfuncadd sysloadfuncs, rexxutil, sysloadfuncs
call sysloadfuncs

/*---------------------------------------------------------------------------*/
/* CHECK ARGUMENTS                                                           */
/*---------------------------------------------------------------------------*/
if wf2_directory = '.' then
     wf2_directory=directory()  /* pathname of cwd */
else
do
     if wf2_directory = '..' then
     do
     wf2_directory=directory()       /* store cwd */
     wf2_directory=directory('..')   /* pathname of directory above cwd */
     rc=directory(dirCurrent)        /* move back to cwd */
     end
end

rc = SysFileTree(wf2_directory,dir,D) /*check directory existance*/
if (rc \= 0 | dir.0 = 0) then
do
     say command': Error - directory='wf2_directory' does not exist.'
     exit(1)
end

if (pause_time = '') then
     pause_time=0
if (pause_time < 0 | pause_time > 999) then
do
     say command': Error - invalid pause_time='pause_time'; range is between 0 and 999.'
     exit(1)
end

say command': STARTING WORKFRAME/2 PHASE 2 INSTALLATION ...'
/*---------------------------------------------------------------------------*/
/* SETUP INSTALLATION PHASE INFORMATION                                      */
/*---------------------------------------------------------------------------*/
say command': Updating system files, please wait ...'
iniFile. = ''
iniFile.0 = 4
iniFile.1.!name = ''
iniFile.1.!app  = 'IBMWFV2'
iniFile.1.!key  = 'DIR'
iniFile.1.!val  = wf2_directory
iniFile.2.!name = ''
iniFile.2.!app  = 'IBMWFV2'
iniFile.2.!key  = 'PHASE'
iniFile.2.!val  = '1'
iniFile.3.!name = boot_drive'\os2\ibmwfv2.ini'
iniFile.3.!app  = 'IBMWFV2'
iniFile.3.!key  = 'DIR'
iniFile.3.!val  = wf2_directory
iniFile.4.!name = boot_drive'\os2\ibmwfv2.ini'
iniFile.4.!app  = 'IBMWFV2'
iniFile.4.!key  = 'PHASE'
iniFile.4.!val  = '1'

do i=1 to iniFile.0
     rc=SysSleep(pause_time)
     rc=SysIni(iniFile.i.!name, iniFile.i.!app, iniFile.i.!key, iniFile.i.!val)
     if (iniFile.i.!name = '') then
          iniFile.i.!name = 'USER' /* display name for default ini file */
     if (rc = '') then
          say command':     Successful ini file update 'i' - 'iniFile.i.!name
     else
     do
          say command':     Failed ini file update 'i' - 'iniFile.i.!name' with RC='rc
          exit(rc)
     end
end

/*---------------------------------------------------------------------------*/
/* DEREGISTER AND REGISTER WORKFRAME/2 CLASSES                               */
/*---------------------------------------------------------------------------*/
say command': Deregistering WorkFrame/2 classes, please wait ...'
classWF2. = ''
classWF2.0 = 4
classWF2.1.!name = 'DDE3Router'
classWF2.1.!dll  = 'dde3worm'
classWF2.2.!name = 'DDE3Profile'
classWF2.2.!dll  = 'dde3sprf'
classWF2.3.!name = 'DDE3Folder'
classWF2.3.!dll  = 'dde3prjf'
classWF2.4.!name = 'DDE3Project'
classWF2.4.!dll  = 'dde3base'

do i=1 to classWF2.0
     rc=SysSleep(pause_time)
     rc = SysDeregisterObjectClass(classWF2.i.!name)
     if (rc) then
          say command':     Successful deregistration - 'classWF2.i.!name
     else
     do
          say command':     Failed deregistration - 'classWF2.i.!name' with RC='rc' continuing ...'
     end
end

say command': Registering WorkFrame/2 classes, please wait ...'
do i=1 to classWF2.0
     rc=SysSleep(pause_time)
     rc = SysRegisterObjectClass(classWF2.i.!name,classWF2.i.!dll)
     if (rc) then
          say command':     Successful registration - 'classWF2.i.!name
     else
     do
          say command':     Failed registration - 'classWF2.i.!name' with RC='rc
          exit(rc)
     end
end

/*---------------------------------------------------------------------------*/
/* CREATE WORKFRAME/2 OBJECTS                                                */
/*---------------------------------------------------------------------------*/
say command': Creating WorkFrame/2 objects, please wait ...'

objectWF2. = ''
objectWF2.0 = 22
/*---------------------------------------------------------------------------*/
objectWF2.1.!classname      = 'WPFolder'
objectWF2.1.!title          = 'IBM WorkFrame/2 V2.1'
objectWF2.1.!location       = '<WP_DESKTOP>'
objectWF2.1.!setup          = 'OBJECTID=<WKF_MAINFOLDER>;NOCOPY=YES;NORENAME=YES;ICONFILE='wf2_directory'\wkframe.ico'
objectWF2.1.!options        = 'replace'
objectWF2.1.!objectid       = '<WKF_MAINFOLDER>'
objectWF2.1.!objectdata.0   = 0
objectWF2.1.!optionsdata.0  = 0
/*---------------------------------------------------------------------------*/
objectWF2.2.!classname      = 'WPFolder'
objectWF2.2.!title          = 'Actions Profiles'
objectWF2.2.!location       = '<WKF_MAINFOLDER>'
objectWF2.2.!setup          = 'OBJECTID=<WKF_PROFILE_FOLDER>;NOCOPY=YES;NORENAME=YES;ICONFILE='wf2_directory'\profold.ico'
objectWF2.2.!options        = 'replace'
objectWF2.2.!objectid       = '<WKF_PROFILE_FOLDER>'
objectWF2.2.!objectdata.0   = 0
objectWF2.2.!optionsdata.0  = 0
/*---------------------------------------------------------------------------*/
objectWF2.3.!classname      = 'WPFolder'
objectWF2.3.!title          = 'Information'
objectWF2.3.!location       = '<WKF_MAINFOLDER>'
objectWF2.3.!setup          = 'OBJECTID=<WKF_INFO_FOLDER>;ICONFILE='wf2_directory'\info.ico'
objectWF2.3.!options        = 'replace'
objectWF2.3.!objectid       = '<WKF_INFO_FOLDER>'
objectWF2.3.!objectdata.0   = 0
objectWF2.3.!optionsdata.0  = 0
/*---------------------------------------------------------------------------*/
objectWF2.4.!classname      = 'WPFolder'
objectWF2.4.!title          = 'Tools'
objectWF2.4.!location       = '<WKF_MAINFOLDER>'
objectWF2.4.!setup          = 'OBJECTID=<WKF_TOOLSFOLDER>;ICONFILE='wf2_directory'\tools.ico'
objectWF2.4.!options        = 'replace'
objectWF2.4.!objectid       = '<WKF_TOOLSFOLDER>'
objectWF2.4.!objectdata.0   = 0
objectWF2.4.!optionsdata.0  = 0
/*---------------------------------------------------------------------------*/
objectWF2.5.!classname      = 'DDE3Router'
objectWF2.5.!title          = 'Action Log'
objectWF2.5.!location       = '<WKF_MAINFOLDER>'
objectWF2.5.!setup          = 'OBJECTID=<WKF_ROUTER>'
objectWF2.5.!options        = 'replace'
objectWF2.5.!objectid       = '<WKF_ROUTER>'
objectWF2.5.!objectdata.0   = 0
objectWF2.5.!optionsdata.0  = 0
/*---------------------------------------------------------------------------*/
objectWF2.6.!classname      = 'DDE3Profile'
objectWF2.6.!title          = 'Default Actions Profile'
objectWF2.6.!location       = '<WKF_PROFILE_FOLDER>'
objectWF2.6.!setup          = 'OBJECTID=<WKF_PROFILE_DFLT>;NODELETE=YES;NOCOPY=YES;NORENAME=YES;ICONFILE='wf2_directory'\DEFPRO.ICO'
objectWF2.6.!options        = 'replace'
objectWF2.6.!objectid       = '<WKF_PROFILE_DFLT>'
objectWF2.6.!objectdata.0   = 11
objectWF2.6.!objectdata.1   = 'WKF_ACTION=Monitored, RUN, *, *.exe'||x2c('0a')||'*.com*.cmd'||x2c('0a')||'*.bat, , DDE3DEF2, RUN, WKF_ACTIONTYPE_CMD, WKF_ACTIONSCOPE_FILE, WKF_MENUSCOPE_SHORT, WKF_RUNMODE_MONITOR,'
objectWF2.6.!objectdata.2   = 'WKF_ACTION=Foreground, RUN, *, *.exe'||x2c('0a')||'*.com'||x2c('0a')||'*.cmd'||x2c('0a')||'*.bat, , DDE3DEF2, RUN, WKF_ACTIONTYPE_CMD, WKF_ACTIONSCOPE_FILE, WKF_MENUSCOPE_SHORT, WKF_RUNMODE_DEFAULT,'
objectWF2.6.!objectdata.3   = 'WKF_ACTION=WorkFrame/2, MAKEMAKE, dde3make.exe, , *.mak'||x2c('0a')||'makefile, DDE3DEF2, DEFAULT, WKF_ACTIONTYPE_CMD, WKF_ACTIONSCOPE_PROJECT, WKF_MENUSCOPE_SHORT, WKF_RUNMODE_DEFAULT,'
objectWF2.6.!objectdata.4   = 'IF_FOUND=nmake.exe;WKF_ACTION=NMake, MAKE, nmake.exe, *.mak'||x2c('0a')||'makefile, , DDE3DEF2, MAKE, WKF_ACTIONTYPE_CMD, WKF_ACTIONSCOPE_BOTH,  WKF_MENUSCOPE_SHORT, WKF_RUNMODE_MONITOR, view toolinfo %TOPIC%, nmake'
objectWF2.6.!objectdata.5   = 'WKF_ACTION=Link, LINK, link386.exe, *.obj'||x2c('0a')||'*.def, *.exe'||x2c('0a')||'*.map'||x2c('0a')||'*.dll, DDE3DEF2, LINK,    WKF_ACTIONTYPE_CMD, WKF_ACTIONSCOPE_FILE,    WKF_MENUSCOPE_SHORT, WKF_RUNMODE_MONITOR,'
objectWF2.6.!objectdata.6   = 'WKF_ACTION=PMLib, LIB, pmlib.exe, *.obj'||x2c('0a')||'*.lib, *.lib'||x2c('0a')||'*.lst, DDE3DEF2, DEFAULT, WKF_ACTIONTYPE_CMD, WKF_ACTIONSCOPE_PROJECT, WKF_MENUSCOPE_SHORT, WKF_RUNMODE_DEFAULT,'
objectWF2.6.!objectdata.7   = 'WKF_ACTION=Object Library Manager, LIB, lib.exe, *.obj'||x2c('0a')||'*.lib, *.lib'||x2c('0a')||'*.lst, DDE3DEF2, LIB, WKF_ACTIONTYPE_CMD, WKF_ACTIONSCOPE_FILE, WKF_MENUSCOPE_SHORT, WKF_RUNMODE_MONITOR, view dde3lib,'
objectWF2.6.!objectdata.8   = 'IF_FOUND=e.exe;WKF_ACTION=System Edit, EDIT, e.exe, *, , DDE3DEF2, EDIT, WKF_ACTIONTYPE_CMD, WKF_ACTIONSCOPE_FILE,  WKF_MENUSCOPE_SHORT, WKF_RUNMODE_DEFAULT,'
objectWF2.6.!objectdata.9   = 'IF_FOUND=slink.exe;WKF_ACTION=SourceLink, EDIT, slink.exe, *, , DDE3DEF2, EDIT, WKF_ACTIONTYPE_CMD, WKF_ACTIONSCOPE_FILE,  WKF_MENUSCOPE_SHORT, WKF_RUNMODE_DEFAULT,'
objectWF2.6.!objectdata.10  = 'IF_FOUND=epm.exe;WKF_ACTION=EPM, EDIT, epm.exe, *, , DDE3DEF2, EDIT, WKF_ACTIONTYPE_CMD, WKF_ACTIONSCOPE_FILE,  WKF_MENUSCOPE_SHORT, WKF_RUNMODE_DEFAULT,'
objectWF2.6.!objectdata.11  = 'WKF_DFLTPROFILE=YES'
objectWF2.6.!optionsdata.0  = 0
/*---------------------------------------------------------------------------*/
objectWF2.7.!classname      = 'DDE3Profile'
objectWF2.7.!title          = 'IBM Toolkit Profile'
objectWF2.7.!location       = '<WKF_PROFILE_FOLDER>'
objectWF2.7.!setup          = 'OBJECTID=<WKF_PROFILE_TLKT>'
objectWF2.7.!options        = 'replace'
objectWF2.7.!objectid       = '<WKF_PROFILE_TLKT>'
objectWF2.7.!objectdata.0   = 14
objectWF2.7.!objectdata.1   = 'WKF_ACTION=Compress, PACKAGE, pack.exe, *, , DDE3DEF2, DEFAULT, WKF_ACTIONTYPE_CMD, WKF_ACTIONSCOPE_FILE,  WKF_MENUSCOPE_SHORT, WKF_RUNMODE_MONITOR, view toolinfo %TOPIC%, pack'
objectWF2.7.!objectdata.2   = 'WKF_ACTION=View EXE header, INSPECT, exehdr.exe, *.exe'||x2c('0a')||'*.dll, , DDE3DEF2, DEFAULT, WKF_ACTIONTYPE_CMD, WKF_ACTIONSCOPE_FILE,  WKF_MENUSCOPE_SHORT, WKF_RUNMODE_MONITOR,view toolinfo %TOPIC%, exehdr'
objectWF2.7.!objectdata.3   = 'WKF_ACTION=Map Symbols, INSPECT, mapsym.exe, *.map, *.sym, DDE3DEF2, DEFAULT, WKF_ACTIONTYPE_CMD, WKF_ACTIONSCOPE_FILE,  WKF_MENUSCOPE_SHORT, WKF_RUNMODE_MONITOR,view toolinfo %TOPIC%, mapsym'
objectWF2.7.!objectdata.4   = 'WKF_ACTION=Resource Bind, BIND, rc.exe, *.res'||x2c('0a')||'*.exe'||x2c('0a')||'*.dll, *.exe'||x2c('0a')||'*.dll, DDE3DEF2, RESOURCE_BIND, WKF_ACTIONTYPE_CMD, WKF_ACTIONSCOPE_FILE,  WKF_MENUSCOPE_SHORT, WKF_RUNMODE_MONITOR,view toolinfo %TOPIC%, Resource Compiler'
objectWF2.7.!objectdata.5   = 'WKF_ACTION=Parse and bind messages, BIND, dde3msgb.exe, *.msg'||x2c('0a')||'*.exe'||x2c('0a')||'*.dll, *.exe'||x2c('0a')||'*.dll, DDE3DEF2, MSGBIND_PLUS, WKF_ACTIONTYPE_CMD, WKF_ACTIONSCOPE_FILE, WKF_MENUSCOPE_SHORT, WKF_RUNMODE_MONITOR,view toolinfo %TOPIC%, msgbind'
objectWF2.7.!objectdata.6   = 'WKF_ACTION=Import Lib, LIB, implib.exe, *.def, *.lib, DDE3DEF2, IMPLIB, WKF_ACTIONTYPE_CMD, WKF_ACTIONSCOPE_FILE,  WKF_MENUSCOPE_SHORT, WKF_RUNMODE_MONITOR,view toolinfo %TOPIC%, implib'
objectWF2.7.!objectdata.7   = 'WKF_ACTION=NMake, MAKE, nmake.exe, *.mak'||x2c('0a')||'makefile, , DDE3DEF2, MAKE, WKF_ACTIONTYPE_CMD, WKF_ACTIONSCOPE_BOTH,  WKF_MENUSCOPE_SHORT, WKF_RUNMODE_MONITOR,view toolinfo %TOPIC%, nmake'
objectWF2.7.!objectdata.8   = 'WKF_ACTION=IPF Compile, COMPILE, ipfc.exe, *.ipf, *.hlp, DDE3DEF2, IPF_COMPILE, WKF_ACTIONTYPE_CMD, WKF_ACTIONSCOPE_FILE,  WKF_MENUSCOPE_SHORT, WKF_RUNMODE_MONITOR,view ipfc20'
objectWF2.7.!objectdata.9   = 'WKF_ACTION=Message Compile, COMPILE, mkmsgf.exe, *.txt, *.msg, DDE3DEF2, MESSAGE_COMPILE, WKF_ACTIONTYPE_CMD, WKF_ACTIONSCOPE_FILE,  WKF_MENUSCOPE_SHORT, WKF_RUNMODE_MONITOR,view toolinfo %TOPIC%, mkmsgf'
objectWF2.7.!objectdata.10  = 'WKF_ACTION=Resource Compile, COMPILE, rc.exe, *.rc, *.res, DDE3DEF2, RESOURCE_COMPILE, WKF_ACTIONTYPE_CMD, WKF_ACTIONSCOPE_FILE,  WKF_MENUSCOPE_SHORT, WKF_RUNMODE_MONITOR,view toolinfo %TOPIC%, Resource Compiler'
objectWF2.7.!objectdata.11  = 'WKF_ACTION=SOM, COMPILE, sc.exe, *.csc, *.ih, DDE3DEF2, COMPILE, WKF_ACTIONTYPE_CMD, WKF_ACTIONSCOPE_FILE,  WKF_MENUSCOPE_SHORT, WKF_RUNMODE_MONITOR,view som'
objectWF2.7.!objectdata.12  = 'WKF_ACTION=MARKEXE, EDIT, markexe.exe, *.exe, *.exe, DDE3DEF2, DEFAULT, WKF_ACTIONTYPE_CMD, WKF_ACTIONSCOPE_FILE,  WKF_MENUSCOPE_SHORT, WKF_RUNMODE_MONITOR,view toolinfo %TOPIC%, markexe'
objectWF2.7.!objectdata.13  = 'WKF_ACTION=Icon Editor, EDIT, iconedit.exe, *.ico, , DDE3DEF2, DEFAULT, WKF_ACTIONTYPE_CMD, WKF_ACTIONSCOPE_FILE,  WKF_MENUSCOPE_SHORT, WKF_RUNMODE_DEFAULT,view toolinfo %TOPIC%, Icon Editor'
objectWF2.7.!objectdata.14  = 'WKF_ACTION=Dialog Editor, EDIT, dlgedit.exe, *.res, , DDE3DEF2, DEFAULT, WKF_ACTIONTYPE_CMD, WKF_ACTIONSCOPE_FILE,  WKF_MENUSCOPE_SHORT, WKF_RUNMODE_DEFAULT,view toolinfo %TOPIC%, Dialog Editor'
objectWF2.7.!optionsdata.0  = 0
/*---------------------------------------------------------------------------*/
objectWF2.8.!classname      = 'DDE3Profile'
objectWF2.8.!title          = 'Sample Actions Profile'
objectWF2.8.!location       = '<WKF_PROFILE_FOLDER>'
objectWF2.8.!setup          = 'OBJECTID=<WKF_PROFILE_SAMPLE>'
objectWF2.8.!options        = 'replace'
objectWF2.8.!objectid       = '<WKF_PROFILE_SAMPLE>'
objectWF2.8.!objectdata.0   = 0
objectWF2.8.!optionsdata.0  = 0
/*---------------------------------------------------------------------------*/
objectWF2.9.!classname      = 'DDE3Profile'
objectWF2.9.!title          = 'CLC Actions Profile'
objectWF2.9.!location       = '<WKF_PROFILE_FOLDER>'
objectWF2.9.!setup          = 'OBJECTID=<WKF_PROFILE_CLC>'
objectWF2.9.!options        = 'replace'
objectWF2.9.!objectid       = '<WKF_PROFILE_CLC>'
objectWF2.9.!objectdata.0   = 5
objectWF2.9.!objectdata.1   = 'WKF_ACTION=CLC C++, COMPILE, icc.exe, *.cpp, *.obj,         DDE4ICC2, COMPILE, WKF_ACTIONTYPE_CMD, WKF_ACTIONSCOPE_FILE, WKF_MENUSCOPE_SHORT, WKF_RUNMODE_MONITOR,'
objectWF2.9.!objectdata.2   = 'WKF_ACTION=CLC Link, LINK, icc.exe, *.obj, *.exe'||x2c('0a')||'*.dll, DDE4ICL2, LINK,    WKF_ACTIONTYPE_CMD, WKF_ACTIONSCOPE_FILE, WKF_MENUSCOPE_SHORT, WKF_RUNMODE_MONITOR,'
objectWF2.9.!objectdata.3   = 'WKF_ACTION=IPF, COMPILE, ipfc.exe, *.ipf, *.inf'||x2c('0a')||'*.hlp,  DDE3DEF2, DEFAULT, WKF_ACTIONTYPE_CMD, WKF_ACTIONSCOPE_FILE, WKF_MENUSCOPE_SHORT, WKF_RUNMODE_MONITOR,'
objectWF2.9.!objectdata.4   = 'WKF_ACTION=Lib, LIB, lib.exe, *.lib'||x2c('0a')||'*.obj, ,            DDE3DEF2, LIB,     WKF_ACTIONTYPE_CMD, WKF_ACTIONSCOPE_FILE, WKF_MENUSCOPE_SHORT, WKF_RUNMODE_MONITOR,'
objectWF2.9.!objectdata.5   = 'WKF_ENVIRON=INCLUDE, '||wf2_directory||'\PRJ\CLC\HEADERS^;%INCLUDE%'
objectWF2.9.!optionsdata.0  = 0
/*---------------------------------------------------------------------------*/
objectWF2.10.!classname     = 'DDE3Folder'
objectWF2.10.!title         = 'Samples'
objectWF2.10.!location      = '<WKF_MAINFOLDER>'
objectWF2.10.!setup         = 'OBJECTID=<WKF_COMPPROJ>'
objectWF2.10.!options       = 'replace'
objectWF2.10.!objectid      = '<WKF_COMPPROJ>'
objectWF2.10.!objectdata.0  = 1
objectWF2.10.!objectdata.1  = 'SEQUENCE=Hello World'||x2c('0a')||'CLC;'
objectWF2.10.!optionsdata.0 = 0
/*---------------------------------------------------------------------------*/
objectWF2.11.!classname     = 'DDE3Folder'
objectWF2.11.!title         = 'CLC'
objectWF2.11.!location      = '<WKF_COMPPROJ>'
objectWF2.11.!setup         = 'OBJECTID=<WKF_CLC_FOLDER>'
objectWF2.11.!options       = 'replace'
objectWF2.11.!objectid      = '<WKF_CLC_FOLDER>'
objectWF2.11.!objectdata.0  = 1
objectWF2.11.!objectdata.1  = 'SEQUENCE=DLL'||x2c('0a')||'EXE'||x2c('0a')||'INFO'||x2c('0a')||'LIB;'
objectWF2.11.!optionsdata.0 = 0
/*---------------------------------------------------------------------------*/
objectWF2.12.!classname     = 'WPProgram'
objectWF2.12.!title         = 'Library Utility Reference'
objectWF2.12.!location      = '<WKF_INFO_FOLDER>'
objectWF2.12.!setup         = 'OBJECTID=<WKF_LIBREF>;EXENAME=view.exe;PARAMETERS='wf2_directory'\help\dde3lib.inf;ICONFILE='wf2_directory'\books.ico'
objectWF2.12.!options       = 'replace'
objectWF2.12.!objectid      = '<WKF_LIBREF>'
objectWF2.12.!objectdata.0  = 0
objectWF2.12.!optionsdata.0 = 0
/*---------------------------------------------------------------------------*/
objectWF2.13.!classname     = 'WPProgram'
objectWF2.13.!title         = 'IBM WorkFrame/2 Tutorial'
objectWF2.13.!location      = '<WKF_INFO_FOLDER>'
objectWF2.13.!setup         = 'OBJECTID=<WKF_WF2TUTORIAL>;EXENAME=view.exe;PARAMETERS='wf2_directory'\help\dde3tut.inf;ICONFILE='wf2_directory'\tutor.ico'
objectWF2.13.!options       = 'replace'
objectWF2.13.!objectid      = '<WKF_WF2TUTORIAL>'
objectWF2.13.!objectdata.0  = 0
objectWF2.13.!optionsdata.0 = 0
/*---------------------------------------------------------------------------*/
objectWF2.14.!classname     = 'WPProgram'
objectWF2.14.!title         = 'IBM Library Manager Tutorial'
objectWF2.14.!location      = '<WKF_INFO_FOLDER>'
objectWF2.14.!setup         = 'OBJECTID=<WKF_PMLIBTUTORIAL>;EXENAME=view.exe;PARAMETERS='wf2_directory'\help\dde3ltt.inf;ICONFILE='wf2_directory'\tutor.ico'
objectWF2.14.!options       = 'replace'
objectWF2.14.!objectid      = '<WKF_PMLIBTUTORIAL>'
objectWF2.14.!objectdata.0  = 0
objectWF2.14.!optionsdata.0 = 0
/*---------------------------------------------------------------------------*/
objectWF2.15.!classname     = 'WPProgram'
objectWF2.15.!title         = 'MakeMake'
objectWF2.15.!location      = '<WKF_TOOLSFOLDER>'
objectWF2.15.!setup         = 'OBJECTID=<WKF_MAKEMAKE>;EXENAME='wf2_directory'\bin\dde3make.exe;ICONFILE='wf2_directory'\makemake.ico'
objectWF2.15.!options       = 'replace'
objectWF2.15.!objectid      = '<WKF_MAKEMAKE>'
objectWF2.15.!objectdata.0  = 0
objectWF2.15.!optionsdata.0 = 0
/*---------------------------------------------------------------------------*/
objectWF2.16.!classname     = 'WPProgram'
objectWF2.16.!title         = 'IBM Library Manager'
objectWF2.16.!location      = '<WKF_TOOLSFOLDER>'
objectWF2.16.!setup         = 'OBJECTID=<WKF_PMLIB>;EXENAME='wf2_directory'\bin\pmlib.exe;ICONFILE='wf2_directory'\libutil1.ico'
objectWF2.16.!options       = 'replace'
objectWF2.16.!objectid      = '<WKF_PMLIB>'
objectWF2.16.!objectdata.0  = 0
objectWF2.16.!optionsdata.0 = 0
/*---------------------------------------------------------------------------*/
objectWF2.17.!classname     = 'WPProgram'
objectWF2.17.!title         = 'Setup'
objectWF2.17.!location      = '<WKF_MAINFOLDER>'
objectWF2.17.!setup         = 'OBJECTID=<WKF_SETUP>;EXENAME='wf2_directory'\wfsetup.exe;ICONFILE='wf2_directory'\setup.ico'
objectWF2.17.!options       = 'replace'
objectWF2.17.!objectid      = '<WKF_SETUP>'
objectWF2.17.!objectdata.0  = 0
objectWF2.17.!optionsdata.0 = 0
/*---------------------------------------------------------------------------*/
objectWF2.18.!classname     = 'DDE3Project'
objectWF2.18.!title         = 'Hello World'
objectWF2.18.!location      = '<WKF_COMPPROJ>'
objectWF2.18.!setup         = 'OBJECTID=<WKF_BASE_SAMPLE1>;DIR='wf2_directory'\PRJ\SAMPLE1;MASK=*.c'||x2c('0a')||'*.h'||x2c('0a')||'*.mak;TARGETNAME=SAMPLE1.EXE;MONITOR=WKF_MTR_MINIMIZE;MAKEFILE=SAMPLE1.MAK;'
objectWF2.18.!options       = 'replace'
objectWF2.18.!objectid      = '<WKF_BASE_SAMPLE1>'
objectWF2.18.!objectdata.0  = 0
objectWF2.18.!optionsdata.0 = 3
objectWF2.18.!optionsdata.1 = '1\nCOMPILE::Compile::FILE\n%%f\n%%f(%%i)%%t\n'
objectWF2.18.!optionsdata.2 = '2\nEDIT::Edit::FILE\n%%a %%z\nNULL\n'
objectWF2.18.!optionsdata.3 = '4\nLINK::Link::FILE\n0\n0\n0\n0\n0\n1\n0\n0\n0\n0\n0\n1\n0\n0\n1\n0\n0\n0\nNULL\nNULL\nNULL\nNULL\nNULL\nNULL\nNULL\n%%o\nNULL\nNULL\nNULL\n'
/*---------------------------------------------------------------------------*/
objectWF2.19.!classname     = 'DDE3Project'
objectWF2.19.!title         = 'DLL'
objectWF2.19.!location      = '<WKF_CLC_FOLDER>'
objectWF2.19.!setup         = 'OBJECTID=<WKF_CLC_DLL>;DIR='wf2_directory'\PRJ\CLC\DLL'||x2c('0a')||wf2_directory'\PRJ\CLC\HEADERS;MASK=*;TARGETNAME=CALCFUNC.DLL;MONITOR=WKF_MTR_MINIMIZE;TARGETPATH='wf2_directory'\PRJ\CLC;MAKEFILE=MAK.BAK;PROFILE=<WKF_PROFILE_CLC>'
objectWF2.19.!options       = 'replace'
objectWF2.19.!objectid      = '<WKF_CLC_DLL>'
objectWF2.19.!objectdata.0  = 0
objectWF2.19.!optionsdata.0 = 1
objectWF2.19.!optionsdata.1 = '4\nLINK::Link::FILE\n0\n0\n0\n0\n0\n1\n0\n0\n0\n0\n0\n1\n0\n0\n1\n0\n0\n0\nNULL\nNULL\nNULL\nNULL\nNULL\nNULL\nNULL\n%%o\nNULL\nNULL\nNULL\n'
/*---------------------------------------------------------------------------*/
objectWF2.20.!classname     = 'DDE3Project'
objectWF2.20.!title         = 'EXE'
objectWF2.20.!location      = '<WKF_CLC_FOLDER>'
objectWF2.20.!setup         = 'OBJECTID=<WKF_CLC_EXE>;DIR='wf2_directory'\PRJ\CLC\EXE'||x2c('0a')||wf2_directory'\PRJ\CLC\HEADERS;MASK=*;TARGETNAME=CALC.EXE;MONITOR=WKF_MTR_MINIMIZE;TARGETPATH='wf2_directory'\PRJ\CLC;MAKEFILE=EXE.MAK;PROFILE=<WKF_PROFILE_CLC>;'
objectWF2.20.!options       = 'replace'
objectWF2.20.!objectid      = '<WKF_CLC_EXE>'
objectWF2.20.!objectdata.0  = 0
objectWF2.20.!optionsdata.0 = 1
objectWF2.20.!optionsdata.1 = '4\nLINK::Link::FILE\n0\n0\n0\n0\n0\n1\n0\n0\n0\n0\n0\n1\n0\n0\n1\n0\n0\n0\nNULL\nNULL\nNULL\nNULL\nNULL\nNULL\nNULL\n%%o\nNULL\nNULL\nNULL\n'
/*---------------------------------------------------------------------------*/
objectWF2.21.!classname     = 'DDE3Project'
objectWF2.21.!title         = 'INFO'
objectWF2.21.!location      = '<WKF_CLC_FOLDER>'
objectWF2.21.!setup         = 'OBJECTID=<WKF_CLC_INFO>;DIR='wf2_directory'\PRJ\CLC\INFO'||x2c('0a')||wf2_directory'\PRJ\CLC\HEADERS;MASK=*;MONITOR=WKF_MTR_MINIMIZE;TARGETPATH='wf2_directory'\PRJ\CLC;MAKEFILE=INFO.MAK;PROFILE=<WKF_PROFILE_CLC>'
objectWF2.21.!options       = 'replace'
objectWF2.21.!objectid      = '<WKF_CLC_INFO>'
objectWF2.21.!objectdata.0  = 0
objectWF2.21.!optionsdata.0 = 1
objectWF2.21.!optionsdata.1 = '4\nLINK::Link::FILE\n0\n0\n0\n0\n0\n1\n0\n0\n0\n0\n0\n1\n0\n0\n1\n0\n0\n0\nNULL\nNULL\nNULL\nNULL\nNULL\nNULL\nNULL\n%%o\nNULL\nNULL\nNULL\n'
/*---------------------------------------------------------------------------*/
objectWF2.22.!classname     = 'DDE3Project'
objectWF2.22.!title         = 'LIB'
objectWF2.22.!location      = '<WKF_CLC_FOLDER>'
objectWF2.22.!setup         = 'OBJECTID=<WKF_CLC_LIB>;DIR='wf2_directory'\PRJ\CLC\LIB'||x2c('0a')||wf2_directory'\PRJ\CLC\HEADERS;MASK=*;MONITOR=WKF_MTR_MINIMIZE;TARGETPATH='wf2_directory'\PRJ\CLC;MAKEFILE=LIB.MAK;PROFILE=<WKF_PROFILE_CLC>'
objectWF2.22.!options       = 'replace'
objectWF2.22.!objectid      = '<WKF_CLC_LIB>'
objectWF2.22.!objectdata.0  = 0
objectWF2.22.!optionsdata.0 = 1
objectWF2.22.!optionsdata.1 = '4\nLINK::Link::FILE\n0\n0\n0\n0\n0\n1\n0\n0\n0\n0\n0\n1\n0\n0\n1\n0\n0\n0\nNULL\nNULL\nNULL\nNULL\nNULL\nNULL\nNULL\n%%o\nNULL\nNULL\nNULL\n'
/*---------------------------------------------------------------------------*/
do i=1 to objectWF2.0 
     rc=SysSleep(pause_time)
     rc = SysCreateObject(objectWF2.i.!classname, objectWF2.i.!title, objectWF2.i.!location, objectWF2.i.!setup, objectWF2.i.!options)
     if (rc \= 0) then
     do
          say command':     Successful object creation - 'objectWF2.i.!title
          do j=1 to objectWF2.i.!objectdata.0
               rc=SysSleep(pause_time)
               rc = SysSetObjectData(objectWF2.i.!objectid,objectWF2.i.!objectdata.j)
               if (rc \= 0) then
               do
                    say command':          Successful object initialization 'j' - 'objectWF2.i.!title
               end
               else
               do
                    say command':          Failed object initialization 'j' - 'objectWF2.i.!title' with RC='rc
                    exit(rc)
               end
          end /* do j */

          do j=1 to objectWF2.i.!optionsdata.0
               rc=SysSleep(pause_time)
               ''wf2_directory'\wfsetopt.exe "'objectWF2.i.!objectid'" "'objectWF2.i.!optionsdata.j'"'
               if (rc \= 0) then
               do
                    say command':          Successful object option initialization 'j' - 'objectWF2.i.!title
               end
               else
               do
                    say command':          Failed object option initialization 'j' - 'objectWF2.i.!title' with RC='rc' continuing ...'
               end
          end /* do j */
     end
     else
     do
          say command':     Failed object creation - 'objectWF2.i.!title' with RC='rc
          exit(rc)
     end
end /* do i */
/*---------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------*/
/* SETUP INSTALLATION PHASE INFORMATION                                      */
/*---------------------------------------------------------------------------*/
say command': Updating system files, please wait ...'
iniFile. = ''
iniFile.0 = 2
iniFile.1.!name = ''
iniFile.1.!app  = 'IBMWFV2'
iniFile.1.!key  = 'PHASE'
iniFile.1.!val  = '2'
iniFile.2.!name = boot_drive'\os2\ibmwfv2.ini'
iniFile.2.!app  = 'IBMWFV2'
iniFile.2.!key  = 'PHASE'
iniFile.2.!val  = '2'

do i=1 to iniFile.0
     rc=SysSleep(pause_time)
     rc=SysIni(iniFile.i.!name, iniFile.i.!app, iniFile.i.!key, iniFile.i.!val)
     if (iniFile.i.!name = '') then
          iniFile.i.!name = 'USER' /* display name for default ini file */
     if (rc = '') then
          say command':     Successful ini file update 'i' - 'iniFile.i.!name
     else
     do
          say command':     Failed ini file update 'i' - 'iniFile.i.!name' with RC='rc
          exit(rc)
     end
end

say command': SUCCESSFULLY COMPLETED WORKFRAME/2 PHASE 2.'
return 0
