/*  Rexx-Programm zum Einrichten eines persnlichen Textbuch-Verzeichnisses
     Autor: Martin Vieregg, Juni 1998  */

say ""
say "Dieses Programm bereitet in einem neuen Verzeichnis Ihre persnlichen"
say "Buchhaltungs-Daten fr Textbuch vor. Zum Ausprobieren von Textbuch mit"
say "dem Beispiels-Kontenplan bentigen Sie dieses Programm nicht, sondern"
say "knnen direkt TBUCH.EXE starten. Weitermachen ? J/N"
pull YesNo
if \ ((YesNo = "Y") | (YesNo = "y") | (YesNo = "J") | (YesNo = "j")) then exit


Call RxFuncAdd 'SysLoadFuncs','RexxUtil','SysLoadFuncs'
Call SysLoadFuncs

CurrentDir = directory()

say "Geben Sie bitte das Verzeichnis an, das Ihre persnlichen Buchhaltungsdaten"
say "enthalten soll, z. B. C:\BUCHHALT (Voller Verzeichnisname!)"
pull Zielverz
if (Zielverz = "") then DO
  say "Es mu ein Verzeichnis eingegeben werden! Programmende."
  pause
  exit
END

rc = sysmkdir(Zielverz)
if \ ((rc = 0) | (rc = 5)) then DO
  say "Das Verzeichnis konnte nicht angelegt werden! Programmende."
  pause
  exit
END

"copy STANDARD.TBU "Zielverz

/*Kontenplan kopiert TBUCH.EXE automatisch
"copy KONTPLAN.TXT "Zielverz*/

"copy AUSGABE.SMA "Zielverz
"copy GEGENST.SMA "Zielverz

say ""
say "Es sollten nun drei Dateien kopiert worden sein. Weiter?  J/N"
pull YesNo
if \ ((YesNo = "Y") | (YesNo = "y") | (YesNo = "J") | (YesNo = "j")) then exit

say "Nun wird ein Programmobjekt auf der Arbeitsoberflche erzeugt."
say "Wie soll das Programmobjekt heien? Standard ist Textbuch. Mglich ist"
say "aber auch etwa eine Firmenbezeichnung."
pull Name

if (Name = "") then Name = "Textbuch"

Call SysCreateObject "WPProgram", Name, "<WP_DESKTOP>",,
	"OBJECTID=<MVtbuch"Name">;EXENAME="CurrentDir"\tbuch.exe;STARTUPDIR="Zielverz";PARAMETERS=STANDARD.TBU;"

Call SysCreateObject "WPProgram", "Textbuch Doku", "<WP_DESKTOP>",,
	"OBJECTID=<MVtbuchdoku>;EXENAME=view.exe;STARTUPDIR="CurrentDir";PARAMETERS=TBUCH.HLP;"

say "Programmobjekt "Name" wurde erzeugt. Installation beendet!"
say "Sie knnen nun das Programm starten und den Kontenplan Ihren Bedrfnissen"
say "anpassen."

"pause"
exit

Kopiere:
Quelle = CurrentDir"\"ARG(1)
Ziel = Zielverz"\"ARG(1)
rc = SysCopyObject(Quelle, Ziel)
if (rc = 1) then say Quelle" wurde nach "Ziel" kopiert."
else say Quelle" konnte nicht nach "Ziel" kopiert werden!"
return