/* merge dumped stock quotes */

Call RxFuncAdd 'StockLoadFuncs', 'RXSTOCK', 'StockLoadFuncs'

call StockLoadFuncs

parse arg file

if file = '' then do
	say 'syntax: merge mergefile'
	return
end

v = linein(file)
do while stream(file, 'S') \= 'NOTREADY'
	parse var v act parm
	select
		when act="S" then do
			res=StockAddStock(parm)
			say 'Merging ' parm
		end
		when act="T" then do
			parse var parm ticker
			call StockSetStockData "Symbol", ticker
		end
		when act="Q" then do
			parse var parm date close
			call StockAddQuote date, close
		end
		when act="D" then do
			parse var parm date val
			call StockAddDividend date, val
		end
		otherwise
			say 'Invalid line ' v
	end
	v = linein(file)
end

call StockSave
