#ifndef _XCOMP_HPP_
#define _XCOMP_HPP_

#define     INCL_DOSFILEMGR
#define     INCL_DOSERRORS
#define     INCL_DOSMISC
#include    <os2.h>

#include    <stream.h>
#include    <string.h>
#include    <memory.h>

#include    <Excp.hpp>

#define     XCOMPDATASIZE               (1<<19)

class       XCOMP
{
public:
            XCOMP(int argc, char *argv[]);
           ~XCOMP(void);
    void    process(void);
    void    usage(void);
    int     getProblemOpenCount();
    int     getProblemCompareCount();
private:
    void    verifySourcePath(void);
    void    verifyTargetPath(void);
    void    searchFiles(char *pcSourcePath, char *pcSourceFiles, char *pcTargetPath);
    int     compareFiles(char *pcSourcePath, char *pcSourceFile, char *pcTargetPath);

    int     iCompareBufferSize;
    char    acSourcePath[CCHMAXPATH];            
    int     iSourcePathRootLen;
    char    acSourceFiles[CCHMAXPATH];            
    char    acTargetPath[CCHMAXPATH];            
    int     iTargetPathRootLen;
    BYTE   *pbSourceData;   
    BYTE   *pbTargetData;
    int     iCountProblemOpen;   
    int     iCountProblemCompare;   
};

#endif  /* _COMP_HPP_ */
