#pragma strings(readonly)

#include    <XComp.hpp>

            XCOMP::XCOMP(int argc, char *argv[])
{
    cout << endl;
    if(argc<3)
        throw(EXCP(1, "Too less commandline arguments specified"));
    if(strlen(argv[1])>CCHMAXPATH)
        throw(EXCP(2, "Source path too long"));
    if(strlen(argv[2])>CCHMAXPATH)
        throw(EXCP(3, "Target path too long"));
    strcpy((char *)acSourcePath, argv[1]);
    strcpy((char *)acTargetPath, argv[2]);
}

            XCOMP::~XCOMP(void)
{
    if(iCountProblemOpen!=0)
        cout << "XCOMP030: " << iCountProblemOpen << " file(s) could not be opened. This may be caused by\nnon existing or locked files." << endl;
    if(iCountProblemCompare!=0)
        {
        cout << "XCOMP031: " << iCountProblemCompare << " file(s) did not match. You don't have an exact copy of the source" << endl;
        cout << "files with the target files. Not matching files are listed above. Please rerun\nthe copy operation!" << endl;
        }
}

void        XCOMP::process(void)
{
    ULONG   ulMemorySize;

    iCompareBufferSize=XCOMPDATASIZE;
    if(DosQuerySysInfo(QSV_TOTPHYSMEM, QSV_TOTPHYSMEM, &ulMemorySize, sizeof(ulMemorySize))==NO_ERROR)
        {
        if(ulMemorySize>(1<<25))
            iCompareBufferSize<<=1;
        if(ulMemorySize>(1<<26))
            iCompareBufferSize<<=1;
        if(ulMemorySize>(1<<27))
            iCompareBufferSize<<=1;
        }
    pbSourceData=new BYTE[iCompareBufferSize];
    pbTargetData=new BYTE[iCompareBufferSize];
    iCountProblemOpen=iCountProblemCompare=0;
    verifySourcePath();
    verifyTargetPath();
    cout << "Comparing files qualified by " << acSourceFiles << endl;
    cout << "  at  " << acSourcePath << endl;
    cout << "with  " << acTargetPath << endl;
    cout << "using " << iCompareBufferSize << " bytes buffer size\n" << endl;
    searchFiles(acSourcePath, acSourceFiles, acTargetPath);
    delete pbSourceData;
    delete pbTargetData;
    cout << "                                                                               " << endl;
}

void        XCOMP::usage(void)
{
    cout << "XCOMP/2 - The recursive file compare utility for OS/2, V1.10\n" << endl;
    cout << "          (C( Roman Stangl 09, 1998 (Roman_Stangl@at.ibm.com)" << endl;
    cout << "          http://www.geocities.com/SiliconValley/Pines/7885/\n" << endl;
    cout << "Use the XCOMP command to selectively compare groups of files located in two" << endl;
    cout << "directories, including all subdirectories.\n" << endl;
    cout << "Syntax:" << endl;
    cout << "  XCOMP [drive:\\|\\\\server\\][path\\]filename(s) [drive:\\|\\\\server\\]path" << endl;
    cout << "Where:" << endl;
    cout << "  [drive:\\|\\\\server\\][path\\]filename(s)" << endl;
    cout << "                 Specifies the location and name of the source file(s) to" << endl;
    cout << "                 compare from. You may specify a fully qualified path or" << endl;
    cout << "                 UNC path" << endl;
    cout << "  [drive:\\|\\\\server\\]path" << endl;
    cout << "                 Specifies the location of the destination path to compare" << endl;
    cout << "                 with. You may specify a fully qualified path or UNC path" << endl;
    cout << "Returns:" << endl;
    cout << "  0              Successful completion" << endl;
    cout << "  1              Files could not be opened to compare (possibly 0-length,"  << endl;
    cout << "                 locked or not existing)" << endl;
    cout << "  2              A mismatch between at least 1 file was detected" << endl;
    cout << "  100+           Fatal, unrecoverable exceptions\n" << endl;
}

void        XCOMP::verifySourcePath(void)
{
    int     iUNCFilename;
    char   *pcFilename;
    APIRET  apiretRc;

                                        /* Check for leading backslash, which we remove */
    iSourcePathRootLen=strlen(acSourcePath);
    if(acSourcePath[iSourcePathRootLen-1]=='\\')
        acSourcePath[iSourcePathRootLen-1]='\0';
                                        /* Now let's OS/2 try to expand the path to a fully
                                           qualified name (if possible, that is we ignore an
                                           error here as we'll find it later) */
    apiretRc=DosQueryPathInfo(acSourcePath, FIL_QUERYFULLNAME, acSourcePath, sizeof(acSourcePath));
                                        /* Test for an UNC-name */
    iUNCFilename=FALSE;
    if(!strncmp(acSourcePath, "\\\\", sizeof("\\\\")-1))
        iUNCFilename=TRUE;
                                        /* Test for a backslash, as everything that follows must
                                           be the filename(s) we want to compare from */
    pcFilename=strrchr(acSourcePath, '\\');
    if(pcFilename!=0)
        {
                                        /* If we found the backslash, construct path and filename(s)
                                           info, but take care for UNC filenames */
        if((iUNCFilename==TRUE) && (pcFilename<=(acSourcePath+1)))
            {
            throw(EXCP(4, "Invalid UNC name specified for source path"));
            }
        pcFilename++;
        if(*pcFilename=='\0')
            strcpy(acSourceFiles, "*");
        else
            strcpy(acSourceFiles, pcFilename);
        *pcFilename='\0';
        iSourcePathRootLen=strlen(acSourcePath);
        }
    else
        {
        ULONG   ulDriveNum;
        ULONG   ulDriveMap;
        ULONG   ulLength;

                                        /* We need the current drive anyway */
        apiretRc=DosQueryCurrentDisk(&ulDriveNum, &ulDriveMap);
        if(apiretRc!=NO_ERROR)
            {
            EXCP   *pexcpError=new EXCP(5, "", __LINE__);
        
            *pexcpError << "Error " << apiretRc << " returned by DosQueryCurrentDisk()";
            throw(*pexcpError);
            }
                                        /* If we didn't find a backslash, we may either have:
                                             - just the filename(s)
                                             - just the drive letter */
        pcFilename=strchr(acSourcePath, ':');
        if(pcFilename==acSourcePath)
            {
            throw(EXCP(6, "Drive letter not specified for source path"));
            }
        if(pcFilename==0)
            {
                                        /* We didn't find a drive letter, so let's use the
                                           current drive and directory */
            strcpy(acSourceFiles, acSourcePath);
            strcpy(acSourcePath, "C:\\");
            ulLength=CCHMAXPATH-strlen(acSourcePath);
            acSourcePath[0]=(char)((ulDriveNum-1)+(ULONG)'a');
            apiretRc=DosQueryCurrentDir(ulDriveNum, &acSourcePath[strlen(acSourcePath)], &ulLength);
            if(apiretRc!=NO_ERROR)
                {
                EXCP   *pexcpError=new EXCP(7, "", __LINE__);
            
                *pexcpError << "Error " << apiretRc << " returned by DosQueryCurrentDir()";
                throw(*pexcpError);
                }
            }
        else if(*pcFilename==':')
            {
                                        /* We found a drive letter, which has to be enhanced with
                                           the current directory on that drive */
            strcpy(acSourceFiles, pcFilename+1);
            strcpy(pcFilename+1, "\\");
            ulLength=CCHMAXPATH-strlen(acSourcePath);
            ulDriveNum=((ULONG)*(pcFilename-1) | 0x00000020)-(ULONG)'a';
            ulDriveNum++;
            apiretRc=DosQueryCurrentDir(ulDriveNum, &acSourcePath[strlen(acSourcePath)], &ulLength);
            if(apiretRc!=NO_ERROR)
                {
                EXCP   *pexcpError=new EXCP(8, "", __LINE__);
            
                *pexcpError << "Error " << apiretRc << " returned by DosQueryCurrentDir()";
                throw(*pexcpError);
                }
            }
        else
            {
                                        /* As we didn't find any drive letter, the user must have
                                           specified the filename(s) he's looking for, so get the
                                           current directory and the current drive */
            strcpy(acSourceFiles, acSourcePath);
            acSourcePath[0]=(char)((ulDriveNum-1)+(ULONG)'a');
            strcpy(&acSourcePath[1], ":\\");
            ulLength=CCHMAXPATH-strlen(acSourcePath);
            apiretRc=DosQueryCurrentDir(ulDriveNum, &acSourcePath[strlen(acSourcePath)], &ulLength);
            if(apiretRc!=NO_ERROR)
                {
                EXCP   *pexcpError=new EXCP(9, "", __LINE__);
            
                *pexcpError << "Error " << apiretRc << " returned by DosQueryCurrentDir()";
                throw(*pexcpError);
                }
            }
        iSourcePathRootLen=strlen(acSourcePath);
        if(acSourcePath[iSourcePathRootLen-1]!='\\')
            {
            strcat(acSourcePath, "\\");
            iSourcePathRootLen++;
            }
        }
}

void        XCOMP::verifyTargetPath(void)
{
    int     iUNCFilename;
    char   *pcPath;
    APIRET  apiretRc;

                                        /* Check for leading backslash, which we remove */
    iTargetPathRootLen=strlen(acTargetPath);
    if(acTargetPath[iTargetPathRootLen-1]=='\\')
        acTargetPath[iTargetPathRootLen-1]='\0';
                                        /* Now let's OS/2 try to expand the path to a fully
                                           qualified name (if possible, that is we ignore an
                                           error here as we'll find it later), and add a trailing
                                           backslash */
    apiretRc=DosQueryPathInfo(acTargetPath, FIL_QUERYFULLNAME, acTargetPath, sizeof(acTargetPath));
    strcat(acTargetPath, "\\");
                                        /* Test for an UNC-name */
    iUNCFilename=FALSE;
    if(!strncmp(acTargetPath, "\\\\", sizeof("\\\\")-1))
        iUNCFilename=TRUE;
                                        /* Test for a backslash, as everything that follows must
                                           be the path we want to compare to */
    pcPath=strrchr(acTargetPath, '\\');
    if(pcPath!=0)
        {
                                        /* If we found the backslash, construct path info, but 
                                           take care for UNC filenames */
        if(iUNCFilename==TRUE)
            {
            if(pcPath<=(acTargetPath+1))
                {
                throw(EXCP(10, "Invalid UNC name specified for target path"));
                }
            if((*(pcPath+1)!='\0') || (strchr(acTargetPath+2, '\\')>=pcPath))
                {
                throw(EXCP(11, "Invalid UNC name specified for target path"));
                }
            }
        iTargetPathRootLen=strlen(acTargetPath);
        }
    else
        {
        ULONG   ulDriveNum;
        ULONG   ulDriveMap;
        ULONG   ulLength;

                                        /* If we didn't find a backslash, we may either have:
                                             - just the drive letter */
        pcPath=strchr(acTargetPath, ':');
        if(pcPath==acTargetPath)
            {
            throw(EXCP(12, "Drive letter not specified for target path"));
            }
        if(pcPath!=NULL)
            {
                                        /* We found a drive letter, which has to be enhanced with
                                           the current directory on that drive */
            strcpy(pcPath+1, "\\");
            ulLength=CCHMAXPATH-strlen(acTargetPath);
            ulDriveNum=((ULONG)*(pcPath-1) | 0x00000020) - (ULONG)'a';
            ulDriveNum++;
            apiretRc=DosQueryCurrentDir(ulDriveNum, &acTargetPath[strlen(acTargetPath)], &ulLength);
            if(apiretRc!=NO_ERROR)
                {
                EXCP   *pexcpError=new EXCP(13, "", __LINE__);
            
                *pexcpError << "Error " << apiretRc << " returned by DosQueryCurrentDir()";
                throw(*pexcpError);
                }
            }
        else
            {
            throw(EXCP(14, "Invalid target path specified"));
            }
        }
    iTargetPathRootLen=strlen(acTargetPath);
    if(acTargetPath[iTargetPathRootLen-1]!='\\')
        {
        strcat(acTargetPath, "\\");
        iTargetPathRootLen++;
        }
}

void        XCOMP::searchFiles(char *pcSourcePath, char *pcSourceFiles, char *pcTargetPath)
{
    char            acSourceFiles[CCHMAXPATH];
    char            acTargetFiles[CCHMAXPATH];
    HDIR            hdirSourceFiles;
    FILEFINDBUF3    ffb3SourceFiles;    
    ULONG           ulffb3Length;
    ULONG           ulFindCount;
    APIRET          apiretRc;
    char           *pcSourceDirectories;
    char           *pcTargetDirectories;

                                        /* Open directories enumeration */
    strcpy(acSourceFiles, pcSourcePath);
    strcat(acSourceFiles, pcSourceFiles);
    hdirSourceFiles=HDIR_CREATE;
    ulffb3Length=sizeof(ffb3SourceFiles);
    ulFindCount=1;
    apiretRc=DosFindFirst(acSourceFiles, 
        &hdirSourceFiles, 
        FILE_ARCHIVED | FILE_SYSTEM | FILE_HIDDEN | FILE_READONLY,
        &ffb3SourceFiles,
        ulffb3Length,
        &ulFindCount,
        FIL_STANDARD);
//@@@@@@
    if(apiretRc==ERROR_SEEK)
        {
        cout << "Error 1" << apiretRc << " returned by DosFindFirst()" << endl;
        }
    else if((apiretRc!=NO_ERROR) && (apiretRc!=ERROR_NO_MORE_FILES))
        {
        EXCP   *pexcpError=new EXCP(15, "", __LINE__);
    
        *pexcpError << "Error " << apiretRc << " returned by DosFindFirst()";
        throw(*pexcpError);
        }
                                        /* Enumerate files */
    while(apiretRc!=ERROR_NO_MORE_FILES)
        {
        cout << &pcSourcePath[iSourcePathRootLen] << ffb3SourceFiles.achName << endl;
        compareFiles(pcSourcePath, ffb3SourceFiles.achName, pcTargetPath);
        ulFindCount=1;
        memset(&ffb3SourceFiles, 0, ulffb3Length);
        apiretRc=DosFindNext(hdirSourceFiles,
            &ffb3SourceFiles,
            ulffb3Length,
            &ulFindCount);
//@@@@@@
        if(apiretRc==ERROR_SEEK)
            {
            cout << "Error 2 " << apiretRc << " returned by DosFindFirst()" << endl;
            }
        else if((apiretRc!=NO_ERROR) && (apiretRc!=ERROR_NO_MORE_FILES))
            {
            EXCP   *pexcpError=new EXCP(16, "", __LINE__);
        
            *pexcpError << "Error " << apiretRc << " returned by DosFindNext()";
            throw(*pexcpError);
            }
        }
                                        /* Close file enumeration, if not a single file
                                           was found DosFindFirst() returns a handle which
                                           DosFindClose() finds invalid (I'm not sure if this
                                           isn't a bug) */    
    apiretRc=DosFindClose(hdirSourceFiles);
    if((apiretRc!=NO_ERROR) && (apiretRc!=ERROR_INVALID_HANDLE))
        {
        EXCP   *pexcpError=new EXCP(17, "", __LINE__);
    
        *pexcpError << "Error " << apiretRc << " returned by DosFindClose()";
        throw(*pexcpError);
        }
                                        /* Open directories enumeration */
    strcpy(acSourceFiles, pcSourcePath);
    pcSourceDirectories=strchr(acSourceFiles, '\0');
    strcpy(acTargetFiles, pcTargetPath);
    pcTargetDirectories=strchr(acTargetFiles, '\0');
    strcat(acSourceFiles, "*");
    hdirSourceFiles=HDIR_CREATE;
    ulffb3Length=sizeof(ffb3SourceFiles);
    ulFindCount=1;
    apiretRc=DosFindFirst(acSourceFiles, 
        &hdirSourceFiles, 
        MUST_HAVE_DIRECTORY | FILE_ARCHIVED | FILE_SYSTEM | FILE_HIDDEN | FILE_READONLY,
        &ffb3SourceFiles,
        ulffb3Length,
        &ulFindCount,
        FIL_STANDARD);
//@@@@@@
    if(apiretRc==ERROR_SEEK)
        {
        cout << "Error 3" << apiretRc << " returned by DosFindFirst()" << endl;
        }
    else if((apiretRc!=NO_ERROR) && (apiretRc!=ERROR_NO_MORE_FILES))
        {
        EXCP   *pexcpError=new EXCP(18, "", __LINE__);
    
        *pexcpError << "Error " << apiretRc << " returned by DosFindFirst()";
        throw(*pexcpError);
        }
                                        /* Enumerate directories, but skip . and .. */
    while(apiretRc!=ERROR_NO_MORE_FILES)
        {
        if((strcmp(ffb3SourceFiles.achName, ".")) && (strcmp(ffb3SourceFiles.achName, "..")))
            {
            strcpy(pcSourceDirectories, ffb3SourceFiles.achName);
            strcat(pcSourceDirectories, "\\");
            strcpy(pcTargetDirectories, ffb3SourceFiles.achName);
            strcat(pcTargetDirectories, "\\");
            searchFiles(acSourceFiles, pcSourceFiles, acTargetFiles);
            }
        ulFindCount=1;
        memset(&ffb3SourceFiles, 0, ulffb3Length);
        apiretRc=DosFindNext(hdirSourceFiles,
            &ffb3SourceFiles,
            ulffb3Length,
            &ulFindCount);
//@@@@@@
        if(apiretRc==ERROR_SEEK)
            {
            cout << "Error 4" << apiretRc << " returned by DosFindFirst()" << endl;
            }
        else if((apiretRc!=NO_ERROR) && (apiretRc!=ERROR_NO_MORE_FILES))
            {
            EXCP   *pexcpError=new EXCP(19, "", __LINE__);
        
            *pexcpError << "Error " << apiretRc << " returned by DosFindNext()";
            throw(*pexcpError);
            }
        }
                                        /* Close file enumeration */    
    apiretRc=DosFindClose(hdirSourceFiles);
    if((apiretRc!=NO_ERROR) && (apiretRc!=ERROR_INVALID_HANDLE))
        {
        EXCP   *pexcpError=new EXCP(20, "", __LINE__);
    
        *pexcpError << "Error " << apiretRc << " returned by DosFindClose()";
        throw(*pexcpError);
        }
}

int         XCOMP::compareFiles(char *pcSourcePath, char *pcSourceFile, char *pcTargetPath)
{
    char            acSourceFile[CCHMAXPATH];
    char            acTargetFile[CCHMAXPATH];
    HFILE           hfileSourceFile;
    HFILE           hfileTargetFile;
    ULONG           ulActionSourceFile;
    ULONG           ulActionTargetFile;
    ULONG           ulBytesReadSourceFile;
    ULONG           ulBytesReadTargetFile;
    APIRET          apiretRc;

    strcpy(acSourceFile, pcSourcePath);    
    strcat(acSourceFile, pcSourceFile);    
    strcpy(acTargetFile, pcTargetPath);    
    strcat(acTargetFile, pcSourceFile);   
    apiretRc=DosOpen(acSourceFile,
        &hfileSourceFile,
        &ulActionSourceFile,
        0,
        FILE_NORMAL,
        OPEN_ACTION_FAIL_IF_NEW | OPEN_ACTION_OPEN_IF_EXISTS,
        OPEN_FLAGS_FAIL_ON_ERROR | OPEN_FLAGS_SEQUENTIAL | OPEN_SHARE_DENYNONE | OPEN_ACCESS_READONLY,
        0);
    if(apiretRc!=NO_ERROR)
        {
        iCountProblemOpen++;
        cout << "XCOMP021: Error " << apiretRc << " opening source file returned by DosOpen() at Line " << (int)__LINE__ << endl; 
        DosClose(hfileSourceFile);
        return(apiretRc);
        }
    apiretRc=DosOpen(acTargetFile,
        &hfileTargetFile,
        &ulActionTargetFile,
        0,
        FILE_NORMAL,
        OPEN_ACTION_FAIL_IF_NEW | OPEN_ACTION_OPEN_IF_EXISTS,
        OPEN_FLAGS_FAIL_ON_ERROR | OPEN_FLAGS_SEQUENTIAL | OPEN_SHARE_DENYNONE | OPEN_ACCESS_READONLY,
        0);
    if(apiretRc!=NO_ERROR)
        {
        iCountProblemOpen++;
        cout << "XCOMP022: Error " << apiretRc << " opening target file returned by DosOpen() at Line " << (int)__LINE__ << endl; 
        DosClose(hfileSourceFile);
        DosClose(hfileTargetFile);
        return(apiretRc);
        }
    else
        {
        while (TRUE)
            {
                                        /* Read iCompareBufferSize sized blocks of data from both
                                           the source and target file and compare them. If
                                           iCompareBufferSize bytes couldn't be read anymore, we
                                           have read the last block and can exit the loop */
            apiretRc=DosRead(hfileSourceFile,
                pbSourceData,
                iCompareBufferSize,
                &ulBytesReadSourceFile);
            if(apiretRc!=NO_ERROR)
                {
                cout << "XCOMP023: Error " << apiretRc << " reading source file returned by DosRead() at Line " << (int)__LINE__ << endl; 
                break;
                }
            apiretRc=DosRead(hfileTargetFile,
                pbTargetData,
                iCompareBufferSize,
                &ulBytesReadTargetFile);
            if(apiretRc!=NO_ERROR)
                {
                cout << "XCOMP024: Error " << apiretRc << " reading target file returned by DosRead() at Line " << (int)__LINE__ << endl; 
                break;
                }
            if(ulBytesReadSourceFile!=ulBytesReadTargetFile)
                {
                iCountProblemCompare++;
                cout << "XCOMP025: Size of source and target file differs" << endl; 
                break;
                }
            if(memcmp(pbSourceData, pbTargetData, ulBytesReadSourceFile))
                {
                iCountProblemCompare++;
                cout << "XCOMP026: Contents of source and target file differs" << endl; 
                break;
                }
            if(ulBytesReadSourceFile!=iCompareBufferSize)
                break;
            }
        }
    apiretRc=DosClose(hfileSourceFile);
    if(apiretRc!=NO_ERROR)
        {
        cout << "XCOMP027: Error " << apiretRc << " closing source file returned by DosClose() at Line " << (int)__LINE__ << endl; 
        }
    apiretRc=DosClose(hfileTargetFile);
    if(apiretRc!=NO_ERROR)
        {
        cout << "XCOMP028: Error " << apiretRc << " closing target file returned by DosClose() at Line " << (int)__LINE__ << endl; 
        }
    return(NO_ERROR);
}

int         XCOMP::getProblemOpenCount(void)
{
    return(iCountProblemOpen);
}

int         XCOMP::getProblemCompareCount(void)
{
    return(iCountProblemCompare);
}

int     main(int argc, char *argv[])
{
    int     iReturnCode=0;
    XCOMP  *pxcompInstance=0;

//    UCHAR   aucSource[CCHMAXPATH];
//    UCHAR   aucEdit[CCHMAXPATH];
//    UCHAR   aucTarget[CCHMAXPATH];
//
//    strcpy((char *)aucSource, argv[1]);
//    strcpy((char *)aucEdit, "*");
//    iReturnCode=DosQueryPathInfo((PCSZ)aucSource, FIL_QUERYFULLNAME, aucTarget, sizeof(aucTarget));
//    if(iReturnCode)
//        cout << "Error" << endl;
//    else
//        cout << aucTarget << endl;
//    return(1);

    try
        {
        pxcompInstance=new XCOMP(argc, argv);
        try
            {
            pxcompInstance->process();
            }
        catch(EXCP& rexcpError)
            {
            rexcpError.print();
            cout << endl;
            pxcompInstance->usage();
            iReturnCode=rexcpError.getError();
            }
                                        /* If no fatal exception happened, set return code
                                           depending on criticalness of recoverable errors */
        if(pxcompInstance->getProblemCompareCount())
            iReturnCode=2;
        if((iReturnCode==0) && (pxcompInstance->getProblemOpenCount()))
            iReturnCode=1;
        }
    catch(EXCP& rexcpError)
        {
        pxcompInstance->usage();
        rexcpError.print();
        iReturnCode=rexcpError.getError();
        }
    delete pxcompInstance;
    return(iReturnCode);
}
