/***********************************************************************

	WSOS2.C - OS/2 command-line main program for PC Magazine
	WSEARCH utility

	Copyright 1996, Ziff-Davis Publishing Company.  All Rights Reserved.
	First Published in PC Magazine, US Edition, March 26, 1996.

	Author:  Tom Rawson.

	(This file is formatted for tabs every 3 columns.)

	This is the OS/2 main program.  The bulk of the WSEARCH code is in
	WSEARCH.C.

***********************************************************************/

#include <process.h>
#include <stdio.h>

#define INCL_BASE
#include <os2.h>

#define DEFINE_GLOBALS
#include "wsearch.h"

// External function prototypes
extern int WSParse(PSZ, PSZ, PSZ, int *, PSZ);
extern int WSearch(PSZ, PSZ, int, ULONG *, PSZ);


// ---------------------------------------------------------------------
// WSOS2 main program 
// ---------------------------------------------------------------------
int main(int argc, char **argv) {

	char szCmdLine[MAX_COMMAND];			// retrieved command line
	char szFiles[MAX_STRING];				// current filespecs
	char szExpression[MAX_STRING];		// current expression
	char szErrString[MAX_PATHNAME];		// error detail
	ULONG ulFiles;								// file count
	int fFlags = 0;							// flag bits
	int rval;									// return value

	// Sign on
	puts(PROGTITLE);

	// Retrieve the full (not parsed) command line
	getcmd(szCmdLine);

	// Parse the command line; if that works, do the search
	szErrString[0] = '\0';
	if ((rval = WSParse(szCmdLine, szFiles, szExpression, &fFlags, szErrString)) == 0) {
		if ((rval = WSearch(szFiles, szExpression, fFlags, &ulFiles, szErrString)) <= 0)
			// Display "1 file found" or "n files found" after search
			printf("\n  %lu file%s found\n", ulFiles, ((ulFiles == 1) ? NULLSTR : "s"));
	}

	// Display any error
	if (rval > 0) {
		printf("Error:  %s", ErrorList[rval - 1]);
		// If a string was supplied, display it with quotes
		if (szErrString[0])
			printf(" \"%s\"", szErrString);
		puts("\n");
	}

	return rval;
}


// ---------------------------------------------------------------------
// Display search results
// We ignore the status information (type = 1) displayed in Windows,
// and display only the actual results (type = 0)
// ---------------------------------------------------------------------
int WSDispResult(int nDispType, PSZ pszResultString)
{
	// Only display real results, not search status
	if (nDispType == 0)
		puts(pszResultString);

	return 0;
}
