/***********************************************************************

	WSEARCH.H - C Header file for PC Magazine WSEARCH utility

	Copyright 1996, Ziff-Davis Publishing Company.  All Rights Reserved.
	First Published in PC Magazine, US Edition, March 26, 1996.

	Author:  Tom Rawson.

	(This file is formatted for tabs every 3 columns.)

***********************************************************************/


#if defined(__OS2__)
#define INCL_BASE
#include <os2.h>
#endif


// ---------------------------------------------------------------------
// System-specific definitions
// ---------------------------------------------------------------------
// LFN is defined for long filename support
#if (defined(__OS2__) || defined(__NT__))
#define __LFN__
#endif


// ---------------------------------------------------------------------
// Type definitions
// ---------------------------------------------------------------------

// General data types
typedef unsigned int UINT;
typedef unsigned long ULONG;
typedef unsigned char UCHAR;
typedef unsigned char *PCH;
typedef PCH PSZ;

// Type for pointer to comparison function (memcmp or memicmp)
typedef int (*PSTRMATCH)(const void *, const void *, size_t);


// ---------------------------------------------------------------------
// Defined parameters
// ---------------------------------------------------------------------

// Program and file names
#if defined(__WINDOWS__)
#define PROGNAME "WSEARCH/16 1.00"
#define PROGTITLE "WSEARCH/16 -- PC Magazine File and Text Search"
#elif defined(__NT__)
#define PROGNAME "WSEARCH/32 1.00"
#define PROGTITLE "WSEARCH/32 -- PC Magazine File and Text Search"
#elif defined(__OS2__)
#define PROGNAME "WSEARCH for OS/2 1.00"
#define PROGTITLE "\nWSEARCH for OS/2 -- PC Magazine File and Text Search\n"
#endif
#define HELPNAME "WSEARCH.HLP"

// Logical values
#define FALSE 0
#define TRUE 1

// ASCII characters
#define EOL '\n'
#define CR '\r'
#define TAB '\t'
#define BEL '\07'

// Maximum length of the command line
#define MAX_COMMAND 127

// Maximum path name length
#ifdef __LFN__
#define MAX_PATHNAME 260
#else
#define MAX_PATHNAME 80
#endif

// Maximum number of elements and maximum string size in the search expression
#define MAX_EXPR_ELEMENTS 256
#define MAX_STRING 1024
#define MAX_FILENAME_ELEMENTS 64

// Maximum number of file specifications
#define MAX_FILESPECS 32

// Maximum length of an output line:
//		Filename		 80 characters
//		":  "			  3 characters
//		"[ln]  "	    14 characters (10-char line number)
//		"...."		  4 characters
//		text			128 characters
//		"...."		  4 characters
//		total			233 characters
#define MAX_OUTPUT 233

// Max text for output is as above.  The max to save is the output length
// plus an equal size prefix or suffix
#define MAX_MATCH_OUTPUT 128
#define MAX_MATCH_SAVE (2 * MAX_MATCH_OUTPUT)

// Length of parts of a truncated filename or status display
#define MAX_FN_OUTPUT 79
#define FN_PART1_LEN 32
#define MAX_STATUS_OUTPUT 40
#define STATUS_PART1_LEN 16

// Buffer sizes -- BUF_ALLOC allows room for a full buffer of data, plus a
// max length discarded line, plus a forced EOL character
#define BUF_SIZE 32768
#define LINE_MAX 2048
#define BUF_ALLOC BUF_SIZE + LINE_MAX + 1

// Switch flag bits
#define MATCH_ALL 			0x001
#define CASE_SENSITIVE 		0x002
#define SHOW_NOMATCH			0x004
#define LINE_NUMBERS 		0x008
#define SUBDIRS				0x010
#define FAST_RESPONSE		0x020
#define MATCH_STRING			0x040
#define START_SEARCH			0x080
#define IN_SUBDIRS			0x100

// WSearch return values (positive values are errors)
#define MATCH_FOUND 0
#define FILE_FOUND 0
#define MATCH_NOT_FOUND -1
#define FILE_NOT_FOUND -1
#define NO_MORE_FILES -2
#define TERMINATE -3

// File attributes
//		ATTR_ALL allows Archive and Read-only atributes
//		ATTR_DIR requires directory, allows Archive and Read-only
#if (defined(__WINDOWS__) || defined(__NT__))
#define ATTR_ALL _A_NORMAL
#define ATTR_DIR (0x8000 | _A_SUBDIR)
#elif defined(__OS2__)
#define ATTR_ALL (FILE_ARCHIVED | FILE_READONLY)
#define ATTR_DIR (MUST_HAVE_DIRECTORY | FILE_DIRECTORY | FILE_ARCHIVED | FILE_READONLY)
#endif

// Our windows message numbers
#ifdef __WINDOWS__
#define WM_CLEANUP WM_USER + 1
#endif

// Switch characters
#define SWITCH1 '/'
#define SWITCH2 '-'
#define SWITCH_USAGE '?'
#define SWITCH_ALL 'A'
#define SWITCH_CASE 'C'
#define SWITCH_FILESPEC 'F'
#define SWITCH_GO 'G'
#define SWITCH_NOMATCH 'M'
#define SWITCH_LINENUM 'N'
#define SWITCH_FASTRESP 'R'
#define SWITCH_SUBDIRS 'S'
#define SWITCH_EXPRESSION 'T'

// Pattern meta-characters
#define MC_SCAN '*'
#define MC_ANY '?'
#define MC_BOL '<'
#define MC_EOL '>'
#define MC_CLASS '['
#define MC_ENDCLASS ']'
#define MC_RANGE '-'
#define MC_REVCLASS '~'
#define MC_STDMETA "*?<>[]"
#define MC_CLASSMETA "~-]"

// Escape characters
#define ESCAPE '^'
#define ESC_TAB 't'
#define ESC_EOL 'n'
#define ESC_CR 'r'
#define ESC_HEX 'x'

// Replacement for non-printing characters -- "." in OS/2, ASCII 1
// in Windows
#if defined(__OS2__)
#define REPL_CHAR '.'
#else
#define REPL_CHAR '\1'
#endif

// Leader and trailer for output truncation
#define LEADER "...."
#define TRAILER LEADER
#define LEADLEN 4
#define TRAILLEN 4

// Pattern element types
#define ET_CHR 0
#define ET_STRING 1
#define ET_CLASS 2
#define ET_ANY 3
#define ET_ALL 4
#define ET_BEGINLINE 5
#define ET_ENDLINE 6

// State codes for compiler state machine
#define ST_COMPINIT		0
#define ST_NEXTCHAR		1
#define ST_INITELEMENT	2
#define ST_INITSTRING	3
#define ST_FILLSTRING	4
#define ST_STRINGDONE	5
#define ST_METACHAR		6
#define ST_INITCLASS		7
#define ST_FILLCLASS		8
#define ST_NEXTELEMENT	9
#define ST_COMPEXIT 		-1

// State codes for pattern-matching state machine
#define ST_MATCHINIT 	0
#define ST_NEXTBUF 		1
#define ST_NEXTLINE 		2
#define ST_NEWLINE 		3
#define ST_SCANBUF 		4
#define ST_CCHECK 		5
#define ST_ADVANCE  		6
#define ST_TESTMATCH 	7
#define ST_SCANLINE 		8
#define ST_EMISMATCH 	9
#define ST_LMISMATCH 	10
#define ST_LCHECK 		11
#define ST_MATCHED 		12
#define ST_MATCHDONE 	13
#define ST_MATCHEXIT 	-1

// MS-DOS error numbers
#define DOS_FILE_NOT_FOUND 	2
#define DOS_PATH_NOT_FOUND 	3
#define DOS_NO_MORE_FILES 		18

// Internal error numbers
#define ERR_BADSWITCH			1
#define ERR_TWOEXPRESSIONS		2 
#define ERR_NOFILES				3 
#define ERR_TOOMANYFILES		4 
#define ERR_NOEXPRESSION		5 
#define ERR_MEMORY				6 
#define ERR_EXPR_LENGTH			7 
#define ERR_EXPR_INCOMPLETE	8 
#define ERR_INVALID_HEX			9 
#define ERR_INVALID_DEC			10
#define ERR_STR_LENGTH			11
#define ERR_CLASS_NOSTART		12
#define ERR_INVALID_CLASS		13
#define ERR_FIND_FILE			14
#define ERR_FSEEK					15
#define ERR_FREAD					16
#define ERR_RESULT_SPACE		17


// ---------------------------------------------------------------------
// Text definitions
// ---------------------------------------------------------------------

// Error list
#ifdef DEFINE_GLOBALS
const char *ErrorList[] = {
"Invalid switch",												// 01 (ERR_BADSWITCH)
"More than one expression specified",					// 02 (ERR_TWOEXPRESSIONS)
"No file(s) specified",										// 03 (ERR_NOFILES)
"Too many file specifications",							// 04 (ERR_TOOMANYFILES)
"No expression found",										// 05 (ERR_NOEXPRESSION)
"Out of memory",												// 06 (ERR_MEMORY)
"Expression too long",										// 07 (ERR_EXPR_LENGTH)
"Expression incomplete",									// 08 (ERR_EXPR_INCOMPLETE)
"Invalid hex value", 										// 09 (ERR_INVALID_HEX)
"Invalid decimal value",									// 10 (ERR_INVALID_DEC)
"String too long",											// 11 (ERR_STR_LENGTH)
"No class open",												// 12 (ERR_CLASS_NOSTART)
"Invalid class",												// 13 (ERR_INVALID_CLASS)
"File search failed for",									// 14 (ERR_FIND_FILE)
"Seek error",													// 15 (ERR_FSEEK)
"Read error",													// 16 (ERR_FREAD)
"There is not enough memory\nto display any more results"	// 17 (ERR_RESULT_SPACE)
};
#else
extern const char *ErrorList[];
#endif

// Text errors and messages (not in message array above)
#define USAGE "\n" \
"Usage:  WSOS2 [switches] [-t] text [-f] filespec\n\n" \
"Switches:   -a   show all matches      -n   show line numbers\n" \
"            -c   case-sensitive        -s   search subdirectories\n" \
"            -m   show mismatches\n\n"
#define NULLSTR ""
#define SEARCH_LABEL "Search"
#define STOP_LABEL "Stop"
#define SEARCH_COMPLETED "Completed"
#define SEARCH_TERMINATED "** Terminated **"
#define ERRMSG_DIALOG_LOAD "Cannot load dialog box"
#define ERR_CAPTION "Error"
#define NO_MATCH_MSG ":  ** No match **"
#define NO_FILE_MSG ":  ** Not found **"
#define OPEN_ERROR ":  ** Unavailable **"
#if defined(__LFN__)
#define OFN_FILTER "All Files\0*\0\0"
#else
#define OFN_FILTER "All Files\0*.*\0\0"
#endif
#define OFN_TITLE "Select a file or directory"
#define CONFIRM_CLOSE "Search in process -- press OK to close\nor Cancel to continue search"

// The wildcard character string to retrieve "all files" is
// different for LFN and non-LFN environments
#ifdef DEFINE_GLOBALS
#ifdef __LFN__
char szWildName[] = "*";
#else
char szWildName[] = "*.*";
#endif
#else
extern const char szWildName[];
#endif

// ---------------------------------------------------------------------
// Dialog box IDs
// ---------------------------------------------------------------------
#define WSEARCHICON			101
#define WSEARCHDIALOG		102
#define ABOUTDIALOG			103

#define IDD_CURDIRLABEL		201
#define IDD_CURDIR			202
#define IDD_SEARCHLABEL		203
#define IDD_SEARCHING		204
#define IDD_FILELABEL		205
#define IDD_FILENAME			206
#define IDD_EXPRLABEL		207
#define IDD_EXPRESSION		208
#define IDD_SUBDIRS			209
#define IDD_CASE				210
#define IDD_NOMATCH			211
#define IDD_ALLLINES			212
#define IDD_LINENUM			213
#define IDD_FASTRESP			214
#define IDD_RESULTLABEL		215
#define IDD_RESULTS			216
#define IDD_SEARCH			217
#define IDD_EXIT				218
#define IDD_HELP				219
#define IDD_ABOUT				220
#define IDD_BROWSE			221

#define IDD_VERSION			231


// ---------------------------------------------------------------------
// Data structures
// ---------------------------------------------------------------------

// Structure for compiled elements of a regular expression.
//
typedef struct _ELEMENT {
	int nType;					// element type, see ET_xxxx list
	int nLength;				// length to match (string length or number of ?s)
	int fScan;					// TRUE to scan line for match
	int fUpper; 				// TRUE if there is a separate upper-case character
	union {
		UCHAR chr;				// single character to match
		UCHAR *pString;		// pointer to string, or to class array
	} text;
} ELEMENT, *PELEMENT;


// Status of current search (used by SearchFile)
typedef struct _SEARCHSTATUS {
	ULONG ulBlockOffset;		// offset of current block in file
	UINT uPrefixLen;			// bytes of prefix to get full first line
	UINT uDiscardCount;		// bytes after last EOL in buffer
	PCH pBufEnd;				// last usable byte in current buffer
	ULONG ulLineNum;			// current line number
	PCH pLine;					// position in current line
	PCH pLineStart;			// start of current line
	PCH pLineEnd;				// end of current line
	PELEMENT pElement;		// current pattern element
} SEARCHSTATUS, *PSEARCHSTATUS;


// Structure for file specifications
typedef struct _FILESPEC {
	int nPathLen;				// length of path portion of name
	int nFileElements;		// number of elements in filename expression
	PCH pFileName;				// file name to match
	PELEMENT pFileExpr;		// pointer to filename regular expression
} FILESPEC, *PFILESPEC;


typedef struct _FINDDATA {
	int fInit;						// TRUE if search has been initialized
#if defined(__WINDOWS__)
	struct find_t FileInfo;		// DOS / Win16 find data structure
#elif defined(__NT__)
	HANDLE hSearch;				// search handle
	WIN32_FIND_DATA FileInfo;	// Win32 find data structure
#elif defined(__OS2__)
	HDIR hSearch;					// search handle
#endif
} FINDDATA, *PFINDDATA;


// Checkbox data
typedef struct _CHECKBOX {
	int nBoxID; 					// checkbox ID in dialog
	int nFlagBit;					// flag bit mask
} CHECKBOX;

