/* SAV2DISK.CMD */

/*Written by Charles Cohen, CIS # 71674,3113*/

/*---------------------------------------------------------------------------*/
/* Procedures for loading Rexx                                               */
/*---------------------------------------------------------------------------*/

'@echo off'
CALL RxFuncAdd 'SysLoadFuncs','RexxUtil','SysLoadFuncs'
CALL SysLoadFuncs

/*---------------------------------------------------------------------------*/
/* Procedures for loading RXextras                                           */
/*---------------------------------------------------------------------------*/

CALL RxFuncAdd 'RxExtra', 'RxExtras', 'RxExtra'
CALL RxExtra 'Load'
    
/*---------------------------------------------------------------------------*/
/* Procedures for loading Vrexx                                              */
/*---------------------------------------------------------------------------*/

CALL RxFuncAdd 'VInit', 'VREXX', 'VINIT'
initcode = VInit()
if initcode = 'ERROR' then signal CLEANUP

signal on notready name CLEANUP
signal on failure name CLEANUP
signal on halt name CLEANUP
signal on syntax name CLEANUP

/*----------------------------------------------------*/
/* Procedures for Sav2disk Program                    */
/*----------------------------------------------------*/

CALL SysFileSearch '`','s2dsetup.fil','textline.'

do i = 1 to textline.0
	textline.i = strip(textline.i,l,'`')
end
	
list.vstring = list.1 

do while list.vstring = list.1 | substr(list.vstring,2,14) = 'Unused Choice'

	currentdir = DIRECTORY()
	logfile = currentdir'\s2dlog.fil'
	checklog = 0
	list.0 = 12
	list.1  = ' Viewing/Setup Tools'
	list.2  = ' 'textline.1
	list.3  = ' 'textline.4
	list.4  = ' 'textline.7
	list.5  = ' 'textline.10
	list.6  = ' 'textline.13
	list.7  = ' 'textline.16
	list.8  = ' 'textline.19
	list.9  = ' 'textline.22
	list.10 = ' 'textline.25
	list.11 = ' 'textline.28
	list.12 = ' Pick a File to Save'
	list.vstring = list.1 

	CALL VDialogPos 50, 50
	rb = VRadioBox('  Select a Group to Save', list, 3)
	if rb = 'CANCEL' then do
		CALL CLEANUP
	end
	if rb = 'OK' then do
		if list.vstring = list.1 then do
			viewlist.0 = 4
			viewlist.1  = ' View Sav2disk Log '
			viewlist.2  = ' View - A:\ Drive  '
			viewlist.3  = ' View - B:\ Drive  '
			viewlist.4  = ' Modify Sav2disk   '
			viewlist.vstring = viewlist.1
			rb = VRadioBox(' Choose a Utility....', viewlist, 3)
			if rb = 'CANCEL' then do
			end
			if rb = 'OK' then do
				if viewlist.vstring = viewlist.1 then do
					CALL SysFileSearch ' ','s2dlog.fil','logline.'
					part = 's2dlog.fil'
					fspec = SysSearchPath('currentdir',part)
					if fspec <> " " then do
						win.left   = 2
						win.right  = 85
						win.top    = 52
						win.bottom = 2
						vlid = VOpenWindow(' Sav2disk Log Viewer.......', 'WHITE', win)

						CALL VSetFont vlid, 'SYSTEM', 10

						l = 1		    
			    		if logline.0 > 18 then do
				    		l = logline.0 - 17
					    end
				    
						x = 10
						y = 900
						do while l <= logline.0
						    call VSay vlid, x, y, logline.l
						    y = y - 50
						    l = l + 1
						end
					
						CALL VdialogPos 68,70
						msg.0 = 5
						msg.1 = '             These are the last 18 entries that   '
						msg.2 = '          have been made to the log file.  If you '
						msg.3 = '           wish to see more, use an ASCII editor.  '
						msg.4 = '       OK will return you to the initial screen or '
						msg.5 = '                     CANCEL to Exit.               '

						rb = VMsgBox('  Log Viewer Routine......', msg, 3)
						if rb = 'CANCEL' then do
							CALL VCloseWindow vlid
							CALL CLEANUP
						end
						if rb = 'OK' then do
							CALL VCloseWindow vlid
						end
					end
					if fspec = " " then do
						CALL VdialogPos 50, 50
						msg.0 = 6
						msg.1 = '             There are either no entries in the    '
						msg.2 = '           log file or the log file has not been   '
						msg.3 = '           created yet. (Sav2disk creates it when  '
						msg.4 = '        the program is used initially). Press OK to'
						msg.5 = '              return to the initial screen or      '
						msg.6 = '                  press CANCEL to Exit.          '
						rb = VMsgBox('  Log Viewer Routine......', msg, 3)
						if rb = 'CANCEL' then do
							CALL CLEANUP
						end
						if rb = 'OK' then do
						end
					end
				end
				if viewlist.vstring = viewlist.2 then do
					do while RxQueryDriveType("A:") = "NOTREADY"
						msg.0 = 3
						msg.1 = '           Please insure that the disk is in the  '
						msg.2 = '          A:\ drive and the drive door is closed. '
						msg.3 = '          Press OK to continue or CANCEL to Exit. '

						rb = VMsgBox(' Disk Viewer Routine......', msg, 3)
						if rb = 'CANCEL' then do
							CALL CLEANUP
						end
						if rb = 'OK' then do
						end
					end
					if RxQueryDriveType("A:") <> "NOTREADY" then do
						button = VFileBox('View a disk...', 'A:\', 'file')
						if button = "CANCEL" then do
						end		
						if button = "OK" then do
						end
					end
				end
				if viewlist.vstring = viewlist.3 then do
					do while RxQueryDriveType("B:") = "NOTREADY"
						msg.0 = 3
						msg.1 = '           Please insure that the disk is in the  '
						msg.2 = '          B:\ drive and the drive door is closed. '
						msg.3 = '          Press OK to continue or CANCEL to Exit. '

						rb = VMsgBox(' Disk Viewer Routine......', msg, 3)
						if rb = 'CANCEL' then do
   							CALL CLEANUP
    					end
						if rb = 'OK' then do
						end
					end
					if RxQueryDriveType("B:") <> "NOTREADY" then do
						button = VFileBox('View a disk...', 'B:\', 'file')
						if button = "CANCEL" then do
						end		
						if button = "OK" then do
						end
					end
				end
				if viewlist.vstring = viewlist.4 then do
					z = 1
					i = 1

					list.0 = 10
					list.1  = ' 'textline.1
					list.2  = ' 'textline.4
					list.3  = ' 'textline.7
					list.4  = ' 'textline.10
					list.5  = ' 'textline.13
					list.6  = ' 'textline.16
					list.7  = ' 'textline.19
					list.8  = ' 'textline.22
					list.9  = ' 'textline.25
					list.10 = ' 'textline.28

					CALL VDialogPos 50, 50
					sel.0 = 10
					sel.0 = list.vstring
					rb = VCheckBox('Choose one or more:', list, sel, 3)
					if rb = 'CANCEL' then do
						list.vstring = list.1
					end
					if rb = 'OK' then do
						if sel.0 > 0 then do
							rb = VMsgBox('You have chosen..', sel, 1)
							if rb = 'OK' then do
								do while z <= sel.0
									teststring = 1
									stop = 0
									do while DATATYPE(teststring,mixed case) <> 1 & stop = 0
										input.0 = 10
										input.1  = 'Enter new Title for:'
										input.2  = strip(sel.z)'    *'
										input.3  = 'If entry field is blank or the title is Unused..the source      '
										input.4  = 'source & target directories will be blanked out when            '
										input.5  = 'Sav2disk queries for them. The entry is case insensitive.       '
										input.6  = 'Sav2disk will capitalize the first letter in each word and      '
										input.7  = 'lowercase the rest. Sav2disk limits the entry size to 21        '
										input.8  = 'char.and\or 4 words.  This does not insure a proper display.    '
										input.9  = 'Check display after edit is saved.  You may have to redo it.    '
										input.10 = '           Please use only valid letters, A to Z only.      '
										
										input.vstring = strip(sel.z)
										if substr(sel.z,2,14) = 'Unused Choice' then do 
											input.vstring = ''
										end
										rb = VInputBox(' New Title Entry....', input, 25, 3)
										if rb = 'CANCEL' then do
											stop = 1
										end
										if strip(input.vstring) = '' then do
											stop = 1
										end
										teststring = SPACE(input.vstring,0)
									end
									if rb = 'OK' then do
										do while textline.i <> sel.z
											i = i + 1
										end
										j = i + 1
										if length(strip(input.vstring)) = 0 then do
											textline.j = ' '
										end
										source.0 = 5
										source.1 = 'Enter Source Directory for:'
										source.2 = strip(sel.z)'    *'
										source.3 = 'ie:'
										source.4 = ' Drive:\Path\*.* or   '
										source.5 = ' Drive:\Path\*.dbf    '  
										source.vstring = strip(textline.j)
										rb = VInputBox(' Source Dir Entry....', source, 45, 3)
										if rb = 'CANCEL' then do
										end
										if rb = 'OK' then do
											k = i + 2
											if length(strip(input.vstring)) = 0	then do
												textline.k = ' '
											end
											if k < 30 then do
												txtstring = '#'
												stop = 0
												do while DATATYPE(txtstring,alphanumeric) <> 1 & stop = 0
													target.0 = 7
													target.1 = 'Enter Target Directory for:'
													target.2 = strip(sel.z)'    *'
													target.3 = 'ie: DBDATA      '
													target.4 = 'Directory name only or   '
													target.5 = 'if left blank, the       '
													target.6 = 'root dir will be used    '
													target.7 = 'A to Z or 0 thru 9 only  '
													target.vstring = strip(textline.k)
													rb = VInputBox(' Target Dir Entry....', target, 25, 3)
													if rb = 'CANCEL' then do
												   		stop = 1
												    end
													if strip(target.vstring) = '' then do
														stop = 1
													end
													txtstring = SPACE(target.vstring,0)
													if length(strip(target.vstring)) = 0 then do
														stop = 1
													end
												end
												if rb = 'OK' then do
												end
											end
										end
									end
									if rb = 'OK' then do							
										notvalid = 0
										twoerr = 0
									   	if length(input.vstring) = 0 then do
									   		newinput = ''
									   	end
									    if length(input.vstring) > 0 then do
											case = substr(input.vstring,1,21)
											lettercase  = 'AaBbCcDdEeFfGgHhIiJjKkLlMmNnOoPpQqRrSsTtUuVvWwXxYyZz'
											numword = WORDS(case)
											nw = 1
											if numword < 5 then do
												do while nw <= numword
													if nw = 1 then do
														casestring = WORD(case,1)
													end
													if nw = 2 then do
														casestring = WORD(case,2)
													end
													if nw = 3 then do
														casestring = WORD(case,3)
													end
													if nw = 4 then do
														casestring = WORD(case,4)
													end
													PUSH casestring
													PULL casestring
													letter = substr(casestring,1,1)
													lowerstr = substr(casestring,2)
													newinput = letter
													l = 1
													do while substr(lowerstr,l,1) <> ' '
														strchk = 1
														chklower = substr(lowerstr,l,1)
														do while substr(lettercase,strchk,1) <> strip(chklower)
															strchk = strchk + 2
														end
														newletr = substr(lettercase,strchk + 1, 1)
														l = l + 1
														newinput = INSERT(newinput,newletr)
													end
													if nw = 1 then do
														fstinput = newinput
													end
													if nw = 2 then do
														sndinput = fstinput' 'newinput
													end
													if nw = 3 then do
														trdinput = sndinput' 'newinput
													end
													if nw = 4 then do
														frthinput = trdinput' 'newinput
													end
													nw = nw + 1
												end
												nw = nw - 1
												if nw = 1 then do
													newinput = fstinput
												end
												if nw = 2 then do
													newinput = sndinput
												end
												if nw = 3 then do
													newinput = trdinput
												end
												if nw = 4 then do
													newinput = frthinput
												end
 											end
											if length(source.vstring) > 0 then do
												source.vstring = SPACE(source.vstring,0)
												sourcedrive = filespec('drive',source.vstring)
												sourcepath  = filespec('path',source.vstring)
												sourcefile  = filespec('name',source.vstring)
											end
											if sourcedrive = ' ' then do
												notvalid = 1
											end
											if sourcepath = ' ' then do
												notvalid = 1
											end
											if sourcefile = ' ' then do
												notvalid = 1
											end
											if length(source.vstring) = 0 then do
												notvalid = 1
											end
											if notvalid = 1 then do
												winsource.vstring = 'NOT A VALID ENTRY '
												twoerr = 1
											end
											if numword > 4 then do
												notvalid = 1
												newinput = 'Too Many Words in the Title - max. 4   '
												if twoerr = 0 then do
													winsource.vstring = source.vstring
													if length(source.vstring) > 36 then do
														winsource.vstring = filespec('drive',source.vstring)'\...\'filespec('name',source.vstring)
													end
												end
											end
										end
										if notvalid = 0 then do
									        newinput = substr(newinput,1,21)
											winsource.vstring = source.vstring
											if length(source.vstring) > 36 then do
												winsource.vstring = filespec('drive',source.vstring)'\...\'filespec('name',source.vstring)
											end
										end
										if length(strip(input.vstring)) > 0 then do
											PUSH winsource.vstring
											PULL winsource.vstring
											target.vstring = SPACE(target.vstring,0) 
											target.vstring = substr(target.vstring,1,8)
											PUSH target.vstring
											PULL target.vstring 
										end
										if k = 30 then do
											target.vstring = ' '	
										end
										msg.0 = 8
										msg.1 = '         You have completed the necessary     '
										msg.2 = '          information to save this routine.   '
										msg.3 = '----------------------------------------'
										msg.4 = ' 'newinput
										msg.5 = ' 'winsource.vstring
										msg.6 = ' 'target.vstring
										if length(strip(input.vstring)) = 0 then do
											msg.5 = '                  Unused Choice               '
											msg.6 = ' '
										end
										msg.7 = '----------------------------------------'
										if notvalid = 0 then do
											msg.8 = '        Press YES to Save or NO to continue.'
											rb = VMsgBox('Save Settings....', msg, 6)
										end
										if notvalid = 1 then do
											msg.8 = '               Press OK to cotinue.      '
											rb = VMsgBox('Save Settings....', msg, 1)
										end	
										if rb = 'YES' then do
											if length(strip(input.vstring)) = 0 then do
												sublist = '2818251622141912161013081006070404020100'
												chk = 1
												do while substr(sublist,chk,2) <> i
													chk = chk + 4
												end
												chk = chk + 2
												no = i - substr(sublist,chk,2)
												textline.i = 'Unused Choice 'no
											end
											if length(strip(input.vstring)) > 0 then do
					 	  						textline.i = strip(newinput)
   											end
											i = i + 1
											if length(strip(input.vstring)) > 0 then do
												if length(strip(source.vstring)) = 0 then do
													textline.i = ' '
												end
												if length(strip(source.vstring)) > 0 then do
													textline.i = substr(source.vstring,1)
													PUSH textline.i
													PULL textline.i
												end
											end
											if length(strip(input.vstring)) = 0 then do
												textline.i = ' '
											end
											i = i + 1
											if length(strip(input.vstring)) > 0 then do
												if length(strip(target.vstring)) = 0 then do
													textline.i = ' '
												end
												if length(strip(target.vstring)) > 0 then do
													if substr(target.vstring,2,2) =':\' | substr(target.vstring,1,1) ='\'then do
														target.vstring = substr(target.vstring,4)
														target.vstring = strip(target.vstring,t,'\')
													end
													textline.i = substr(target.vstring,1)
													PUSH textline.i
													PULL textline.i
												end
											end
											if length(strip(input.vstring)) = 0 then do
												textline.i = ' '
											end
											y = 1
											do y = 1 to 29
												writeline.y = '`'strip(textline.y)
											end
											writeline.0 = 29
											RxWrite('writeline.','s2dsetup.fil')
										end
										if rb ='OK' then do
										end
									end
									z = z + 1
								end
								list.vstring = list.1
							end
						end
						list.vstring = list.1
					end
				end
			end
		end
	end
end
CALL VDialogPos 50, 50

/*----------------------------------------------------*/

if rb = 'OK' then do
	i = 1
	win.left   = 2
	win.right  = 58
	win.top    = 50
	win.bottom = 3
	id = VOpenWindow(' Backing up Description....', 'WHITE', win)

	text.1  = ' You are backing up.....'
	text.2  = ' '
	text.3  = ' 'list.vstring                                             
	text.4  = ' -----------------------------'
	text.5  = ' Place a disk in either drive (A: or B:) '
	text.6  = ' '
	text.7  = ' & press OK to continue the copying. Press'
	text.8  = ' '
	text.9  = ' CANCEL to abandon the operation.  If the'
	text.10 = ' '
	text.11 = ' the drive is NOT READY or UNAVAILBLE, you'
	text.12 = ' '
	text.13 = ' you will be prompted to insure the drive'
	text.14 = ' '
	text.15 = ' door is shut & the disk is in the drive or'
	text.16 = ' '
	text.17 = ' if the drive is nonexistant (if so CANCEL).'
	
	CALL VSetFont id, 'SYSTEM', 12

	x = 10
	y = 900
	do l = 1 to 17
	   call VSay id, x, y, text.l
	   y = y - 50
	end

	drivelist.0 = 4
	drivelist.1  = 'A:\ - chosen Dir only '
	drivelist.2  = 'A:\ - total disk space'
	drivelist.3  = 'B:\ - chosen Dir only '
	drivelist.4  = 'B:\ - total disk space'
	drivelist.vstring = drivelist.1
	rb = VRadioBox(' Back up to:            ', drivelist, 3)
	if rb = 'CANCEL' then do
		CALL VCloseWindow id
		CALL CLEANUP
	end
	if rb = 'OK' then do
		CALL VCloseWindow id
		if drivelist.vstring = drivelist.1 | drivelist.vstring = drivelist.2 then do
			if RxQueryDriveType("A:") <> "NOTREADY" then do
				targetdir = 'A:\'
			end
		end
		if drivelist.vstring = drivelist.3 | drivelist.vstring = drivelist.4 then do
			if RxQueryDriveType("B:") <> "NOTREADY"	then do
				targetdir = 'B:\'
			end
		end	

		do while RxQueryDriveType(substr(targetdir,1,2)) = "NOTREADY"
			win.left   = 2
			win.right  = 58
			win.top    = 50
			win.bottom = 3
			zid = VOpenWindow(' Backing up Disk Error.....', 'WHITE', win)

			text.1  = ' You are backing up.....'
			text.2  = ' '
			text.3  = ' 'list.vstring                                             
			text.4  = ' -----------------------------'
			text.5  = ' Place a disk in either drive (A: or B:) '
			text.6  = ' '
			text.7  = ' & press OK to continue the copying. Press'
			text.8  = ' '
			text.9  = ' CANCEL to abandon the operation.  If the'
			text.10 = ' '
			text.11 = ' the drive is NOT READY or UNAVAILBLE, you'
			text.12 = ' '
			text.13 = ' you will be prompted to insure the drive'
			text.14 = ' '
			text.15 = ' door is shut & the disk is in the drive or'
			text.16 = ' '
			text.17 = ' if the drive is nonexistant (if so CANCEL).'

			CALL VSetFont zid, 'SYSTEM', 12
			x = 10
			y = 900
			do l = 1 to 17
			   call VSay zid, x, y, text.l
			   y = y - 50
			end
				
			drivelist.0 = 4
			drivelist.1  = 'A:\ - chosen Dir only '
			drivelist.2  = 'A:\ - total disk space'
			drivelist.3  = 'B:\ - chosen Dir only '
			drivelist.4  = 'B:\ - total disk space'
			drivelist.vstring = drivelist.1
			rb = VRadioBox(' Back up to:            ', drivelist, 3)
			if rb = 'CANCEL' then do
				CALL VCloseWindow zid
				CALL CLEANUP
			end
			if rb = 'OK' then do
				CALL VCloseWindow zid
				if drivelist.vstring = drivelist.1 | drivelist.vstring = drivelist.2 then do
					targetdir = 'A:\'
				end
				if drivelist.vstring = drivelist.3 | drivelist.vstring = drivelist.4 then do
					targetdir = 'B:\'
				end
			end
		end	

   		tabtest = 1
		do while rc = 0 & tabtest = 1
			'XCOPY s2d.tmp' substr(targetdir,1,3)
			tabtest = 0
		end

		if rc = 1 then do
			CALL CLEANUP
		end
		if rc > 2 then do
			CALL CLEANUP
		end

		do while rc = 2 & RxQueryDriveType(substr(targetdir,1,2)) <> "NOTREADY"
			win.left   = 2
			win.right  = 58
			win.top    = 50
			win.bottom = 3
			cid = VOpenWindow(' Disk Error...........', 'WHITE', win)

			text.1  = ' You are backing up.....'
			text.2  = ' '
			text.3  = ' 'list.vstring                                             
			text.4  = ' -----------------------------'
			text.5  = ' The disk that you have placed into the '
			text.6  = ' '
			text.7  = ' drive has no room to accomodate any more'
			text.8  = ' '
			text.9  = ' entries into the FAT Table or the tab is'
			text.10 = ' '
			text.11 = ' still set. If not, then choose TOTAL DISK'
			text.12 = ' '
			text.13 = ' SPACE, or use an empty diskette, or '
			text.14 = ' '
			text.15 = ' choose CHOSEN DIR ONLY and place any '
			text.16 = ' '
			text.17 = ' diskette in the appropriate drive. ***'
	
			CALL VSetFont cid, 'SYSTEM', 12

			x = 10
			y = 900
			do l = 1 to 17
			   call VSay cid, x, y, text.l
			   y = y - 50
			end
	
			drivelist.0 = 2
			drivelist.1  = substr(targetdir,1,3)' - chosen Dir only '
			drivelist.2  = substr(targetdir,1,3)' - total disk space'
			drivelist.vstring = drivelist.1	
			rb = VRadioBox(' Back up to:            ', drivelist, 3)
			if rb = 'CANCEL' then do
				CALL VCloseWindow cid
				CALL CLEANUP
			end
			if rb = 'OK' then do
				CALL VCloseWindow cid
				do while RxQueryDriveType(substr(targetdir,1,2)) = "NOTREADY"
					win.left   = 2
					win.right  = 58
					win.top    = 50
					win.bottom = 3
					zid = VOpenWindow(' Backing up Disk Error.....', 'WHITE', win)

					text.1  = ' You are backing up.....'
					text.2  = ' '
					text.3  = ' 'list.vstring                                             
					text.4  = ' -----------------------------'
					text.5  = ' Place a disk in either drive (A: or B:) '
					text.6  = ' '
					text.7  = ' & press OK to continue the copying. Press'
					text.8  = ' '
					text.9  = ' CANCEL to abandon the operation.  If the'
					text.10 = ' '
					text.11 = ' the drive is NOT READY or UNAVAILBLE, you'
					text.12 = ' '
					text.13 = ' you will be prompted to insure the drive'
					text.14 = ' '
					text.15 = ' door is shut & the disk is in the drive or'
					text.16 = ' '
					text.17 = ' if the drive is nonexistant (if so CANCEL).'
			
					CALL VSetFont zid, 'SYSTEM', 12

					x = 10
					y = 900
					do l = 1 to 17
					   call VSay zid, x, y, text.l
					   y = y - 50
					end
				
					drivelist.0 = 2
					drivelist.1  = substr(targetdir,1,3)' - chosen Dir only '
					drivelist.2  = substr(targetdir,1,3)' - total disk space'
					drivelist.vstring = drivelist.1	
					rb = VRadioBox(' Back up to:            ', drivelist, 3)
					if rb = 'CANCEL' then do
						CALL VCloseWindow zid
						CALL CLEANUP
					end
					if rb = 'OK' then do
						CALL VCloseWindow zid
					end
				end

				tabtest = 1
				rc = 0
				do while rc = 0 & tabtest = 1
					'XCOPY s2d.tmp' substr(targetdir,1,3)
					tabtest = 0
				end
				if rc = 1 then do
					CALL CLEANUP
				end
				if rc > 2 then do
					CALL CLEANUP
				end
			end
			if drivelist.vstring = drivelist.2 then do
				'DEL 'substr(targetdir,1,3)'*.* /N'
				if rc = 255 then do
					CALL CLEANUP
				end
				rc = 0
			end
		end

		if drivelist.vstring = drivelist.2 | drivelist.vstring = drivelist.4 then do
			'DEL 'substr(targetdir,1,3)'*.* /N'
			CALL SysFileTree substr(targetdir,1,3),'dfile', 'DSO'
			n = dfile.0
			do while n > 0
				deltargetdir = dfile.n
				'DEL 'deltargetdir'\*.* /N'
				'RD 'deltargetdir
				n = n - 1
			end
		end

		if drivelist.vstring = drivelist.1 | drivelist.vstring = drivelist.3 then do
			'DEL' substr(targetdir,1,3)'s2d.tmp'
		end
	end
end
		
/*----------------------------------------------------*/

	if list.vstring = list.2 then do
		sourcedir = textline.2
		targetdir = (targetdir)textline.3
	end
	if list.vstring = list.3 then do
		sourcedir = textline.5
		targetdir = (targetdir)textline.6
	end
	if list.vstring = list.4 then do
		sourcedir = textline.8
		targetdir = (targetdir)textline.9
	end
	if list.vstring = list.5 then do
		sourcedir = textline.11
		targetdir = (targetdir)textline.12
	end		
	if list.vstring = list.6 then do
		sourcedir = textline.14
		targetdir = (targetdir)textline.15
	end
	if list.vstring = list.7 then do
		sourcedir = textline.17
		targetdir = (targetdir)textline.18
	end
	if list.vstring = list.8 then do
		sourcedir = textline.20
		targetdir = (targetdir)textline.21
	end
	if list.vstring = list.9 then do
		sourcedir = textline.23
		targetdir = (targetdir)textline.24
	end
	if list.vstring = list.10 then do
		sourcedir = textline.26
		targetdir = (targetdir)textline.27
	end
	if list.vstring = list.11 then do
		sourcedir = textline.29
		CALL checkdisksize
	end
	if list.vstring = list.12 then do
		CALL pickfile
	end
	if length(strip(sourcedir))	<= 2 then do
		CALL notvalidchoice
	end

	CALL SysFileTree sourcedir, 'file', 'FO'

	if file.0 <= 0 then do
		CALL nofilesfound
	end

/*---------------------------------------------------------------------------*/
/* Procedure for checking existance of sub-directory                         */
/*---------------------------------------------------------------------------*/

	info = sysdriveinfo(substr(targetdir,1,1))
	freespace = strip(substr(info,5,7))
	disksize = strip(substr(info,18,7))
	if length(targetdir) > 3 then
		fulltargetdir = (targetdir)'\' 
	else do
		fulltargetdir = targetdir
	end
	if length(targetdir) > 3 & freespace > 512 then do
		copydir = DIRECTORY(targetdir)
		if copydir = targetdir then do
			CALL DIRECTORY currentdir
		end
		if copydir <> targetdir then do
			'MD' targetdir
			CALL DIRECTORY currentdir
		end
	end
	do while length(targetdir) > 3 & freespace <= 512
		msg.0 = 6
		msg.1 = '                   There is not enough room to        '        
		msg.2 = '                    make the target directory.        '
		msg.3 = '                Press YES to delete all the files     '
		msg.4 = '               on this disk or place another disk     '
		msg.5 = '              in the drive and press NO to continue.  '
		msg.6 = '       Make sure the disk is in the drive & ready to copy.'     
		
		rb = VMsgBox(' Lack of Space Error...', msg, 6)
		if rb = 'NO' then do
			info = sysdriveinfo(substr(targetdir,1,1))
			freespace = strip(substr(info,5,7))
			disksize = strip(substr(info,18,7))
			if length(targetdir) > 3 & freespace > 512 then do
				copydir = DIRECTORY(targetdir)
				if copydir = targetdir then do
					CALL DIRECTORY currentdir
				end
				if copydir <> targetdir then do
					'MD' targetdir
					CALL DIRECTORY currentdir
				end
			end
		end
	    if rb = 'YES' then do
	    	leave = 1
			do while RxQueryDriveType(substr(targetdir,1,2)) <> "NOTREADY" & leave = 1
 				tabtest = 1
				rc = 0
				do while rc = 0 & tabtest = 1
					'XCOPY s2d.tmp' substr(targetdir,1,3)
					tabtest = 0
				end
				if rc = 1 then do
					CALL CLEANUP
				end
				if rc > 2 then do
					CALL CLEANUP
				end

				'XCOPY s2d.tmp' substr(targetdir,1,3)
				if rc > 1 then do
					msg.0 = 5
					msg.1 = '             The write-protect tab is       '
					msg.2 = '           still set. Press OK and begin    '
					msg.3 = '         again, with the tab set correctly. '
					msg.4 = '            The disk may be defective       '
					msg.5 = '            or the FAT Table is Full.       '

					rb = VMsgBox(' Write-protect Error', msg, 1)
					if rb = 'OK' then do
				   		CALL CLEANUP
					end
				end
				'DEL 'substr(targetdir,1,3)'*.* /N'
				CALL SysFileTree substr(targetdir,1,3),'dfile', 'DSO'
				n = dfile.0
				do while n > 0
					deltargetdir = dfile.n
					'DEL 'deltargetdir'\*.* /N'
					'RD 'deltargetdir
					n = n - 1
				end
				'MD' targetdir
				leave = 0
			end
		end
	end

/*---------------------------------------------------------------------------*/
/* Procedures for copying files to disk                                      */
/*---------------------------------------------------------------------------*/

	logmessage = DATE('N') TIME('C')': Saving: 'strip(list.vstring)
	call LINEOUT logfile,logmessage
	call LINEOUT logfile
	do while i <= file.0
		continue = 0
		part = filespec('name',file.i)
		CALL DIRECTORY targetdir
		fspec = SysSearchPath('targetdir',part)
		newfilespec = (fulltargetdir)(part)
		CALL DIRECTORY currentdir
		sourcefspecsize = stream(file.i,'C','QUERY SIZE')
		do while sourcefspecsize > disksize
			if length(file.i) > 41 then do
				file.i = filespec('drive',file.i)'\...\'filespec('name',file.i)
			end
			msg.0 = 4
			msg.1 = ' 'file.i
			msg.2 = '           is larger than the total disk space:   '
			msg.3 = '            Press YES to continue copying the      '
			msg.4 = '           rest of the files or NO to exit now.    '
	
			rb = VMsgBox('     File to Large Error:', msg, 6)
			if rb = 'NO' then do
				CALL SysFileTree fulltargetdir'*.*','allfiles','F','*****','***-*'
				logmessage =  DATE('N') TIME('C')': Cancelled: 'strip(list.vstring)
				call LINEOUT logfile,logmessage
				call LINEOUT logfile
				CALL CLEANUP
			end
			if rb = 'YES' then do
				checklog = checklog + 1
				logmessage = ' Too Large: 'file.i
				call LINEOUT logfile,logmessage
				call LINEOUT logfile
			    i = i + 1
				part = filespec('name',file.i)
				CALL DIRECTORY targetdir
				fspec = SysSearchPath('targetdir',part)
				newfilespec = (fulltargetdir)(part)
				CALL DIRECTORY currentdir
				sourcefspecsize = stream(file.i,'C','QUERY SIZE')
		    end
		end
		if fspec = " " then	do
			info = sysdriveinfo(substr(targetdir,1,1))
			freespace = strip(substr(info,5,7))
			if freespace > sourcefspecsize then do
				'COPY' file.i targetdir
				if rc > 0 then do
					checklog = checklog + 1
					logmessage = ' Failed: 'file.i
					call LINEOUT logfile,logmessage
					call LINEOUT logfile
				end
				continue = 0
			end
			if freespace <= sourcefspecsize then do
				continue = 1
			end
		end
		if fspec <> " " then do
			filecopy = 0
			sourcefspec = stream(file.i,'C','QUERY DATETIME')
			copyspec = stream(fspec,'C','QUERY DATETIME')
			if substr(sourcefspec,7,2) > substr(copyspec,7,2) then do
				filecopy = 1
			end
			if substr(sourcefspec,7,2) = substr(copyspec,7,2) &	substr(sourcefspec,1,2) > substr(copyspec,1,2) then do
				filecopy = 1
			end
			if substr(sourcefspec,7,2) = substr(copyspec,7,2) &	substr(sourcefspec,1,2) = substr(copyspec,1,2) then do
				if substr(sourcefspec,4,2) > substr(copyspec,4,2) then do
					filecopy = 1
				end
			end
			if substr(sourcefspec,7,2) = substr(copyspec,7,2) &	substr(sourcefspec,1,2) = substr(copyspec,1,2) then do
				if substr(sourcefspec,4,2) = substr(copyspec,4,2) then do
					if substr(sourcefspec,11) > substr(copyspec,11) then do
						filecopy = 1
					end
				end
			end
   			if filecopy = 1 then do
   				'DEL' fspec
				info = sysdriveinfo(substr(targetdir,1,1))
				freespace = strip(substr(info,5,7))
				if freespace > sourcefspecsize then do
					'COPY' file.i targetdir
					if rc > 0 then do
						checklog = checklog + 1
						logmessage = ' Failed: 'file.i
						call LINEOUT logfile,logmessage
						call LINEOUT logfile
					end
					continue = 0
				end
				if freespace <= sourcefspecsize then do
					continue = 2
				end
			end
		end
		do while continue > 0
			do while freespace <= sourcefspecsize
				CALL SysFileTree fulltargetdir'*.*','filesize','FO','***-*','*****'
				j = filesize.0
				do while j <= 0 & RxQueryDriveType(substr(targetdir,1,2)) <> "NOTREADY"
				    CALL SysFileTree fulltargetdir'*.*','allfiles','F','*****','***-*'
					win.left   = 2
					win.right  = 58
					win.top    = 55
					win.bottom = 8
					naid = VOpenWindow(' Disk Full Error...........', 'WHITE', win)

					text.1  = ' You are backing up.....'
					text.2  = ' '
					text.3  = ' 'list.vstring                                             
					text.4  = ' -----------------------------'
					text.5  = ' The disk that you have placed into the '
					text.6  = ' '
					text.7  = ' drive is full. Place a new disk in the'
					text.8  = ' '
					text.9  = ' appropriate drive and choose CHOSEN DIR'
					text.10 = ' '
					text.11 = ' ONLY or TOTAL DISK SPACE.  If you do not'
					text.12 = ' '
					text.13 = ' replace the diskette, the routine will'
					text.14 = ' '
					text.15 = ' continue and erase some of the files that'
					text.16 = ' '
					text.17 = ' you have already copied. ***************'

					CALL VSetFont naid, 'SYSTEM', 12
					x = 10
					y = 900
					do l = 1 to 17
					    call VSay naid, x, y, text.l
	 				    y = y - 50
					end

					drivelist.0 = 2
					drivelist.1  = substr(targetdir,1,3)' - chosen Dir only '
					drivelist.2  = substr(targetdir,1,3)' - total disk space'
					drivelist.vstring = drivelist.1
					rb = VRadioBox(' Back up to:            ', drivelist, 3)
					if rb = 'CANCEL' then do
						CALL VCloseWindow naid
						logmessage =  DATE('N') TIME('C')': Cancelled: 'strip(list.vstring)
						call LINEOUT logfile,logmessage
						call LINEOUT logfile
						CALL CLEANUP
					end
					if rb = 'OK' then do
						CALL VCloseWindow naid
						do while RxQueryDriveType(substr(targetdir,1,2)) = "NOTREADY"
							win.left   = 2
							win.right  = 58
							win.top    = 55
							win.bottom = 8
							naid = VOpenWindow(' Disk Full Error...........', 'WHITE', win)
		
							text.1  = ' You are backing up.....'
							text.2  = ' '
							text.3  = ' 'list.vstring                                             
							text.4  = ' -----------------------------'
							text.5  = ' Place a disk in either drive (A: or B:) '
							text.6  = ' '
							text.7  = ' & press OK to continue the copying. Press'
							text.8  = ' '
							text.9  = ' CANCEL to abandon the operation.  If the'
							text.10 = ' '
							text.11 = ' the drive is NOT READY or UNAVAILBLE, you'
							text.12 = ' '
							text.13 = ' you will be prompted to insure the drive'
							text.14 = ' '
							text.15 = ' door is shut & the disk is in the drive or'
							text.16 = ' '
							text.17 = ' if the drive is nonexistant (if so CANCEL).'
				
							CALL VSetFont naid, 'SYSTEM', 12
			
							x = 10
							y = 900
							do l = 1 to 17
							    call VSay naid, x, y, text.l
	 						    y = y - 50
							end
	
							drivelist.0 = 2
							drivelist.1  = substr(targetdir,1,3)' - chosen Dir only '
							drivelist.2  = substr(targetdir,1,3)' - total disk space'
							drivelist.vstring = drivelist.1	
							rb = VRadioBox(' Back up to:            ', drivelist, 3)
							if rb = 'CANCEL' then do
								CALL VCloseWindow zid
								logmessage =  DATE('N') TIME('C')': Cancelled: 'strip(list.vstring)
								call LINEOUT logfile,logmessage
								call LINEOUT logfile
								CALL CLEANUP
							end
							if rb = 'OK' then do
								CALL VCloseWindow zid
							end
						end
						tabtest = 1
						rc = 0
						do while rc = 0 & tabtest = 1
							'XCOPY s2d.tmp' substr(targetdir,1,3)
							tabtest = 0
						end
						if rc = 1 then do
							logmessage =  DATE('N') TIME('C')': Cancelled: 'strip(list.vstring)
							call LINEOUT logfile,logmessage
							call LINEOUT logfile
							CALL CLEANUP
						end
						if rc > 2 then do
							logmessage =  DATE('N') TIME('C')': Cancelled: 'strip(list.vstring)
							call LINEOUT logfile,logmessage
							call LINEOUT logfile
							CALL CLEANUP
						end

						if rc = 0 then do
							'DEL' substr(targetdir,1,3)'s2d.tmp'
						end
						
						do while rc = 2 & RxQueryDriveType(substr(targetdir,1,2)) <> "NOTREADY"
							win.left   = 2
							win.right  = 58
							win.top    = 50
							win.bottom = 3
							cid = VOpenWindow(' Disk Error...........', 'WHITE', win)

							text.1  = ' You are backing up.....'
							text.2  = ' '
							text.3  = ' 'list.vstring                                             
							text.4  = ' -----------------------------'
							text.5  = ' The disk that you have placed into the '
							text.6  = ' '
							text.7  = ' drive has no room to accomodate any more'
							text.8  = ' '
							text.9  = ' entries into the FAT Table or the tab is'
							text.10 = ' '
							text.11 = ' still set. If not, then choose TOTAL DISK'
							text.12 = ' '
							text.13 = ' SPACE, or use an empty diskette, or '
							text.14 = ' '
							text.15 = ' choose CHOSEN DIR ONLY and place any '
							text.16 = ' '
							text.17 = ' diskette in the appropriate drive. ***'
	
							CALL VSetFont cid, 'SYSTEM', 12

							x = 10
							y = 900
							do l = 1 to 17
							   call VSay cid, x, y, text.l
							   y = y - 50
							end
	
							drivelist.0 = 2
							drivelist.1  = substr(targetdir,1,3)' - chosen Dir only '
							drivelist.2  = substr(targetdir,1,3)' - total disk space'
							drivelist.vstring = drivelist.1	
							rb = VRadioBox(' Back up to:            ', drivelist, 3)
							if rb = 'CANCEL' then do
								CALL VCloseWindow cid
								logmessage =  DATE('N') TIME('C')': Cancelled: 'strip(list.vstring)
								call LINEOUT logfile,logmessage
								call LINEOUT logfile
								CALL CLEANUP
							end
							if rb = 'OK' then do
								CALL VCloseWindow cid
								do while RxQueryDriveType(substr(targetdir,1,2)) = "NOTREADY"
									win.left   = 2
									win.right  = 58
									win.top    = 50
									win.bottom = 3
									zid = VOpenWindow(' Backing up Disk Error.....', 'WHITE', win)

									text.1  = ' You are backing up.....'
									text.2  = ' '
									text.3  = ' 'list.vstring                                             
									text.4  = ' -----------------------------'
									text.5  = ' Place a disk in either drive (A: or B:) '
									text.6  = ' '
									text.7  = ' & press OK to continue the copying. Press'
									text.8  = ' '
									text.9  = ' CANCEL to abandon the operation.  If the'
									text.10 = ' '
									text.11 = ' the drive is NOT READY or UNAVAILBLE, you'
									text.12 = ' '
									text.13 = ' you will be prompted to insure the drive'
									text.14 = ' '
									text.15 = ' door is shut & the disk is in the drive or'
									text.16 = ' '
									text.17 = ' if the drive is nonexistant (if so CANCEL).'
						
									CALL VSetFont zid, 'SYSTEM', 12
		
									x = 10
									y = 900
									do l = 1 to 17
									   call VSay zid, x, y, text.l
									   y = y - 50
									end
				
									drivelist.0 = 2
									drivelist.1  = substr(targetdir,1,3)' - chosen Dir only '
									drivelist.2  = substr(targetdir,1,3)' - total disk space'
									drivelist.vstring = drivelist.1	
									rb = VRadioBox(' Back up to:            ', drivelist, 3)
									if rb = 'CANCEL' then do
										CALL VCloseWindow zid
										logmessage =  DATE('N') TIME('C')': Cancelled: 'strip(list.vstring)
										call LINEOUT logfile,logmessage
										call LINEOUT logfile
										CALL CLEANUP
									end
									if rb = 'OK' then do
										CALL VCloseWindow zid
									end
								end

								tabtest = 1
								rc = 0
								do while rc = 0 & tabtest = 1
									'XCOPY s2d.tmp' substr(targetdir,1,3)
									tabtest = 0
								end
								if rc = 1 then do
									logmessage =  DATE('N') TIME('C')': Cancelled: 'strip(list.vstring)
									call LINEOUT logfile,logmessage
									call LINEOUT logfile
									CALL CLEANUP
								end
								if rc > 2 then do
									logmessage =  DATE('N') TIME('C')': Cancelled: 'strip(list.vstring)
									call LINEOUT logfile,logmessage
									call LINEOUT logfile
									CALL CLEANUP
								end
							end
							if drivelist.vstring = drivelist.2 then do
								'DEL 'substr(targetdir,1,3)'*.* /N'
								if rc = 255 then do
									CALL CLEANUP
								end
								rc = 0
							end
						end

						if drivelist.vstring = drivelist.2 then do
							'DEL 'substr(targetdir,1,3)'*.* /N'
							CALL SysFileTree substr(targetdir,1,3),'dfile', 'DSO'
							n = dfile.0
							do while n > 0
								deltargetdir = dfile.n
								'DEL 'deltargetdir'\*.* /N'
								'RD 'deltargetdir
								n = n - 1
							end
						end

						info = sysdriveinfo(substr(targetdir,1,1))
						freespace = strip(substr(info,5,7))
						disksize = strip(substr(info,18,7))
						if length(targetdir) > 3 then
							fulltargetdir = (targetdir)'\' 
						else do
							fulltargetdir = targetdir
						end
						if length(targetdir) > 3 & freespace > 512 then do
							copydir = DIRECTORY(targetdir)
							if copydir = targetdir then do
								CALL DIRECTORY currentdir
							end
							if copydir <> targetdir then do
								'MD' targetdir
								CALL DIRECTORY currentdir
							end
						end
						do while length(targetdir) > 3 & freespace <= 512
							msg.0 = 6
							msg.1 = '                   There is not enough room to        '        
							msg.2 = '                    make the target directory.        '
							msg.3 = '                Press YES to delete all the files     '
							msg.4 = '               on this disk or place another disk     '
							msg.5 = '              in the drive and press NO to continue.  '
							msg.6 = '       Make sure the disk is in the drive & ready to copy.'     
	
							rb = VMsgBox(' Blank Source Dir Error:', msg, 6)
							if rb = 'NO' then do
								info = sysdriveinfo(substr(targetdir,1,1))
								freespace = strip(substr(info,5,7))
								disksize = strip(substr(info,18,7))
								if length(targetdir) > 3 & freespace > 512 then do
									copydir = DIRECTORY(targetdir)
									if copydir = targetdir then do
										CALL DIRECTORY currentdir
									end
									if copydir <> targetdir then do
										'MD' targetdir
										CALL DIRECTORY currentdir
									end
								end
							end
						    if rb = 'YES' then do
						    	leave = 1
								do while RxQueryDriveType(substr(targetdir,1,2)) <> "NOTREADY" & leave = 1
					 				tabtest = 1
									rc = 0
									do while rc = 0 & tabtest = 1
										'XCOPY s2d.tmp' substr(targetdir,1,3)
										tabtest = 0
									end
									if rc = 1 then do
										logmessage =  DATE('N') TIME('C')': Cancelled: 'strip(list.vstring)
										call LINEOUT logfile,logmessage
										call LINEOUT logfile
										CALL CLEANUP
									end
									if rc > 2 then do
										logmessage =  DATE('N') TIME('C')': Cancelled: 'strip(list.vstring)
										call LINEOUT logfile,logmessage
										call LINEOUT logfile
										CALL CLEANUP
									end
									'XCOPY s2d.tmp' substr(targetdir,1,3)
									if rc > 1 then do
										msg.0 = 5
										msg.1 = '             The write-protect tab is       '
										msg.2 = '           still set. Press OK and begin    '
										msg.3 = '         again, with the tab set correctly. '
										msg.4 = '            The disk may be defective       '
										msg.5 = '            or the FAT Table is Full.       '

										rb = VMsgBox(' Write-protect Error', msg, 1)
										if rb = 'OK' then do
											logmessage =  DATE('N') TIME('C')': Cancelled: 'strip(list.vstring)
											call LINEOUT logfile,logmessage
											call LINEOUT logfile
									   		CALL CLEANUP
										end
									end
									'DEL 'substr(targetdir,1,3)'*.* /N'
									CALL SysFileTree substr(targetdir,1,3),'dfile', 'DSO'
									n = dfile.0
									do while n > 0
										deltargetdir = dfile.n
										'DEL 'deltargetdir'\*.* /N'
										'RD 'deltargetdir
										n = n - 1
									end
								end
								'MD' targetdir
								leave = 0
							end
							info = sysdriveinfo(substr(targetdir,1,1))
							freespace = strip(substr(info,5,7))
							disksize = strip(substr(info,18,7))
						end
					end
					j = 1
				end
				j = filesize.0
				info = sysdriveinfo(substr(targetdir,1,1))
				freespace = strip(substr(info,5,7))
				disksize = strip(substr(info,18,7))
				if j > 0 then do
					'DEL' filesize.j 
				end
				info = sysdriveinfo(substr(targetdir,1,1))
				freespace = strip(substr(info,5,7))
				if freespace > sourcefspecsize then do
					'COPY' file.i targetdir
					if rc > 0 then do
						checklog = checklog + 1
						logmessage = ' Failed: 'file.i
						call LINEOUT logfile,logmessage
						call LINEOUT logfile
					end
				end
			end
			continue = 0
		end
 		CALL SysFileTree newfilespec,'allfiles','F','*****','***+*'
		i = i + 1
	end		
	CALL SysFileTree fulltargetdir'*.*','allfiles','F','*****','***-*'
	CALL finishcopy

/*---------------------------------------------------------------------------*/
/* Procedure for having chose an entry with a blank source directory         */
/*---------------------------------------------------------------------------*/

notvalidchoice:

	msg.0 = 4
	msg.1 = '       Your choice has an blank '
	msg.2 = '           source directory:'
	msg.3 = ' '
	msg.4 = '          Press OK to Exit.'

	rb = VMsgBox(' Blank Source Dir Error:', msg, 1)
	if rb = 'OK' then do
		CALL CLEANUP
	end

/*---------------------------------------------------------------------------*/
/* Procedure for having chose an entry with no files found in sourcedir      */
/*---------------------------------------------------------------------------*/

nofilesfound:

	msg.0 = 4
	msg.1 = '           There were no files found to'
	msg.2 = '     compare & copy in the chosen directory:'
	msg.3 = ' '
	msg.4 = '                Press OK to Exit. '

	rb = VMsgBox('   No Files Found Error:', msg, 1)
	if rb = 'OK' then do
		CALL CLEANUP
	end

/*---------------------------------------------------------------------------*/
/* Procedure for Total Copy with sub-directories                             */
/*---------------------------------------------------------------------------*/

checkdisksize:

	if length(strip(sourcedir))	<= 3 then do
		CALL noxcopy
	end
	CALL SysFileTree sourcedir, 'file', 'FSO'
	if file.0 <= 0 then do
		CALL nofilesfound
	end
	part = filespec('path',sourcedir)
	targetdir = substr(targetdir,1,3)substr(part,2,)
	info = sysdriveinfo(substr(targetdir,1,1))
	freespace = strip(substr(info,5,7))
	disksize = strip(substr(info,18,7))
	sourcesize = 0
	targetsize = 0
	i = 1	
	do while i <= file.0
		sizefspec = stream(file.i,'C','QUERY SIZE')
		i = i + 1
		sourcesize = sourcesize + sizefspec
		if sourcesize > disksize then do
			CALL totalfilenewdisk
		end
	end
	copydir = DIRECTORY(strip(targetdir,t,'\'))
	if copydir = strip(targetdir,t,'\') then do
		CALL SysFileTree targetdir'*.*', 'tfile', 'FSO'
		i = 1
		do while i <= tfile.0
			tsizefspec = stream(tfile.i,'C','QUERY SIZE')
			i = i + 1
			targetsize = targetsize + tsizefspec
		end
	end
	CALL DIRECTORY currentdir
	CALL totalcopy

/*---------------------------------------------------------------------------*/

noxcopy:

	msg.0 = 5
	msg.1 = '       You should not use a root'
	msg.2 = '    directory of any drive for this'
	msg.3 = '    routine.  Please correct error'
	msg.4 = '      in the SOURCEDIR variable.'

	rb = VMsgBox(' Invalid Xcopy Sourcedir', msg, 1)
	if rb = 'OK' then do
		CALL CLEANUP
	end

/*---------------------------------------------------------------------------*/

totalcopy:

	logmessage = DATE('N') TIME('C')': Xcopy Saving: 'strip(list.vstring)
	call LINEOUT logfile,logmessage
	call LINEOUT logfile
	if freespace + targetsize >= sourcesize then do
		'XCOPY 'sourcedir' 'targetdir' /E/S'
		CALL finishcopy
	end
	CALL totalfilenewdisk

/*---------------------------------------------------------------------------*/

totalfilenewdisk:

	if sourcesize > disksize then do
		CALL totalfile2big
	end

	win.left   = 2
	win.right  = 58
	win.top    = 50
	win.bottom = 3
	cid = VOpenWindow(' Disk Full Error...........', 'WHITE', win)
	
	text.1  = ' You are backing up.....'
	text.2  = ' '
	text.3  = ' 'list.vstring                                             
	text.4  = ' -----------------------------'
	text.5  = ' The disk that you have placed into the '
	text.6  = ' '
	text.7  = ' drive is too full to accomodate the files.'
	text.8  = ' '
	text.9  = ' Please choose TOTAL DISK SPACE and use '
	text.10 = ' '
	text.11 = ' the same diskette, choose CHOSEN DIR ONLY'
	text.12 = ' '
	text.13 = ' and replace with an empty diskette, or '
	text.14 = ' '
	text.15 = ' choose TOTAL DISK SPACE and place any '
	text.16 = ' '
	text.17 = ' diskette in the appropriate drive. ***'

	CALL VSetFont cid, 'SYSTEM', 12
	x = 10
	y = 900
	do l = 1 to 17
	   call VSay cid, x, y, text.l
	   y = y - 50
	end
	
	drivelist.0 = 2
	drivelist.1  = substr(targetdir,1,3)' - chosen Dir only '
	drivelist.2  = substr(targetdir,1,3)' - total disk space'
	drivelist.vstring = drivelist.1	
	rb = VRadioBox(' Back up to:            ', drivelist, 3)
	if rb = 'CANCEL' then do
		CALL VCloseWindow cid
		logmessage =  DATE('N') TIME('C')': Cancelled: 'strip(list.vstring)
		call LINEOUT logfile,logmessage
		call LINEOUT logfile
		CALL CLEANUP
	end
	if rb = 'OK' then do
		CALL VCloseWindow cid
		do while RxQueryDriveType(substr(targetdir,1,2)) = "NOTREADY"
			win.left   = 2
			win.right  = 58
			win.top    = 50
			win.bottom = 3
			zid = VOpenWindow(' Disk Full Error...........', 'WHITE', win)
	
			text.1  = ' You are backing up.....'
			text.2  = ' '
			text.3  = ' 'list.vstring                                             
			text.4  = ' -----------------------------'
			text.5  = ' Place a disk in either drive (A: or B:) '
			text.6  = ' '
			text.7  = ' & press OK to continue the copying. Press'
			text.8  = ' '
			text.9  = ' CANCEL to abandon the operation.  If the'
			text.10 = ' '
			text.11 = ' the drive is NOT READY or UNAVAILBLE, you'
			text.12 = ' '
			text.13 = ' you will be prompted to insure the drive'
			text.14 = ' '
			text.15 = ' door is shut & the disk is in the drive or'
			text.16 = ' '
			text.17 = ' if the drive is nonexistant (if so CANCEL).'

			CALL VSetFont zid, 'SYSTEM', 12
			x = 10
			y = 900
			do l = 1 to 17
			   call VSay zid, x, y, text.l
			   y = y - 50
			end
		
			drivelist.0 = 2
			drivelist.1  = substr(targetdir,1,3)' - chosen Dir only '
			drivelist.2  = substr(targetdir,1,3)' - total disk space'
			drivelist.vstring = drivelist.1	
			rb = VRadioBox(' Back up to:            ', drivelist, 3)
			if rb = 'CANCEL' then do
				CALL VCloseWindow zid
				logmessage =  DATE('N') TIME('C')': Cancelled: 'strip(list.vstring)
				call LINEOUT logfile,logmessage
				call LINEOUT logfile
				CALL CLEANUP
			end
			if rb = 'OK' then do
				CALL VCloseWindow zid
			end
		end
		tabtest = 1
		rc = 0
		do while rc = 0 & tabtest = 1
			'XCOPY s2d.tmp' substr(targetdir,1,3)
			tabtest = 0
		end
		if rc = 1 then do
			logmessage =  DATE('N') TIME('C')': Cancelled: 'strip(list.vstring)
			call LINEOUT logfile,logmessage
			call LINEOUT logfile
			CALL CLEANUP
		end
		if rc > 2 then do
			logmessage =  DATE('N') TIME('C')': Cancelled: 'strip(list.vstring)
			call LINEOUT logfile,logmessage
			call LINEOUT logfile
			CALL CLEANUP
		end
	end
	
	do while rc = 2 & RxQueryDriveType(substr(targetdir,1,2)) <> "NOTREADY"
		win.left   = 2
		win.right  = 58
		win.top    = 50
		win.bottom = 3
		cid = VOpenWindow(' Disk Error...........', 'WHITE', win)

		text.1  = ' You are backing up.....'
		text.2  = ' '
		text.3  = ' 'list.vstring                                             
		text.4  = ' -----------------------------'
		text.5  = ' The disk that you have placed into the '
		text.6  = ' '
		text.7  = ' drive has no room to accomodate any more'
		text.8  = ' '
		text.9  = ' entries into the FAT Table or the tab is'
		text.10 = ' '
		text.11 = ' still set. If not, then choose TOTAL DISK'
		text.12 = ' '
		text.13 = ' SPACE, or use an empty diskette, or '
		text.14 = ' '
		text.15 = ' choose CHOSEN DIR ONLY and place any '
		text.16 = ' '
		text.17 = ' diskette in the appropriate drive. ***'
	
		CALL VSetFont cid, 'SYSTEM', 12

		x = 10
		y = 900
		do l = 1 to 17
			call VSay cid, x, y, text.l
			y = y - 50
		end

		drivelist.0 = 2
		drivelist.1  = substr(targetdir,1,3)' - chosen Dir only '
		drivelist.2  = substr(targetdir,1,3)' - total disk space'
		drivelist.vstring = drivelist.1	
		rb = VRadioBox(' Back up to:            ', drivelist, 3)
		if rb = 'CANCEL' then do
			CALL VCloseWindow cid
			logmessage =  DATE('N') TIME('C')': Cancelled: 'strip(list.vstring)
			call LINEOUT logfile,logmessage
			call LINEOUT logfile
			CALL CLEANUP
		end
		if rb = 'OK' then do
			CALL VCloseWindow cid
			do while RxQueryDriveType(substr(targetdir,1,2)) = "NOTREADY"
				win.left   = 2
				win.right  = 58
				win.top    = 50
				win.bottom = 3
				zid = VOpenWindow(' Backing up Disk Error.....', 'WHITE', win)
	
				text.1  = ' You are backing up.....'
				text.2  = ' '
				text.3  = ' 'list.vstring                                             
				text.4  = ' -----------------------------'
				text.5  = ' Place a disk in either drive (A: or B:) '
				text.6  = ' '
				text.7  = ' & press OK to continue the copying. Press'
				text.8  = ' '
				text.9  = ' CANCEL to abandon the operation.  If the'
				text.10 = ' '
				text.11 = ' the drive is NOT READY or UNAVAILBLE, you'
				text.12 = ' '
				text.13 = ' you will be prompted to insure the drive'
				text.14 = ' '
				text.15 = ' door is shut & the disk is in the drive or'
				text.16 = ' '
				text.17 = ' if the drive is nonexistant (if so CANCEL).'
		
				CALL VSetFont zid, 'SYSTEM', 12

				x = 10
				y = 900
				do l = 1 to 17
				   call VSay zid, x, y, text.l
				   y = y - 50
				end
		
				drivelist.0 = 2
				drivelist.1  = substr(targetdir,1,3)' - chosen Dir only '
				drivelist.2  = substr(targetdir,1,3)' - total disk space'
				drivelist.vstring = drivelist.1	
				rb = VRadioBox(' Back up to:            ', drivelist, 3)
				if rb = 'CANCEL' then do
					CALL VCloseWindow zid
					logmessage =  DATE('N') TIME('C')': Cancelled: 'strip(list.vstring)
					call LINEOUT logfile,logmessage
					call LINEOUT logfile
					CALL CLEANUP
				end
				if rb = 'OK' then do
					CALL VCloseWindow zid
				end
			end			

			tabtest = 1
			rc = 0
			do while rc = 0 & tabtest = 1
				'XCOPY s2d.tmp' substr(targetdir,1,3)
				tabtest = 0
			end
			if rc = 1 then do
				logmessage =  DATE('N') TIME('C')': Cancelled: 'strip(list.vstring)
				call LINEOUT logfile,logmessage
				call LINEOUT logfile
				CALL CLEANUP
			end
			if rc > 2 then do
				logmessage =  DATE('N') TIME('C')': Cancelled: 'strip(list.vstring)
				call LINEOUT logfile,logmessage
				call LINEOUT logfile
				CALL CLEANUP
			end
		end
		if drivelist.vstring = drivelist.2 then do
			'DEL 'substr(targetdir,1,3)'*.* /N'
			if rc = 255 then do
				CALL CLEANUP
			end
			rc = 0
		end
	end
	
	if drivelist.vstring = drivelist.2 then do
		'DEL 'substr(targetdir,1,3)'*.* /N'
		CALL SysFileTree substr(targetdir,1,3),'dfile', 'DSO'
		n = dfile.0
		do while n > 0
			deltargetdir = dfile.n
			'DEL 'deltargetdir'\*.* /N'
			'RD 'deltargetdir
			n = n - 1
		end
	end

	if drivelist.vstring = drivelist.1 then do
		'DEL' substr(targetdir,1,3)'s2d.tmp'
	end

	CALL checkdisksize

/*---------------------------------------------------------------------------*/

totalfile2big:

	msg.0 = 3
	msg.1 = '               The files chosen are larger than the total disk space:      '
	msg.2 = '                          If possible, reduce the file size,                 '
	msg.3 = '                      otherwise, use another Backup Routine.               '
	
	rb = VMsgBox('           Files are to Large Error:', msg, 1)
	if rb = 'OK' then do
		checklog = checklog + 1
		logmessage = ' Xcopy to Large: 'sourcedir
		call LINEOUT logfile,logmessage
		logmessage =  DATE('N') TIME('C')': Cancelled: 'strip(list.vstring)
		call LINEOUT logfile,logmessage
		call LINEOUT logfile
		CALL CLEANUP
	end

/*---------------------------------------------------------------------------*/
/* Procedures for Pick a File Routine                                        */
/*---------------------------------------------------------------------------*/

pickfile:

	info = sysdriveinfo(substr(targetdir,1,1))
	freespace = strip(substr(info,5,7))
	disksize = strip(substr(info,18,7))
	button = VFileBox('Pick a file...', 'C:\', 'file')
	if button = "CANCEL" then do
		CALL CLEANUP
	end		
	if button = "OK" then do
		logmessage = DATE('N') TIME('C')': Saving File: 'file.vstring
		call LINEOUT logfile,logmessage
		call LINEOUT logfile
		winfilename = file.vstring
		if length(file.vstring) > 30 then do
			filename = filespec('drive',file.vstring)'\...\'filespec('name',file.vstring)
		end
		msg.0 = 2
		msg.1 = ' File name picked was:         '
		msg.2 = ' 'winfilename

		button = VMsgBox('    File Copy Routine', msg, 3)
		if button = "CANCEL" then do
			logmessage =  DATE('N') TIME('C')': Cancelled: 'strip(list.vstring)
			call LINEOUT logfile,logmessage
			call LINEOUT logfile
			CALL CLEANUP
		end
		if button = 'OK' then do
			pickdrive = filespec('drive',file.vstring)
			pickpath = filespec('path',file.vstring)
			pickfile = filespec('name',file.vstring)
			picksearch = (pickdrive)(pickpath)
			if length(picksearch) > 3 then do
				longsearch = strip(picksearch,t,'\')							
				CALL DIRECTORY(longsearch)
			end
			if length(picksearch) = 3 then do
				CALL DIRECTORY(picksearch)
			end
			fspec = SysSearchPath('picksearch',pickfile)
			CALL DIRECTORY currentdir
			if fspec = " " then do
				CALL pickfilenotfound
			end
			sourcefspecsize = stream(file.vstring,'C','QUERY SIZE')
			if freespace > sourcefspecsize then do
				pickdrive = filespec('drive',file.vstring)
				if pickdrive'\' = targetdir then do
					checklog = checklog + 1
					logmessage = ' Failed: 'file.vstring
					call LINEOUT logfile,logmessage
					call LINEOUT logfile
				end
				if pickdrive = 'B:' & targetdir = 'A:\' then do
					checklog = checklog + 1
					logmessage = ' Failed: 'file.vstring
					call LINEOUT logfile,logmessage
					call LINEOUT logfile
				end
				if pickdrive = 'A:' & targetdir = 'B:\' then do
					checklog = checklog + 1
					logmessage = ' Failed: 'file.vstring
					call LINEOUT logfile,logmessage
					call LINEOUT logfile
				end
				if checklog = 0 then do
					'COPY' file.vstring targetdir
				end
				if rc > 0 then do
					checklog = checklog + 1
					logmessage = ' Failed: 'file.vstring
					call LINEOUT logfile,logmessage
					call LINEOUT logfile
				end
				list.vstring = file.vstring
				CALL finishcopy
			end
			if sourcefspecsize > disksize then do
				CALL pickfile2big
			end
			do while freespace <= sourcefspecsize
				CALL SysFileTree fulltargetdir'*.*','filesize','FO','***-*','*****'
				j = filesize.0 - 1
				if j <= 0 then do
					win.left   = 2
					win.right  = 58
					win.top    = 50
					win.bottom = 3
					cid = VOpenWindow(' Disk Full Error...........', 'WHITE', win)
	
					text.1  = ' You are backing up.....'
					text.2  = ' '
					text.3  = ' 'list.vstring                                             
					text.4  = ' -----------------------------'
					text.5  = ' The disk that you have placed into the '
					text.6  = ' '
					text.7  = ' drive is too full to accomodate the files.'
					text.8  = ' '
					text.9  = ' Please choose TOTAL DISK SPACE and use '
					text.10 = ' '
					text.11 = ' the same diskette, choose CHOSEN DIR ONLY'
					text.12 = ' '
					text.13 = ' and replace with an empty diskette, or '
					text.14 = ' '
					text.15 = ' choose TOTAL DISK SPACE and place any '
					text.16 = ' '
					text.17 = ' diskette in the appropriate drive. ***'

					CALL VSetFont cid, 'SYSTEM', 12
					x = 10
					y = 900
					do l = 1 to 17
					   call VSay cid, x, y, text.l
					   y = y - 50
					end
	
					drivelist.0 = 2
					drivelist.1  = substr(targetdir,1,3)' - chosen Dir only '
					drivelist.2  = substr(targetdir,1,3)' - total disk space'
					drivelist.vstring = drivelist.1	
					rb = VRadioBox(' Back up to:            ', drivelist, 3)
					if rb = 'CANCEL' then do
						CALL VCloseWindow cid
						logmessage =  DATE('N') TIME('C')': Cancelled: 'strip(list.vstring)
						call LINEOUT logfile,logmessage
						call LINEOUT logfile
						CALL CLEANUP
					end
					if rb = 'OK' then do
						CALL VCloseWindow cid
						do while RxQueryDriveType(substr(targetdir,1,2)) = "NOTREADY"
							win.left   = 2
							win.right  = 58
							win.top    = 50
							win.bottom = 3
							zid = VOpenWindow(' Disk Full Error...........', 'WHITE', win)
						
							text.1  = ' You are backing up.....'
							text.2  = ' '
							text.3  = ' 'list.vstring                                             
							text.4  = ' -----------------------------'
							text.5  = ' Place a disk in either drive (A: or B:) '
							text.6  = ' '
							text.7  = ' & press OK to continue the copying. Press'
							text.8  = ' '
							text.9  = ' CANCEL to abandon the operation.  If the'
							text.10 = ' '
							text.11 = ' the drive is NOT READY or UNAVAILBLE, you'
							text.12 = ' '
							text.13 = ' you will be prompted to insure the drive'
							text.14 = ' '
							text.15 = ' door is shut & the disk is in the drive or'
							text.16 = ' '
							text.17 = ' if the drive is nonexistant (if so CANCEL).'

							CALL VSetFont zid, 'SYSTEM', 12

							x = 10
							y = 900
							do l = 1 to 17
							   call VSay zid, x, y, text.l
							   y = y - 50
							end
		
							drivelist.0 = 2
							drivelist.1  = substr(targetdir,1,3)' - chosen Dir only '
							drivelist.2  = substr(targetdir,1,3)' - total disk space'
							drivelist.vstring = drivelist.1	
							rb = VRadioBox(' Back up to:            ', drivelist, 3)
							if rb = 'CANCEL' then do
								CALL VCloseWindow zid
								logmessage =  DATE('N') TIME('C')': Cancelled: 'strip(list.vstring)
								call LINEOUT logfile,logmessage
								call LINEOUT logfile
								CALL CLEANUP
							end
							if rb = 'OK' then do
								CALL VCloseWindow zid
							end
						end
						tabtest = 1
						rc = 0
						do while rc = 0 & tabtest = 1
							'XCOPY s2d.tmp' substr(targetdir,1,3)
							tabtest = 0
						end
						if rc = 1 then do
							logmessage =  DATE('N') TIME('C')': Cancelled: 'strip(list.vstring)
							call LINEOUT logfile,logmessage
							call LINEOUT logfile
							CALL CLEANUP
						end
						if rc > 2 then do
							logmessage =  DATE('N') TIME('C')': Cancelled: 'strip(list.vstring)
							call LINEOUT logfile,logmessage
							call LINEOUT logfile
							CALL CLEANUP
						end
					end

					do while rc = 2 & RxQueryDriveType(substr(targetdir,1,2)) <> "NOTREADY"
						win.left   = 2
						win.right  = 58
						win.top    = 50
						win.bottom = 3
						cid = VOpenWindow(' Disk Error...........', 'WHITE', win)

						text.1  = ' You are backing up.....'
						text.2  = ' '
						text.3  = ' 'list.vstring                                             
						text.4  = ' -----------------------------'
						text.5  = ' The disk that you have placed into the '
						text.6  = ' '
						text.7  = ' drive has no room to accomodate any more'
						text.8  = ' '
						text.9  = ' entries into the FAT Table or the tab is'
						text.10 = ' '
						text.11 = ' still set. If not, then choose TOTAL DISK'
						text.12 = ' '
						text.13 = ' SPACE, or use an empty diskette, or '
						text.14 = ' '
						text.15 = ' choose CHOSEN DIR ONLY and place any '
						text.16 = ' '
						text.17 = ' diskette in the appropriate drive. ***'

						CALL VSetFont cid, 'SYSTEM', 12

						x = 10
						y = 900
						do l = 1 to 17
						   call VSay cid, x, y, text.l
						   y = y - 50
						end

						drivelist.0 = 2
						drivelist.1  = substr(targetdir,1,3)' - chosen Dir only '
						drivelist.2  = substr(targetdir,1,3)' - total disk space'
						drivelist.vstring = drivelist.1	
						rb = VRadioBox(' Back up to:            ', drivelist, 3)
						if rb = 'CANCEL' then do
							CALL VCloseWindow cid
							logmessage =  DATE('N') TIME('C')': Cancelled: 'strip(list.vstring)
							call LINEOUT logfile,logmessage
							call LINEOUT logfile
							CALL CLEANUP
						end
						if rb = 'OK' then do
							CALL VCloseWindow cid
							do while RxQueryDriveType(substr(targetdir,1,2)) = "NOTREADY"
								win.left   = 2
								win.right  = 58
								win.top    = 50
								win.bottom = 3
								zid = VOpenWindow(' Backing up Disk Error.....', 'WHITE', win)

								text.1  = ' You are backing up.....'
								text.2  = ' '
								text.3  = ' 'list.vstring                                             
								text.4  = ' -----------------------------'
								text.5  = ' Place a disk in either drive (A: or B:) '
								text.6  = ' '
								text.7  = ' & press OK to continue the copying. Press'
								text.8  = ' '
								text.9  = ' CANCEL to abandon the operation.  If the'
								text.10 = ' '
								text.11 = ' the drive is NOT READY or UNAVAILBLE, you'
								text.12 = ' '
								text.13 = ' you will be prompted to insure the drive'
								text.14 = ' '
								text.15 = ' door is shut & the disk is in the drive or'
								text.16 = ' '
								text.17 = ' if the drive is nonexistant (if so CANCEL).'
						
								CALL VSetFont zid, 'SYSTEM', 12
		
								x = 10
								y = 900
								do l = 1 to 17
								   call VSay zid, x, y, text.l
								   y = y - 50
								end
			
								drivelist.0 = 2
								drivelist.1  = substr(targetdir,1,3)' - chosen Dir only '
								drivelist.2  = substr(targetdir,1,3)' - total disk space'
								drivelist.vstring = drivelist.1	
								rb = VRadioBox(' Back up to:            ', drivelist, 3)
								if rb = 'CANCEL' then do
									CALL VCloseWindow zid
									logmessage =  DATE('N') TIME('C')': Cancelled: 'strip(list.vstring)
									call LINEOUT logfile,logmessage
									call LINEOUT logfile
									CALL CLEANUP
								end
								if rb = 'OK' then do
									CALL VCloseWindow zid
								end
							end

							tabtest = 1
							rc = 0
							do while rc = 0 & tabtest = 1
								'XCOPY s2d.tmp' substr(targetdir,1,3)
								tabtest = 0
							end
							if rc = 1 then do
								logmessage =  DATE('N') TIME('C')': Cancelled: 'strip(list.vstring)
								call LINEOUT logfile,logmessage
								call LINEOUT logfile
								CALL CLEANUP
							end
							if rc > 2 then do
								logmessage =  DATE('N') TIME('C')': Cancelled: 'strip(list.vstring)
								call LINEOUT logfile,logmessage
								call LINEOUT logfile
								CALL CLEANUP
							end
						end
						if drivelist.vstring = drivelist.2 then do
							'DEL 'substr(targetdir,1,3)'*.* /N'
							if rc = 255 then do
								CALL CLEANUP
							end
							rc = 0
						end
					end

					if drivelist.vstring = drivelist.2 then do
						'DEL 'substr(targetdir,1,3)'*.* /N'
						CALL SysFileTree substr(targetdir,1,3),'dfile', 'DSO'
						n = dfile.0
						do while n > 0
							deltargetdir = dfile.n
							'DEL 'deltargetdir'\*.* /N'
							'RD 'deltargetdir
							n = n - 1
						end
					end

					if drivelist.vstring = drivelist.1 then do
						'DEL' substr(targetdir,1,3)'s2d.tmp'
					end
					
					sourcefspecsize = stream(file.vstring,'C','QUERY SIZE')
					if freespace > sourcefspecsize then do
						pickdrive = filespec('drive',file.vstring)
						if pickdrive'\' = targetdir then do
							checklog = checklog + 1
							logmessage = ' Failed: 'file.vstring
							call LINEOUT logfile,logmessage
							call LINEOUT logfile
						end
						if pickdrive = 'B:' & targetdir = 'A:\' then do
							checklog = checklog + 1
							logmessage = ' Failed: 'file.vstring
							call LINEOUT logfile,logmessage
							call LINEOUT logfile
						end
						if pickdrive = 'A:' & targetdir = 'B:\' then do
							checklog = checklog + 1
							logmessage = ' Failed: 'file.vstring
							call LINEOUT logfile,logmessage
							call LINEOUT logfile
						end
						if checklog = 0 then do
							'COPY' file.vstring targetdir
						end
						if rc > 0 then do
							checklog = checklog + 1
							logmessage = ' Failed: 'file.vstring
							call LINEOUT logfile,logmessage
							call LINEOUT logfile
						end
						list.vstring = file.vstring
						CALL finishcopy
					end
					do while freespace <= sourcefspecsize
						msg.0 = 6
						msg.1 = '                 There is not enough room to            '        
						msg.2 = '                      copy this file.                   '
						msg.3 = '               Press OK to delete all the files         '
						msg.4 = '            on this disk or any other disk that you     '
						msg.5 = '        place in the drive. Check the write-protect tab.  '
						msg.6 = '           Press CANCEL to abandon the operation.        '     
	
						rb = VMsgBox(' Lack of Space Error....', msg, 3)
						if rb = 'CANCEL' then do
							logmessage =  DATE('N') TIME('C')': Cancelled: 'strip(list.vstring)
							call LINEOUT logfile,logmessage
							call LINEOUT logfile
							CALL CLEANUP
						end
					    if rb = 'OK' then do
							leave = 1
							do while RxQueryDriveType(substr(targetdir,1,2)) <> "NOTREADY" & leave = 1
				 				tabtest = 1
								rc = 0
								do while rc = 0 & tabtest = 1
									'XCOPY s2d.tmp' substr(targetdir,1,3)
									tabtest = 0
								end
								if rc = 1 then do
									logmessage =  DATE('N') TIME('C')': Cancelled: 'strip(list.vstring)
									call LINEOUT logfile,logmessage
									call LINEOUT logfile
									CALL CLEANUP
								end
								if rc > 2 then do
									logmessage =  DATE('N') TIME('C')': Cancelled: 'strip(list.vstring)
									call LINEOUT logfile,logmessage
									call LINEOUT logfile
									CALL CLEANUP
								end
								'XCOPY s2d.tmp' substr(targetdir,1,3)
								if rc > 1 then do
									msg.0 = 5
									msg.1 = '             The write-protect tab is       '
									msg.2 = '           still set. Press OK and begin    '
									msg.3 = '         again, with the tab set correctly. '
									msg.4 = '            The disk may be defective       '
									msg.5 = '            or the FAT Table is Full.       '

									rb = VMsgBox(' Write-protect Error', msg, 1)
									if rb = 'OK' then do
										logmessage =  DATE('N') TIME('C')': Cancelled: 'strip(list.vstring)
										call LINEOUT logfile,logmessage
										call LINEOUT logfile
								   		CALL CLEANUP
									end
								end
								'DEL 'substr(targetdir,1,3)'*.* /N'
								CALL SysFileTree substr(targetdir,1,3),'dfile', 'DSO'
								n = dfile.0
								do while n > 0
									deltargetdir = dfile.n
									'DEL 'deltargetdir'\*.* /N'
									'RD 'deltargetdir
									n = n - 1
								end
								leave = 0
							end
						end
						info = sysdriveinfo(substr(targetdir,1,1))
						freespace = strip(substr(info,5,7))
					end
				end
				CALL SysFileTree targetdir'*.*','filesize','FO','***-*'
				j = filesize.0 - 1
				if j > 0 then do
					'DEL' filesize.j 
				end
				info = sysdriveinfo(substr(targetdir,1,1))
				freespace = strip(substr(info,5,7))
			end
			pickdrive = filespec('drive',file.vstring)
			if pickdrive'\' = targetdir then do
				checklog = checklog + 1
				logmessage = ' Failed: 'file.vstring
				call LINEOUT logfile,logmessage
				call LINEOUT logfile
			end
			if pickdrive = 'B:' & targetdir = 'A:\' then do
				checklog = checklog + 1
				logmessage = ' Failed: 'file.vstring
				call LINEOUT logfile,logmessage
				call LINEOUT logfile
			end
			if pickdrive = 'A:' & targetdir = 'B:\' then do
				checklog = checklog + 1
				logmessage = ' Failed: 'file.vstring
				call LINEOUT logfile,logmessage
				call LINEOUT logfile
			end
			if checklog = 0 then do
				'COPY' file.vstring targetdir
			end
			if rc > 0 then do
				checklog = checklog + 1
				logmessage = ' Failed: 'file.vstring
				call LINEOUT logfile,logmessage
				call LINEOUT logfile
			end
			list.vstring = file.vstring
			CALL finishcopy
		end
    end

/*---------------------------------------------------------------------------*/

pickfile2big:

	if length(file.vstring) > 41 then do
		file.vstring = filespec('drive',file.vstring)'\...\'filespec('name',file.vstring)
	end
	msg.0 = 4
	msg.1 = ' 'file.vstring
	msg.2 = '       is larger than the total disk space:   '
	msg.3 = '        If possible, reduce the file size,    '
	msg.4 = '      otherwise, use another Backup Routine.  '
	
	rb = VMsgBox('     File to Large Error:', msg, 1)
	if rb = 'OK' then do
		checklog = checklog + 1
		logmessage = ' Too Large: 'file.vstring
		call LINEOUT logfile,logmessage
		logmessage =  DATE('N') TIME('C')': Cancelled: 'strip(list.vstring)
		call LINEOUT logfile,logmessage
		call LINEOUT logfile
		CALL CLEANUP
	end

/*---------------------------------------------------------------------------*/

pickfilenotfound:

	if length(file.vstring) > 54 then do
		file.vstring = filespec('drive',file.vstring)'\...\'filespec('name',file.vstring)
	end
	msg.0 = 4
	msg.1 = '    'file.vstring
	msg.2 = '               has not been found in either the default        '
	msg.3 = '          path chosen or the path typed in the entry field.   '
	msg.4 = '                        Press OK to Exit.                     '
	
	rb = VMsgBox('                             File Not Found Error:', msg, 1)
	if rb = 'OK' then do
		checklog = checklog + 1
		logmessage = ' Not Found: 'file.vstring
		call LINEOUT logfile,logmessage
		logmessage =  DATE('N') TIME('C')': Cancelled: 'strip(list.vstring)
		call LINEOUT logfile,logmessage
		call LINEOUT logfile
		CALL CLEANUP
	end

/*---------------------------------------------------------------------------*/
/* Timed closing window routine                                              */
/*---------------------------------------------------------------------------*/

finishcopy:

	if length(list.vstring) > 37 then do
		list.vstring = filespec('drive',list.vstring)'\...\'filespec('name',list.vstring)
	end
	logmessage =  DATE('N') TIME('C')': Save has Ended for: 'strip(list.vstring)
	call LINEOUT logfile,logmessage
	call LINEOUT logfile

	if checklog > 0 then do	
		win.left   = 1
		win.right  = 45
		win.top    = 40
		win.bottom = 25
		eid = VOpenWindow(' Error...', 'WHITE', win)

		text.1  = ' '
		text.2  = ' '
		text.3  = ' There were 'checklog' file(s) '
		text.4  = ' '
		text.5  = ' '
		text.6  = ' '
		text.7  = ' chosen to copy that failed. '                     
		text.8  = ' '
		text.9  = ' '
		text.10 = ' '
		text.11 = ' Please use the Viewing Tools to'
		text.12 = ' '
		text.13 = ' '
		text.14 = ' '
		text.15 = ' check the Sav2disk Backup Log.'
	
		CALL VSetFont eid, 'SYSTEM', 12

		x = 10
		y = 900
		do m = 1 to 15
		   call VSay eid, x, y, text.m
		   y = y - 50
		end
	end

	if checklog > 0 then do
		win.left   = 25
		win.right  = 75
		win.top    = 80
		win.bottom = 40
	end
	if checklog = 0 then do
		win.left   = 20
		win.right  = 70
		win.top    = 80
		win.bottom = 40
	end
			
	fid = VOpenWindow(' Backing up Completed....', 'WHITE', win)

	text.1  = ' You have finished backing up........'
	text.2  = ' '
	text.3  = ' 'list.vstring                                             
	text.4  = ' ------------------------------------'
	text.5  = ' '
	text.6  = '  This routine using Vrexx2 & Rxextras'
	text.7  = ' '
	text.8  = '  was written by:    Charles Cohen   '
	text.9 = ' '
	text.10 = '  This was written for personnal use '
	text.11 = ' '
	text.12 = '  and was posted as FREEWARE.........'
	text.13 = ' '
	text.14 = '  I hope that you find this usefull. '
	text.15 = ' ------------------------------------'                                  
	text.16 = ' '                                  
	text.17 = '* THE WINDOW WILL CLOSE IN 5 SECONDS. *'
	
	CALL VSetFont fid, 'SYSTEM', 12

	x = 10
	y = 900
	do m = 1 to 17
	   call VSay fid, x, y, text.m
	   y = y - 50
	end

	CALL SysSleep 5
	CALL VCloseWindow fid
	if checklog > 0 then do
		CALL VCloseWindow eid
	end
	CALL CLEANUP

/*---------------------------------------------------------------------------*/
/* Cleanup Routine for Vrexx2 - must be run to end program                   */
/*---------------------------------------------------------------------------*/

CLEANUP:
    call VExit
exit

/*---------------------------------------------------------------------------*/
/* End of Sav2disk.cmd                                                       */
/*---------------------------------------------------------------------------*/

