/* showtree.cmd,v 1.14 1998-10-02 08:26:50-04 rl Exp */

/************************************************************************* 
 *                                                                       * 
 * showtree.cmd                                                          * 
 * A REXX script to print a directory tree                               * 
 * 1997-02-01, Rolf Lochbuehler <rolobue@ibm.net>                        * 
 * 1998-10-02, Rolf Lochbuehler <rolf@together.net>                      * 
 *                                                                       * 
 *************************************************************************/

RET_OK = 0
RET_HELP = 1
RET_NO_DIR = 2
RET_INVALID_ARG = 3

INDENT = ''

if 0 <> rxfuncquery('sysfiletree') then
  call rxfuncadd 'sysfiletree', 'rexxutil', 'SysFileTree'

parse arg opt

if length(opt) = 0 then
  do

  startdir = normalize(directory())
  needhelp = 0
  printascii = 0
  maxlevel = 1000
  printfiles = 0

  end
else
  do

  opt1 = translate( opt )
  
  i = wordpos( '/H', opt1 )
  if i = 0 then
    i = wordpos( '-H', opt1 )
  if i > 0 then
    needhelp = 1
  else
    needhelp = 0
  
  i = wordpos( '/A', opt1 )
  if i = 0 then
    i = wordpos( '-A', opt1 )
  if i > 0 then
    do
    printascii = 1
    opt = delword( opt, i, 1 )
    opt1 = translate( opt )
    end
  else
    printascii = 0
  
  i = wordpos( '/D', opt1 )
  if i = 0 then
    i = wordpos( '-D', opt1 )
  if i > 0 then
    do
    maxlevel = word( opt1, i + 1 )
    if maxlevel < 0 then
      do
      say 'Error: Negative level specified'
      call help
      exit RET_INVALID_ARG
      end
    opt = delword( opt, i, 2 )
    opt1 = translate( opt )
    end
  else
    maxlevel = 1000
  
  i = wordpos( '/F', opt1 )
  if i = 0 then
    i = wordpos( '-F', opt1 )
  if i > 0 then
    do
    printfiles = 1
    opt = delword( opt, i, 1 )
    opt1 = translate( opt )
    end
  else
    printfiles = 0
  
  if length(opt) > 0 then
    startdir = normalize(opt)
  else
    startdir = normalize(directory())

  end   /* end else */

if 1 = needhelp then
  do
  call help
  exit RET_HELP
  end

if 1 = printascii then
  do
  DWNCHR = '|'
  MIDCHR = '|--'
  ENDCHR = '`--'
  end
else
  do
  DWNCHR = d2c(179)                    
  MIDCHR = d2c(195)||d2c(196)||d2c(196)
  ENDCHR = d2c(192)||d2c(196)||d2c(196)
  end
  
calldir = directory()

if translate(startdir) <> translate(directory(startdir)) then
  do
  say 'Error: cannot find' startdir
  call help
  exit RET_NO_DIR
  end

if 0 = printfiles then
  say startdir
else
  say startdir'\'

level.0 = 1
level.1 = 0

call tree

call directory calldir
exit RET_OK


/************************************************************************* 
 *                                                                       * 
 * help()                                                                * 
 * Display help screen for the user                                      * 
 *                                                                       * 
 *************************************************************************/
help: procedure
  say ''
  say 'ShowTree V1.14 (REXX), Rolf Lochbuehler <rolf@together.net>'
  say 'Purpose:'
  say '  Print a directory tree in a command line window'
  say 'Usage:'
  say '  showtree [/a] [/d N] [/f] [/h] [Dir]'
  say 'Arguments:'
  say '  /a     Use ASCII characters only (default: PC850)'
  say '  /d N   Show only N subdirectories below the root directory'
  say '  /f     Print file names too (default: only directories)'
  say '  /h     Print help, then exit'
  say '  Dir    The root directory of the directory tree to print (default: .)'
  say 'Examples:'
  say '  showtree /h        prints help'
  say '  showtree           starts in current directory using PC850 characters'
  say '  showtree /a \bin   starts in \bin using ASCII characters' 
  return


/************************************************************************* 
 *                                                                       * 
 * tree()                                                                * 
 * Recursive procedure to print directory tree                           * 
 *                                                                       * 
 *************************************************************************/
tree: procedure expose INDENT DWNCHR MIDCHR ENDCHR level. maxlevel printfiles

  if 1 = printfiles then
    call sysfiletree '*', 'entry', 'bo'
  else
    call sysfiletree '*', 'entry', 'do'

  if entry.0 > 0 then 
    do i = 1 to entry.0

      isdir = 1
      if (1 = printfiles) & ('' <> stream(entry.i,'command','query exists')) then
        isdir = 0

      ln = INDENT

      do k = 1 to level.0 - 1
        if level.k = 1 then
          ln = ln'   'INDENT
        else
          ln = ln || DWNCHR'  'INDENT
      end

      if i = entry.0 then
        do
        ln = ln || ENDCHR
        m = level.0
        level.m = 1
        end
      else                 
        ln = ln || MIDCHR

      if (1 = printfiles) & (1 = isdir) then
        ln = ln || filespec( 'name', entry.i ) || '\'
      else
        ln = ln || filespec( 'name', entry.i )

      say ln

      if (level.0 < maxlevel) & (1 = isdir) then
        do

        call directory entry.i

        level.0 = level.0 + 1
        m = level.0
        level.m = 0
  
        call tree
  
        drop level.m
        level.0 = level.0 - 1
  
        call directory '..'

        end

    end   /* end do */

  return


/************************************************************************* 
 *                                                                       * 
 * normalize()                                                           * 
 * Complete directory name, substitute ellipses, etc.                    * 
 *                                                                       * 
 *************************************************************************/
normalize: procedure

  parse arg d

  d = strip( d, 'both' )
  d = strip( d, 'both', '"' )

  if d = '' then
    dn = directory()
  
  /* '.' */
  else if d = '.' then
    dn = directory()
  
  /* '..' */
  else if d = '..' then
    do
    curdir = directory()
    call directory '..'
    dn = directory()
    call directory curdir
    end
  
  /* '\any\dir\name' (absolute path, but missing 'drive:') */
  else if substr(d,1,1) = '\' then
    do
    drive = filespec( 'drive', directory() )
    dn = drive || d
    end
  
  /* 'any\dir\name' (relative path) */
  else if pos(':',d) = 0 then
    do
    temp = directory() 
    if lastpos('\',temp) <> length(temp) then
      temp = temp || '\'
    dn = temp || d
    end

  else
    dn = d

  return dn

