exit
/****************************************************************************/
/* Utility routines for HTML processing                                     */
/****************************************************************************/

SendHTML:
/****************************************************************************/
/* SendHTML - Send an HTML file back as the response.  Insert data          */
/* in locations occupied by "placeholders".                                 */
/****************************************************************************/
parse arg file,varlist
    reply= charin(file,1,100000)
        do i=1 to words(varlist)
        varname=word(varlist,i)
        varpos=pos("%"varname"%",reply)
        if varpos>0 then
            reply=insert(value(varname),,
                delstr(reply,varpos,length(varname)+2),varpos-1)
        end
    say reply
return

/****************************************************************************/
/* Parse the FORMs variable=value strings and assign the results to the     */
/* Parms. stem.                                                             */
/****************************************************************************/
ParseQueryString: procedure expose Parms. NFields itrace
  Parse arg P
  i = 1
  drop Parms.
  Parms.=""
if itrace then say "<PRE>"
  do while ((P \= '') & (i < 50))
     Parse var P Parms.Text.i '&' rest
     Parse var Parms.Text.i Parms.Tag.i '=' Parms.KeyVal.i
     Parms.Tag.i = translate( Parms.Tag.i)
     Parms.XVal.i=DecodeKeyVal( Parms.KeyVal.i)
     varname=Parms.Tag.i
     if itrace then say varname Parms.XVal.i
     varname="?"varname
     Parms.varname=Parms.XVal.i
     P = rest
     i = i + 1
  end
if itrace then say "</PRE>"
  NFields = i - 1
  return NFields

/****************************************************************************/
/* Descape the URL                                                          */
/****************************************************************************/
DecodeKeyVal: procedure
  parse arg Code
  Text=''
  Code=translate(Code, ' ', '+')
  rest='%'
  do while (rest\='')
     Parse var Code T '%' rest
     Text=Text || T
     if (rest\='') then
      do
        ch = left( rest,2)
        c=X2C(ch)
        Text=Text || c
        Code=substr( rest, 3)
      end
  end
  return Text
