/*
*	Remove DELETE directory on specified drive.
*
*	This program will remove the DELETE directory
*	from the drive(s) whose drive letters are passed
*	on the command line. If the DELETE directory does
*	not exist, then the program will do nothing.
*
*	Copyright 1994 Harold J. Endresen
*	Released to the public domain.
*/

	ARG DriveLetter

	IF Driveletter = '' THEN DO
		SAY 'USAGE:  RMDELDIR <drive>'
		EXIT
	END

	/* load REXX utility functions */

	CALL rxfuncadd 'SysLoadFuncs','RexxUtil','SysLoadFuncs'
	CALL sysloadfuncs

	/* make sure drive letter is valid */

	DriveLetter = LEFT( DriveLetter, 1 )
	IF DriveLetter < 'A' | DriveLetter > 'Z' THEN DO
		SAY 'Drive letter ' DriveLetter ' is invalid.'
		EXIT
	END

	/* get all valid drive local letters */

	DriveMap = SysDriveMap( DriveLetter, 'LOCAL' )
	DO x = 1 to WORDS( DriveMap )
		IF LEFT( WORD( DriveMap, x ), 1) = DriveLetter THEN LEAVE
	END

	/* make sure the specified drive is valid and local */

	IF x > WORDS( DriveMap ) THEN DO
		SAY 'Drive ' || DriveLetter || ': is not a valid local drive.'
		EXIT
	END

	/* scan the disk to see if the directory exists and if there are
	   any files in it. Remove RHS attributes from any files found. */

	rc = SysFileTree( DriveLetter || ':\DELETE\*.*', 'FileList', 'FO', '*****', '**---')
	IF rc <> 0 THEN DO
		SAY 'Error occurred during file system search; aborting.'
		EXIT
	END

	FilesRemoved = 1
	IF FileList.0 <> 0 THEN DO
		DO x = 1 TO FileList.0
			SAY 'Deleting ' || FileList.x
			rc = SysFileDelete( FileList.x )
			IF rc <> 0 THEN DO
				SAY '     UNSUCCESSFUL'
				FilesRemoved = 0
			END
		END
	END

	IF FilesRemoved <> 0 THEN DO
		rc = SysFileTree( DriveLetter || ':\DELETE', 'FileList', 'D' )
		if FileList.0 <> 0 THEN DO
			rc = SysRmDir(  DriveLetter || ':\DELETE' )
			IF rc <> 0 THEN
				SAY 'Unable to remove directory ' || DriveLetter || ':\DELETE'
		END
	END
	EXIT

