/*
 * rencase
 *
 * renames files to same name but different case (all upper, all lower or
 * mixed case).
 *
 * released to public domain by M. Kimes 04/21/94
 */

#define INCL_DOS

#include <os2.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <ctype.h>

#ifndef _tolower
  #define _tolower( c )  ( (c) + 'a' - 'A' )
#endif
#ifndef _toupper
  #define _toupper( c )  ( (c) + 'A' - 'a' )
#endif


void rename_mask (char *mask,int lowercase,int silence) {

  FILEFINDBUF3   f;
  HDIR           hdir = HDIR_CREATE;
  ULONG          nm = 1L;
  CHAR           dir[CCHMAXPATH],casecopy[CCHMAXPATH];
  register CHAR *p,*enddir;
  APIRET         rc;

  if(DosQueryPathInfo(mask,FIL_QUERYFULLNAME,dir,sizeof(dir)))
    strcpy(dir,mask);
  enddir = dir;
  while(*enddir) {
    if(*enddir == '/')
      *enddir = '\\';
    enddir++;
  }
  enddir = strrchr(dir,'\\');
  if(enddir == dir || *(enddir - 1) != ':')
    *enddir = '\\';
  enddir++;
  if(!DosFindFirst(mask,&hdir,FILE_NORMAL | FILE_ARCHIVED | FILE_DIRECTORY |
                   FILE_READONLY | FILE_HIDDEN | FILE_SYSTEM,&f,sizeof(f),
                   &nm,FIL_STANDARD)) {
    do {
      if(*f.achName != '.' || !(f.attrFile & FILE_DIRECTORY)) {
        strcpy(enddir,f.achName);
        strcpy(casecopy,dir);
        p = f.achName;
        while(*p) {
          if(lowercase == 1) {
            if(*p > 'A' - 1 && *p < 'Z' + 1)
              *p = _tolower(*p);
          }
          else if(lowercase == 2) {
            if(p == f.achName || *(p - 1) == ' ' || *(p - 1) == '.' ||
               *(p - 1) == '_') {
              if(*p > 'a' - 1 && *p < 'z' + 1)
                *p = _toupper(*p);
            }
            else {
              if(*p > 'A' - 1 && *p < 'Z' + 1)
                *p = _tolower(*p);
            }
          }
          else {
            if(*p > 'a' - 1 && *p < 'z' + 1)
              *p = _toupper(*p);
          }
          p++;
        }
        strcpy(casecopy + (enddir - dir),f.achName);
        if(!silence)
          printf("\"%s\" -=> \"%s\"",dir,casecopy);
        rc = DosMove(dir,casecopy);
        if(rc && !silence)
          printf("  **Failed (SYS%04d)",rc);
        if(!silence)
          printf("\n");
      }
    } while(nm && !DosFindNext(hdir,&f,sizeof(f),&nm));
    DosFindClose(hdir);
  }
}


int main (int argc,char *argv[]) {

  int   lowercase,silence = 0,x;
  char *p;

  if(argc < 3) {
Help:
    printf("\nusage:  rencase <-u -l or -m> <mask> [<mask>...]\n"
           "renames file system objects matching <mask>s to same name but\n"
           "all upper (-u), lower (-l) or \"mixed\" (-m) case.\n"
           " Hector wuz here.\n");
    return 1;
  }
  else {
    p = argv[1];
    if(*p == '-' || *p == '/')
      p++;
    if(*p == 'u' || *p == 'U') {
      lowercase = 0;
      if(*p == 'U')
        silence = 1;
    }
    else if(*p == 'l' || *p == 'L') {
      lowercase = 1;
      if(*p == 'L')
        silence = 1;
    }
    else if(*p == 'm' || *p == 'M') {
      lowercase = 2;
      if(*p == 'M')
        silence = 1;
    }
    else
      goto Help;
    for(x = 2;x < argc;x++)
      rename_mask(argv[x],lowercase,silence);
  }
}
