#define INCL_DOSFILEMGR
#define INCL_DOSERRORS
#include <os2.h>
#include <stdio.h>
#include <string.h>


int main (int argc, char **argv)
{
  int rc;

  if (argc < 2)
  {
    printf ("RAMDISK: Create a RAM disk\n");
    printf ("Syntax:\n");
    printf ("  RAMDISK d:                   create RAM disk d:\n");
    printf ("  RAMDISK d: vollabel          create RAM disk d: with label vollabel\n");
    return 1;
  }

  printf ("Creating RAM disk %s\n", argv[1]);
  if (argc == 2)
    rc = DosFSAttach (argv[1], "RAMFS", NULL, 0, FS_ATTACH);
  else
    rc = DosFSAttach (argv[1], "RAMFS", argv[2], strlen(argv[2]+1), FS_ATTACH);

  switch (rc)
  {
    case ERROR_INVALID_FSD_NAME:
           printf ("Error: IFS=RAMFS.IFS not loaded in CONFIG.SYS\n");
           return 1;

    case ERROR_INVALID_PATH:
           printf ("Error: Invalid drive letter\n");
           return 1;

    case ERROR_ALREADY_ASSIGNED:
           printf ("Error: This drive letter is already in use\n");
           return 1;
 
    case NO_ERROR:
           printf ("OK\n");
           return 0;

    default:
           printf ("DosFSAttach rc=%d\n", rc);
           return 1;
  }
}
