#include "includes.h"

#include <stdlib.h>
#include <string.h>

ULONG _pascal FS_ATTRIBUTE = FSA_REMOTE;
CHAR  _pascal FS_NAME[] = "RAMFS";

extern unsigned short threednow;
extern unsigned long ramfs_units;

static char hello_msg[] = "RAMFS.IFS version 1.02-perf\r\n";



APIRET EXPENTRY FS_INIT (
    PSZ		szParm,
    ULONG	pDevHlp,
    PULONG	pMiniFSD )	/* not used */
{
  int rc;
  USHORT wlen;
  int   quiet_init = 0;
  char  *p;
  unsigned long vs;
  int vs_mul = -12;

  UtilEnterRamfs();
  DEBUG_PRINTF1 ("FS_INIT  szParm='%s'", szParm);

  if (szParm != NULL)
  {
    /* Force/disable 3DNow! */
    if (strstr(szParm, "/3"))
      threednow = 1;
    else if (strstr(szParm, "/!3"))
      threednow = 0;
    else
      threednow = 0xFFFF;

    /* Quiet initialization */
    if (strstr(szParm, "/q")  ||  strstr(szParm, "/Q"))
       quiet_init = 1;

    /* Readjust size */
    if ((p = strstr(szParm, "/s:")) != NULL || (p = strstr(szParm, "/S:")) != NULL)
    {
       vs = atol(p+3);
       if (vs != 0)
       {
         while (*++p != '\0' && *p != ' ' && *p != '/')
         {
           if (*p == 'k' || *p == 'K')
             vs_mul = -2;
           else if (*p == 'm' || *p == 'M')
             vs_mul = 8;
           else if (*p == 'g' || *p == 'G')
             vs_mul = 18;
           else if (*p == 't' || *p == 'T')
             vs_mul = 28;
         }
       }
       ramfs_units = (vs_mul > 0) ? (vs << vs_mul) : (vs >> (-vs_mul));
    }
  }

  /* show hello message */
  if (!quiet_init)
    DosWrite (1, hello_msg, sizeof(hello_msg)-1, &wlen);

  DevHlp = (PFN) pDevHlp;
  _asm{
   mov al, 1	        /* get global info seg */
   mov dl, 0x24;	/* DevHlp_GetDOSVar */
  }
  (*DevHlp)();
  _asm{
   push es
   mov es, ax
   mov ax, es:[bx]
   mov word ptr pGiseg, 0
   mov word ptr pGiseg+2, ax
   pop es
  }

  NearInit();
  VMInit();

  rc = NO_ERROR;

  DEBUG_PRINTF1 (" => %d\r\n", rc);
  UtilExitRamfs();
  return rc;
}
